/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.thread;

import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.thread.WfRunnableExtend;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.WfEngineEventEnum;
import org.apache.log4j.Logger;

public class WfEngineThreadRunnable
extends WfRunnableExtend {
    private static final Logger logger = Logger.getLogger(WfEngineThreadRunnable.class);
    private static Object lockObj = new Object();
    private final WfEngine engine;

    public WfEngineThreadRunnable(WfEngine engine) {
        super(engine.context());
        this.engine = engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        this.stop = true;
        Object object = lockObj;
        synchronized (object) {
            lockObj.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.run();
        if (this.context() == null) {
            throw new IllegalArgumentException();
        }
        WfLogger wfLogger = this.engine.getWfLogger();
        while (!this.isStop()) {
            try {
                this.engine.clearCache();
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage(), e);
                try {
                    LogTypeEnum logType = LogTypeEnum.ERROR;
                    WfEngineEventEnum event = WfEngineEventEnum.COMMONERROR;
                    wfLogger.addWfEngineLog(logType, event, e.getMessage(), e.toString(), e);
                }
                catch (Throwable wfe) {
                    logger.error((Object)wfe.getMessage(), wfe);
                }
            }
            try {
                Object e = lockObj;
                synchronized (e) {
                    lockObj.wait(10000L);
                }
            }
            catch (InterruptedException e) {
                logger.error((Object)"WfEngineThreadRunnable interrupted.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }
}

