/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.core.thread;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.ClusterStateManager;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.core.Returns;
import com.kingdee.bos.service.job.returns.Delay;
import com.kingdee.bos.service.job.returns.Destroy;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.define.WfPriority;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.engine.core.thread.JobDispatcher;
import com.kingdee.bos.workflow.engine.core.thread.Util;
import com.kingdee.bos.workflow.engine.core.thread.WfDeadlineHandler;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.timeliness.DeadlineWaiter;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Date;
import org.apache.log4j.Logger;
import org.quartz.JobDataMap;

public class WfDeadlineRaiser
implements IJobHandler {
    private static final long serialVersionUID = -2680648882600350091L;
    protected static final Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.engine.core.thread.WfDeadlineRaiser");
    private JobDataMap jbDataMap;
    private String procInstId;

    public static void remove(Context ctx, String id) {
        String title = "~DeadLine:" + id;
        Util.deleteJob(ctx, title);
    }

    public static void add(Context ctx, DeadlineWaiter waiter) {
        JobDataMap jbDataMap = new JobDataMap();
        jbDataMap.put("ActInst_Id", waiter.getActivityId());
        jbDataMap.put("Engine_Name", waiter.getWfEngine().getEngineKey());
        jbDataMap.put("Deadline_Index", waiter.getIndex());
        WfDeadlineRaiser raiser = new WfDeadlineRaiser(jbDataMap);
        String title = "~DeadLine:" + waiter.getId();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"SELECT FJOBINSTID FROM T_JOB_INST WHERE  FTITLE = ?", (Object[])new String[]{title});
            if (rs != null && rs.next()) {
                return;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        Job job = new Job(ctx, title, (IJobHandler)raiser, null, true, true);
        ClusterStateManager cm = ClusterStateManager.get((Context)ctx);
        job.setScheduledTime((Date)cm.toLocalTime(waiter.getFireTime()));
        JobManager.instance().add(job);
    }

    private WfDeadlineRaiser(JobDataMap jbDataMap) {
        this.jbDataMap = jbDataMap;
    }

    public Returns execute(Job job) throws Exception {
        Context ctx = job.getContext();
        String actInstId = this.jbDataMap.getString("ActInst_Id");
        WfEngine engine = WfEngine.getEngine(ctx);
        ActivityInstInfo act = engine.getActInstMetaById(actInstId);
        this.procInstId = act.getProcInstId();
        if (!act.getState().startsWith("open.")) {
            return Destroy.instance();
        }
        String jobId = Mutex.getMutex(ctx, this.procInstId);
        String title = "~DeadLineHandler:" + actInstId;
        try {
            JobDispatcher.dispatch(jobId, ctx, title, new WfDeadlineHandler(this.jbDataMap, ctx.getCaller().toString()), false, WfPriority.LOWEST);
            return Destroy.instance();
        }
        catch (AlreadyInProcessQueueException e) {
            return new Delay((long)RND.nextInt(1000) + 300L);
        }
    }
}

