/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.extscheme.procdiagram.cal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.extscheme.procdiagram.bean.DiaActivityType;
import com.kingdee.bos.workflow.extscheme.procdiagram.bean.DiagramActivity;
import com.kingdee.bos.workflow.extscheme.procdiagram.bean.DiagramProcess;
import com.kingdee.bos.workflow.extscheme.procdiagram.cal.CalProcDiagramDetail;
import com.kingdee.bos.workflow.extscheme.procdiagram.cal.CalUtil;
import com.kingdee.bos.workflow.extscheme.procdiagram.cal.DealProcDiagramInfo;
import com.kingdee.bos.workflow.extscheme.procdiagram.util.ProcDiagramUtil;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CalProcDiagram {
    protected static final Logger logger = Logger.getLogger(CalProcDiagram.class);
    private WfEngine engine;
    private String procDefId;
    private String procinstId;
    private String actinstId;
    private String procDefHash;
    private Context ctx;
    private Map procContextMap;
    private Map<String, Object> predictMap;

    public CalProcDiagram(WfEngine engine, String actinstId, String procDefId, String procinstId, Context ctx, Map procContextMap) {
        this.actinstId = actinstId;
        this.engine = engine;
        this.procDefId = procDefId;
        this.procinstId = procinstId;
        this.ctx = ctx;
        this.procContextMap = procContextMap;
    }

    public void setPredictMap(Map<String, Object> predictMap) {
        this.predictMap = predictMap;
    }

    public Map<String, Object> getPredictMap() {
        return this.predictMap;
    }

    public List<DiagramActivity> calProcDiagram() throws BOSException {
        ArrayList<DiagramActivity> resultActList = new ArrayList();
        this.procDefHash = ProcDiagramUtil.getProcDefHash(this.procinstId, this.procDefId, this.ctx);
        CalProcDiagramDetail tCalProcDiagram = new CalProcDiagramDetail(this.actinstId, this.engine, this.procDefHash, this.procinstId, this.ctx);
        if (this.procinstId == null && this.procContextMap != null) {
            tCalProcDiagram.setDataMap(this.procContextMap);
        }
        tCalProcDiagram.setPredictMap(this.predictMap);
        DiagramProcess tDiagramProcess = tCalProcDiagram.calProcessPath();
        this.dealSubProcDiagram(tDiagramProcess, this.procContextMap);
        if (this.predictMap == null) {
            DealProcDiagramInfo tDealProcDiagramInfo = new DealProcDiagramInfo(this.ctx, this.engine);
            tDealProcDiagramInfo.prepareInfo(tDiagramProcess);
        }
        resultActList = this.converDiagramProcessToActivitys(tDiagramProcess);
        return resultActList;
    }

    private List<DiagramActivity> converDiagramProcessToActivitys(DiagramProcess tDiagramProcess) {
        ArrayList<DiagramActivity> aonverActList = new ArrayList<DiagramActivity>();
        List<DiagramActivity> diaActList = tDiagramProcess.getDiaGramActivitys();
        for (int index = 0; index < diaActList.size(); ++index) {
            DiagramActivity tDiagramActivity = diaActList.get(index);
            aonverActList.add(tDiagramActivity);
            if (tDiagramActivity.getDiagramProcess() == null) continue;
            DiagramProcess detailDiagramProcess = tDiagramActivity.getDiagramProcess();
            if (detailDiagramProcess.isAppend()) {
                aonverActList.addAll(this.getAppendDiagramActivity(detailDiagramProcess));
            }
            if (!detailDiagramProcess.isCludeSub()) continue;
            aonverActList.addAll(this.getSubDiagramActivity(detailDiagramProcess));
        }
        return aonverActList;
    }

    private List<DiagramActivity> getAppendDiagramActivity(DiagramProcess tDiagramProcess) {
        List<DiagramActivity> appendActList = tDiagramProcess.getDiaGramActivitys();
        return appendActList;
    }

    private List<DiagramActivity> getSubDiagramActivity(DiagramProcess tDiagramProcess) {
        List<DiagramActivity> subActList = tDiagramProcess.getDiaGramActivitys();
        for (int index = 0; index < subActList.size(); ++index) {
            DiagramActivity diagramActivity = subActList.get(index);
            if (diagramActivity.getDiaActivityType().equals(DiaActivityType.STARTNODE)) {
                diagramActivity.setActDefName("\u5b50\u6d41\u7a0b\u5f00\u59cb");
                diagramActivity.setDiaActivityType(DiaActivityType.SUBFLOWSTARTNODE);
            }
            if (diagramActivity.getDiaActivityType().equals(DiaActivityType.ENDNODENODE)) {
                diagramActivity.setActDefName("\u5b50\u6d41\u7a0b\u7ed3\u675f");
                diagramActivity.setDiaActivityType(DiaActivityType.SUBFLOWENDNODE);
            }
            diagramActivity.setActDefName(diagramActivity.getActDefName() + "-" + tDiagramProcess.getProcessDef().getName());
            DiagramProcess tSubDiagramProcess = subActList.get(index).getDiagramProcess();
            if (tSubDiagramProcess == null) continue;
            subActList.addAll(this.converDiagramProcessToActivitys(tSubDiagramProcess));
        }
        return subActList;
    }

    private void dealSubProcDiagram(DiagramProcess tDiagramProcess, Map procContextMap) throws BOSException {
        if (!tDiagramProcess.isCludeSub()) {
            return;
        }
        List<DiagramActivity> diaActList = tDiagramProcess.getDiaGramActivitys();
        for (int index = 0; index < diaActList.size(); ++index) {
            DiagramActivity tDiagramActivity = diaActList.get(index);
            DiaActivityType activityType = tDiagramActivity.getDiaActivityType();
            if (!activityType.equals(DiaActivityType.SUBFLOWNODE)) continue;
            SubflowActivityDef tSubflowActivityDef = (SubflowActivityDef)tDiagramActivity.getActDef();
            String subprocDefId = tSubflowActivityDef.getSubflowId();
            String subActinstId = tDiagramActivity.getActivityId();
            String subProcinstId = "";
            if (!StringUtils.isEmpty((String)subActinstId)) {
                WfActivity wfactivity = this.engine.getActivityInst(subActinstId);
                subProcinstId = wfactivity.getMeta().getSubProcInstId();
            }
            String tProcDefHash = ProcDiagramUtil.getProcDefHash(subProcinstId, subprocDefId, this.ctx);
            CalProcDiagramDetail subCalProcDiagram = new CalProcDiagramDetail(null, this.engine, tProcDefHash, subProcinstId, this.ctx);
            Map<String, Object> dataMap = null;
            if (StringUtils.isEmpty((String)subProcinstId)) {
                dataMap = CalUtil.calSubFlowDataMap(this.ctx, tSubflowActivityDef, procContextMap, tProcDefHash);
                subCalProcDiagram.setDataMap(dataMap);
                procContextMap = dataMap;
                Map predictMapClone = null;
                if (this.predictMap != null) {
                    try {
                        predictMapClone = (Map)ObjectUtils.createCopy(this.predictMap);
                        predictMapClone.put("isNotStartSubProc", true);
                        subCalProcDiagram.setPredictMap(predictMapClone);
                    }
                    catch (CloneNotSupportedException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            DiagramProcess tsubDiagramProcess = subCalProcDiagram.calProcessPath();
            tsubDiagramProcess.setCludeSub(true);
            tDiagramActivity.setDiagramProcess(tsubDiagramProcess);
            this.dealSubProcDiagram(tsubDiagramProcess, procContextMap);
        }
    }
}

