/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.participant;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.cache.IWfCacheManager;
import com.kingdee.bos.workflow.exception.WfParticipantException;
import com.kingdee.bos.workflow.participant.Group;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.participant.JobInfo;
import com.kingdee.bos.workflow.participant.OrgUnitInfo;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.participant.PositionInfo;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class EASParticipantCacheProviderWrapper
implements IParticipantProvider {
    private static final long serialVersionUID = -3841983307141130945L;
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.enactment.participant.EASParticipantCacheProvider");
    private static final String cachePrefix = "EPCPW.";
    private IParticipantProvider innerProvider;
    private IWfCacheManager cacheMgr;

    public EASParticipantCacheProviderWrapper(WfEngine destEngine, IParticipantProvider impl) {
        this.cacheMgr = destEngine.getCacheManager();
        this.innerProvider = impl;
    }

    public Person getPersonByUserId(Context context, String personId) throws WfParticipantException {
        return this.innerProvider.getPersonByUserId(context, personId);
    }

    public Person[] getPersonByUserIds(Context context, String[] userIds) throws WfParticipantException {
        return this.innerProvider.getPersonByUserIds(context, userIds);
    }

    public Person[] getPersonsByUserId(Context context, String personId) throws WfParticipantException {
        return this.innerProvider.getPersonsByUserId(context, personId);
    }

    public void cleanCache() throws WfException {
        this.cacheMgr.cleanParticipantCache();
    }

    public Person[] getPersonByEmployeeId(Context context, String personId) throws WfParticipantException {
        return this.innerProvider.getPersonByEmployeeId(context, personId);
    }

    public Person[] getPositionHolders(Context context, String positionId) throws WfParticipantException {
        return this.innerProvider.getPositionHolders(context, positionId);
    }

    public Person[] getOrgMember(Context context, String orgId) throws WfParticipantException {
        return this.innerProvider.getOrgMember(context, orgId);
    }

    public Person[] getOrgAllMember(Context context, String orgId) throws WfParticipantException {
        return this.innerProvider.getOrgAllMember(context, orgId);
    }

    public Person[] getOrgPrincipal(Context context, String orgId) throws WfParticipantException {
        return this.innerProvider.getOrgPrincipal(context, orgId);
    }

    public Person[] getSupervisor(Context context, String personId, String positionId, String hierarchyId) throws WfParticipantException {
        return this.innerProvider.getSupervisor(context, personId, positionId, hierarchyId);
    }

    public Person[] getSubordinate(Context context, String personId, String positionId, String hierarchyId) throws WfParticipantException {
        return this.innerProvider.getSubordinate(context, personId, positionId, hierarchyId);
    }

    public Person[] getFellow(Context context, String personId, String positionId, String hierarchyId) throws WfParticipantException {
        return this.innerProvider.getFellow(context, personId, positionId, hierarchyId);
    }

    public Person[] getAllPosFellow(Context context, String personId, String positionId, String hierarchyId) throws WfParticipantException {
        return this.innerProvider.getAllPosFellow(context, personId, positionId, hierarchyId);
    }

    public Person[] getOtherPosFellow(Context context, String personId, String positionId, String hierarchyId) throws WfParticipantException {
        return this.innerProvider.getOtherPosFellow(context, personId, positionId, hierarchyId);
    }

    public Person[] getRoleMember(Context context, String personUserId, String roleId) throws WfParticipantException {
        return this.innerProvider.getRoleMember(context, personUserId, roleId);
    }

    public PositionInfo[] getPositionArrayByUserId(Context context, String userId) throws WfParticipantException {
        return this.innerProvider.getPositionArrayByUserId(context, userId);
    }

    public PositionInfo[] getPositionArrayByEmployeeId(Context context, String employeeId) throws WfParticipantException {
        return this.innerProvider.getPositionArrayByEmployeeId(context, employeeId);
    }

    public PositionInfo[] getPositionArrayByOrgUnitId(Context context, String orgUnitId) throws WfParticipantException {
        return this.innerProvider.getPositionArrayByOrgUnitId(context, orgUnitId);
    }

    public JobInfo[] getJobArrayByOrgUnitId(Context context, String orgUnitId) throws WfParticipantException {
        return this.innerProvider.getJobArrayByOrgUnitId(context, orgUnitId);
    }

    public JobInfo[] getJobsArray(Context context) throws WfParticipantException {
        return this.innerProvider.getJobsArray(context);
    }

    public OrgUnitInfo[] getOrgUnitArrayByEmployeeId(Context context, String employeeId) throws WfParticipantException {
        OrgUnitInfo[] directUnits = this.innerProvider.getOrgUnitArrayByEmployeeId(context, employeeId);
        return this.getAllOrgUnits(context, directUnits);
    }

    private OrgUnitInfo[] getAllOrgUnits(Context context, OrgUnitInfo[] directUnits) throws WfParticipantException {
        HashSet<OrgUnitInfo> units = new HashSet<OrgUnitInfo>();
        HashSet<String> map = new HashSet<String>();
        Connection cn = null;
        Statement smt = null;
        try {
            cn = EJBFactory.getConnection((Context)context);
            smt = cn.createStatement();
        }
        catch (Exception e) {
            if (cn != null) {
                try {
                    cn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new WfParticipantException("create connection failed", (Throwable)e);
        }
        try {
            for (int i = 0; i < directUnits.length; ++i) {
                String sql = "select flongnumber from  t_org_admin where fid='" + directUnits[i].getId() + "'";
                ResultSet rs = this.executeQuery(smt, sql);
                rs.next();
                String numbers = "'" + rs.getString(1).replaceAll("!", "','") + "'";
                rs.close();
                sql = "select fid, fname_" + context.getLocale().toString() + " from t_org_admin where fnumber in(" + numbers + ")";
                rs = this.executeQuery(smt, sql);
                while (rs.next()) {
                    String id = rs.getString(1);
                    String name = rs.getString(2);
                    if (map.contains(id)) continue;
                    map.add(id);
                    OrgUnitInfo unit = new OrgUnitInfo();
                    unit.setId(id);
                    unit.setName(context.getLocale(), name);
                    units.add(unit);
                }
                rs.close();
            }
        }
        catch (Exception e) {
            throw new WfParticipantException("retrieve orgunit failed", (Throwable)e);
        }
        finally {
            try {
                cn.close();
                smt.close();
            }
            catch (Exception exception) {}
        }
        return units.toArray(new OrgUnitInfo[units.size()]);
    }

    private ResultSet executeQuery(Statement smt, String sql) throws SQLException {
        return smt.executeQuery(sql);
    }

    public OrgUnitInfo[] getAllOrgUnitArray(Context context) throws WfParticipantException {
        return this.innerProvider.getAllOrgUnitArray(context);
    }

    public OrgUnitInfo[] getAllOrgUnitByType(Context context, int orgType) throws WfParticipantException {
        return this.innerProvider.getAllOrgUnitByType(context, orgType);
    }

    public OrgUnitInfo getRootUnit(Context context, int orgType) throws WfParticipantException {
        return this.innerProvider.getRootUnit(context, orgType);
    }

    public OrgUnitInfo[] getOrgUnitArrayByUserId(Context context, String userId) throws WfParticipantException {
        return this.innerProvider.getOrgUnitArrayByUserId(context, userId);
    }

    public OrgUnitInfo[] getSubOrgUnit(Context context, String parantOrgUnitId) throws WfParticipantException {
        return this.innerProvider.getSubOrgUnit(context, parantOrgUnitId);
    }

    public OrgUnitInfo getParentOrgUnit(Context context, String orgUintId) throws WfParticipantException {
        return this.innerProvider.getParentOrgUnit(context, orgUintId);
    }

    public boolean isPersonInOrg(Context context, String personId, String OrgId) throws WfParticipantException {
        return this.innerProvider.isPersonInOrg(context, personId, OrgId);
    }

    public String getHierarchyNameByID(Context context, String id) throws WfParticipantException {
        return this.innerProvider.getHierarchyNameByID(context, id);
    }

    public PositionInfo[] getPositionByPersonAndHierarchy(Context context, String personID, String hierarchyID) throws WfParticipantException {
        return this.innerProvider.getPositionByPersonAndHierarchy(context, personID, hierarchyID);
    }

    public String[] getHierarchyByOrgType(Context context, int orgType) throws WfParticipantException {
        return this.innerProvider.getHierarchyByOrgType(context, orgType);
    }

    public String getAdminOrgUnitNamebyPositionID(Context context, String posittonID) throws WfParticipantException {
        return this.innerProvider.getAdminOrgUnitNamebyPositionID(context, posittonID);
    }

    public Person[] getIndirectSupervisor(Context context, String personId, String positionId, String hierarchyId) throws WfParticipantException {
        return this.innerProvider.getIndirectSupervisor(context, personId, positionId, hierarchyId);
    }

    public String getCurrentOrgIdByUser(Context context, String userId, int orgType) throws WfParticipantException {
        return this.innerProvider.getCurrentOrgIdByUser(context, userId, orgType);
    }

    public Person[] getSameJobGradePersonFellow(Context context, String personId) throws WfParticipantException {
        return this.innerProvider.getSameJobGradePersonFellow(context, personId);
    }

    public Person[] getAdminOrgUnitJobHolders(Context context, String adminOrgUnitID, String jobID) throws WfParticipantException {
        return this.innerProvider.getAdminOrgUnitJobHolders(context, adminOrgUnitID, jobID);
    }

    public JobInfo[] getJobArrayByEmployeeId(Context context, String employeeId) throws WfParticipantException {
        return this.innerProvider.getJobArrayByEmployeeId(context, employeeId);
    }

    public Group[] getAllGroups(Context context) throws WfParticipantException {
        return this.innerProvider.getAllGroups(context);
    }

    public Person[] getPersonsFromGroup(Context context, String groupId) throws WfParticipantException {
        return this.innerProvider.getPersonsFromGroup(context, groupId);
    }

    public Group[] getGroupArrayByEmployeeId(Context context, String employeeId) throws WfParticipantException {
        return this.innerProvider.getGroupArrayByEmployeeId(context, employeeId);
    }

    public Set<String> getVoidedEmployees(Context context) {
        return null;
    }
}

