/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.WfReleaseInfo;
import com.kingdee.bos.workflow.biz.BizEventMap;
import com.kingdee.bos.workflow.biz.BizProcInfo;
import com.kingdee.bos.workflow.biz.EventUtils;
import com.kingdee.bos.workflow.define.AccessLevel;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.AssignmentMessage;
import com.kingdee.bos.workflow.define.BlockActivityDef;
import com.kingdee.bos.workflow.define.EndActivityDef;
import com.kingdee.bos.workflow.define.ExtenalClassActivityDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.FunctionActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ProcessType;
import com.kingdee.bos.workflow.define.RouterActivityDef;
import com.kingdee.bos.workflow.define.ScriptActivityDef;
import com.kingdee.bos.workflow.define.ServiceActivityDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.define.WebBillManpowerActivityDef;
import com.kingdee.bos.workflow.define.enhanced.EMessage;
import com.kingdee.bos.workflow.define.enhanced.IEMessageActivity;
import com.kingdee.bos.workflow.define.enhanced.IMessageActivity;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.define.extended.BotpActivityDef;
import com.kingdee.bos.workflow.define.extended.ManualDecisionActivityDef;
import com.kingdee.bos.workflow.define.extended.MessageActivityDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfDefinitionMgr;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.WfProcessMgr;
import com.kingdee.bos.workflow.enactment.cache.IIdentifiableObject;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.engine.core.ThreadCache;
import com.kingdee.bos.workflow.metas.BizProcMetaCollection;
import com.kingdee.bos.workflow.metas.BizProcMetaInfo;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.ProcessDefOperationEnum;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.metas.WfEngineEventEnum;
import com.kingdee.bos.workflow.metas.WorkflowLogItem;
import com.kingdee.bos.workflow.participant.PerformerType;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.EngineUtil;
import com.kingdee.bos.workflow.service.IWfDefineService;
import com.kingdee.bos.workflow.store.ProcessStorer;
import com.kingdee.bos.workflow.util.WorkflowLogUtil;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class WfDefineService
extends AbstractBOSObject
implements IWfDefineService,
IIdentifiableObject {
    private static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"WDIS");
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.service.WfDefineService");
    private static final String SUBMIT_METHOD_INNER_ID = "dfd2c083-00fa-1000-e000-001fc0a813e6";

    public static IWfDefineService getService(Context ctx) {
        return new WfDefineService(ctx);
    }

    public WfDefineService() {
        this.registerInterface(IWfDefineService.class, this);
    }

    public WfDefineService(Context ctx) {
        super(ctx);
        this.registerInterface(IWfDefineService.class, this);
    }

    private WfLogger getWfLogger() throws WfException {
        return EngineUtil.getEngine(this.getContext()).getWfLogger();
    }

    public ProcessDefInfo[] getProcDefInfoArrayAll() throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:WfDefineService Method:getProcDefInfoArrayAll been called.");
            String desc = buffer.toString();
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfDefinitionMgr defMgr = wfEngine.getDefinitionMgr();
        return defMgr.getProcDefMetaArrayAll();
    }

    public ProcessDefInfo[] getProcDefArrayDistinct() throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:WfDefineService Method:getProcDefArrayDistinct been called.");
            String desc = buffer.toString();
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfDefinitionMgr defMgr = wfEngine.getDefinitionMgr();
        return defMgr.getProcDefArrayDistinct();
    }

    public ProcessDefInfo getProcessDefInfo(String procDefId) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:WfDefineService Method:WfDefineService been called.");
            String desc = buffer.toString();
            buffer.append("parameter: procDefId=\"");
            buffer.append(procDefId);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfDefinitionMgr defMgr = wfEngine.getDefinitionMgr();
        return defMgr.getProcessDefInfo(procDefId);
    }

    public ProcessDefInfo[] getProcDefArrayDistinct(ProcessType type) throws WfException {
        throw new RuntimeException("TODO");
    }

    public ProcessDefInfo[] getProcDefArrayDistinctByUserID(String userID) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:WfDefineService Method:getProcDefArrayDistinctByUserID been called.");
            String desc = buffer.toString();
            buffer.append("parameter: userID=\"");
            buffer.append(userID);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        if (userID == null || userID.trim().length() == 0) {
            throw new IllegalArgumentException("userID is null.");
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        ProcessDefInfo[] procDefInfoArray = wfEngine.getBizProcFinder().getProcDefArrayDistinctByUserID(userID);
        ArrayList<ProcessDefInfo> list = new ArrayList<ProcessDefInfo>();
        WfEngine engine = EngineUtil.getEngine(this.getContext());
        for (int i = 0; i < procDefInfoArray.length; ++i) {
            ProcessDef procDef = engine.getProcessDef(procDefInfoArray[i].getMd5HashValue());
            if (procDef == null || !procDef.getProcessHeader().isEnableClientStart()) continue;
            list.add(procDefInfoArray[i]);
        }
        ProcessDefInfo[] rtnArray = new ProcessDefInfo[list.size()];
        list.toArray(rtnArray);
        return rtnArray;
    }

    public void setProcessDefEnable(String userId, String procDefId, boolean enable) throws WfException {
        Context context = this.getContext();
        String jobDefId = procDefId.substring(0, 36) + "BGJOBDEF";
        String sql = "select 1 from t_job_def where fjobdefid='" + jobDefId + "'";
        try {
            if (SQL.getValue((String)context.getAIS(), (String)sql) != null) {
                if (enable) {
                    JobServiceFactory.getLocalInstance((Context)context).enableTrigger(jobDefId);
                } else {
                    JobServiceFactory.getLocalInstance((Context)context).disableTrigger(jobDefId);
                }
                return;
            }
        }
        catch (BOSException e) {
            throw new WfException((Throwable)e);
        }
        WorkflowLogItem wli = WorkflowLogItem.PROCESS_DEF_TABLE_ENABLE;
        if (!enable) {
            wli = WorkflowLogItem.PROCESS_DEF_TABLE_DISABLE;
        }
        IObjectPK logPk = WorkflowLogUtil.beginLogByLocal(this.getContext(), wli, procDefId);
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:WfDefineService Method:setProcessDefEnable been called.");
            String desc = buffer.toString();
            buffer.append("parameter: userID=\"");
            buffer.append(userId);
            buffer.append('\"');
            buffer.append(" procDefId=\"");
            buffer.append(procDefId);
            buffer.append('\"');
            buffer.append(" enable=");
            buffer.append(enable);
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = WfEngine.getEngine(context);
        ProcessDef procDef = wfEngine.getProcessMgr(procDefId).getProcessDef();
        if (procDef.getType().equals((Object)ProcessType.BACKGROUNDJOB)) {
            throw new WfException("background job service isn't upgrade, please upgrade it first!");
        }
        wfEngine.setProcessDefEnable(userId, procDefId, enable);
        WorkflowLogUtil.endLogByLocal(this.getContext(), logPk);
    }

    public WfReleaseInfo releaseProcessDef(String userId, String xmlString, boolean enable) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:WfDefineService Method:releaseProcessDef been called.");
            String desc = buffer.toString();
            buffer.append("parameter: userID=\"");
            buffer.append(userId);
            buffer.append('\"');
            buffer.append(" xmlString=\"");
            buffer.append(xmlString);
            buffer.append('\"');
            buffer.append(" enable=");
            buffer.append(enable);
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine engine = EngineUtil.getEngine(this.getContext());
        WfDefinitionMgr defMgr = engine.getDefinitionMgr();
        ProcessDefInfo procDefInfo = defMgr.loadXpdlDoc(userId, xmlString, enable);
        WfReleaseInfo rtnValue = new WfReleaseInfo();
        rtnValue.setProcessDefInfo(procDefInfo);
        this.tryToUpdateUIPkRef(procDefInfo.getProcDefId());
        WfLogger wfLogger = WfEngine.getEngine(this.getContext()).getWfLogger();
        wfLogger.addWfProcessDefLog(userId, LogTypeEnum.INFO, procDefInfo.getProcDefId(), ProcessDefOperationEnum.RELEASE);
        return rtnValue;
    }

    private void tryToUpdateUIPkRef(String processId) {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("delete from t_wfr_uipkRef where fprocdefId =? and fispublish = ?");
            SQL.executeUpdate((Context)this.getContext(), (String)sql.toString(), (int[])new int[]{12, 4}, (Object[])new Object[]{processId, 1});
            sql.setLength(0);
            sql.append("update t_wfr_uipkref set fispublish = 1 where fprocdefid=? and fispublish = 0");
            SQL.executeUpdate((Context)this.getContext(), (String)sql.toString(), (int[])new int[]{12}, (Object[])new Object[]{processId});
        }
        catch (Throwable e) {
            log.error((Object)"update t_wfr_uipkref error ", e);
        }
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    public String findSubmitProcDef(BOSObjectType boType, String userID) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:WfDefineService Method:findSubmitProcDef been called.");
            String desc = buffer.toString();
            buffer.append("parameter: boType=\"");
            buffer.append(boType.toString());
            buffer.append('\"');
            buffer.append(" userID=\"");
            buffer.append(userID);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        if (boType == null || StringUtils.isEmpty((String)userID)) {
            throw new IllegalArgumentException("boType or userID is null");
        }
        Context ctx = this.getContext();
        MetaDataPK operationPk = new MetaDataPK(SUBMIT_METHOD_INNER_ID);
        if (!this.operationMatch((IMetaDataPK)operationPk, boType, ctx)) {
            return null;
        }
        BizEventMap.EventStructEntry[] eventMapEntry = EventUtils.getByMethod(ctx, operationPk.getName() + boType.toString());
        if (eventMapEntry == null || eventMapEntry.length == 0) {
            return null;
        }
        String fullFuncName = eventMapEntry[0].getFunction();
        String operatonName = eventMapEntry[0].getOperation();
        String functionName = fullFuncName.substring(fullFuncName.lastIndexOf(".") + 1, fullFuncName.length());
        String packageName = fullFuncName.substring(0, fullFuncName.lastIndexOf("."));
        return this.findProcDef(userID, functionName, packageName, operatonName);
    }

    public String findSubmitProcDef(String userID, IObjectValue bizObject, String functionName, String operationName) throws WfException {
        assert (!StringUtils.isEmpty((String)userID));
        Context ctx = this.getContext();
        String bizPackageName = null;
        String bizFunctionName = null;
        String bizOperationName = null;
        if (!StringUtils.isEmpty((String)functionName) && !StringUtils.isEmpty((String)operationName)) {
            bizPackageName = functionName.substring(0, functionName.lastIndexOf("."));
            bizFunctionName = functionName.substring(functionName.lastIndexOf(".") + 1);
            bizOperationName = operationName;
        } else {
            MetaDataPK defaultSubmitMethodPK = new MetaDataPK(SUBMIT_METHOD_INNER_ID);
            if (!this.operationMatch((IMetaDataPK)defaultSubmitMethodPK, bizObject.getBOSType(), ctx)) {
                return null;
            }
            BizEventMap.EventStructEntry[] eventMapEntry = EventUtils.getByMethod(ctx, SUBMIT_METHOD_INNER_ID + bizObject.getBOSType().toString());
            if (eventMapEntry == null || eventMapEntry.length == 0) {
                return null;
            }
            String bizFullFunctionName = eventMapEntry[0].getFunction();
            bizPackageName = bizFullFunctionName.substring(0, bizFullFunctionName.lastIndexOf("."));
            bizFunctionName = bizFullFunctionName.substring(bizFullFunctionName.lastIndexOf(".") + 1);
            bizOperationName = eventMapEntry[0].getOperation();
        }
        if (bizObject != null) {
            return this.findProcDef(userID, bizObject, bizFunctionName, bizPackageName, bizOperationName);
        }
        return this.findProcDef(userID, bizFunctionName, bizPackageName, bizOperationName);
    }

    private boolean operationMatch(IMetaDataPK operationPk, BOSObjectType boType, Context ctx) {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:WfDefineService Method:operationMatch been called.");
            String desc = buffer.toString();
            buffer.append("parameter: operationPk=\"");
            buffer.append(operationPk.toString());
            buffer.append('\"');
            buffer.append(" boType=\"");
            buffer.append(boType);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        if (operationPk == null) {
            return false;
        }
        return EventUtils.containsByMethod(ctx, operationPk.getName() + boType.toString());
    }

    public String findProcDef(String userID, String funcName, String packageName, String operationName) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:WfDefineService Method:findProcDef been called.");
            String desc = buffer.toString();
            buffer.append("parameter: userID=\"");
            buffer.append(userID.toString());
            buffer.append('\"');
            buffer.append(" funcName=\"");
            buffer.append(funcName);
            buffer.append('\"');
            buffer.append(" packageName=\"");
            buffer.append(packageName);
            buffer.append('\"');
            buffer.append(" operationName=\"");
            buffer.append(operationName);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        if (StringUtils.isEmpty((String)userID)) {
            throw new IllegalArgumentException("userId is null");
        }
        if (StringUtils.isEmpty((String)funcName)) {
            throw new IllegalArgumentException("funcName is null");
        }
        if (StringUtils.isEmpty((String)packageName)) {
            throw new IllegalArgumentException("packageName is null");
        }
        if (StringUtils.isEmpty((String)operationName)) {
            throw new IllegalArgumentException("operationName is null");
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        Person person = wfEngine.getPariticipantProvider().getPersonByUserId(this.getContext(), userID);
        if (person == null) {
            return null;
        }
        BizProcInfo[] bizProcInfoArray = null;
        bizProcInfoArray = person.getUserId() != null && person.getEmployeeId() == null ? wfEngine.getBizProcFinder().findProcDef(person, PerformerType.USER, funcName, packageName, operationName) : wfEngine.getBizProcFinder().findProcDef(person, PerformerType.EMPLOYEE, funcName, packageName, operationName);
        if (bizProcInfoArray.length == 0) {
            return null;
        }
        ArrayList<BizProcInfo> list = new ArrayList<BizProcInfo>();
        for (int i = 0; i < bizProcInfoArray.length; ++i) {
            if (!EngineUtil.getEngine(this.getContext()).getProcessMgr(bizProcInfoArray[i].getProcDefId()).getData().isEnable()) continue;
            list.add(bizProcInfoArray[i]);
        }
        if (list.size() == 0) {
            return null;
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object obj, Object anotherObj) {
                BizProcInfo info = (BizProcInfo)obj;
                BizProcInfo info2 = (BizProcInfo)anotherObj;
                return info.getProcPriority() - info2.getProcPriority();
            }
        });
        return ((BizProcInfo)list.get(0)).getProcDefId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findProcDef(String userID, IObjectValue bizOBject, String funcName, String packageName, String operationName) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:WfDefineService Method:findProcDef been called.");
            String desc = buffer.toString();
            buffer.append("parameter: userID=\"");
            buffer.append(userID.toString());
            buffer.append('\"');
            buffer.append(" funcName=\"");
            buffer.append(funcName);
            buffer.append('\"');
            buffer.append(" packageName=\"");
            buffer.append(packageName);
            buffer.append('\"');
            buffer.append(" operationName=\"");
            buffer.append(operationName);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        if (StringUtils.isEmpty((String)userID)) {
            throw new IllegalArgumentException("userId is null");
        }
        if (bizOBject == null) {
            throw new IllegalArgumentException("bizOBject is null");
        }
        if (StringUtils.isEmpty((String)funcName)) {
            throw new IllegalArgumentException("funcName is null");
        }
        if (StringUtils.isEmpty((String)packageName)) {
            throw new IllegalArgumentException("packageName is null");
        }
        if (StringUtils.isEmpty((String)operationName)) {
            throw new IllegalArgumentException("operationName is null");
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        Person person = null;
        person = EngineUtil.getEngine(this.getContext()).getPariticipantProvider().getPersonByUserId(this.getContext(), userID);
        if (person == null) {
            return null;
        }
        BizProcInfo[] bizProcInfoArray = null;
        if (person.getUserId() != null && person.getEmployeeId() == null) {
            bizProcInfoArray = wfEngine.getBizProcFinder().findProcDef(person, PerformerType.USER, funcName, packageName, operationName);
        } else {
            try {
                ThreadCache.create();
                ThreadCache.put("OBJECT_VALUE", bizOBject);
                bizProcInfoArray = wfEngine.getBizProcFinder().findProcDef(person, PerformerType.EMPLOYEE, funcName, packageName, operationName);
            }
            finally {
                ThreadCache.destroy();
            }
        }
        if (bizProcInfoArray == null || bizProcInfoArray.length == 0) {
            return null;
        }
        BizProcInfo matchedBizPorcInfo = wfEngine.findMatchedBizProcInfo(bizOBject, bizProcInfoArray);
        if (matchedBizPorcInfo == null) {
            return null;
        }
        return matchedBizPorcInfo.getProcDefId();
    }

    public void deleteProcessDefine(String processDefineId) throws DataAccessException, WfException, SQLException {
        IObjectPK logPk = WorkflowLogUtil.beginLogByLocal(this.getContext(), WorkflowLogItem.PROCESS_DEF_TABLE_DEL, processDefineId);
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:WfDefineService Method:findProcDef been called.");
            String desc = buffer.toString();
            buffer.append("parameter: processDefineId=\"");
            buffer.append(processDefineId.toString());
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        EngineUtil.getEngine(this.getContext()).getStoreManager().getProcessStorer().deleteProcessDefine(processDefineId, -1);
        WorkflowLogUtil.endLogByLocal(this.getContext(), logPk);
    }

    public void deleteProcessDefine(String processDefineId, int innerVersion) throws DataAccessException, WfException, SQLException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:WfDefineService Method:findProcDef been called.");
            String desc = buffer.toString();
            buffer.append("parameter: processDefineId=\"");
            buffer.append(processDefineId.toString());
            buffer.append('\"');
            buffer.append(" innerVersion=");
            buffer.append(innerVersion);
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        EngineUtil.getEngine(this.getContext()).getStoreManager().getProcessStorer().deleteProcessDefine(processDefineId, innerVersion);
    }

    public boolean isSendMail(String procInstId, String actInstId, String procHashValue) throws WfException {
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        ProcessDef procDef = wfEngine.getProcessDef(procHashValue);
        ProcessInstInfo procInstInfo = wfEngine.getProcessInst(procInstId).getProcessMeta();
        String processDefId = procInstInfo.getProcDefId();
        if (!procDef.getID().equals(processDefId)) {
            return false;
        }
        ActivityInstInfo actInstInfo = wfEngine.getActivityInst(actInstId).getMeta();
        if (actInstInfo == null) {
            throw new WfException("can not get actInstInfo by actInstId:" + actInstId);
        }
        String actDefId = actInstInfo.getActDefId();
        ActivityDef actDef = procDef.getActivitys().get(actDefId);
        if (actDef == null) {
            throw new WfException("can not find activity,procDefId:" + processDefId + ",activityDefId:" + actDefId);
        }
        if (actDef instanceof IMessageActivity) {
            IMessageActivity msgAct = (IMessageActivity)actDef;
            AssignmentMessage msg = msgAct.getMessage();
            if (msgAct instanceof MessageActivityDef) {
                return msg.isSendMail();
            }
            return msg.isSendMail() && this.checkInPreApproveActivity(wfEngine, procInstId, actInstId, "isMailNotifyNext");
        }
        return false;
    }

    private boolean checkInPreApproveActivity(WfEngine wfEngine, String procInstId, String actInstId, String methodName) throws WfException {
        ActivityInstInfo actInstInfo = wfEngine.getActivityInst(actInstId).getMeta();
        String[] preActInstIds = actInstInfo.getPreActInstList();
        boolean hasApproveActivity = false;
        for (String preActInstId : preActInstIds) {
            WfActivity preActInst = wfEngine.getActivityInst(preActInstId);
            ActivityDef actDef = preActInst.getDefinition();
            if (actDef instanceof ApproveActivityDef) {
                hasApproveActivity = true;
                WfActivity preActivity = wfEngine.getActivityInst(preActInstId);
                List list = preActivity.assignments();
                int m = list.size();
                for (int j = 0; j < m; ++j) {
                    WfAssignment wfAssignment = (WfAssignment)list.get(j);
                    String assignId = wfAssignment.getId();
                    if (!wfAssignment.state().equals((Object)WfAssignmentState.COMPLETED)) continue;
                    try {
                        IBOSObject obj = BOSObjectFactory.createBOSObject((Context)this.getContext(), (BOSObjectType)BOSObjectType.create((String)"63D30103"));
                        Class[] paramTypes = new Class[]{String.class};
                        Object[] args = new Object[]{assignId};
                        Method method = obj.getClass().getMethod(methodName, paramTypes);
                        if (method == null) {
                            throw new WfException("fatal error");
                        }
                        boolean isSend = (Boolean)method.invoke((Object)obj, args);
                        if (!isSend) continue;
                        return isSend;
                    }
                    catch (BOSException e) {
                        throw new WfException((Throwable)e);
                    }
                    catch (SecurityException e) {
                        throw new WfException((Throwable)e);
                    }
                    catch (NoSuchMethodException e) {
                        throw new WfException((Throwable)e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new WfException((Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new WfException((Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new WfException((Throwable)e);
                    }
                }
                continue;
            }
            if (actDef instanceof ManpowerActivityDef) continue;
            if (actDef instanceof StartActivityDef) {
                return true;
            }
            if (actDef instanceof SubflowActivityDef) {
                ActivityInstInfo preActInstInfo = wfEngine.getActivityInst(preActInstId).getMeta();
                String subProcInstId = preActInstInfo.getSubProcInstId();
                if (StringUtils.isEmpty((String)subProcInstId)) continue;
                String endActivityId = this.getEndActivityId(wfEngine, subProcInstId);
                return this.checkInPreApproveActivity(wfEngine, subProcInstId, endActivityId, methodName);
            }
            return this.checkInPreApproveActivity(wfEngine, procInstId, preActInstId, methodName);
        }
        return !hasApproveActivity;
    }

    private String getEndActivityId(WfEngine wfEngine, String procInstId) throws WfException {
        WfProcess wfProcess = wfEngine.getProcessInst(procInstId);
        List list = wfProcess.activities();
        boolean hasApproveActivity = false;
        String endActivityId = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            WfActivity actInst = (WfActivity)list.get(i);
            String actInstId = actInst.getId();
            if (actInst.getDefinition() instanceof EndActivityDef) {
                endActivityId = actInstId;
            }
            if (!(actInst.getDefinition() instanceof ApproveActivityDef)) continue;
            hasApproveActivity = true;
        }
        if (hasApproveActivity) {
            return endActivityId;
        }
        return null;
    }

    public boolean isSendMobelMessage(String procInstId, String actInstId, String procHashValue) throws WfException {
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        ProcessDef procDef = wfEngine.getProcessDef(procHashValue);
        ProcessInstInfo procInstInfo = wfEngine.getProcessInst(procInstId).getProcessMeta();
        String processDefId = procInstInfo.getProcDefId();
        if (!procDef.getID().equals(processDefId)) {
            return false;
        }
        ActivityInstInfo actInstInfo = wfEngine.getActivityInst(actInstId).getMeta();
        if (actInstInfo == null) {
            throw new WfException("can not get actInstInfo by actInstId:" + actInstId);
        }
        String actDefId = actInstInfo.getActDefId();
        ActivityDef actDef = procDef.getActivitys().get(actDefId);
        if (actDef == null) {
            throw new WfException("can not find activity,procDefId:" + processDefId + ",activityDefId:" + actDefId);
        }
        if (actDef instanceof IEMessageActivity) {
            IEMessageActivity emsgAct = (IEMessageActivity)actDef;
            EMessage emsg = emsgAct.getEMessage();
            if (actDef instanceof MessageActivityDef) {
                return emsg.isEnable();
            }
            return emsg.isEnable() && this.checkInPreApproveActivity(wfEngine, procInstId, actInstId, "isMobelNotifyNext");
        }
        return false;
    }

    public ProcessDef getProcessDefByDefineHashValue(String procDefHashValue) throws WfException {
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfDefinitionMgr defMgr = wfEngine.getDefinitionMgr();
        return defMgr.getProcessDefByHash(procDefHashValue);
    }

    public void deleteEventProc(String procDefId) throws WfException, DataAccessException, SQLException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:WfDefineService Method:deleteEventProc been called.");
            String desc = buffer.toString();
            buffer.append("parameter: procDefId=\"");
            buffer.append(procDefId);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        EngineUtil.getEngine(this.getContext()).getStoreManager().getEventStorer().clearEventProcRelation(procDefId);
    }

    public void deleteBizProc(String processDefineId) throws WfException, DataAccessException, SQLException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:WfDefineService Method:deleteBizProc been called.");
            String desc = buffer.toString();
            buffer.append("parameter: processDefineId=\"");
            buffer.append(processDefineId.toString());
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        EngineUtil.getEngine(this.getContext()).getStoreManager().getProcessStorer().clearBizProcRelation(processDefineId);
    }

    public ProcessDefInfo[] getProcessDefInfos(String packageName, String functionName, String operationName, int performerType) throws WfException {
        return WfEngine.getEngine(this.getContext()).getStoreManager().getProcessStorer().getProcessDefInfos(packageName, functionName, operationName, performerType);
    }

    public void setProcessDefEnable(String userId, String[] procDefIds, boolean enable) throws WfException {
        int size = procDefIds.length;
        for (int i = 0; i < size; ++i) {
            this.setProcessDefEnable(userId, procDefIds[i], enable);
        }
    }

    public Set getOperationsOfBindingProcessStartEvent() throws WfException {
        HashSet<String> retVal = new HashSet<String>();
        try {
            WfEngine engine = WfEngine.getEngine(this.getContext());
            ProcessStorer storer = engine.getStoreManager().getProcessStorer();
            BizProcMetaCollection bizProcCol = storer.getBizProcInfoCollection("select bizPackage, bizFunc, bizOperation");
            if (bizProcCol != null) {
                int n = bizProcCol.size();
                for (int i = 0; i < n; ++i) {
                    BizProcMetaInfo bizProcInfo = bizProcCol.get(i);
                    String bizPackage = bizProcInfo.getBizPackage();
                    String bizFunc = bizProcInfo.getBizFunc();
                    String bizOper = bizProcInfo.getBizOperation();
                    String key = bizPackage + "." + bizFunc + "-" + bizOper;
                    retVal.add(key);
                }
            }
        }
        catch (DataAccessException e) {
            throw new WfException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
        return retVal;
    }

    public boolean isBindedProcessStartEvent(String fullFunctionName, String operationName) throws WfException {
        int pos = fullFunctionName.lastIndexOf(46);
        String pack = fullFunctionName.substring(0, pos);
        String funcName = fullFunctionName.substring(pos + 1);
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            boolean ret;
            con = EJBFactory.getConnection((Context)this.getContext());
            ps = con.prepareStatement("select top 1 1 from t_wfr_BizProc a, t_wfr_procdef b  where a.fbizPackage = ? and a.fbizFunc = ? and a.fbizOperation = ? and a.fprocdefid = b.fprocdefid and b.fenable=1");
            ps.setString(1, pack);
            ps.setString(2, funcName);
            ps.setString(3, operationName);
            rs = ps.executeQuery();
            boolean bl = ret = rs.next();
            return bl;
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ActivityDef getActDefByActInstInfo(ActivityInstInfo actInstInfo) throws WfException {
        String hash;
        ActivityDef actDef = null;
        WfEngine wfEngine = WfEngine.getEngine(this.getContext());
        ProcessDef procDef = wfEngine.getProcessDef(hash = actInstInfo.getProcDefHashValue());
        if (procDef != null) {
            actDef = procDef.getActivityDef(actInstInfo.getActDefId());
        }
        return actDef;
    }

    public boolean isSubProcessDefine(String processDefineID) throws WfException {
        WfProcessMgr wfProcessMgr = WfEngine.getEngine(this.getContext()).getProcessMgr(processDefineID);
        ProcessDef processDef = wfProcessMgr.getProcessDef();
        return AccessLevel.PRIVATE.equals((Object)processDef.getAccessLevel());
    }

    public ProcessDef getRuntimeProcessDef(String procDefHashValue) throws WfException {
        WfEngine wfEngine = WfEngine.getEngine(this.getContext());
        return wfEngine.getProcessDef(procDefHashValue);
    }

    public int getActTypeByAssignment(String assignmentID) throws WfException {
        WfEngine wfEngine = WfEngine.getEngine(this.getContext());
        AssignmentInfo info = wfEngine.getAssignment(assignmentID).getMeta();
        if (info == null) {
            throw new WfException("Can not find Assignment which id is :" + assignmentID);
        }
        String id = info.getActInstId();
        WfActivity actInst = wfEngine.getActivityInst(id);
        if (actInst != null) {
            ActivityDef def = actInst.getDefinition();
            Class<?> cls = def.getClass();
            if (cls == BlockActivityDef.class) {
                return 0;
            }
            if (cls == EndActivityDef.class) {
                return 1;
            }
            if (cls == ManpowerActivityDef.class) {
                return 2;
            }
            if (cls == ApproveActivityDef.class) {
                return 3;
            }
            if (cls == ManualDecisionActivityDef.class) {
                return 4;
            }
            if (cls == RouterActivityDef.class) {
                return 5;
            }
            if (cls == StartActivityDef.class) {
                return 6;
            }
            if (cls == SubflowActivityDef.class) {
                return 7;
            }
            if (cls == ToolActivityDef.class) {
                return 13;
            }
            if (cls == BotpActivityDef.class) {
                return 8;
            }
            if (cls == ExtenalClassActivityDef.class) {
                return 9;
            }
            if (cls == FunctionActivityDef.class) {
                return 10;
            }
            if (cls == MessageActivityDef.class) {
                return 11;
            }
            if (cls == ScriptActivityDef.class) {
                return 12;
            }
            if (cls == ServiceActivityDef.class) {
                return 14;
            }
            if (cls == WebBillManpowerActivityDef.class) {
                return 15;
            }
            return -1;
        }
        throw new WfException("Can not find activity instance which assignment id is :" + assignmentID);
    }

    public String getStatusByAssignment(String assignmentID) throws WfException {
        WfEngine wfEngine = WfEngine.getEngine(this.getContext());
        AssignmentInfo info = wfEngine.getAssignment(assignmentID).getMeta();
        if (info == null) {
            throw new WfException("Can not find Assignment which id is :" + assignmentID);
        }
        String id = info.getActInstId();
        WfActivity actInst = wfEngine.getActivityInst(id);
        ActivityDef actDef = actInst.getDefinition();
        if (actDef != null && actDef.getActivityHeader().getExtendedAttributes().get("customUIStatus") != null) {
            ExtendedAttributeDef attrDef = actDef.getActivityHeader().getExtendedAttributes().get("customUIStatus");
            return attrDef.getValue();
        }
        return null;
    }

    public String getMultiApproveDecision(String assignmentID) throws WfException {
        ExtendedAttributeDef attr;
        ExtendedAttributeCollection attrs;
        ApproveActivityDef approveDef;
        String manulDecisionItem = "";
        WfEngine wfEngine = WfEngine.getEngine(this.getContext());
        AssignmentInfo info = wfEngine.getAssignment(assignmentID).getMeta();
        if (info == null) {
            throw new WfException("Can not find Assignment which id is :" + assignmentID);
        }
        String actInstId = info.getActInstId();
        WfActivity actInst = wfEngine.getActivityInst(actInstId);
        ActivityDef actDef = actInst.getDefinition();
        if (actDef instanceof ApproveActivityDef && StringUtils.isEmpty((String)(manulDecisionItem = (approveDef = (ApproveActivityDef)actDef).getManualDecisionItems(this.getContext().getLocale())))) {
            manulDecisionItem = approveDef.getManualDecisionItems();
        }
        if (StringUtils.isEmpty((String)manulDecisionItem) && (attrs = actDef.getActivityHeader().getExtendedAttributes()) != null && (attr = attrs.get("manualDecisionItems")) != null) {
            manulDecisionItem = attr.getValue();
        }
        return manulDecisionItem;
    }

    @Override
    public String getIdentifier() {
        return String.valueOf(this.hashCode());
    }
}

