/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.scheduler.util.SchedulerUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.workcalendar.IWorkCalendarDayProvider;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class WorkCalendarService
extends AbstractBOSObject
implements IWorkCalendarDayProvider {
    private static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"WFWORKCALS");
    private static WorkCalendarService instance = new WorkCalendarService();

    private static Date getDayBegin() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static WorkCalendarService getInstance() {
        return instance;
    }

    private static Date getNextDay(Date date) {
        return new Date(date.getTime() + 86400000L);
    }

    private WorkCalendarService() {
    }

    public Date add(Context ctx, String orgId, Date workday, int diff) throws BOSException {
        Calendar cal = Calendar.getInstance();
        workday = this.getWorkDay(ctx, orgId, workday);
        cal.setTime(workday);
        for (int i = 0; i < diff; ++i) {
            cal.add(5, 1);
            workday = cal.getTime();
            workday = this.getWorkDay(ctx, orgId, workday);
            cal.setTime(workday);
        }
        return workday;
    }

    public Date getNowWorkDay(Context ctx, String orgId) throws BOSException {
        Date d = WorkCalendarService.getDayBegin();
        d = this.getWorkDay(ctx, orgId, d);
        return d;
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    private Date getWorkDay(Context ctx, String orgId, Date d) throws BOSException {
        while (!this.isWorkDay(ctx, orgId, true, d)) {
            d = WorkCalendarService.getNextDay(d);
        }
        return d;
    }

    private boolean isWorkDay(Context ctx, String orgUnitID, boolean isCastBack, Date d) throws BOSException {
        return SchedulerUtils.isWorkDay((Context)ctx, (String)orgUnitID, (Date)d, (boolean)isCastBack);
    }

    public boolean isWorkDay(Context ctx, String orgId, Date date) throws BOSException {
        return this.isWorkDay(ctx, orgId, true, date);
    }
}

