/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service.ormrpc;

import com.kingdee.bos.Context;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.service.job.core.BOSSchedulerService;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.JobLoader;
import com.kingdee.bos.service.job.core.ReadyJobs;
import com.kingdee.bos.service.job.core.RunningJobs;
import com.kingdee.bos.service.job.core.WaitingJobs;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.recycle.WfRecycleMange;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.enactment.trace.WfLoggerManage;
import com.kingdee.bos.workflow.service.ormrpc.IWfRunMonitorService;
import com.kingdee.bos.workflow.store.StoreManager;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.log4j.Logger;

public class WfRunMonitorService
extends ORMObject
implements IWfRunMonitorService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.service.ormrpc.WfRunMonitorService");
    public static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"WFRUNM");

    public WfRunMonitorService() {
        super.registerInterface(IWfRunMonitorService.class, (Object)this);
    }

    public WfRunMonitorService(Context ctx) {
        super.registerInterface(IWfRunMonitorService.class, (Object)this);
    }

    public boolean checkWfLicence() {
        try {
            Class<?> cls = Class.forName("com.kingdee.eas.base.license.agent.LicenseSrvFactory");
            Object srv = cls.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Method m = srv.getClass().getMethod("licenseCheck", String.class);
            int r = (Integer)m.invoke(srv, "BPM");
            if (r != 1) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean jobServerIsRun() {
        return BOSSchedulerService.isRunning();
    }

    public boolean jobServerIsEnable() {
        return Configuration.isEnable();
    }

    public String getJobIsolationLevel() {
        return Configuration.defaultJobIsolationLevel().toString();
    }

    public int getJobLoaderSize() {
        return JobLoader.loadJobSize;
    }

    public int getReadJobSize() {
        return ReadyJobs.size();
    }

    public int getWaitingJobsSize() {
        return WaitingJobs.size();
    }

    public int getRunningJobsSize() {
        return RunningJobs.size();
    }

    public List getReadJobs() {
        return ReadyJobs.getAllJobs();
    }

    public List getWaitingJobs() {
        return WaitingJobs.getAllJobs();
    }

    public List getRunningJobs() {
        return RunningJobs.getAllJobs();
    }

    public WfEngine getEngine(String key) {
        WfEngine engine = null;
        try {
            engine = WfEngine.getEnginenew(key);
        }
        catch (WfException e) {
            e.printStackTrace();
        }
        return engine;
    }

    public int getState(String key) {
        if (this.getEngine(key) != null) {
            return this.getEngine(key).getState();
        }
        return 0;
    }

    public void restart(String key) throws WfException {
        if (this.getEngine(key) != null) {
            this.getEngine(key).restart();
        }
    }

    public void restartAll() throws WfException {
        WfEngine.restartAll();
    }

    public void start(String key) throws WfException {
        if (this.getEngine(key) != null) {
            this.getEngine(key).start();
        }
    }

    public void startAll() throws WfException {
        WfEngine.startAll();
    }

    public void clearCache(String key) throws WfException {
        if (this.getEngine(key) != null) {
            this.getEngine(key).clearCache();
        }
    }

    public void clearCacheAll() throws WfException {
        WfEngine.clearCacheAll();
    }

    public int getDaysOfBeforeToClear() {
        WfRecycleMange rcy = new WfRecycleMange();
        return rcy.getDaysOfBeforeToClear();
    }

    public int getNumberOfPerRecycle() {
        WfRecycleMange rcy = new WfRecycleMange();
        return rcy.getNumberOfPerRecycle();
    }

    public int getRunBeginClock() {
        WfRecycleMange rcy = new WfRecycleMange();
        return rcy.getRunBeginClock();
    }

    public int getRunEndClock() {
        WfRecycleMange rcy = new WfRecycleMange();
        return rcy.getRunEndClock();
    }

    public boolean getStop() {
        WfRecycleMange rcy = new WfRecycleMange();
        return rcy.getStop();
    }

    public void setWfRecycle(int daysOfBeforeToClear, int numberOfPerRecycle, int runBeginClock, int runEndClock, boolean stop) {
        WfRecycleMange rcy = new WfRecycleMange();
        rcy.setDaysOfBeforeToClear(daysOfBeforeToClear);
        rcy.setNumberOfPerRecycle(numberOfPerRecycle);
        rcy.setRunBeginClock(runBeginClock);
        rcy.setRunEndClock(runEndClock);
        rcy.setStop(stop);
    }

    public boolean isEnableEngineLog(String key) {
        if (this.getEngine(key) != null) {
            WfEngine wfengine = this.getEngine(key);
            StoreManager sm = new StoreManager(wfengine);
            WfLogger wl = new WfLogger(sm);
            WfLoggerManage wfm = new WfLoggerManage(wl);
            return wfm.isEnableEngineLog();
        }
        return false;
    }

    public boolean isEnableProcessInstLog(String key) {
        if (this.getEngine(key) != null) {
            WfEngine wfengine = this.getEngine(key);
            StoreManager sm = new StoreManager(wfengine);
            WfLogger wl = new WfLogger(sm);
            WfLoggerManage wfm = new WfLoggerManage(wl);
            return wfm.isEnableProcessInstLog();
        }
        return false;
    }

    public String getLogLevel(String key) {
        if (this.getEngine(key) != null) {
            WfEngine wfengine = this.getEngine(key);
            StoreManager sm = new StoreManager(wfengine);
            WfLogger wl = new WfLogger(sm);
            WfLoggerManage wfm = new WfLoggerManage(wl);
            return wfm.getLogLevel();
        }
        return "";
    }

    public void setWfLogger(String key, boolean isEnableQueueLog, boolean enableProcessInstLog, String logLevel) {
        if (this.getEngine(key) != null) {
            WfEngine wfengine = this.getEngine(key);
            StoreManager sm = new StoreManager(wfengine);
            WfLogger wl = new WfLogger(sm);
            WfLoggerManage wfm = new WfLoggerManage(wl);
            wfm.setEnableEngineLog(isEnableQueueLog);
            wfm.setEnableProcessInstLog(enableProcessInstLog);
            wfm.setLogLevel(logLevel);
        }
    }
}

