/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.metas.CorrMatchDataFieldCollection;
import com.kingdee.bos.workflow.metas.CorrMatchDataFieldFactory;
import com.kingdee.bos.workflow.metas.CorrMatchDataFieldInfo;
import com.kingdee.bos.workflow.metas.ICorrMatchDataField;
import com.kingdee.bos.workflow.store.AbstractBaseStorer;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class CorrMatchDataFieldStorer
extends AbstractBaseStorer {
    private static final Logger logger = Logger.getLogger(CorrMatchDataFieldStorer.class);

    CorrMatchDataFieldStorer(Context context) {
        super(context);
    }

    public void deleteCorrMatcheDataFieldsByProcInstId(String procInstId) throws WfException {
        try {
            ICorrMatchDataField corrMatchDataField = CorrMatchDataFieldFactory.getLocalInstance((Context)this.getContext());
            String oql = "WHERE procInstId = '" + procInstId + "' ";
            corrMatchDataField.delete(oql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
    }

    public CorrMatchDataFieldInfo getCorrMatchDataFieldInfo(String procInstId, String dataFieldName) throws WfException {
        try {
            ICorrMatchDataField corrMatchDataField = CorrMatchDataFieldFactory.getLocalInstance((Context)this.getContext());
            String oql = "WHERE procInstId =  '" + procInstId + "' AND dataFieldName = '" + dataFieldName + "' ";
            CorrMatchDataFieldCollection collection = corrMatchDataField.getCollection(oql);
            if (collection.size() > 0) {
                return collection.get(0);
            }
            return null;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
    }

    public Set getMatchedProcDefIds() throws WfException {
        HashSet<String> hashSet;
        HashSet<String> retVal = new HashSet<String>();
        Connection cn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection();
            ps = cn.prepareStatement("SELECT DISTINCT FProcDefId FROM T_WFR_CorrelationMatch");
            rs = ps.executeQuery();
            while (rs.next()) {
                retVal.add(rs.getString("FProcDefId"));
            }
            hashSet = retVal;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new WfException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
        return hashSet;
    }

    public void addCorrMatchDataFieldInfo(CorrMatchDataFieldInfo corrMatchDataFieldInfo) throws WfException {
        try {
            ICorrMatchDataField corrMatchDataField = CorrMatchDataFieldFactory.getLocalInstance((Context)this.getContext());
            corrMatchDataField.addnew((IObjectPK)new ObjectUuidPK(corrMatchDataFieldInfo.getId()), corrMatchDataFieldInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
    }

    public void updateCorrMatchDataFieldInfo(CorrMatchDataFieldInfo corrMatchDataFieldInfo) throws WfException {
        try {
            ICorrMatchDataField corrMatchDataField = CorrMatchDataFieldFactory.getLocalInstance((Context)this.getContext());
            corrMatchDataField.update((IObjectPK)new ObjectUuidPK(corrMatchDataFieldInfo.getId()), corrMatchDataFieldInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
    }
}

