/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.returns.Delay;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.store.WorkItemStorer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class WorkItemCleanup
implements IJobHandler {
    private static final long serialVersionUID = 3575097229746267968L;

    public static void init(Context ctx) {
        if (ctx == null) {
            throw new NullPointerException();
        }
        Job job = new Job(ctx, (IJobHandler)new WorkItemCleanup(), null, false);
        JobManager.instance().add(job);
    }

    public Object execute(Job job) throws Exception {
        try {
            this.deleteClosedAssigns(job);
        }
        catch (Throwable t) {
            JobLog log = new JobLog(JobLog.Type.Error, "\u6e05\u9664\u5df2\u5173\u95ed\u4efb\u52a1\u5931\u8d25!", "-", "-", t);
            job.saveMessage(log);
        }
        return new Delay(3600);
    }

    private void deleteClosedAssigns(Job job) throws BOSException {
        block0: while (true) {
            String sql = "select top 100 fassignid from t_wfr_assign WITH(READPAST) where fstate in(4,8,16)";
            ArrayList result = SQL.executeQuery((Context)job.getContext(), (String)sql);
            if (result.size() == 0) break;
            WfEngine engine = WfEngine.getEngine(job.getContext());
            int i = 0;
            while (true) {
                if (i >= result.size()) continue block0;
                Map map = (Map)result.get(i);
                String assignId = (String)map.get("fassignid");
                String countSql = "select count(*) as c from T_WFR_AssignDetail  where fassignid='" + assignId + "'";
                Map item = (Map)SQL.executeQuery((Context)job.getContext(), (String)countSql).get(0);
                int count = ((Number)item.get("c")).intValue();
                if (count == 0) {
                    WorkItemStorer storer = engine.getStoreManager().getWorkItemStorer();
                    HashSet<String> set = new HashSet<String>(1);
                    set.add(assignId);
                    storer.dump(set);
                } else {
                    String delete = "delete from t_wfr_assign where fassignid='" + assignId + "'";
                    SQL.executeUpdate((Context)job.getContext(), (String)delete);
                }
                ++i;
            }
            break;
        }
    }
}

