/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.transaction;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.cache.IWfCacheManager;
import com.kingdee.bos.workflow.extscheme.search.WFSearchAgent;
import com.kingdee.bos.workflow.store.ActivityBatchPersistence;
import com.kingdee.bos.workflow.store.AssignmentBatchPersistence;
import com.kingdee.bos.workflow.store.ProcessBatchPersistence;
import com.kingdee.bos.workflow.store.ProcessContextBatchPersistence;
import com.kingdee.bos.workflow.transaction.LazyPersistentMgr;
import com.kingdee.bos.workflow.transaction.TxActivityMgr;
import com.kingdee.bos.workflow.transaction.TxAssignmentMgr;
import com.kingdee.bos.workflow.transaction.TxMessageMgr;
import com.kingdee.bos.workflow.transaction.TxProcessMgr;
import com.kingdee.bos.workflow.transaction.WfMutexMgr;
import com.kingdee.util.LowTimer;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.log4j.Logger;

public class WfTxContext {
    private static final Logger logger = Logger.getLogger(WfTxContext.class);
    private final Context bosCtx;
    private LazyPersistentMgr lazyPersistentMgr = null;
    private WfMutexMgr mutexMgr;
    private TxProcessMgr txProcessMgr;
    private TxActivityMgr txActivityMgr;
    private TxAssignmentMgr txAssignmentMgr;
    private TxMessageMgr txMessageMgr;
    private static ThreadLocal threadCtx = new ThreadLocal();
    private final Stack stackCtx;

    private WfTxContext(Context ctx) {
        this.bosCtx = ctx;
        this.stackCtx = new Stack();
        this.initLazyPersistentMgr();
        this.initMutexMgr();
        this.initTxManagers();
    }

    public static WfTxContext current() {
        Stack stackCtx = (Stack)threadCtx.get();
        if (stackCtx != null && !stackCtx.isEmpty()) {
            return (WfTxContext)stackCtx.peek();
        }
        return null;
    }

    public static WfTxContext beginTx(Context ctx) {
        WfTxContext wfContext = null;
        Stack stackCtx = (Stack)threadCtx.get();
        wfContext = stackCtx != null && !stackCtx.isEmpty() ? (WfTxContext)stackCtx.peek() : new WfTxContext(ctx);
        wfContext.stackCtx.push(wfContext);
        threadCtx.set(wfContext.stackCtx);
        return wfContext;
    }

    public static WfTxContext beginNewTx(Context ctx) {
        WfTxContext wfContext = new WfTxContext(ctx);
        wfContext.stackCtx.push(wfContext);
        threadCtx.set(wfContext.stackCtx);
        return wfContext;
    }

    public static void setCurrent(WfTxContext wfContext) {
        if (wfContext == null) {
            threadCtx.set(null);
        } else {
            threadCtx.set(wfContext.stackCtx);
        }
    }

    public void endTx() {
        LowTimer lowTimer = new LowTimer();
        try {
            if (this.isTopTx()) {
                int size2;
                int size1;
                this.notifyCacheChange();
                do {
                    ArrayList createEventList = new ArrayList();
                    createEventList.addAll(this.txAssignmentMgr.getAssignmentCreationEvents());
                    ArrayList messageList = new ArrayList();
                    messageList.addAll(this.txMessageMgr.getMessages());
                    this.txAssignmentMgr.fireAssignmentCreationEvent();
                    this.txMessageMgr.sendMessagesWithoutTx();
                    this.lazyPersistentMgr.commit();
                    this.txAssignmentMgr.dumpAssignments();
                    this.pushToLucene();
                    this.txAssignmentMgr.getAssignmentCreationEvents().removeAll(createEventList);
                    this.txMessageMgr.getMessages().removeAll(messageList);
                    size1 = this.txAssignmentMgr.getAssignmentCreationEvents().size();
                    size2 = this.txMessageMgr.getMessages().size();
                } while (size1 != 0 || size2 != 0);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("WfTxContext.endTx cost:" + lowTimer.msValue()));
            }
            if (this.isTopTx()) {
                threadCtx.set(null);
            } else {
                this.stackCtx.pop();
            }
        }
    }

    public void rollbackTx() {
        try {
            this.cleanDirtyCaches();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.isTopTx()) {
                threadCtx.set(null);
            } else {
                this.stackCtx.pop();
            }
        }
    }

    public boolean isTopTx() {
        return this.stackCtx.size() == 1;
    }

    public Context getContext() {
        return this.bosCtx;
    }

    public LazyPersistentMgr getLazyPersistentMgr() {
        return this.lazyPersistentMgr;
    }

    private void initTxManagers() {
        this.txProcessMgr = new TxProcessMgr(this.bosCtx);
        this.txActivityMgr = new TxActivityMgr(this.bosCtx);
        this.txAssignmentMgr = new TxAssignmentMgr(this.bosCtx);
        this.txMessageMgr = new TxMessageMgr(this.bosCtx);
    }

    private void initLazyPersistentMgr() {
        this.lazyPersistentMgr = new LazyPersistentMgr(this.bosCtx);
        this.lazyPersistentMgr.register(new ProcessBatchPersistence(this.bosCtx));
        this.lazyPersistentMgr.register(new ActivityBatchPersistence(this.bosCtx));
        this.lazyPersistentMgr.register(new AssignmentBatchPersistence(this.bosCtx));
        this.lazyPersistentMgr.register(new ProcessContextBatchPersistence(this.bosCtx));
    }

    private void initMutexMgr() {
        try {
            this.mutexMgr = new WfMutexMgr(this.bosCtx);
        }
        catch (WfException e) {
            throw new RuntimeException(e);
        }
    }

    public TxProcessMgr getTxProcessMgr() {
        return this.txProcessMgr;
    }

    public TxActivityMgr getTxActivityMgr() {
        return this.txActivityMgr;
    }

    public TxAssignmentMgr getTxAssignmentMgr() {
        return this.txAssignmentMgr;
    }

    public TxMessageMgr getTxMessageMgr() {
        return this.txMessageMgr;
    }

    public WfMutexMgr getMutexManager() {
        return this.mutexMgr;
    }

    private void cleanDirtyCaches() throws WfException {
        this.txAssignmentMgr.removeFromCache();
        this.txActivityMgr.removeFromCache();
        this.txProcessMgr.removeFromCache();
        this.lazyPersistentMgr.wfExecutionExpired();
        if (logger.isDebugEnabled()) {
            WfEngine engine = WfEngine.getEngine(this.bosCtx);
            IWfCacheManager cacheManager = engine.getCacheManager();
            logger.debug((Object)("wf cache size: " + cacheManager.size()));
        }
    }

    private void pushToLucene() {
        WFSearchAgent.buildIndex(this.getContext(), this.txAssignmentMgr.getassignIdSet4Lucene());
    }

    private void notifyCacheChange() throws WfException {
        this.txAssignmentMgr.notfiyCacheChange();
        this.txActivityMgr.notfiyCacheChange();
        this.txProcessMgr.notfiyCacheChange();
        if (logger.isDebugEnabled()) {
            WfEngine engine = WfEngine.getEngine(this.bosCtx);
            IWfCacheManager cacheManager = engine.getCacheManager();
            logger.debug((Object)("wf cache size: " + cacheManager.size()));
        }
    }
}

