/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import org.apache.log4j.Logger;

public class Semaphore {
    private static Logger logger = Logger.getLogger(Semaphore.class);
    private int notifications = 0;
    private int maxNotifications = 0;

    public Semaphore(int notifications) {
        this.notifications = notifications;
        this.maxNotifications = notifications;
    }

    public synchronized boolean acquire() throws InterruptedException {
        return this.acquire(Long.MAX_VALUE);
    }

    public synchronized boolean acquire(long delay) throws InterruptedException {
        if (Thread.interrupted()) {
            logger.error((Object)"Semaphore interrupted.");
            throw new InterruptedException();
        }
        long start = System.currentTimeMillis();
        long timeLeft = delay;
        while (true) {
            if (this.notifications > 0) {
                --this.notifications;
                return true;
            }
            if (timeLeft <= 0L) {
                return false;
            }
            this.wait(timeLeft);
            timeLeft = start + delay - System.currentTimeMillis();
        }
    }

    public synchronized void release() {
        ++this.notifications;
        this.notifyAll();
    }

    public synchronized void setMaxNotifications(int newVal) {
        this.notifications += newVal - this.maxNotifications;
        this.maxNotifications = newVal;
    }

    public int getMaxNotifications() {
        return this.maxNotifications;
    }
}

