/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.wfdesigner.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.cust.IWFRole;
import com.kingdee.bos.workflow.cust.IWFRoleGroup;
import com.kingdee.bos.workflow.cust.WFRoleFactory;
import com.kingdee.bos.workflow.cust.WFRoleGroupFactory;
import com.kingdee.bos.workflow.cust.WFRoleGroupInfo;
import com.kingdee.bos.workflow.cust.WFRoleInfo;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ParticipantType;
import com.kingdee.bos.workflow.exception.WfParticipantException;
import com.kingdee.bos.workflow.participant.Group;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.participant.JobInfo;
import com.kingdee.bos.workflow.participant.OrgUnitInfo;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.participant.PersonAllInfo;
import com.kingdee.bos.workflow.participant.PositionInfo;
import com.kingdee.bos.workflow.security.IPermissionProvider;
import com.kingdee.bos.workflow.util.EngineConfig;
import com.kingdee.bos.workflow.wfdesigner.service.IParticipantHelper;
import com.kingdee.bos.workflow.wfdesigner.service.ParticipantHelperUtil;
import com.kingdee.bos.workflow.wfdesigner.service.WfDesignerParticipantException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ParticipantHelper
extends AbstractBOSObject
implements IParticipantHelper {
    private static final String PERMISSION_EXCEPTION_NAME = "com.kingdee.eas.base.permission.PermissionException";
    private static final String PERMISSION_SERVICE_EXCEPTION_NAME = "com.kingdee.eas.base.permission.PermissionServiceException";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.wfdesigner.service.ParticipantHelper");
    IParticipantProvider _provider;
    IPermissionProvider _permissionProvider;

    public ParticipantHelper() {
        super.registerInterface(IParticipantHelper.class, (Object)this);
        this._provider = this.loadParticipantProvider();
        this._permissionProvider = this.loadPermissionProvider();
    }

    public ParticipantHelper(Context ctx) {
        super(ctx);
        super.registerInterface(IParticipantHelper.class, (Object)this);
        this._provider = this.loadParticipantProvider();
        this._permissionProvider = this.loadPermissionProvider();
    }

    private IPermissionProvider loadPermissionProvider() {
        String sPermissionProviderClassName = EngineConfig.getInstance().getPermissionProvider();
        if (sPermissionProviderClassName != null) {
            try {
                Class<?> sPermissionProviderClass = Class.forName(sPermissionProviderClassName);
                IPermissionProvider myPermissionProvider = (IPermissionProvider)sPermissionProviderClass.newInstance();
                return myPermissionProvider;
            }
            catch (IllegalAccessException ex1) {
                logger.error((Object)"PermissionProvider init error", (Throwable)ex1);
                return null;
            }
            catch (InstantiationException ex1) {
                logger.error((Object)"PermissionProvider init error", (Throwable)ex1);
                return null;
            }
            catch (ClassNotFoundException ex1) {
                logger.error((Object)"PermissionProvider init error", (Throwable)ex1);
                return null;
            }
        }
        return null;
    }

    private IParticipantProvider loadParticipantProvider() {
        String sParticipantProviderClassName = EngineConfig.getInstance().getParticipantProvider();
        if (sParticipantProviderClassName != null) {
            try {
                Class<?> sParticipantProviderClass = Class.forName(sParticipantProviderClassName);
                IParticipantProvider myParticipantProvider = (IParticipantProvider)sParticipantProviderClass.newInstance();
                return myParticipantProvider;
            }
            catch (IllegalAccessException ex1) {
                logger.error((Object)"PraticipantProvider init error", (Throwable)ex1);
                return null;
            }
            catch (InstantiationException ex1) {
                logger.error((Object)"PraticipantProvider init error", (Throwable)ex1);
                return null;
            }
            catch (ClassNotFoundException ex1) {
                logger.error((Object)"PraticipantProvider init error", (Throwable)ex1);
                return null;
            }
        }
        return null;
    }

    public Person getPersonByUserId(String personId) throws WfDesignerParticipantException {
        try {
            return this._provider.getPersonByUserId(this.getContext(), personId);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public Person[] getPersonByEmployeeId(String personId) throws WfDesignerParticipantException {
        try {
            return this._provider.getPersonByEmployeeId(this.getContext(), personId);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public Person[] getPositionHolders(String positionId) throws WfDesignerParticipantException {
        try {
            return this._provider.getPositionHolders(this.getContext(), positionId);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public Person[] getOrgMember(String orgId) throws WfDesignerParticipantException {
        try {
            return this._provider.getOrgMember(this.getContext(), orgId);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public Person[] getOrgAllMember(String orgId) throws WfDesignerParticipantException {
        try {
            return this._provider.getOrgAllMember(this.getContext(), orgId);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public Set<String> getVoidedEmployees() {
        return this._provider.getVoidedEmployees(this.getContext());
    }

    public Person[] getOrgPrincipal(String orgId) throws WfDesignerParticipantException {
        try {
            return this._provider.getOrgPrincipal(this.getContext(), orgId);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public Person[] getSupervisor(String personId, String positionId, String hierarchyId) throws WfDesignerParticipantException {
        try {
            return this._provider.getSupervisor(this.getContext(), personId, positionId, hierarchyId);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public Person[] getSubordinate(String personId, String positionId, String hierarchyId) throws WfDesignerParticipantException {
        try {
            return this._provider.getSubordinate(this.getContext(), personId, positionId, hierarchyId);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public Person[] getFellow(String personId, String positionId, String hierarchyId) throws WfDesignerParticipantException {
        try {
            return this._provider.getFellow(this.getContext(), personId, positionId, hierarchyId);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public Person[] getRoleMember(String personUserId, String roleId) throws WfDesignerParticipantException {
        try {
            return this._provider.getRoleMember(this.getContext(), personUserId, roleId);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public PositionInfo[] getPositionArrayByUserId(String userId) throws WfDesignerParticipantException {
        try {
            return this._provider.getPositionArrayByUserId(this.getContext(), userId);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public PositionInfo[] getPositionArrayByEmployeeId(String employeeId) throws WfDesignerParticipantException {
        try {
            return this._provider.getPositionArrayByEmployeeId(this.getContext(), employeeId);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public PositionInfo[] getPositionArrayByOrgUnitId(String orgUnitId) throws WfDesignerParticipantException {
        try {
            return this._provider.getPositionArrayByOrgUnitId(this.getContext(), orgUnitId);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public OrgUnitInfo[] getOrgUnitArrayByEmployeeId(String employeeId) throws WfDesignerParticipantException {
        try {
            return this._provider.getOrgUnitArrayByEmployeeId(this.getContext(), employeeId);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public OrgUnitInfo[] getAllOrgUnitArray() throws WfDesignerParticipantException {
        try {
            return this._provider.getAllOrgUnitArray(this.getContext());
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public OrgUnitInfo[] getAllOrgUnitByType(int orgType) throws WfDesignerParticipantException {
        try {
            OrgUnitInfo[] result = this._provider.getAllOrgUnitByType(this.getContext(), orgType);
            return result;
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public OrgUnitInfo getRootUnit(int orgType) throws WfDesignerParticipantException {
        try {
            return this._provider.getRootUnit(this.getContext(), orgType);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public OrgUnitInfo[] getOrgUnitArrayByUserId(String userId) throws WfDesignerParticipantException {
        try {
            return this._provider.getOrgUnitArrayByUserId(this.getContext(), userId);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public OrgUnitInfo[] getSubOrgUnit(String parantOrgUnitId) throws WfDesignerParticipantException {
        try {
            return this._provider.getSubOrgUnit(this.getContext(), parantOrgUnitId);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public OrgUnitInfo getParentOrgUnit(String orgUintId) throws WfDesignerParticipantException {
        try {
            return this._provider.getParentOrgUnit(this.getContext(), orgUintId);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public boolean isPersonInOrg(String personId, String OrgId) throws WfDesignerParticipantException {
        try {
            return this._provider.isPersonInOrg(this.getContext(), personId, OrgId);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public String getHierarchyNameByID(String id) throws WfDesignerParticipantException {
        try {
            return this._provider.getHierarchyNameByID(this.getContext(), id);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public PositionInfo[] getPositionByPersonAndHierarchy(String personID, String hierarchyID) throws WfDesignerParticipantException {
        try {
            return this._provider.getPositionByPersonAndHierarchy(this.getContext(), personID, hierarchyID);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public String[] getHierarchyByOrgType(int orgType) throws WfDesignerParticipantException {
        try {
            return this._provider.getHierarchyByOrgType(this.getContext(), orgType);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public BOSObjectType getType() {
        return BOSObjectType.create((String)"WFPH");
    }

    public String getAdminOrgUnitNamebyPositionID(String posittonID) throws WfDesignerParticipantException {
        try {
            return this._provider.getAdminOrgUnitNamebyPositionID(this.getContext(), posittonID);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    private String getErrDetailString(Throwable t) {
        ByteArrayOutputStream baOut = new ByteArrayOutputStream(1024);
        PrintStream ps = new PrintStream(baOut);
        t.printStackTrace(ps);
        ps.close();
        return new String(baOut.toByteArray());
    }

    private WfDesignerParticipantException getException(Exception e) {
        String trace = this.getErrDetailString(e);
        logger.error((Object)"Error", (Throwable)e);
        if (e.getCause() != null) {
            if (PERMISSION_SERVICE_EXCEPTION_NAME.equals(e.getCause().getClass().getName()) && e.getCause().getCause() != null && PERMISSION_EXCEPTION_NAME.equals(e.getCause().getCause().getClass().getName())) {
                return new WfDesignerParticipantException(e.getCause().getCause().getMessage(), trace);
            }
            return new WfDesignerParticipantException(e.getCause().getMessage(), trace);
        }
        return new WfDesignerParticipantException("Login Error" + e.getMessage(), trace);
    }

    public JobInfo[] getJobArrayByOrgUnitId(String orgUnitId) throws WfDesignerParticipantException {
        try {
            return this._provider.getJobArrayByOrgUnitId(this.getContext(), orgUnitId);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public JobInfo[] getJobsArray() throws WfDesignerParticipantException {
        try {
            return this._provider.getJobsArray(this.getContext());
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public Group[] getAllGroups() throws WfDesignerParticipantException {
        try {
            return this._provider.getAllGroups(this.getContext());
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public Person[] getPersonsFromGroup(String groupId) throws WfDesignerParticipantException {
        try {
            return this._provider.getPersonsFromGroup(this.getContext(), groupId);
        }
        catch (WfParticipantException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public PersonAllInfo[] caculatePersonsByParticipantDef(ActivityDef activityDef, ParticipantCollection participants, Map refInfoMap) throws WfException {
        ArrayList persons = new ArrayList();
        for (ParticipantDef participantDef : participants) {
            if (participantDef.getParticipantType() == ParticipantType.POSITION) {
                ParticipantHelperUtil.getPersonByPosition(persons, this._provider, this.getContext(), participantDef);
                continue;
            }
            if (ParticipantType.GROUP.equals((Object)participantDef.getParticipantType())) {
                ParticipantHelperUtil.getPersonByGroup(persons, this._provider, this.getContext(), participantDef);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_MEMBER) {
                ParticipantHelperUtil.getPersonByOrgMember(persons, this._provider, this.getContext(), participantDef);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_ALLMEMBER) {
                ParticipantHelperUtil.getPersonByOrgAllMember(persons, this._provider, this.getContext(), participantDef);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_PRINCIPAL) {
                ParticipantHelperUtil.getPersonByPrincipal(persons, this._provider, this.getContext(), participantDef);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_PERMISSION_OWNER) {
                ParticipantHelperUtil.getPersonByOrgPermissionOwner(persons, this._provider, this._permissionProvider, this.getContext(), activityDef, participantDef);
                continue;
            }
            if (ParticipantType.ORGANIZATIONAL_UNIT_SCOPE.equals((Object)participantDef.getParticipantType())) {
                ParticipantHelperUtil.getOrgAllMember(persons, this._provider, this.getContext(), participantDef);
                continue;
            }
            if (ParticipantType.ORGANIZATIONAL_UNIT_JOB.equals((Object)participantDef.getParticipantType())) {
                ParticipantHelperUtil.getPersonByOrgJob(persons, this._provider, this.getContext(), participantDef);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.USER || participantDef.getParticipantType() == ParticipantType.HUMAN || participantDef.getParticipantType() == ParticipantType.PERMISSION_OWNER || participantDef.getParticipantType() == ParticipantType.RELATION || participantDef.getParticipantType() == ParticipantType.ROLE || participantDef.getParticipantType() == ParticipantType.VARIANT || participantDef.getParticipantType().equals((Object)ParticipantType.PROCESS_RESPONSIBILITY) || participantDef.getParticipantType().equals((Object)ParticipantType.ALL) || ParticipantType.PROCESS_EXECUTOR.equals((Object)participantDef.getParticipantType())) continue;
            throw new WfException("NOT SUPPORT.");
        }
        persons = ParticipantHelper.distinctPersons(persons, 200);
        int len = persons.size();
        PersonAllInfo[] personinfo = new PersonAllInfo[len];
        for (int i = 0; i < len; ++i) {
            personinfo[i] = new PersonAllInfo();
            Person p = (Person)persons.get(i);
            personinfo[i].setPerson(p);
            personinfo[i].setPosition(ParticipantHelperUtil.getPositionArrayByEmployeeId(this._provider, this.getContext(), p.getEmployeeId()));
        }
        return personinfo;
    }

    private static ArrayList distinctPersons(List persons, int maxSize) {
        HashMap<String, Person> mapPerson = new HashMap<String, Person>();
        int tmpSize = 0;
        int size = persons.size();
        for (int i = 0; i < size; ++i) {
            String key;
            Person person = (Person)persons.get(i);
            if (person == null || StringUtils.isEmpty((String)person.getUserId()) || StringUtils.isEmpty((String)person.getEmployeeId()) || mapPerson.containsKey(key = person.getUserId() + "_" + person.getEmployeeId())) continue;
            mapPerson.put(key, person);
            if (++tmpSize > maxSize) break;
        }
        return new ArrayList(mapPerson.values());
    }

    public PersonAllInfo[] getPersonByUserIds(String[] personIds) throws WfDesignerParticipantException {
        try {
            Person[] persons = this._provider.getPersonByUserIds(this.getContext(), personIds);
            PersonAllInfo[] personinfo = new PersonAllInfo[persons.length];
            for (int i = 0; i < persons.length; ++i) {
                Person p = persons[i];
                personinfo[i] = new PersonAllInfo();
                personinfo[i].setPerson(p);
                if (StringUtils.isEmpty((String)p.getEmployeeId())) continue;
                personinfo[i].setPosition(ParticipantHelperUtil.getPositionArrayByEmployeeId(this._provider, this.getContext(), p.getEmployeeId()));
            }
            return personinfo;
        }
        catch (WfException e) {
            throw this.getException((Exception)((Object)e));
        }
    }

    public List<String[]> getRoleByOrgId(String orgID) {
        ArrayList<String[]> roleList = new ArrayList<String[]>();
        FilterInfo fi = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        fi.getFilterItems().add(new FilterItemInfo("TREEID.ID", (Object)orgID, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("State", (Object)"0", CompareType.EQUALS));
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.bos.workflow.cust.app.WFRoleQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)this.getContext(), (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        try {
            IRowSet rs = queryExcu.executeQuery();
            while (rs.next()) {
                String id = rs.getString("id");
                String num = rs.getString("number");
                String name = rs.getString("RoleName");
                String RoleType = rs.getString("RoleType");
                String RoleState = rs.getString("State");
                String AdminName = rs.getString("Admin.name");
                roleList.add(new String[]{id, num, name, RoleType, RoleState, AdminName});
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return roleList;
    }

    public List<String[]> getAllRoleGroup() {
        ArrayList<String[]> roleGroupList = new ArrayList<String[]>();
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.bos.workflow.cust.app.WFRoleGroupQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)this.getContext(), (IMetaDataPK)queryPK);
        try {
            IRowSet rs = queryExcu.executeQuery();
            while (rs.next()) {
                String rgid = rs.getString("id");
                String rgNum = rs.getString("number");
                String rgName = rs.getString("name");
                roleGroupList.add(new String[]{rgid, rgNum, rgName});
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return roleGroupList;
    }

    public List<String[]> getRoleGroupById(String id) {
        ArrayList<String[]> roleGroupList = new ArrayList<String[]>();
        FilterInfo fi = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.bos.workflow.cust.app.WFRoleGroupQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)this.getContext(), (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        try {
            IRowSet rs = queryExcu.executeQuery();
            while (rs.next()) {
                String rgid = rs.getString("id");
                String rgNum = rs.getString("number");
                String rgName = rs.getString("name");
                roleGroupList.add(new String[]{rgid, rgNum, rgName});
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return roleGroupList;
    }

    public List<String[]> getRoleGroupBySearch(String val) {
        ArrayList<String[]> roleGroupList = new ArrayList<String[]>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (val.trim().length() > 0) {
            val = "%" + val + "%";
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("name", (Object)val, CompareType.LIKE));
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)val, CompareType.LIKE));
            fi.setMaskString("#0 or #1");
            viewInfo.setFilter(fi);
        }
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.bos.workflow.cust.app.WFRoleGroupQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)this.getContext(), (IMetaDataPK)queryPK);
        if (val.trim().length() > 0) {
            queryExcu.setObjectView(viewInfo);
        }
        try {
            IRowSet rs = queryExcu.executeQuery();
            while (rs.next()) {
                String rgid = rs.getString("id");
                String rgNum = rs.getString("number");
                String rgName = rs.getString("name");
                roleGroupList.add(new String[]{rgid, rgNum, rgName});
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return roleGroupList;
    }

    public Map<String, String> getRoleInfo(String roleId) {
        HashMap<String, String> roleMap = new HashMap<String, String>();
        FilterInfo fi = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        fi.getFilterItems().add(new FilterItemInfo("FID", (Object)roleId, CompareType.EQUALS));
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.bos.workflow.cust.app.WFRoleQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)this.getContext(), (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        try {
            IRowSet rs = queryExcu.executeQuery();
            while (rs.next()) {
                roleMap.put("roleType", rs.getString("FROLETYPE"));
                roleMap.put("roleState", rs.getString("FSTATE"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        String roleType = (String)roleMap.get("roleTYpe");
        return null;
    }

    public List<Map<String, String>> getUserByRoleId(String roleType, String roleId) throws Exception {
        if (roleType.equals("0")) {
            return this.getPersonRoleInfo(roleId);
        }
        if (roleType.equals("1")) {
            return this.getPositionRoleInfo(roleId);
        }
        if (roleType.equals("2")) {
            return this.getOrgRoleInfo(roleId);
        }
        return null;
    }

    private List<Map<String, String>> getPersonRoleInfo(String roleId) throws Exception {
        IWFRole iWFRole = WFRoleFactory.getLocalInstance((Context)this.getContext());
        SelectorItemCollection sic = null;
        WFRoleInfo roleInfo = null;
        ArrayList<Map<String, String>> roleInfoList = new ArrayList<Map<String, String>>();
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("PersonEntrys.PersonID.name"));
        sic.add(new SelectorItemInfo("PersonEntrys.OrgID.name"));
        sic.add(new SelectorItemInfo("PersonEntrys.IsInclude"));
        sic.add(new SelectorItemInfo("PersonEntrys.IsDele"));
        sic.add(new SelectorItemInfo("PersonEntrys.DelePersonID.name"));
        roleInfo = iWFRole.getWFRoleInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)roleId)), sic);
        String RoleDescribe = roleInfo.getRoleDescribe(this.getContext().getLocale());
        HashMap<String, String> rdMap = new HashMap<String, String>();
        rdMap.put("RoleDescribe", RoleDescribe);
        roleInfoList.add(rdMap);
        int size = roleInfo.getPersonEntrys().size();
        for (int i = 0; i < size; ++i) {
            String personName = roleInfo.getPersonEntrys().get(i).getPersonID().getName();
            String orgName = roleInfo.getPersonEntrys().get(i).getOrgID().getName();
            boolean bi = roleInfo.getPersonEntrys().get(i).isIsInclude();
            boolean bd = roleInfo.getPersonEntrys().get(i).isIsDele();
            String isInclude = bi ? "\u662f" : "\u5426";
            String IsDele = bd ? "\u662f" : "\u5426";
            String deleName = "";
            if (roleInfo.getPersonEntrys().get(i).getDelePersonID() != null) {
                deleName = roleInfo.getPersonEntrys().get(i).getDelePersonID().getName();
            }
            LinkedHashMap<String, String> roleInfoMap = new LinkedHashMap<String, String>();
            roleInfoMap.put("personName", personName);
            roleInfoMap.put("orgName", orgName);
            roleInfoMap.put("isInclude", isInclude);
            roleInfoMap.put("IsDele", IsDele);
            roleInfoMap.put("deleName", deleName);
            roleInfoList.add(roleInfoMap);
        }
        return roleInfoList;
    }

    private List<Map<String, String>> getPositionRoleInfo(String roleId) throws Exception {
        IWFRole iWFRole = WFRoleFactory.getLocalInstance((Context)this.getContext());
        SelectorItemCollection sic = null;
        WFRoleInfo roleInfo = null;
        ArrayList<Map<String, String>> roleInfoList = new ArrayList<Map<String, String>>();
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("PositionEntrys.PositionID.name"));
        sic.add(new SelectorItemInfo("PositionEntrys.OrgID.name"));
        sic.add(new SelectorItemInfo("PositionEntrys.IsInclude"));
        sic.add(new SelectorItemInfo("PositionEntrys.IsDele"));
        sic.add(new SelectorItemInfo("PositionEntrys.DelePersonID.name"));
        roleInfo = iWFRole.getWFRoleInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)roleId)), sic);
        String RoleDescribe = roleInfo.getRoleDescribe(this.getContext().getLocale());
        HashMap<String, String> rdMap = new HashMap<String, String>();
        rdMap.put("RoleDescribe", RoleDescribe);
        roleInfoList.add(rdMap);
        int size = roleInfo.getPositionEntrys().size();
        for (int i = 0; i < size; ++i) {
            String positionName = roleInfo.getPositionEntrys().get(i).getPositionID().getName();
            String orgName = roleInfo.getPositionEntrys().get(i).getOrgID().getName();
            boolean bi = roleInfo.getPositionEntrys().get(i).isIsInclude();
            boolean bd = roleInfo.getPositionEntrys().get(i).isIsDele();
            String isInclude = bi ? "\u662f" : "\u5426";
            String IsDele = bd ? "\u662f" : "\u5426";
            String deleName = "";
            if (roleInfo.getPositionEntrys().get(i).getDelePersonID() != null) {
                deleName = roleInfo.getPositionEntrys().get(i).getDelePersonID().getName();
            }
            LinkedHashMap<String, String> roleInfoMap = new LinkedHashMap<String, String>();
            roleInfoMap.put("positionName", positionName);
            roleInfoMap.put("orgName", orgName);
            roleInfoMap.put("isInclude", isInclude);
            roleInfoMap.put("IsDele", IsDele);
            roleInfoMap.put("deleName", deleName);
            roleInfoList.add(roleInfoMap);
        }
        return roleInfoList;
    }

    private List<Map<String, String>> getOrgRoleInfo(String roleId) throws Exception {
        IWFRole iWFRole = WFRoleFactory.getLocalInstance((Context)this.getContext());
        SelectorItemCollection sic = null;
        WFRoleInfo roleInfo = null;
        ArrayList<Map<String, String>> roleInfoList = new ArrayList<Map<String, String>>();
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("OrgEntrys.IsInclude"));
        sic.add(new SelectorItemInfo("OrgEntrys.OrgID.name"));
        roleInfo = iWFRole.getWFRoleInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)roleId)), sic);
        String RoleDescribe = roleInfo.getRoleDescribe(this.getContext().getLocale());
        HashMap<String, String> rdMap = new HashMap<String, String>();
        rdMap.put("RoleDescribe", RoleDescribe);
        roleInfoList.add(rdMap);
        int size = roleInfo.getOrgEntrys().size();
        for (int i = 0; i < size; ++i) {
            String Orgname = roleInfo.getOrgEntrys().get(i).getOrgID().getName();
            boolean bi = roleInfo.getOrgEntrys().get(i).isIsInclude();
            String isInclude = bi ? "\u662f" : "\u5426";
            LinkedHashMap<String, String> roleInfoMap = new LinkedHashMap<String, String>();
            roleInfoMap.put("Orgname", Orgname);
            roleInfoMap.put("isInclude", isInclude);
            roleInfoList.add(roleInfoMap);
        }
        return roleInfoList;
    }

    public String getRoleNameByRoleId(String roleId) {
        String roleName = "";
        FilterInfo fi = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        fi.getFilterItems().add(new FilterItemInfo("ID", (Object)roleId, CompareType.EQUALS));
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.bos.workflow.cust.app.WFRoleQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)this.getContext(), (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        try {
            IRowSet rs = queryExcu.executeQuery();
            while (rs.next()) {
                roleName = rs.getString("RoleName");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return roleName;
    }

    public List<String[]> getRoleBySeach(String val) {
        val = "%" + val + "%";
        ArrayList<String[]> roleList = new ArrayList<String[]>();
        FilterInfo fi = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        fi.getFilterItems().add(new FilterItemInfo("RoleName", (Object)val, CompareType.LIKE));
        fi.getFilterItems().add(new FilterItemInfo("number", (Object)val, CompareType.LIKE));
        fi.getFilterItems().add(new FilterItemInfo("State", (Object)"0", CompareType.EQUALS));
        fi.setMaskString("(#0 or #1) and #2 ");
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.bos.workflow.cust.app.WFRoleQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)this.getContext(), (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        try {
            IRowSet rs = queryExcu.executeQuery();
            while (rs.next()) {
                String id = rs.getString("id");
                String num = rs.getString("number");
                String name = rs.getString("RoleName");
                String RoleType = rs.getString("RoleType");
                String RoleState = rs.getString("State");
                String AdminName = rs.getString("Admin.name");
                String treeId = rs.getString("treeid.id");
                roleList.add(new String[]{id, num, name, RoleType, RoleState, AdminName, treeId});
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return roleList;
    }

    public List<String[]> getRoleById(String roleId) {
        ArrayList<String[]> roleList = new ArrayList<String[]>();
        FilterInfo fi = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)roleId, CompareType.EQUALS));
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.bos.workflow.cust.app.WFRoleQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)this.getContext(), (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        try {
            IRowSet rs = queryExcu.executeQuery();
            while (rs.next()) {
                String id = rs.getString("id");
                String num = rs.getString("number");
                String name = rs.getString("RoleName");
                String RoleType = rs.getString("RoleType");
                String RoleState = rs.getString("State");
                String AdminName = rs.getString("Admin.name");
                String treeId = rs.getString("treeid.id");
                roleList.add(new String[]{id, num, name, RoleType, RoleState, AdminName, treeId});
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return roleList;
    }

    public List<Map<String, String>> getRoleByrgId(String roleGroupId) {
        ArrayList<Map<String, String>> roleInfoList = new ArrayList<Map<String, String>>();
        try {
            IWFRoleGroup iWFRoleGroup = WFRoleGroupFactory.getLocalInstance((Context)this.getContext());
            SelectorItemCollection sic = new SelectorItemCollection();
            WFRoleGroupInfo roleGroupInfo = null;
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("entrys.RoleID.*"));
            roleGroupInfo = iWFRoleGroup.getWFRoleGroupInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)roleGroupId)), sic);
            String rgDes = roleGroupInfo.getDescription(this.getContext().getLocale());
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("rgDes", rgDes);
            roleInfoList.add(m);
            int size = roleGroupInfo.getEntrys().size();
            for (int i = 0; i < size; ++i) {
                String roleName = roleGroupInfo.getEntrys().get(i).getRoleID().getRoleName();
                String roleNum = roleGroupInfo.getEntrys().get(i).getRoleID().getNumber();
                String roleType = roleGroupInfo.getEntrys().get(i).getRoleID().getRoleType().getAlias();
                String roleState = roleGroupInfo.getEntrys().get(i).getRoleID().getState().getAlias();
                LinkedHashMap<String, String> mlink = new LinkedHashMap<String, String>();
                mlink.put("roleName", roleName);
                mlink.put("roleNum", roleNum);
                mlink.put("roleType", roleType);
                mlink.put("roleState", roleState);
                roleInfoList.add(mlink);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return roleInfoList;
    }

    public boolean isSettedRoleParam(String roleParam) {
        FilterInfo fi = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        fi.getFilterItems().add(new FilterItemInfo("billEntry", (Object)roleParam, CompareType.EQUALS));
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.bos.workflow.cust.app.WFRoleParaQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)this.getContext(), (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        try {
            System.out.println(queryExcu.getSQL());
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        try {
            IRowSet rs = queryExcu.executeQuery();
            if (rs.size() > 0) {
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean hasRoleInTreeNode(String treeid) {
        FilterInfo fi = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        fi.getFilterItems().add(new FilterItemInfo("TREEID.ID", (Object)treeid, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("State", (Object)"0", CompareType.EQUALS));
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.bos.workflow.cust.app.WFRoleQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)this.getContext(), (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        try {
            IRowSet rs = queryExcu.executeQuery();
            if (rs.size() > 0) {
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }

    public HashMap<String, String> getOrgStrMap(String entityuipk) {
        MetaDataPK pk = new MetaDataPK(entityuipk);
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.getContext());
        EntityObjectInfo entity = loader.getEntity((IMetaDataPK)pk);
        PropertyCollection properties = entity.getInheritedProperties();
        HashMap<String, String> hm = new HashMap<String, String>();
        Class<?> orgUnit = null;
        try {
            orgUnit = Class.forName("com.kingdee.eas.basedata.org.OrgUnit");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        for (int i = 0; i < properties.size(); ++i) {
            RelationshipInfo relationship;
            PropertyInfo property = properties.get(i);
            if (!(property instanceof LinkPropertyInfo) || (relationship = ((LinkPropertyInfo)property).getRelationship()) == null || relationship.getSupplierObject() == null) continue;
            EntityObjectInfo objInfo = relationship.getSupplierObject();
            Object obj = null;
            try {
                Class<?> clazz = Class.forName(objInfo.getBusinessImplName());
                obj = clazz.newInstance();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (orgUnit.isInstance(obj)) {
                String alias = property.getAlias();
                String name = property.getName();
                if (!StringUtils.isEmpty((String)alias) && !StringUtils.isEmpty((String)name)) {
                    hm.put(property.getAlias(), property.getName() + ",");
                }
            }
            if (!this.isEntry((LinkPropertyInfo)property)) continue;
            String entry = ((LinkPropertyInfo)property).getName() + ".";
            this.genOrgStrForEntry(entry, objInfo, hm);
        }
        return hm;
    }

    private void genOrgStrForEntry(String entry, EntityObjectInfo EntryobjInfo, HashMap<String, String> hm) {
        String entryName = EntryobjInfo.getAlias() + ".";
        PropertyCollection properties = EntryobjInfo.getPropertiesRuntime();
        Class<?> orgUnit = null;
        try {
            orgUnit = Class.forName("com.kingdee.eas.basedata.org.OrgUnit");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        for (int i = 0; i < properties.size(); ++i) {
            RelationshipInfo relationship;
            PropertyInfo property = properties.get(i);
            if (!(property instanceof LinkPropertyInfo) || (relationship = ((LinkPropertyInfo)property).getRelationship()) == null || relationship.getSupplierObject() == null) continue;
            EntityObjectInfo objInfo = relationship.getSupplierObject();
            Object obj = null;
            try {
                Class<?> clazz = Class.forName(objInfo.getBusinessImplName());
                obj = clazz.newInstance();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (!orgUnit.isInstance(obj)) continue;
            String alias = property.getAlias();
            String name = property.getName();
            if (StringUtils.isEmpty((String)alias) || StringUtils.isEmpty((String)name)) continue;
            hm.put(entryName + property.getAlias(), entry + property.getName() + ",");
        }
    }

    private void genApplStrForEntry(String entry, EntityObjectInfo EntryobjInfo, HashMap<String, String> hm) {
        String entryName = EntryobjInfo.getAlias() + ".";
        PropertyCollection properties = EntryobjInfo.getPropertiesRuntime();
        for (int i = 0; i < properties.size(); ++i) {
            RelationshipInfo relationship;
            PropertyInfo property = properties.get(i);
            if (!(property instanceof LinkPropertyInfo) || (relationship = ((LinkPropertyInfo)property).getRelationship()) == null || relationship.getSupplierObject() == null) continue;
            EntityObjectInfo objInfo = relationship.getSupplierObject();
            String fullname = objInfo.getFullName();
            if ("com.kingdee.eas.base.permission.app.User".equals(fullname)) {
                hm.put(entryName + property.getAlias(), entry + property.getName() + ",0");
                continue;
            }
            if (!"com.kingdee.eas.basedata.person.app.Person".equals(fullname)) continue;
            hm.put(entryName + property.getAlias(), entry + property.getName() + ",1");
        }
    }

    public HashMap<String, String> getApplStrMap(String entityuipk) throws WfDesignerParticipantException {
        MetaDataPK pk = new MetaDataPK(entityuipk);
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.getContext());
        EntityObjectInfo entity = loader.getEntity((IMetaDataPK)pk);
        PropertyCollection properties = entity.getInheritedProperties();
        HashMap<String, String> hm = new HashMap<String, String>();
        for (int i = 0; i < properties.size(); ++i) {
            RelationshipInfo relationship;
            PropertyInfo property = properties.get(i);
            if (!(property instanceof LinkPropertyInfo) || (relationship = ((LinkPropertyInfo)property).getRelationship()) == null || relationship.getSupplierObject() == null) continue;
            EntityObjectInfo objInfo = relationship.getSupplierObject();
            String fullname = objInfo.getFullName();
            if ("com.kingdee.eas.base.permission.app.User".equals(fullname)) {
                hm.put(property.getAlias(), property.getName() + ",0");
                continue;
            }
            if ("com.kingdee.eas.basedata.person.app.Person".equals(fullname)) {
                hm.put(property.getAlias(), property.getName() + ",1");
                continue;
            }
            if (!this.isEntry((LinkPropertyInfo)property)) continue;
            String entry = ((LinkPropertyInfo)property).getName() + ".";
            this.genApplStrForEntry(entry, objInfo, hm);
        }
        return hm;
    }

    public List<HashMap<String, String>> getOrgHasRole() throws BOSException, SQLException {
        String treequery = "com.kingdee.bos.workflow.cust.app.AdminOrgRange";
        MetaDataPK queryPK = MetaDataPK.create((String)treequery);
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)this.getContext(), (IMetaDataPK)queryPK);
        IRowSet rs = queryExcu.executeQuery();
        while (rs.next()) {
            if (this.isNull(rs)) continue;
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("treeId", rs.getString("TREEID.ID"));
            hm.put("level", rs.getString("TREEID.LEVEL"));
            hm.put("isLeaf", rs.getString("TREEID.ISLEAF"));
            hm.put("longNumber", rs.getString("TREEID.LONGNUMBER"));
            hm.put("number", rs.getString("TREEID.NUMBER"));
            hm.put("name", rs.getString("TREEID.NAME"));
            list.add(hm);
        }
        return list;
    }

    private boolean isNull(IRowSet rs) throws SQLException {
        String[] ars;
        for (String s : ars = new String[]{rs.getString("TREEID.LEVEL"), rs.getString("TREEID.ISLEAF"), rs.getString("TREEID.LONGNUMBER"), rs.getString("TREEID.NUMBER"), rs.getString("TREEID.NAME")}) {
            if (s != null) continue;
            return true;
        }
        return false;
    }

    private boolean isEntry(LinkPropertyInfo property) {
        RelationshipInfo relationship = property.getRelationship();
        return Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) || relationship != null && relationship.getClientObject() != null && RelationshipType.COMPOSITION.equals((Object)relationship.getType()) && (CardinalityType.ONE.equals((Object)relationship.getClientCardinality()) || CardinalityType.ZERO_TO_ONE.equals((Object)relationship.getClientCardinality())) && (CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()) || CardinalityType.ONE_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()));
    }

    public List<?> getUserGroup() {
        String sqlStr = "select a.fid,a.flongnumber,a.fname_l2 from T_PM_USERGROUP a where a.fid in (select DISTINCT  b.FGROUPID from T_PM_USER b where b.FTYPE<>20);";
        try {
            ArrayList list = SQL.executeQuery((Context)this.getContext(), (String)sqlStr);
            if (list != null && list.size() > 0) {
                return list;
            }
        }
        catch (BOSException e) {
            logger.error((Object)("\u83b7\u53d6\u7528\u6237\u7ec4\u4fe1\u606f\u51fa\u9519\uff1a" + (Object)((Object)e)));
        }
        return new ArrayList();
    }

    public List<?> getUserInfo(String userGroupId) {
        if (userGroupId == null) {
            return null;
        }
        Timestamp time = new Timestamp(System.currentTimeMillis());
        String nowTime = "{ts '" + time.toString().substring(0, 19) + "'}";
        StringBuilder sqlBuilder = new StringBuilder();
        if (userGroupId.length() != 0) {
            sqlBuilder.append("SELECT fid,fnumber,fname_l2,ftype from T_PM_USER a where a.Fid in( ");
            sqlBuilder.append("SELECT b.fuserid from T_PM_USERGROUPG b where b.FGROUPID= ");
            sqlBuilder.append("'" + userGroupId + "') and ");
        } else {
            sqlBuilder.append("SELECT fid,fnumber,fname_l2,ftype from T_PM_USER a where ");
        }
        sqlBuilder.append("a.FFORBIDDEN=0 and a.FISLOCKED=0 ");
        sqlBuilder.append("and a.FEFFECTIVEDATE<=" + nowTime);
        sqlBuilder.append(" and a.FINVALIDATIONDATE>=" + nowTime + " ");
        sqlBuilder.append("and a.FPWEFFECTIVEDATE<=" + nowTime);
        sqlBuilder.append(" and a.ftype in (30,40,50) and a.FISDELETE =0 and a.FAGENTUSER =0");
        try {
            ArrayList list = SQL.executeQuery((Context)this.getContext(), (String)sqlBuilder.toString());
            if (list != null && list.size() > 0) {
                return list;
            }
        }
        catch (BOSException e) {
            logger.error((Object)("\u83b7\u53d6\u7528\u6237\u7ec4\u4fe1\u606f\u51fa\u9519\uff1a" + (Object)((Object)e)));
        }
        return null;
    }

    public List<?> getUserByFilter(String filter) {
        if (StringUtils.isEmpty((String)filter)) {
            return null;
        }
        int userTypeCode = -1;
        userTypeCode = this.getUserTypeCode(filter);
        String sql = "select fid,fnumber,fname_l2,ftype from T_PM_USER where (fnumber like '%" + filter + "%' or fname_l2 like '%" + filter + "%'";
        sql = userTypeCode > 0 ? sql + " or ftype = " + userTypeCode + ") and ftype in (30,40,50)  " : sql + ") and ftype in (30,40,50) ";
        try {
            ArrayList list = SQL.executeQuery((Context)this.getContext(), (String)sql);
            if (list != null && list.size() > 0) {
                return list;
            }
        }
        catch (BOSException e) {
            logger.error((Object)("\u83b7\u53d6\u7528\u6237\u7ec4\u4fe1\u606f\u51fa\u9519\uff1a" + (Object)((Object)e)));
        }
        return null;
    }

    private int getUserTypeCode(String s) {
        String[] type = new String[]{"\u7cfb\u7edf\u7528\u6237", "\u5ba2\u6237", "\u4f9b\u5e94\u5546", "\u5176\u4ed6"};
        int[] code = new int[]{10, 30, 40, 50};
        for (int k = 0; k < type.length; ++k) {
            if (!type[k].contains(s)) continue;
            return code[k];
        }
        return -1;
    }

    public boolean isRoleExist(String roleId) {
        try {
            IWFRole iWFRole = WFRoleFactory.getLocalInstance((Context)this.getContext());
            return iWFRole.exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)roleId)));
        }
        catch (Exception e) {
            return true;
        }
    }
}

