/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.wfdesigner.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.participant.Group;
import com.kingdee.bos.workflow.participant.JobInfo;
import com.kingdee.bos.workflow.participant.OrgUnitInfo;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.participant.PositionInfo;
import com.kingdee.bos.workflow.wfdesigner.service.IParticipantHelper;
import com.kingdee.bos.workflow.wfdesigner.service.IParticipantXMLHelper;
import com.kingdee.bos.workflow.wfdesigner.service.ParticipantHelper;
import com.kingdee.bos.workflow.wfdesigner.service.WfDesignerParticipantException;
import com.kingdee.util.StringUtils;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class ParticipantXMLHelper
extends AbstractBOSObject
implements IParticipantXMLHelper {
    private static Logger logger = Logger.getLogger(ParticipantXMLHelper.class);
    IParticipantHelper _participantHelper;
    Context ctx;
    private static final Locale DEF_LOCALE = new Locale("l2");

    public ParticipantXMLHelper() {
        super.registerInterface(IParticipantXMLHelper.class, (Object)this);
        this.ctx = this.copyContext(this.getContext());
        this._participantHelper = new ParticipantHelper(this.ctx);
    }

    public ParticipantXMLHelper(Context ctx2) {
        super.registerInterface(IParticipantXMLHelper.class, (Object)this);
        this.ctx = this.copyContext(ctx2);
        this._participantHelper = new ParticipantHelper(this.ctx);
    }

    private Context copyContext(Context context) {
        return context;
    }

    private static void addContent(Element element, String type, String key, String value) {
        Element contentElement = new Element(String.valueOf(type));
        contentElement.setAttribute("Key", String.valueOf(key));
        contentElement.addContent((Content)new CDATA(String.valueOf(value)));
        element.addContent((Content)contentElement);
    }

    private static String ElementToXml(Element element) {
        if (element != null) {
            Document XMLDoc = new Document(element);
            XMLOutputter xml = new XMLOutputter();
            Format format = xml.getFormat();
            format.setIndent("   ");
            format.setLineSeparator("");
            xml.setFormat(format);
            return xml.outputString(XMLDoc);
        }
        return null;
    }

    private static String PersonToXml(Person node) {
        Element element = new Element("Root");
        Element ele = ParticipantXMLHelper.PersonToElement(node);
        element.addContent((Content)ele);
        String xml = ParticipantXMLHelper.ElementToXml(element);
        return xml;
    }

    private static String PersonsToXml(Person[] node) {
        Element element = new Element("Root");
        if (node != null) {
            for (int i = 0; i < node.length; ++i) {
                Element ele = ParticipantXMLHelper.PersonToElement(node[i]);
                element.addContent((Content)ele);
            }
        }
        String xml = ParticipantXMLHelper.ElementToXml(element);
        return xml;
    }

    private static Element PersonToElement(Person node) {
        Element rtn = new Element("Person");
        rtn.setAttribute("UserId", String.valueOf(node.getUserId()));
        rtn.setAttribute("EmployeeId", String.valueOf(node.getEmployeeId()));
        Element r2 = new Element("UserName");
        rtn.addContent((Content)r2);
        ParticipantXMLHelper.addContent(r2, "Resource", "L1", node.getUserName(new Locale("L1")));
        ParticipantXMLHelper.addContent(r2, "Resource", "L2", node.getUserName(new Locale("L2")));
        ParticipantXMLHelper.addContent(r2, "Resource", "L3", node.getUserName(new Locale("L3")));
        Element r3 = new Element("EmployeeName");
        rtn.addContent((Content)r3);
        ParticipantXMLHelper.addContent(r3, "Resource", "L1", node.getEmployeeName(new Locale("L1")));
        ParticipantXMLHelper.addContent(r3, "Resource", "L2", node.getEmployeeName(new Locale("L2")));
        ParticipantXMLHelper.addContent(r3, "Resource", "L3", node.getEmployeeName(new Locale("L3")));
        return rtn;
    }

    private static String PositionsToXml(PositionInfo[] node) {
        Element element = new Element("Root");
        if (node != null) {
            for (int i = 0; i < node.length; ++i) {
                Element ele = ParticipantXMLHelper.PositionToElement(node[i]);
                element.addContent((Content)ele);
            }
        }
        String xml = ParticipantXMLHelper.ElementToXml(element);
        return xml;
    }

    private static Element PositionToElement(PositionInfo node) {
        Element rtn = new Element("Position");
        rtn.setAttribute("Id", String.valueOf(node.getId()));
        rtn.setAttribute("OrgId", String.valueOf(node.getOrgId()));
        Element r2 = new Element("Name");
        rtn.addContent((Content)r2);
        ParticipantXMLHelper.addContent(r2, "Resource", "L1", node.getName(new Locale("L1")));
        ParticipantXMLHelper.addContent(r2, "Resource", "L2", node.getName(new Locale("L2")));
        ParticipantXMLHelper.addContent(r2, "Resource", "L3", node.getName(new Locale("L3")));
        Element r3 = new Element("OrgName");
        rtn.addContent((Content)r3);
        ParticipantXMLHelper.addContent(r3, "Resource", "L1", node.getOrgName(new Locale("L1")));
        ParticipantXMLHelper.addContent(r3, "Resource", "L2", node.getOrgName(new Locale("L2")));
        ParticipantXMLHelper.addContent(r3, "Resource", "L3", node.getOrgName(new Locale("L3")));
        return rtn;
    }

    private static String OrgUnitToXml(OrgUnitInfo node) {
        Element element = new Element("Root");
        Element ele = ParticipantXMLHelper.OrgUnitToElement(node);
        element.addContent((Content)ele);
        String xml = ParticipantXMLHelper.ElementToXml(element);
        return xml;
    }

    private static String OrgUnitsToXml(OrgUnitInfo[] node) {
        Element element = new Element("Root");
        if (node != null) {
            for (int i = 0; i < node.length; ++i) {
                Element ele = ParticipantXMLHelper.OrgUnitToElement(node[i]);
                element.addContent((Content)ele);
            }
        }
        String xml = ParticipantXMLHelper.ElementToXml(element);
        return xml;
    }

    private static Element OrgUnitToElement(OrgUnitInfo node) {
        Element rtn = new Element("OrgUnit");
        rtn.setAttribute("Id", String.valueOf(node.getId()));
        rtn.setAttribute("ParentId", String.valueOf(node.getParentId()));
        rtn.setAttribute("CU", String.valueOf(node.isCU()));
        rtn.setAttribute("OrgType", String.valueOf(node.getOrgType()));
        Element r2 = new Element("Name");
        rtn.addContent((Content)r2);
        ParticipantXMLHelper.addContent(r2, "Resource", "L1", node.getName(new Locale("L1")));
        ParticipantXMLHelper.addContent(r2, "Resource", "L2", node.getName(new Locale("L2")));
        ParticipantXMLHelper.addContent(r2, "Resource", "L3", node.getName(new Locale("L3")));
        Element r3 = new Element("ParentName");
        rtn.addContent((Content)r3);
        ParticipantXMLHelper.addContent(r3, "Resource", "L1", node.getParentName(new Locale("L1")));
        ParticipantXMLHelper.addContent(r3, "Resource", "L2", node.getParentName(new Locale("L2")));
        ParticipantXMLHelper.addContent(r3, "Resource", "L3", node.getParentName(new Locale("L3")));
        return rtn;
    }

    private static String JobsToXml(JobInfo[] node) {
        Element element = new Element("Root");
        if (node != null) {
            for (int i = 0; i < node.length; ++i) {
                Element ele = ParticipantXMLHelper.JobToElement(node[i]);
                element.addContent((Content)ele);
            }
        }
        String xml = ParticipantXMLHelper.ElementToXml(element);
        return xml;
    }

    private static Element JobToElement(JobInfo node) {
        Element rtn = new Element("Job");
        rtn.setAttribute("Id", String.valueOf(node.getId()));
        rtn.setAttribute("OrgId", String.valueOf(node.getOrgId()));
        Element r2 = new Element("Name");
        rtn.addContent((Content)r2);
        ParticipantXMLHelper.addContent(r2, "Resource", "L1", node.getName(new Locale("L1")));
        ParticipantXMLHelper.addContent(r2, "Resource", "L2", node.getName(new Locale("L2")));
        ParticipantXMLHelper.addContent(r2, "Resource", "L3", node.getName(new Locale("L3")));
        Element r3 = new Element("OrgName");
        rtn.addContent((Content)r3);
        ParticipantXMLHelper.addContent(r3, "Resource", "L1", node.getOrgName(new Locale("L1")));
        ParticipantXMLHelper.addContent(r3, "Resource", "L2", node.getOrgName(new Locale("L2")));
        ParticipantXMLHelper.addContent(r3, "Resource", "L3", node.getOrgName(new Locale("L3")));
        return rtn;
    }

    private String GroupsToXml(Group[] node) {
        Element element = new Element("Root");
        if (node != null) {
            for (int i = 0; i < node.length; ++i) {
                Element ele = this.GroupToElement(node[i]);
                element.addContent((Content)ele);
            }
        }
        String xml = ParticipantXMLHelper.ElementToXml(element);
        return xml;
    }

    private Element GroupToElement(Group node) {
        Element rtn = new Element("Group");
        rtn.setAttribute("Id", node.getGroupId());
        String groupname = node.getGroupName(this.getLocale());
        if (groupname == null) {
            groupname = "";
            HashMap map = node.getGroupName();
            if (map != null && map.size() > 0) {
                logger.info((Object)"==========Group Names========\n");
                Set entryset = map.entrySet();
                for (Map.Entry entry : entryset) {
                    Locale locale = (Locale)entry.getKey();
                    logger.error((Object)("locale is: --" + locale.toString() + "  name is:--" + entry.getValue()));
                }
                logger.info((Object)"==========End Group Names========");
            }
        }
        rtn.setAttribute("name", groupname);
        return rtn;
    }

    public String getPersonByUserId(String personId) throws WfDesignerParticipantException {
        Person rtn = this._participantHelper.getPersonByUserId(personId);
        return ParticipantXMLHelper.PersonToXml(rtn);
    }

    public String getPersonByEmployeeId(String personId) throws WfDesignerParticipantException {
        Person[] rtn = this._participantHelper.getPersonByEmployeeId(personId);
        Element element = new Element("Root");
        if (rtn != null) {
            for (int i = 0; i < rtn.length; ++i) {
                Element ele = ParticipantXMLHelper.PersonToElement(rtn[i]);
                element.addContent((Content)ele);
            }
        }
        String xml = ParticipantXMLHelper.ElementToXml(element);
        return xml;
    }

    public String getPositionHolders(String positionId) throws WfDesignerParticipantException {
        Person[] rtn = this._participantHelper.getPositionHolders(positionId);
        return ParticipantXMLHelper.PersonsToXml(rtn);
    }

    public String getOrgMember(String orgId) throws WfDesignerParticipantException {
        Person[] rtn = this._participantHelper.getOrgMember(orgId);
        return ParticipantXMLHelper.PersonsToXml(rtn);
    }

    public String getOrgAllMember(String orgId) throws WfDesignerParticipantException {
        Person[] rtn = this._participantHelper.getOrgAllMember(orgId);
        return ParticipantXMLHelper.PersonsToXml(rtn);
    }

    public String getOrgPrincipal(String orgId) throws WfDesignerParticipantException {
        Person[] rtn = this._participantHelper.getOrgPrincipal(orgId);
        return ParticipantXMLHelper.PersonsToXml(rtn);
    }

    public String getSupervisor(String personId, String positionId, String hierarchyId) throws WfDesignerParticipantException {
        Person[] rtn = this._participantHelper.getSupervisor(personId, positionId, hierarchyId);
        return ParticipantXMLHelper.PersonsToXml(rtn);
    }

    public String getSubordinate(String personId, String positionId, String hierarchyId) throws WfDesignerParticipantException {
        Person[] rtn = this._participantHelper.getSubordinate(personId, positionId, hierarchyId);
        return ParticipantXMLHelper.PersonsToXml(rtn);
    }

    public String getFellow(String personId, String positionId, String hierarchyId) throws WfDesignerParticipantException {
        Person[] rtn = this._participantHelper.getFellow(personId, positionId, hierarchyId);
        return ParticipantXMLHelper.PersonsToXml(rtn);
    }

    public String getRoleMember(String personUserId, String roleId) throws WfDesignerParticipantException {
        Person[] rtn = this._participantHelper.getRoleMember(personUserId, roleId);
        return ParticipantXMLHelper.PersonsToXml(rtn);
    }

    public String getPositionArrayByUserId(String userId) throws WfDesignerParticipantException {
        PositionInfo[] rtn = this._participantHelper.getPositionArrayByUserId(userId);
        return ParticipantXMLHelper.PositionsToXml(rtn);
    }

    public String getPositionArrayByEmployeeId(String employeeId) throws WfDesignerParticipantException {
        PositionInfo[] rtn = this._participantHelper.getPositionArrayByEmployeeId(employeeId);
        return ParticipantXMLHelper.PositionsToXml(rtn);
    }

    public String getPositionArrayByOrgUnitId(String orgUnitId) throws WfDesignerParticipantException {
        PositionInfo[] rtn = this._participantHelper.getPositionArrayByOrgUnitId(orgUnitId);
        return ParticipantXMLHelper.PositionsToXml(rtn);
    }

    public String getPositionIDbyEmployeeId(String employeeId) throws WfDesignerParticipantException {
        PositionInfo[] rtn = this._participantHelper.getPositionArrayByEmployeeId(employeeId);
        PositionInfo info = null;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < rtn.length; ++i) {
            info = rtn[i];
            if (buffer.length() > 0) {
                buffer.append(';');
            }
            buffer.append(info.getId());
        }
        return buffer.toString();
    }

    public String getOrgIDbyEmployeeId(String employeeId) throws WfDesignerParticipantException {
        OrgUnitInfo[] rtn = this._participantHelper.getOrgUnitArrayByEmployeeId(employeeId);
        OrgUnitInfo info = null;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < rtn.length; ++i) {
            info = rtn[i];
            if (buffer.length() > 0) {
                buffer.append(';');
            }
            buffer.append(info.getId());
        }
        return buffer.toString();
    }

    public String getOrgUnitArrayByEmployeeId(String employeeId) throws WfDesignerParticipantException {
        OrgUnitInfo[] rtn = this._participantHelper.getOrgUnitArrayByEmployeeId(employeeId);
        return ParticipantXMLHelper.OrgUnitsToXml(rtn);
    }

    public String getAllOrgUnitArray() throws WfDesignerParticipantException {
        OrgUnitInfo[] rtn = this._participantHelper.getAllOrgUnitArray();
        return ParticipantXMLHelper.OrgUnitsToXml(rtn);
    }

    public String getAllOrgUnitByType(int orgType) throws WfDesignerParticipantException {
        OrgUnitInfo[] rtn = this._participantHelper.getAllOrgUnitByType(orgType);
        return ParticipantXMLHelper.OrgUnitsToXml(rtn);
    }

    public String getFlexJobsTree() throws WfDesignerParticipantException {
        JobInfo job = null;
        JobInfo[] jobs = this._participantHelper.getJobsArray();
        Element element = new Element("Root");
        Element ele = null;
        for (int i = 0; i < jobs.length; ++i) {
            job = jobs[i];
            if (job == null) continue;
            String name = job.getName(this.getLocale());
            if (name == null || name.length() == 0) {
                name = "";
            }
            ele = new Element("item");
            ele.setAttribute("label", name != null ? name : "");
            ele.setAttribute("Id", job.getId() != null ? job.getId() : "");
            ele.setAttribute("orgId", job.getOrgId() != null ? job.getOrgId() : "");
            element.addContent((Content)ele);
        }
        jobs = null;
        String xml = ParticipantXMLHelper.ElementToXml(element);
        return xml;
    }

    public String getFlexEmployeeByOrgId(String orgId) throws WfDesignerParticipantException {
        if (StringUtils.isEmpty((String)orgId)) {
            return "";
        }
        Person[] ar = null;
        ar = this._participantHelper.getOrgAllMember(orgId);
        if (ar == null || ar.length <= 0) {
            return "";
        }
        HashMap<String, Person> map = new HashMap<String, Person>();
        for (int i = ar.length - 1; i >= 0; --i) {
            String id = ar[i].getEmployeeId();
            if (map.containsKey(id)) continue;
            map.put(id, ar[i]);
        }
        ArrayList list = new ArrayList(map.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                Map.Entry obj1 = (Map.Entry)o1;
                Map.Entry obj2 = (Map.Entry)o2;
                if (obj1.getValue() instanceof Person && obj2.getValue() instanceof Person) {
                    String name1 = ((Person)obj1.getValue()).getEmployeeName(ParticipantXMLHelper.this.getLocale());
                    String name2 = ((Person)obj2.getValue()).getEmployeeName(ParticipantXMLHelper.this.getLocale());
                    if (name1 == null) {
                        name1 = "";
                    }
                    if (name2 == null) {
                        name2 = "";
                    }
                    Collator myCollator = Collator.getInstance(ParticipantXMLHelper.this.getLocale());
                    return myCollator.compare(name1, name2);
                }
                return 0;
            }
        });
        Element element = new Element("Root");
        element.setAttribute("orgId", orgId != null ? orgId : "");
        Element ele = null;
        for (Map.Entry entry : list) {
            Person person = (Person)entry.getValue();
            if (person == null) continue;
            String name = person.getEmployeeName(this.getLocale()) != null ? person.getEmployeeName(this.getLocale()) : "unknown";
            ele = new Element("item");
            ele.setAttribute("label", name != null ? name : "");
            ele.setAttribute("Id", person.getEmployeeId() != null ? person.getEmployeeId() : "");
            element.addContent((Content)ele);
        }
        ar = null;
        String xml = ParticipantXMLHelper.ElementToXml(element);
        return xml;
    }

    public String getFlexEmployeeByPositionId(String positionId) throws WfDesignerParticipantException {
        if (StringUtils.isEmpty((String)positionId)) {
            return "";
        }
        Person[] ar = null;
        ar = this._participantHelper.getPositionHolders(positionId);
        if (ar == null || ar.length <= 0) {
            return "";
        }
        HashMap<String, Person> map = new HashMap<String, Person>();
        for (int i = ar.length - 1; i >= 0; --i) {
            String id = ar[i].getEmployeeId();
            if (map.containsKey(id)) continue;
            map.put(id, ar[i]);
        }
        ArrayList list = new ArrayList(map.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                Map.Entry obj1 = (Map.Entry)o1;
                Map.Entry obj2 = (Map.Entry)o2;
                if (obj1.getValue() instanceof Person && obj2.getValue() instanceof Person) {
                    String name1 = ((Person)obj1.getValue()).getEmployeeName(ParticipantXMLHelper.this.getLocale());
                    String name2 = ((Person)obj2.getValue()).getEmployeeName(ParticipantXMLHelper.this.getLocale());
                    if (name1 == null) {
                        name1 = "";
                    }
                    if (name2 == null) {
                        name2 = "";
                    }
                    Collator myCollator = Collator.getInstance(ParticipantXMLHelper.this.getLocale());
                    return myCollator.compare(name1, name2);
                }
                return 0;
            }
        });
        Element element = new Element("Root");
        element.setAttribute("positionId", positionId);
        Element ele = null;
        for (Map.Entry entry : list) {
            Person person = (Person)entry.getValue();
            if (person == null) continue;
            String name = person.getEmployeeName(this.getLocale()) != null ? person.getEmployeeName(this.getLocale()) : "unknown";
            ele = new Element("item");
            ele.setAttribute("label", name != null ? name : "");
            ele.setAttribute("Id", person.getEmployeeId() != null ? person.getEmployeeId() : "");
            element.addContent((Content)ele);
        }
        ar = null;
        String xml = ParticipantXMLHelper.ElementToXml(element);
        return xml;
    }

    public String getFlexPosition(String orgId) throws WfDesignerParticipantException {
        Element element = new Element("Root");
        element.setAttribute("orgId", orgId);
        if (StringUtils.isEmpty((String)orgId)) {
            return "";
        }
        PositionInfo[] ar = null;
        Element ele = null;
        ar = this._participantHelper.getPositionArrayByOrgUnitId(orgId);
        if (ar == null || ar.length <= 0) {
            return "";
        }
        PositionInfo obj = null;
        for (int i = 0; i < ar.length; ++i) {
            obj = ar[i];
            ele = new Element("item");
            String name = obj.getName(this.getLocale());
            if (StringUtils.isEmpty((String)name)) {
                name = "";
            }
            ele.setAttribute("label", name != null ? name : "");
            ele.setAttribute("Id", obj.getId() != null ? obj.getId() : "");
            ele.setAttribute("orgId", obj.getId() != null ? obj.getId() : "");
            element.addContent((Content)ele);
        }
        ar = null;
        String xml = ParticipantXMLHelper.ElementToXml(element);
        return xml;
    }

    public String getFlexAllOrgUit(int orgType) throws WfDesignerParticipantException {
        OrgUnitInfo[] rtn = this._participantHelper.getAllOrgUnitByType(orgType);
        Element element = new Element("Root");
        OrgUnitInfo obj = null;
        obj = this._participantHelper.getRootUnit(0);
        if (obj == null) {
            return "";
        }
        String name = obj.getName(this.getLocale());
        if (StringUtils.isEmpty((String)name)) {
            name = "";
        }
        if (obj.getId() == null) {
            return "";
        }
        Element orgRoot = new Element("Item");
        orgRoot.setAttribute("label", name != null ? name : "");
        orgRoot.setAttribute("Id", obj.getId() != null ? obj.getId() : "");
        element.addContent((Content)orgRoot);
        this.deployCreateOrgTreeByParent(orgRoot, obj.getId(), rtn);
        String xml = ParticipantXMLHelper.ElementToXml(element);
        return xml;
    }

    private void deployCreateOrgTreeByParent(Element parentEle, String id, OrgUnitInfo[] _allOrg) {
        if (parentEle == null) {
            return;
        }
        ArrayList ar = this.getAllChildrenByID(id, _allOrg);
        if (ar == null || ar.size() == 0) {
            ar = null;
            return;
        }
        Collections.sort(ar, new OrgUnitInfoComparator());
        Element tvItem = null;
        OrgUnitInfo obj = null;
        for (int i = 0; i < ar.size(); ++i) {
            obj = (OrgUnitInfo)ar.get(i);
            if (obj == null) continue;
            tvItem = new Element("item");
            String name = obj.getName(this.getLocale());
            if (name == null || name.length() == 0 || obj.getId() == null) continue;
            tvItem.setAttribute("label", name);
            tvItem.setAttribute("Id", obj.getId() != null ? obj.getId() : "");
            parentEle.addContent((Content)tvItem);
            this.deployCreateOrgTreeByParent(tvItem, obj.getId(), _allOrg);
        }
        ar = null;
        tvItem = null;
        obj = null;
    }

    private ArrayList getAllChildrenByID(String id, OrgUnitInfo[] _allOrg) {
        if (id == null || id.trim().length() == 0) {
            return null;
        }
        ArrayList<OrgUnitInfo> ar = new ArrayList<OrgUnitInfo>();
        for (int i = 0; i < _allOrg.length; ++i) {
            if (_allOrg[i].getParentId() == null || _allOrg[i].getParentId().length() == 0 || !_allOrg[i].getParentId().equals(id)) continue;
            ar.add(_allOrg[i]);
        }
        return ar;
    }

    public String getRootUnit(int orgType) throws WfDesignerParticipantException {
        OrgUnitInfo rtn = this._participantHelper.getRootUnit(orgType);
        return ParticipantXMLHelper.OrgUnitToXml(rtn);
    }

    public String getOrgUnitArrayByUserId(String userId) throws WfDesignerParticipantException {
        OrgUnitInfo[] rtn = this._participantHelper.getOrgUnitArrayByUserId(userId);
        return ParticipantXMLHelper.OrgUnitsToXml(rtn);
    }

    public String getSubOrgUnit(String parantOrgUnitId) throws WfDesignerParticipantException {
        OrgUnitInfo[] rtn = this._participantHelper.getSubOrgUnit(parantOrgUnitId);
        return ParticipantXMLHelper.OrgUnitsToXml(rtn);
    }

    public String getParentOrgUnit(String orgUintId) throws WfDesignerParticipantException {
        OrgUnitInfo rtn = this._participantHelper.getParentOrgUnit(orgUintId);
        return ParticipantXMLHelper.OrgUnitToXml(rtn);
    }

    public boolean isPersonInOrg(String personId, String OrgId) throws WfDesignerParticipantException {
        return this._participantHelper.isPersonInOrg(personId, OrgId);
    }

    public String getHierarchyNameByID(String id) throws WfDesignerParticipantException {
        return this._participantHelper.getHierarchyNameByID(id);
    }

    public String getPositionByPersonAndHierarchy(String personID, String hierarchyID) throws WfDesignerParticipantException {
        PositionInfo[] rtn = this._participantHelper.getPositionByPersonAndHierarchy(personID, hierarchyID);
        return ParticipantXMLHelper.PositionsToXml(rtn);
    }

    public String getHierarchyByOrgType(int orgType) throws WfDesignerParticipantException {
        try {
            String[] hiberids = this._participantHelper.getHierarchyByOrgType(orgType);
            Element root = new Element("root");
            if (hiberids != null && hiberids.length > 0) {
                Element el = null;
                for (int i = 0; i < hiberids.length; ++i) {
                    String hiberid = hiberids[i];
                    String hibername = this.getHierarchyNameByID(hiberid);
                    el = new Element("item");
                    el.setAttribute("Id", hiberid);
                    el.setAttribute("label", hibername);
                    root.addContent((Content)el);
                }
            }
            return ParticipantXMLHelper.ElementToXml(root);
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u6c47\u62a5\u5173\u7cfb\u65f6\u51fa\u73b0\u9519\u8bef\uff0c\u7ec4\u7ec7\u7c7b\u578bid= " + orgType + " =="), (Throwable)e);
            if (e instanceof WfDesignerParticipantException) {
                throw (WfDesignerParticipantException)e;
            }
            throw new WfDesignerParticipantException(e.getCause());
        }
    }

    public String getAdminOrgUnitNamebyPositionID(String posittonID) throws WfDesignerParticipantException {
        return this._participantHelper.getAdminOrgUnitNamebyPositionID(posittonID);
    }

    public String getJobArrayByOrgUnitId(String orgUnitId) throws WfDesignerParticipantException {
        JobInfo[] rtn = this._participantHelper.getJobArrayByOrgUnitId(orgUnitId);
        return ParticipantXMLHelper.JobsToXml(rtn);
    }

    public String getJobsArray() throws WfDesignerParticipantException {
        JobInfo[] rtn = this._participantHelper.getJobsArray();
        return ParticipantXMLHelper.JobsToXml(rtn);
    }

    public String getAllGroups() throws WfDesignerParticipantException {
        Group[] rtn = this._participantHelper.getAllGroups();
        return this.GroupsToXml(rtn);
    }

    public String getPersonsFromGroup(String groupId) throws WfDesignerParticipantException {
        Person[] rtn = this._participantHelper.getPersonsFromGroup(groupId);
        return ParticipantXMLHelper.PersonsToXml(rtn);
    }

    public BOSObjectType getType() {
        return IParticipantXMLHelper.BOSTYPE;
    }

    private Locale getLocale() {
        Locale rtn = null;
        if (this.ctx != null && this.ctx.getLocale() != null) {
            rtn = this.ctx.getLocale();
        }
        if (rtn == null) {
            rtn = DEF_LOCALE;
        }
        return rtn;
    }

    public String getPositionByEmployeeAndHiber(String employeeid, String hiberid) throws WfDesignerParticipantException {
        try {
            PositionInfo[] postions = this._participantHelper.getPositionByPersonAndHierarchy(employeeid, hiberid);
            Element root = new Element("Root");
            if (postions != null && postions.length > 0) {
                for (int _idx = 0; _idx < postions.length; ++_idx) {
                    PositionInfo _tmp = postions[_idx];
                    Element item = new Element("item");
                    item.setAttribute("Id", _tmp.getId());
                    item.setAttribute("label", _tmp.getName(this.getLocale()));
                    root.addContent((Content)item);
                }
            }
            return ParticipantXMLHelper.ElementToXml(root);
        }
        catch (Exception e) {
            logger.error((Object)"flex getPositionByEmployeeAndHiber eror", (Throwable)e);
            throw new WfDesignerParticipantException("flex\u63a5\u53e3\u83b7\u53d6\u804c\u4f4d\u4fe1\u606f\u65f6\u51fa\u9519", e.getStackTrace().toString());
        }
    }

    class OrgUnitInfoComparator
    implements Comparator {
        OrgUnitInfoComparator() {
        }

        public int compare(Object orgUnitInfo1, Object orgUnitInfo2) {
            if (orgUnitInfo1 instanceof OrgUnitInfo && orgUnitInfo2 instanceof OrgUnitInfo) {
                OrgUnitInfo info1 = (OrgUnitInfo)orgUnitInfo1;
                OrgUnitInfo info2 = (OrgUnitInfo)orgUnitInfo2;
                String name1 = info1.getName(ParticipantXMLHelper.this.getLocale());
                String name2 = info2.getName(ParticipantXMLHelper.this.getLocale());
                if (name1 == null) {
                    name1 = "";
                }
                if (name2 == null) {
                    name2 = "";
                }
                Collator myCollator = Collator.getInstance(ParticipantXMLHelper.this.getLocale());
                return myCollator.compare(name1, name2);
            }
            return 0;
        }
    }
}

