/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewFilterInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeEntryCollection;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeEntryInfo;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeFactory;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeInfo;
import com.kingdee.eas.basedata.master.account.AsstChangeInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.IAsstAccountChangeProcess;
import com.kingdee.eas.basedata.master.account.app.AbstractAccountFacadeControllerBean;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstAccount;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.BizHasDealException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.STConverter;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountFacadeControllerBean
extends AbstractAccountFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.account.app.AccountFacadeControllerBean");
    private String allResource = "com.kingdee.eas.basedata.master.account.AllAccountResource";

    @Override
    protected void _copyAccount(Context ctx, String parentAccountId, String firstAccountNumber, Map accountMap) throws BOSException, EASBizException {
        if (accountMap == null || accountMap.size() == 0) {
            return;
        }
        String parentid = parentAccountId;
        AccountViewInfo info = (AccountViewInfo)this.getInterface(ctx).getValue((IObjectPK)new ObjectUuidPK(parentid));
        Set set = accountMap.keySet();
        Iterator it = set.iterator();
        String firstNumber = firstAccountNumber;
        AccountViewInfo firstaccount = null;
        while (it.hasNext()) {
            String key = (String)it.next();
            AccountViewInfo srcaccount = (AccountViewInfo)accountMap.get(key);
            if (key.equals(firstNumber)) {
                firstaccount = srcaccount;
            }
            this.addNew(ctx, key, info, srcaccount);
        }
        this.addNewFirst(ctx, firstNumber, info, firstaccount);
    }

    protected void addNew(Context ctx, String number, AccountViewInfo parent, AccountViewInfo srcaccount) throws BOSException, EASBizException {
        AccountViewInfo info = (AccountViewInfo)this.getInterface(ctx).getValue((IObjectPK)new ObjectUuidPK(srcaccount.getId().toString()));
        String oldname = info.getName();
        info.setId(null);
        info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        info.setCompanyID(ContextUtil.getCurrentFIUnit((Context)ctx));
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setNumber(number);
        info.setLongNumber(parent.getLongNumber() + "!" + number);
        info.setLongName(parent.getLongName() + "_" + oldname);
        info.setDisplayName(parent.getLongName() + "_" + oldname);
        this.getInterface(ctx).addnew((CoreBaseInfo)info);
    }

    protected void addNewFirst(Context ctx, String number, AccountViewInfo parent, AccountViewInfo srcaccount) throws BOSException {
    }

    private IAccountView getInterface(Context ctx) throws BOSException {
        return AccountViewFactory.getLocalInstance(ctx);
    }

    @Override
    protected boolean _isSameMeasureWithAccount(Context ctx, String asstActTypeId, String measureUnitGroup, String measureId) throws BOSException {
        String sql = "select b.fmeasureunitgroupid,b.fmeasureunitid from t_bd_asstaccount a,t_bd_accountview b , \r\n t_bd_asstactgroupdetail c ,t_bd_asstacttype e \t\t\t\t\t\t\t\t\t\r\n where a.fid=b.fcaa and a.fid=c.fasstaccountid and c.fasstacttypeid=e.fid \t\t\t\r\n and e.fid=?  and b.fisqty=1   ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{asstActTypeId});
        try {
            if (rowSet != null && rowSet.next()) {
                String measuregroup = rowSet.getString("fmeasureUnitGroupId");
                if (measureUnitGroup == null || measuregroup != null && !measuregroup.equals(measureUnitGroup)) {
                    return false;
                }
                String measure = rowSet.getString("fmeasureunitid");
                if (measureId == null || measure != null && !measure.equals(measureId)) {
                    return false;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    @Override
    protected boolean _isSameMeasureWithAsst(Context ctx, String accountViewId, String asstAccountId, String measureUnitGroup, String measureId) throws BOSException {
        String sql = "select fmeasureUnitGroupId,fmeasureunitid from t_bd_asstaccount where fid=? and fisqty=1";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{asstAccountId});
        try {
            if (rowSet != null && rowSet.next()) {
                String measuregroup = rowSet.getString("fmeasureUnitGroupId");
                String measure = rowSet.getString("fmeasureunitid");
                if (accountViewId == null) {
                    if (measuregroup == null || !measuregroup.equals(measureUnitGroup)) {
                        return false;
                    }
                    if (measure == null || measure != null && !measure.equals(measureId)) {
                        return false;
                    }
                } else {
                    sql = "select fmeasureunitgroupid,fmeasureunitid  from t_bd_accountview where fid=? and fisqty=1 ";
                    rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{accountViewId});
                    if (rowSet != null && rowSet.next()) {
                        String ameasureGroup = rowSet.getString("fmeasureunitgroupid");
                        if (measuregroup == null || !measuregroup.equals(ameasureGroup)) {
                            return false;
                        }
                        String ameasure = rowSet.getString("fmeasureunitid");
                        if (measure == null || measure != null && !measure.equals(ameasure)) {
                            return false;
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    @Override
    public String checkCompanyAuxAccount(Context ctx, String acctId, String caa) throws BOSException, EASBizException {
        String acctNumber;
        IRowSet rsToGetChildNeedCheckAA;
        String sqlToGetChildNeedCheckAA;
        ObjectUuidPK pkCompany;
        String result;
        MessageFormat mf;
        String msg;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("number");
        sic.add("name");
        sic.add("CAA");
        sic.add("GAA");
        sic.add("parentAA");
        sic.add("AC");
        sic.add("ACNotice");
        sic.add("parent.CAA");
        sic.add("upper.CAA");
        sic.add("CU.number");
        sic.add("companyID.number");
        AccountViewInfo accountViewInfo = AccountViewFactory.getLocalInstance(ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(acctId), sic);
        IAsstAccount iAsstAccount = AsstAccountFactory.getLocalInstance((Context)ctx);
        StringBuffer warnStr = new StringBuffer();
        if (accountViewInfo.getUpper() != null) {
            ObjectUuidPK pkUpper;
            msg = EASResource.getString((String)this.allResource, (String)"CAANOTINCLUDEGAA_NEW");
            mf = new MessageFormat(msg);
            result = mf.format(new String[]{accountViewInfo.getCompanyID().getNumber(), accountViewInfo.getNumber()});
            if (accountViewInfo.getGAA() != null && caa == null) {
                warnStr.append(result).append("\n");
            }
            if (accountViewInfo.getGAA() != null && caa != null && !iAsstAccount.compare((IObjectPK)(pkUpper = new ObjectUuidPK(accountViewInfo.getGAA().getId())), (IObjectPK)(pkCompany = new ObjectUuidPK(caa)))) {
                warnStr.append(result).append("\n");
            }
        }
        if (accountViewInfo.getParent() != null) {
            ObjectUuidPK pkParent;
            msg = EASResource.getString((String)this.allResource, (String)"CAANOTINCLUDEPARENTAA_NEW");
            mf = new MessageFormat(msg);
            result = mf.format(new String[]{accountViewInfo.getCompanyID().getNumber(), accountViewInfo.getNumber()});
            if (accountViewInfo.getParent().getCAA() != null && caa == null) {
                warnStr.append(result).append("\n");
            }
            if (accountViewInfo.getParent().getCAA() != null && caa != null && !iAsstAccount.compare((IObjectPK)(pkParent = new ObjectUuidPK(accountViewInfo.getParentAA().getId())), (IObjectPK)(pkCompany = new ObjectUuidPK(caa)))) {
                warnStr.append(result).append("\n");
            }
        }
        if (caa != null) {
            sqlToGetChildNeedCheckAA = "SELECT CHILD.FNUMBER, CHILD.FCAA FROM T_BD_ACCOUNTVIEW CHILD INNER JOIN T_BD_ACCOUNTVIEW PARENT ON CHILD.FPARENTID = PARENT.FID WHERE CHILD.FPARENTID=? order by CHILD.FNUMBER";
            rsToGetChildNeedCheckAA = DbUtil.executeQuery((Context)ctx, (String)sqlToGetChildNeedCheckAA, (Object[])new Object[]{accountViewInfo.getId().toString()});
            try {
                while (rsToGetChildNeedCheckAA.next()) {
                    acctNumber = rsToGetChildNeedCheckAA.getString("FNUMBER");
                    String acctCaa = rsToGetChildNeedCheckAA.getString("FCAA");
                    if (acctCaa != null && iAsstAccount.compare((IObjectPK)new ObjectUuidPK(caa), (IObjectPK)new ObjectUuidPK(acctCaa))) continue;
                    String msg2 = EASResource.getString((String)this.allResource, (String)"ChildNotIncludeParentAA_NEW");
                    MessageFormat mf2 = new MessageFormat(msg2);
                    String result2 = mf2.format(new String[]{accountViewInfo.getCompanyID().getNumber(), accountViewInfo.getNumber(), acctNumber});
                    warnStr.append(result2).append("\n");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (caa != null) {
            sqlToGetChildNeedCheckAA = "SELECT CHILD.FNUMBER FNUMBER, PARENT.FNUMBER PFNUMBER, CHILD.FCAA FCAA, U.FNUMBER UFNUMBER ,U.FNAME_L1 UFNAME_L1,U.FNAME_L2 UFNAME_L2,U.FNAME_L3 UFNAME_L3 FROM T_BD_ACCOUNTVIEW CHILD INNER JOIN T_BD_ACCOUNTVIEW PARENT ON CHILD.FUPPERID = PARENT.FID INNER JOIN T_ORG_COMPANY U ON CHILD.FCompanyID=U.FID WHERE CHILD.FUPPERID=? ";
            rsToGetChildNeedCheckAA = DbUtil.executeQuery((Context)ctx, (String)sqlToGetChildNeedCheckAA, (Object[])new Object[]{accountViewInfo.getId().toString()});
            try {
                while (rsToGetChildNeedCheckAA.next()) {
                    acctNumber = rsToGetChildNeedCheckAA.getString("FNUMBER");
                    String parentAcctNumber = rsToGetChildNeedCheckAA.getString("PFNUMBER");
                    String acctCaa = rsToGetChildNeedCheckAA.getString("FCAA");
                    String childCompanyNumber = rsToGetChildNeedCheckAA.getString("UFNUMBER");
                    String childCompanyName = null;
                    childCompanyName = "L1".equalsIgnoreCase(ctx.getLocale().toString()) ? rsToGetChildNeedCheckAA.getString("UFNAME_L1") : ("L3".equalsIgnoreCase(ctx.getLocale().toString()) ? rsToGetChildNeedCheckAA.getString("UFNAME_L3") : rsToGetChildNeedCheckAA.getString("UFNAME_L2"));
                    if (acctCaa != null && iAsstAccount.compare((IObjectPK)new ObjectUuidPK(caa), (IObjectPK)new ObjectUuidPK(acctCaa))) continue;
                    String msg3 = EASResource.getString((String)this.allResource, (String)"InfeComNotIncludeAA");
                    MessageFormat mf3 = new MessageFormat(msg3);
                    String result3 = mf3.format(new String[]{childCompanyNumber, acctNumber, parentAcctNumber});
                    warnStr.append(result3).append("\n");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (accountViewInfo.isAC()) {
            CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(accountViewInfo.getCompanyID().getId()));
            String msg4 = EASResource.getString((String)this.allResource, (String)"CAAMUSTASSTBUTE_Attr");
            MessageFormat mf4 = new MessageFormat(msg4);
            String result4 = mf4.format(new String[]{accountViewInfo.getNumber(), companyOrgUnitInfo.getNumber()});
            if (caa == null) {
                warnStr.append(result4);
            } else {
                String sql = "select FasstHGAttribute from t_bd_asstacttype  a  left join T_BD_AsstActTypeDefault b  on a.fid=b.fasstacttypeid where b.FCompanyID=? and b.fisaccountcussent=1 and  a.fid in ( select fasstacttypeid from t_bd_asstactgroupdetail where \tfasstaccountid =? )";
                IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{accountViewInfo.getCompanyID().getId().toString(), caa});
                try {
                    if (rowset == null || !rowset.next()) {
                        warnStr.append(result4);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        if (accountViewInfo.isACNotice()) {
            msg = EASResource.getString((String)this.allResource, (String)"CAAMUSTCSP");
            mf = new MessageFormat(msg);
            result = mf.format(new String[]{accountViewInfo.getNumber()});
            if (accountViewInfo.getCAA() == null || caa == null) {
                warnStr.append(result);
            } else {
                String sql = "select FasstHGAttribute from t_bd_asstacttype where  fid in ( select fasstacttypeid from t_bd_asstactgroupdetail where \tfasstaccountid =? )";
                IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{caa});
                boolean hasCPS = false;
                try {
                    while (rowset != null && rowset.next()) {
                        String asstHGAttribute = rowset.getString("FasstHGAttribute");
                        if (!"customer".equals(asstHGAttribute) && !"companyOrg".equals(asstHGAttribute) && !"provider".equals(asstHGAttribute)) continue;
                        hasCPS = true;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                if (!hasCPS) {
                    warnStr.append(result);
                }
            }
        }
        return warnStr.toString();
    }

    @Override
    protected String _changeAsst(Context ctx, AccountViewInfo account, String oldCaa, String newCaa, Map defaultVal) throws BOSException, EASBizException {
        return this._changeAsst(ctx, account, oldCaa, newCaa, defaultVal, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected String _changeAsst(Context ctx, AccountViewInfo account, String oldCaa, String newCaa, Map defaultVal, PeriodInfo enablePeriod) throws BOSException, EASBizException {
        ArrayList<IAsstAccountChangeProcess> ps;
        AsstAccountChangeInfo change;
        AsstAccountChangeInfo last;
        CompanyOrgUnitInfo company;
        block28: {
            if (oldCaa == null && newCaa == null || oldCaa != null && newCaa != null && oldCaa.equals(newCaa)) {
                throw new BOSException("oldCaa and newCaa can not be equal.");
            }
            if (!account.containsKey("isLeaf") || !account.containsKey("hasUserProperty")) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("isLeaf");
                selector.add("hasUserProperty");
                AccountViewInfo temp = AccountViewFactory.getLocalInstance(ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(account.getId()), selector);
                account.setIsLeaf(temp.isIsLeaf());
                account.setHasUserProperty(temp.isHasUserProperty());
            }
            if (!(company = account.getCompanyID()).containsKey("isBizUnit")) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("isBizUnit");
                CompanyOrgUnitInfo temp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selector);
                company.setIsBizUnit(temp.isIsBizUnit());
            }
            if (enablePeriod == null && company.isIsBizUnit()) {
                enablePeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
            }
            last = null;
            if (company.isIsBizUnit() && account.isIsLeaf() && enablePeriod != null && (last = this._getLastAsstAccountChange(ctx, account.getId().toString())) != null && enablePeriod.getNumber() < last.getPeriod().getNumber()) {
                throw new AccountException(AccountException.ASSTACCOUNT_CHANGE_PERIODERROR, new Object[]{String.valueOf(enablePeriod.getNumber()), String.valueOf(last.getPeriod().getNumber())});
            }
            change = this.buildAsstAccountChange(ctx, account, enablePeriod, oldCaa, newCaa, defaultVal);
            change.put("last", last);
            ps = new ArrayList<IAsstAccountChangeProcess>();
            try {
                void var12_14;
                String[] processor = RefCheckersDAO.getCheckers((Context)ctx, (String)account.getBOSType().toString(), IAsstAccountChangeProcess.class);
                if (processor == null || processor.length <= 0) break block28;
                boolean bl = false;
                while (var12_14 < processor.length) {
                    try {
                        Class<?> processClass = Class.forName(processor[var12_14]);
                        IAsstAccountChangeProcess iAsstAccountChangeProcess = (IAsstAccountChangeProcess)processClass.newInstance();
                        if (iAsstAccountChangeProcess != null) {
                            iAsstAccountChangeProcess.init(ctx, change, defaultVal);
                            ps.add(iAsstAccountChangeProcess);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (AbstractMethodError e) {
                        throw new EASBizException(new NumericExceptionSubItem("101", "\u8bf7\u6253\u603b\u8d26\u8865\u4e01PT134978\u548c\u5229\u6da6\u4e2d\u5fc3\u603b\u8d26\u8865\u4e01PT134977\u6216\u603b\u8d26\u548c\u5229\u6da6\u4e2d\u5fc3\u603b\u8d26\u4e4b\u540e\u53d1\u5e03\u7684\u8865\u4e01\u3002"), (Throwable)e);
                    }
                    ++var12_14;
                }
            }
            catch (EASDBException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        try {
            for (IAsstAccountChangeProcess iAsstAccountChangeProcess : ps) {
                String result = iAsstAccountChangeProcess.requestMutex();
                if (result == null) continue;
                String string = result;
                return string;
            }
            String ids = "'" + account.getId().toString() + "'";
            this.updateCaa(ctx, newCaa, ids);
            String string = this.checkCompanyAuxAccount(ctx, account.getId().toString(), newCaa);
            if (!StringUtils.isEmpty((String)string)) {
                this.updateCaa(ctx, oldCaa, ids);
                Iterator iterator = string;
                return iterator;
            }
            for (IAsstAccountChangeProcess iAsstAccountChangeProcess : ps) {
                iAsstAccountChangeProcess.check();
            }
            for (IAsstAccountChangeProcess iAsstAccountChangeProcess : ps) {
                iAsstAccountChangeProcess.change();
            }
            if (newCaa != null) {
                // empty if block
            }
            this.saveLogs(ctx, defaultVal, account);
            ORMValueCacheService.getInstance().remove(ctx, account.getBOSType(), (IObjectPK)new ObjectUuidPK(account.getId()));
            if (company.isIsBizUnit() && account.isIsLeaf() && enablePeriod != null) {
                if (last != null && enablePeriod.getNumber() == last.getPeriod().getNumber()) {
                    AsstAccountChangeFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(last.getId()));
                    this.fixAsstAccountChange(ctx, change, last);
                }
                if (change.getAfter() == null && change.getBefore() != null || change.getAfter() != null && change.getBefore() == null || change.getAfter() != null && change.getBefore() != null && !change.getAfter().getId().equals((Object)change.getBefore().getId())) {
                    AsstAccountChangeFactory.getLocalInstance(ctx).addnew(change);
                }
            }
        }
        finally {
            for (IAsstAccountChangeProcess iAsstAccountChangeProcess : ps) {
                iAsstAccountChangeProcess.releaseMutex();
            }
        }
        return null;
    }

    private void saveLogs(Context ctx, Map defaultVal, AccountViewInfo accountViewInfo) {
        String methodName = EASCommonResource.getString((String)"com.kingdee.eas.basedata.master.account.AllAccountResource", (String)"AsstChange", (Locale)ctx.getLocale());
        BOSObjectType bizObjType = accountViewInfo.getBOSType();
        IObjectPK instancePK = null;
        String msg = EASCommonResource.getString((String)"com.kingdee.eas.basedata.master.account.AllAccountResource", (String)"account_asstChange_To", (Locale)ctx.getLocale());
        MessageFormat mf = new MessageFormat(msg);
        String instanceDetail = mf.format(new String[]{accountViewInfo.toString(), defaultVal.toString()});
        if (instanceDetail.endsWith("{}")) {
            instanceDetail = instanceDetail.replace("{}", "null");
        }
        String logItemName = "bd_account_accountView_changeAsst";
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)bizObjType, instancePK, (String)instanceDetail, (String)logItemName);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected String _batchChangeAsst(Context ctx, IObjectCollection coll, String newCaa, Map defaultVal, boolean isNew) throws BOSException, EASBizException {
        return this._batchChangeAsst(ctx, coll, newCaa, defaultVal, isNew, null);
    }

    @Override
    protected String _batchChangeAsst(Context ctx, IObjectCollection coll, String newCaa, Map defaultVal, boolean isNew, PeriodInfo enablePeriod) throws BOSException, EASBizException {
        AccountViewCollection acctColl = (AccountViewCollection)coll;
        String oldCaa = null;
        if (acctColl.get(0).getCAA() != null && !StringUtils.isEmpty((String)acctColl.get(0).getCAA().getId().toString())) {
            oldCaa = acctColl.get(0).getCAA().getId().toString();
        }
        ArrayList<String> idList = new ArrayList<String>();
        AccountViewInfo accInfo = null;
        for (int i = 0; i < acctColl.size(); ++i) {
            accInfo = acctColl.get(i);
            if (accInfo.getId() == null) continue;
            String warnStr = AccountFacadeFactory.getLocalInstance(ctx).changeAsst(accInfo, oldCaa, newCaa, defaultVal, enablePeriod);
            if (!StringUtils.isEmpty((String)warnStr)) {
                this.updateLastUpdateTime(ctx, idList);
                return warnStr;
            }
            idList.add(accInfo.getId().toString());
        }
        this.updateLastUpdateTime(ctx, idList);
        return "";
    }

    private void updateLastUpdateTime(Context ctx, List<String> idList) throws BOSException {
        if (idList == null || idList.size() < 1) {
            return;
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String updateAccountSql = "update t_bd_accountview set flastupdateuserid = '" + userId + "',flastupdatetime= getdate() where fid in(" + AccountTools.aryToStr(idList, true) + ") ";
        DbUtil.execute((Context)ctx, (String)updateAccountSql, (Object[])idList.toArray());
        updateAccountSql = "update t_bd_accountview set flastupdateuserid = '" + userId + "', flastupdatetime= getdate()  where fparentid in(" + AccountTools.aryToStr(idList, true) + ") ";
        DbUtil.execute((Context)ctx, (String)updateAccountSql, (Object[])idList.toArray());
        updateAccountSql = "update t_bd_accountview set flastupdateuserid = '" + userId + "',flastupdatetime= getdate()  where fupperid in(" + AccountTools.aryToStr(idList, true) + ") ";
        DbUtil.execute((Context)ctx, (String)updateAccountSql, (Object[])idList.toArray());
    }

    private void updateCaa(Context ctx, String caa, String ids) throws BOSException {
        AccountViewInfo acctInfo = new AccountViewInfo();
        String updateAccountSql = "update t_bd_accountview set fcaa=" + (caa == null ? "null" : "'" + caa + "'") + " where fid in(" + ids + ") ";
        DbUtil.execute((Context)ctx, (String)updateAccountSql);
        String forCacheids = ids.replaceAll("'", "");
        ORMValueCacheService.getInstance().removeBatch(ctx, acctInfo.getBOSType(), forCacheids.split(","));
        updateAccountSql = "update t_bd_accountview set FParentAAID=" + (caa == null ? "null" : "'" + caa + "'") + " where fparentid in(" + ids + ") ";
        DbUtil.execute((Context)ctx, (String)updateAccountSql);
        updateAccountSql = "select fid from  t_bd_accountview  where fparentid in(" + ids + ") ";
        this.removeCache(ctx, updateAccountSql, acctInfo.getBOSType());
        updateAccountSql = "update t_bd_accountview set fgaa=" + (caa == null ? "null" : "'" + caa + "'") + " where fupperid in(" + ids + ") ";
        DbUtil.execute((Context)ctx, (String)updateAccountSql);
        updateAccountSql = "select fid from  t_bd_accountview  where fupperid in(" + ids + ") ";
        this.removeCache(ctx, updateAccountSql, acctInfo.getBOSType());
    }

    @Override
    protected void _changeOthers(Context ctx, Map data, String id, List companyList) throws BOSException, EASBizException {
        ArrayList<String> listParam = new ArrayList<String>();
        String curUserID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer("update T_BD_Accountview set  FLastUpdateUserId=? ");
        listParam.add(curUserID);
        Set keyset = data.keySet();
        for (String key : keyset) {
            Object obj = data.get(key);
            sql.append(",").append(key).append("=? ");
            listParam.add((String)obj);
        }
        sql.append(" where   Fnumber=?  and FAccountTableId=? and FCompanyID in ('");
        listParam.add((String)data.get("FNumber"));
        listParam.add(id);
        for (int i = 0; i < companyList.size(); ++i) {
            String companyId = (String)companyList.get(i);
            if (i > 0) {
                sql.append("','");
            }
            sql.append(companyId);
        }
        sql.append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])listParam.toArray());
    }

    @Override
    protected boolean _isHasDeal(Context ctx, IObjectCollection accountViewCollection) {
        if (accountViewCollection != null && accountViewCollection.size() > 0) {
            AccountViewCollection accountViews = (AccountViewCollection)accountViewCollection;
            try {
                BizCheckResult biz = AccountTools.hasDeal(ctx, accountViews);
                if (biz.isFound()) {
                    return true;
                }
            }
            catch (BizHasDealException e) {
                e.printStackTrace();
                logger.debug((Object)e);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                logger.debug((Object)e);
            }
        }
        return false;
    }

    @Override
    protected boolean _isAcctTableHasDeal(Context ctx, IObjectValue acctTable, IObjectValue company) throws BOSException {
        AccountTableInfo acctTableInfo = (AccountTableInfo)acctTable;
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)company;
        AccountViewCollection cols = AccountTools.getAccountViewCollection(ctx, acctTableInfo, companyInfo);
        if (cols != null && cols.size() > 0) {
            try {
                BizCheckResult biz = AccountTools.hasDeal(ctx, cols);
                if (biz.isFound()) {
                    return true;
                }
            }
            catch (BizHasDealException e) {
                e.printStackTrace();
                logger.debug((Object)e);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                logger.debug((Object)e);
            }
        }
        return false;
    }

    @Override
    protected void _repairTC(Context ctx, IObjectValue accountTable) throws BOSException, EASBizException {
        AccountTableInfo accountTableInfo = (AccountTableInfo)accountTable;
        try {
            this.repairTraditionChinese(ctx, accountTableInfo);
            this.repairLevel(ctx, accountTableInfo);
            this.repairParent(ctx, accountTableInfo);
            this.repairUpperid(ctx, accountTableInfo);
            this.repairLongnameAndLongnumber(ctx, accountTableInfo);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void repairLevel(Context ctx, AccountTableInfo accountTableInfo) throws BOSException, SQLException {
        if (accountTableInfo.isIsUseSeparator()) {
            String separator = accountTableInfo.getSeparator();
            String sql = "update T_BD_AccountView set  FLevel = len(trim(FNumber)) - len(replace(trim(FNumber),'" + separator + "',''))+1 where (FLevel != len(trim(FNumber)) - len(replace(trim(FNumber),'" + separator + "',''))+1  or FLevel is null) and FAccounttableID ='" + accountTableInfo.getId().toString() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        } else {
            String sql = "select flevel from T_BD_AccountLev where faccounttableid='" + accountTableInfo.getId().toString() + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet != null && rowSet.next()) {
                int level = rowSet.getInt("flevel");
                sql = " update T_BD_AccountView set FLevel = '" + level + "' where  (len(FNumber) !=(select sum(FLength) from T_BD_AccountLev  where FAccountTableID=T_BD_AccountView.FAccountTableID and  FLevel<= T_BD_AccountView.FLevel)  or Flevel is null) and len(FNumber) =(select sum(FLength) from T_BD_AccountLev  where FAccountTableID=T_BD_AccountView.FAccountTableID and  FLevel<= '" + level + "') and FAccounttableID ='" + accountTableInfo.getId().toString() + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            }
        }
    }

    private void repairLongnameAndLongnumber(Context ctx, AccountTableInfo accountTableInfo) throws BOSException, SQLException {
        String sql = accountTableInfo != null && accountTableInfo.getId() != null ? "SELECT MAX(FLEVEL) flevel FROM T_BD_ACCOUNTVIEW WHERE FAccountTableID = '" + accountTableInfo.getId().toString() + "'" : "SELECT MAX(FLEVEL) flevel FROM T_BD_ACCOUNTVIEW ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        int level = 0;
        if (rowSet != null && rowSet.next()) {
            level = rowSet.getInt("flevel");
        }
        String updateSql = "update t_bd_accountview set flongnumber = fnumber,flongname_l2 = fname_l2,flongname_l3= fname_l3,fdisplayname_l2 = fname_l2,fdisplayname_l3 = fname_l3 where flevel = 1";
        DbUtil.execute((Context)ctx, (String)updateSql);
        for (int i = 2; i <= level; ++i) {
            updateSql = "update t_bd_accountview set flongnumber = (select pv.flongnumber || '!'|| t_bd_accountview.fnumber from t_bd_accountview pv where pv.fid = t_bd_accountview.fparentid),flongname_l2 = (select pv.flongname_l2 || '_'|| t_bd_accountview.fname_l2 from t_bd_accountview pv where pv.fid = t_bd_accountview.fparentid),flongname_l3 = (select pv.flongname_l3 || '_' || t_bd_accountview.fname_l3 from t_bd_accountview pv where pv.fid = t_bd_accountview.fparentid),fdisplayname_l2 = (select pv.fdisplayname_l2 || '_' || t_bd_accountview.fname_l2 from t_bd_accountview pv where pv.fid = t_bd_accountview.fparentid),fdisplayname_l3 = (select pv.fdisplayname_l3 || '_' || t_bd_accountview.fname_l3 from t_bd_accountview pv where pv.fid = t_bd_accountview.fparentid) where exists(select 1 from t_bd_accountview pv where pv.fid = t_bd_accountview.fparentid) and flevel = ?";
            DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{new Integer(i)});
        }
    }

    private void repairUpperid(Context ctx, AccountTableInfo accountTableInfo) throws BOSException {
        String sql = "update t_bd_accountview  set fupperid = ( select top 1 b.fid from t_bd_accountview b  where ((b.fcompanyid=(select c.fparentid from t_org_company c  where c.fid = t_bd_accountview.fcompanyid) and t_bd_accountview.fnumber = b.fnumber) and t_bd_accountview.faccounttableid=b.faccounttableid and b.faccounttableid=? )) where faccounttableid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{accountTableInfo.getId().toString(), accountTableInfo.getId().toString()});
    }

    private void repairParent(Context ctx, AccountTableInfo accountTableInfo) throws BOSException, SQLException {
        if (accountTableInfo.isIsUserLevel()) {
            String sql = " select flevel,flength from T_BD_AccountLev where faccounttableid='" + accountTableInfo.getId().toString() + "' and flevel > 1 order by flevel";
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowset != null && rowset.next()) {
                int level = rowset.getInt("flevel");
                int length = rowset.getInt("flength");
                if (accountTableInfo.isIsUseSeparator()) {
                    ++length;
                }
                sql = "update T_BD_AccountView set FParentID=(select top 1 p.FID from T_BD_AccountView p  where T_BD_AccountView.FCompanyID=p.FCompanyID and T_BD_AccountView.FAccountTableID=p.FAccountTableID \tand p.FNumber=Left(T_BD_AccountView.FNumber,Len(T_BD_AccountView.FNumber)-?)) \twhere  flevel =? and FAccountTableID=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{length, level, accountTableInfo.getId().toString()});
            }
        } else {
            String seperator = accountTableInfo.getSeparator();
            String sql = "update T_BD_AccountView set FParentID=(select top 1 p.FID from T_BD_AccountView p  where T_BD_AccountView.FCompanyID=p.FCompanyID and T_BD_AccountView.FAccountTableID=p.FAccountTableID \tand p.fnumber=substring(T_BD_AccountView.FNumber,1,len(p.fnumber)) and  CharIndex('" + seperator + "',Substring(T_BD_AccountView.FNumber,Len(p.FNumber||'" + seperator + "')+1,Len(T_BD_AccountView.FNumber)))=0)\twhere  FAccountTableID=? and FLevel>1";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{accountTableInfo.getId().toString()});
        }
    }

    private void repairTraditionChinese(Context ctx, AccountTableInfo accountTableInfo) throws AccountException, BOSException {
        if (accountTableInfo == null || accountTableInfo.getId() == null || StringUtils.isEmpty((String)accountTableInfo.getId().toString())) {
            throw new AccountException(AccountException.NOT_ACCOUNTTABLE);
        }
        String sql = "select count(*) count from t_bd_accountview where  FAccountTableID  = '" + accountTableInfo.getId().toString() + "' AND FNAME_L3 is NULL OR FNAME_L3 LIKE '%null%'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        int count = 0;
        try {
            while (rowSet != null && rowSet.next()) {
                count = rowSet.getInt("count");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        int loop = count / 99999 + 1;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            for (int i = 0; i < loop; ++i) {
                sql = "SELECT top 99999 FID,FNAME_L2 FROM T_BD_ACCOUNTVIEW WHERE FAccountTableID  = '" + accountTableInfo.getId().toString() + "' AND FNAME_L3 is NULL OR FNAME_L3 LIKE '%null%' ORDER BY FLEVEL";
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                String updateSql = "UPDATE T_BD_ACCOUNTVIEW SET FNAME_L3 =? WHERE FID=? ";
                stmt = conn.prepareStatement(updateSql);
                while (rowSet != null && rowSet.next()) {
                    String fid = rowSet.getString("FID");
                    String name_l2 = rowSet.getString("FNAME_L2");
                    if (StringUtils.isEmpty((String)name_l2)) continue;
                    String name_l3 = STConverter.sc2tc((String)name_l2);
                    stmt.setString(1, name_l3);
                    stmt.setString(2, fid);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(stmt, (Connection)conn);
        }
    }

    @Override
    protected String _checkAccountAsst(Context ctx, IObjectValue acctInfo, String caa) throws BOSException, EASBizException {
        AccountViewInfo accountviewInfo = (AccountViewInfo)acctInfo;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("ac");
        selector.add("acnotice");
        selector.add("caa");
        AccountViewInfo oldAcctInfo = AccountViewFactory.getLocalInstance(ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountviewInfo.getId()), selector);
        String oldCaa = null;
        if (oldAcctInfo.getCAA() != null && !StringUtils.isEmpty((String)oldAcctInfo.getCAA().getId().toString())) {
            oldCaa = oldAcctInfo.getCAA().getId().toString();
        }
        StringBuffer warnStr = new StringBuffer();
        if (accountviewInfo.getId() == null || StringUtils.isEmpty((String)accountviewInfo.getId().toString())) {
            return null;
        }
        if (caa == null && oldCaa == null) {
            return null;
        }
        if (caa != null && oldCaa != null && oldCaa.equalsIgnoreCase(caa)) {
            return null;
        }
        String ids = "'" + accountviewInfo.getId().toString() + "'";
        this.updateCaa(ctx, caa, ids);
        this.updateAC(ctx, accountviewInfo);
        warnStr.append(this.checkCompanyAuxAccount(ctx, accountviewInfo.getId().toString(), caa));
        IAccountView instance = AccountViewFactory.getLocalInstance(ctx);
        String isImportModel = (String)accountviewInfo.get("importModel");
        if ("true".equalsIgnoreCase(isImportModel) && instance.isHasDeal((IObjectPK)new ObjectUuidPK(accountviewInfo.getId()))) {
            String msg = EASResource.getString((String)this.allResource, (String)"CANNOT_CHANGEACCTBYIMPORT_WHENBIZ");
            MessageFormat mf = new MessageFormat(msg);
            String result = mf.format(new String[]{accountviewInfo.getNumber()});
            warnStr.append(result);
        }
        this.updateCaa(ctx, oldCaa, ids);
        this.updateAC(ctx, oldAcctInfo);
        return warnStr.toString();
    }

    private void updateAC(Context ctx, AccountViewInfo acctInfo) throws BOSException {
        int ac = acctInfo.isAC() ? 1 : 0;
        int acNotice = acctInfo.isACNotice() ? 1 : 0;
        String updateAccountSql = "update t_bd_accountview set fac=?,facnotice=?  where fid =? ";
        DbUtil.execute((Context)ctx, (String)updateAccountSql, (Object[])new Object[]{ac, acNotice, acctInfo.getId().toString()});
        ORMValueCacheService.getInstance().remove(ctx, acctInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(acctInfo.getId()));
    }

    @Override
    protected String _checkCompanyAuxAccount(Context ctx, String accountId, String caaId) throws BOSException, EASBizException {
        String acctCaa;
        String acctNumber;
        IRowSet rsToGetChildNeedCheckAA;
        String sqlToGetChildNeedCheckAA;
        ObjectUuidPK pkCompany;
        String result;
        MessageFormat mf;
        String msg;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("number");
        sic.add("name");
        sic.add("CAA");
        sic.add("GAA");
        sic.add("parentAA");
        sic.add("AC");
        sic.add("ACNotice");
        sic.add("parent.CAA");
        sic.add("upper.CAA");
        sic.add("CU.number");
        sic.add("companyID.number");
        AccountViewInfo accountViewInfo = AccountViewFactory.getLocalInstance(ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId), sic);
        IAsstAccount iAsstAccount = AsstAccountFactory.getLocalInstance((Context)ctx);
        StringBuffer warnStr = new StringBuffer();
        if (accountViewInfo.getUpper() != null) {
            ObjectUuidPK pkUpper;
            msg = EASResource.getString((String)this.allResource, (String)"CAANOTINCLUDEGAA");
            mf = new MessageFormat(msg);
            result = mf.format(new String[]{accountViewInfo.getNumber()});
            if (accountViewInfo.getGAA() != null && caaId == null) {
                warnStr.append(result);
            }
            if (accountViewInfo.getGAA() != null && caaId != null && !iAsstAccount.compare((IObjectPK)(pkUpper = new ObjectUuidPK(accountViewInfo.getGAA().getId())), (IObjectPK)(pkCompany = new ObjectUuidPK(caaId)))) {
                warnStr.append(result);
            }
        }
        if (accountViewInfo.getParent() != null) {
            ObjectUuidPK pkParent;
            msg = EASResource.getString((String)this.allResource, (String)"CAANOTINCLUDEPARENTAA");
            mf = new MessageFormat(msg);
            result = mf.format(new String[]{accountViewInfo.getNumber()});
            if (accountViewInfo.getParentAA() != null && caaId == null) {
                warnStr.append(result);
            }
            if (accountViewInfo.getParentAA() != null && caaId != null && !iAsstAccount.compare((IObjectPK)(pkParent = new ObjectUuidPK(accountViewInfo.getParentAA().getId())), (IObjectPK)(pkCompany = new ObjectUuidPK(caaId)))) {
                warnStr.append(result);
            }
        }
        if (caaId != null) {
            sqlToGetChildNeedCheckAA = "SELECT CHILD.FNUMBER, CHILD.FCAA FROM T_BD_ACCOUNTVIEW CHILD INNER JOIN T_BD_ACCOUNTVIEW PARENT ON CHILD.FPARENTID = PARENT.FID WHERE CHILD.FPARENTID=? order by CHILD.FNUMBER";
            rsToGetChildNeedCheckAA = DbUtil.executeQuery((Context)ctx, (String)sqlToGetChildNeedCheckAA, (Object[])new Object[]{accountViewInfo.getId().toString()});
            try {
                while (rsToGetChildNeedCheckAA.next()) {
                    acctNumber = rsToGetChildNeedCheckAA.getString("FNUMBER");
                    acctCaa = rsToGetChildNeedCheckAA.getString("FCAA");
                    if (acctCaa != null && iAsstAccount.compare((IObjectPK)new ObjectUuidPK(caaId), (IObjectPK)new ObjectUuidPK(acctCaa))) continue;
                    String msg2 = EASResource.getString((String)this.allResource, (String)"ChildNotIncludeParentAA");
                    MessageFormat mf2 = new MessageFormat(msg2);
                    String result2 = mf2.format(new String[]{accountViewInfo.getNumber(), acctNumber});
                    warnStr.append(result2);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (caaId != null) {
            sqlToGetChildNeedCheckAA = "SELECT CHILD.FNUMBER FNUMBER, CHILD.FCAA FCAA, U.FNUMBER UFNUMBER,U.FNAME_L1 UFNAME_L1,U.FNAME_L2 UFNAME_L2,U.FNAME_L3 UFNAME_L3 FROM T_BD_ACCOUNTVIEW CHILD INNER JOIN T_BD_ACCOUNTVIEW PARENT ON CHILD.FUPPERID = PARENT.FID INNER JOIN T_ORG_BASEUNIT U ON CHILD.FCompanyID=U.FID WHERE CHILD.FUPPERID=? ";
            rsToGetChildNeedCheckAA = DbUtil.executeQuery((Context)ctx, (String)sqlToGetChildNeedCheckAA, (Object[])new Object[]{accountViewInfo.getId().toString()});
            try {
                while (rsToGetChildNeedCheckAA.next()) {
                    acctNumber = rsToGetChildNeedCheckAA.getString("FNUMBER");
                    acctCaa = rsToGetChildNeedCheckAA.getString("FCAA");
                    String childCompanyNumber = rsToGetChildNeedCheckAA.getString("UFNUMBER");
                    String childCompanyName = null;
                    childCompanyName = "L1".equalsIgnoreCase(ctx.getLocale().toString()) ? rsToGetChildNeedCheckAA.getString("UFNAME_L1") : ("L3".equalsIgnoreCase(ctx.getLocale().toString()) ? rsToGetChildNeedCheckAA.getString("UFNAME_L3") : rsToGetChildNeedCheckAA.getString("UFNAME_L2"));
                    if (acctCaa != null && iAsstAccount.compare((IObjectPK)new ObjectUuidPK(caaId), (IObjectPK)new ObjectUuidPK(acctCaa))) continue;
                    String msg3 = EASResource.getString((String)this.allResource, (String)"InfeComNotIncludeAA");
                    MessageFormat mf3 = new MessageFormat(msg3);
                    String result3 = mf3.format(new String[]{childCompanyNumber, childCompanyName, acctNumber, acctCaa});
                    warnStr.append(result3);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (accountViewInfo.isAC()) {
            CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(accountViewInfo.getCompanyID().getId()));
            String msg4 = EASResource.getString((String)this.allResource, (String)"CAAMUSTASSTBUTE_Attr");
            MessageFormat mf4 = new MessageFormat(msg4);
            String result4 = mf4.format(new String[]{accountViewInfo.getNumber(), companyOrgUnitInfo.getNumber()});
            if (caaId == null) {
                warnStr.append(result4);
            } else {
                String sql = "select FasstHGAttribute from t_bd_asstacttype  a  left join T_BD_AsstActTypeDefault b  on a.fid=b.fasstacttypeid where b.FCompanyID=? and b.fisaccountcussent=1 and  a.fid in ( select fasstacttypeid from t_bd_asstactgroupdetail where \tfasstaccountid =? )";
                IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{accountViewInfo.getCompanyID().getId().toString(), caaId});
                try {
                    if (rowset == null || !rowset.next()) {
                        warnStr.append(result4);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        if (accountViewInfo.isACNotice()) {
            msg = EASResource.getString((String)this.allResource, (String)"CAAMUSTCSP");
            mf = new MessageFormat(msg);
            result = mf.format(new String[]{accountViewInfo.getNumber()});
            if (accountViewInfo.getCAA() == null || caaId == null) {
                warnStr.append(result);
            } else {
                String sql = "select FasstHGAttribute from t_bd_asstacttype where  fid in ( select fasstacttypeid from t_bd_asstactgroupdetail where \tfasstaccountid =? )";
                IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{caaId});
                boolean hasCPS = false;
                try {
                    while (rowset != null && rowset.next()) {
                        String asstHGAttribute = rowset.getString("FasstHGAttribute");
                        if (!"customer".equals(asstHGAttribute) && !"companyOrg".equals(asstHGAttribute) && !"provider".equals(asstHGAttribute)) continue;
                        hasCPS = true;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                if (!hasCPS) {
                    warnStr.append(result);
                }
            }
        }
        return warnStr.toString();
    }

    @Override
    protected List _getIntersectAssignedAccountNumber(Context ctx, List companyIdList, IObjectValue acctTblObjInfo) throws BOSException {
        AccountTableInfo acctTblInfo = (AccountTableInfo)acctTblObjInfo;
        String[] companyIdArray = new String[companyIdList.size()];
        companyIdList.toArray(companyIdArray);
        List intersectAssignedAccountNumberList = new ArrayList();
        intersectAssignedAccountNumberList = companyIdList.size() > 1000 ? this.batchAssignCompanyInfo(ctx, companyIdList, acctTblInfo) : this.getAccountNumberListByTmpArray(ctx, 0, companyIdArray.length, acctTblInfo, companyIdArray);
        return intersectAssignedAccountNumberList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List batchAssignCompanyInfo(Context ctx, List companyIdList, AccountTableInfo acctTblInfo) {
        ArrayList<String> intersectAssignedAccountNumberList;
        block12: {
            intersectAssignedAccountNumberList = new ArrayList<String>();
            ITableManagerFacade instance = null;
            Connection cn = null;
            PreparedStatement stmt = null;
            String tbl = null;
            instance = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
            tbl = instance.getTableName("ACCOUNTVIEW");
            StringBuffer createSql = new StringBuffer();
            createSql.append("create table ");
            createSql.append(tbl);
            createSql.append(" (fid varchar(44)");
            createSql.append(")");
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(createSql.toString());
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.prepareStatement("insert into " + tbl + " values(?)");
            for (Object companyId : companyIdList) {
                stmt.setString(1, companyId.toString());
                stmt.addBatch();
            }
            stmt.executeBatch();
            String exeSql = "select fnumber from t_bd_accountview where fupperid is not null and fcompanyid in (select fid from " + tbl + ") and faccounttableid = '" + acctTblInfo.getId().toString() + "' group by fnumber having count(fnumber)=" + companyIdList.size() + " order by fnumber";
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)exeSql);
            while (row.next()) {
                intersectAssignedAccountNumberList.add(row.getString(1));
            }
            try {
                instance.releaseTableName(tbl);
                SQLUtils.cleanup((Statement)stmt, (Connection)cn);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            break block12;
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        instance.releaseTableName(tbl);
                        SQLUtils.cleanup(stmt, cn);
                    }
                    catch (BOSException e2) {
                        e2.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    instance.releaseTableName(tbl);
                    SQLUtils.cleanup(stmt, cn);
                }
                catch (BOSException e3) {
                    e3.printStackTrace();
                }
            }
        }
        return intersectAssignedAccountNumberList;
    }

    private List getAccountNumberListByTmpArray(Context ctx, int srcPos, int len, AccountTableInfo acctTblInfo, String[] companyIdArray) throws BOSException {
        String[] tmpArray = new String[len + 1];
        System.arraycopy(companyIdArray, srcPos, tmpArray, 0, len);
        tmpArray[len] = acctTblInfo.getId().toString();
        return this.getAccountNumberList(ctx, tmpArray);
    }

    private List getAccountNumberList(Context ctx, String[] companyIdAndAccounttableIdArray) throws BOSException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select fnumber from t_bd_accountview where fupperid is not null and fcompanyid in(");
        for (int i = 0; i < companyIdAndAccounttableIdArray.length - 1; ++i) {
            if (i != 0) {
                sqlBuffer.append(",");
            }
            sqlBuffer.append("?");
        }
        sqlBuffer.append(") and faccounttableid = ? group by fnumber having count(fnumber)=" + (companyIdAndAccounttableIdArray.length - 1) + " order by fnumber");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])companyIdAndAccounttableIdArray);
        ArrayList<String> accountNumberList = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                accountNumberList.add(rowSet.getString("fnumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return accountNumberList;
    }

    private void removeCache(Context ctx, String sql, BOSObjectType bostype) throws BOSException {
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet != null && rowSet.size() > 0) {
            String[] pks = new String[rowSet.size()];
            int i = 0;
            try {
                while (rowSet.next()) {
                    pks[i] = rowSet.getString("fid");
                    ++i;
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            ORMValueCacheService.getInstance().removeBatch(ctx, bostype, pks);
        }
    }

    @Override
    protected IObjectCollection _getChildCompany(Context ctx, IObjectValue currentCompany, boolean isDisplayAll, String filter) throws BOSException {
        return this._getChildCompanyWithSealUp(ctx, currentCompany, isDisplayAll, filter, false);
    }

    @Override
    protected Set _getMultiOrgAccountNumSet(Context ctx, IObjectValue accountTableInfo, IObjectCollection companyColl) throws BOSException, EASBizException {
        if (companyColl == null || companyColl.size() == 0) {
            return null;
        }
        AccountTableInfo acctTableInfo = (AccountTableInfo)accountTableInfo;
        CompanyOrgUnitCollection comColl = (CompanyOrgUnitCollection)companyColl;
        StringBuffer comIds = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < companyColl.size(); ++i) {
            comIds.append("'").append(comColl.get(i).getId().toString()).append("',");
        }
        comIds.delete(comIds.length() - 1, comIds.length());
        Locale l = ctx.getLocale();
        sql.append("select fnumber, fname_").append(l.toString()).append(" from t_bd_accountview where faccounttableid = '").append(acctTableInfo.getId().toString()).append("'").append(" and fcompanyid in (").append(comIds.toString()).append(") ").append(" group by fnumber ,fname_").append(l.toString()).append(" having count(*) = ").append(comColl.size());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> numSet = new HashSet<String>();
        try {
            while (rs.next()) {
                numSet.add(rs.getString("fnumber"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return numSet;
    }

    @Override
    protected ArrayList _getMultiOrgAccountInfoList(Context ctx, FilterInfo filterInfo) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection seleColl = new SelectorItemCollection();
        seleColl.add(new SelectorItemInfo("id"));
        seleColl.add(new SelectorItemInfo("number"));
        seleColl.add(new SelectorItemInfo("name"));
        viewInfo.setSelector(seleColl);
        viewInfo.setFilter(filterInfo);
        SorterItemCollection sortColl = new SorterItemCollection();
        sortColl.add(new SorterItemInfo("number"));
        viewInfo.setSorter(sortColl);
        AccountViewCollection acctCol = AccountViewFactory.getLocalInstance(ctx).getAccountViewCollection(viewInfo);
        if (acctCol != null && acctCol.size() != 0) {
            HashMap acctNumNameMap = new HashMap();
            String acctNumName = null;
            Set<String> acctIds = null;
            for (int i = 0; i < acctCol.size(); ++i) {
                acctNumName = acctCol.get(i).getNumber().toString() + "," + acctCol.get(i).getName().toString();
                if (acctNumNameMap.get(acctNumName) != null) {
                    ((Set)acctNumNameMap.get(acctNumName)).add(acctCol.get(i).getId().toString());
                    continue;
                }
                acctIds = new HashSet<String>();
                acctIds.add(acctCol.get(i).getId().toString());
                acctNumNameMap.put(acctNumName, acctIds);
            }
            Object[] sortedKey = acctNumNameMap.keySet().toArray();
            Arrays.sort(sortedKey);
            ArrayList<AccountViewFilterInfo> acctFilterList = new ArrayList<AccountViewFilterInfo>();
            AccountViewFilterInfo acctFilterInfo = null;
            String number = null;
            String name = null;
            for (int i = 0; i < sortedKey.length; ++i) {
                String key = (String)sortedKey[i];
                number = key.split(",")[0];
                name = key.split(",")[1];
                acctIds = (Set)acctNumNameMap.get(key);
                acctFilterInfo = new AccountViewFilterInfo(acctIds, number, name);
                acctFilterList.add(acctFilterInfo);
            }
            return acctFilterList;
        }
        return null;
    }

    @Override
    protected boolean _setAsstDefaultValue(Context ctx, IObjectValue account, Map defaultVal) throws BOSException, EASBizException {
        AccountViewInfo accountViewInfo = (AccountViewInfo)account;
        String caa = accountViewInfo.getCAA().getId().toString();
        String sql = "delete from T_BD_ACCOUNTASSTDFTVALUE where faccountid= ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{accountViewInfo.getId().toString()});
        AsstActTypeCollection typeCol = new AsstActTypeCollection();
        AssistantHGInfo hgInfo = new AssistantHGInfo();
        hgInfo.setId(null);
        hgInfo.setAsstAccount(accountViewInfo.getCAA());
        for (AsstActTypeInfo asstActTypeInfo : defaultVal.keySet()) {
            String asstHGAttribute = asstActTypeInfo.getAsstHGAttribute();
            typeCol.add(asstActTypeInfo);
            if (asstActTypeInfo == null || defaultVal.get(asstActTypeInfo) == null) continue;
            hgInfo.put(asstHGAttribute, defaultVal.get(asstActTypeInfo));
        }
        if (typeCol.size() > 0) {
            hgInfo = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHG(hgInfo, caa, typeCol);
            sql = "insert into T_BD_ACCOUNTASSTDFTVALUE (FACCOUNTID,FASSTACCOUNTID,FASSGRPID) values (?,?,?)";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{accountViewInfo.getId().toString(), caa, hgInfo.getId().toString()});
        }
        return true;
    }

    @Override
    protected IObjectValue _getDefaultAssistantHgInfo(Context ctx, IObjectPK accountPK) throws BOSException, EASBizException {
        String sql = "select FASSGRPID from T_BD_ACCOUNTASSTDFTVALUE where FACCOUNTID = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{accountPK.toString()});
        AsstActGroupDetailCollection detailColl = this.getAsstActGroupDetailColl(ctx, accountPK);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        try {
            if (rowSet.next()) {
                for (int i = 0; i < detailColl.size(); ++i) {
                    AsstActTypeInfo asstActInfo = detailColl.get(i).getAsstActType();
                    String attribute = asstActInfo.getAsstHGAttribute();
                    selector.add(new SelectorItemInfo(attribute + ".id"));
                    selector.add(new SelectorItemInfo(attribute + ".number"));
                    selector.add(new SelectorItemInfo(attribute + ".name"));
                }
                String assgrpId = rowSet.getString("FASSGRPID");
                AssistantHGInfo assistantHGInfo = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(assgrpId), selector);
                return assistantHGInfo;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private AsstActGroupDetailCollection getAsstActGroupDetailColl(Context ctx, IObjectPK accountPK) throws BOSException, EASBizException {
        AccountViewInfo account = AccountViewFactory.getLocalInstance(ctx).getAccountViewInfo(accountPK);
        if (account.getCAA() == null) {
            return null;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("asstActType.id");
        evi.getSelector().add("asstActType.number");
        evi.getSelector().add("asstActType.name");
        evi.getSelector().add("asstActType.asstHGAttribute");
        evi.getSelector().add("asstActType.mappingFieldName");
        evi.getSelector().add("asstActType.defaultQueryName");
        evi.getSelector().add("asstActType.isForCompany");
        evi.getSelector().add("asstActType.defaultF7UI");
        evi.getSelector().add("asstActType.glAsstActTypeGrp.id");
        evi.getSelector().add("asstActType.isMultilevel");
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)account.getCAA().getId().toString()));
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("number"));
        AsstActGroupDetailCollection newasstcol = AsstActGroupDetailFactory.getLocalInstance((Context)ctx).getAsstActGroupDetailCollection(evi);
        return newasstcol;
    }

    @Override
    protected AsstAccountChangeInfo _getLastAsstAccountChange(Context ctx, String accountId) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String id = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("select \n");
            sql.append("    c.FID \n");
            sql.append("from T_BD_AsstAccountChange c \n");
            sql.append("join T_BD_Period p on p.FID = c.FPeriodID \n");
            sql.append("where c.FAccountID = ? \n");
            sql.append("order by p.FNumber desc \n");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, accountId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                id = rs.getString("FID");
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"SQL ERROR", (Throwable)e);
                throw new BOSException("SQL ERROR", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        if (id != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("account.id");
            selector.add("period.id");
            selector.add("period.number");
            selector.add("period.periodYear");
            selector.add("period.periodNumber");
            selector.add("period.isAdjustPeriod");
            selector.add("before.id");
            selector.add("after.id");
            selector.add("entries.id");
            selector.add("entries.asstActType.id");
            selector.add("entries.asstAct");
            return AsstAccountChangeFactory.getLocalInstance(ctx).getAsstAccountChangeInfo((IObjectPK)new ObjectUuidPK(id), selector);
        }
        return null;
    }

    @Override
    protected AsstAccountChangeInfo _getLastAsstAccountChange(Context ctx, Set accountIds) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String id = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("select \n");
            sql.append("    c.FID, p.FNumber \n");
            sql.append("from T_BD_AsstAccountChange c \n");
            sql.append("join T_BD_Period p on p.FID = c.FPeriodID \n");
            sql.append("where c.FAccountID = ? \n");
            sql.append("order by p.FNumber desc \n");
            int number = 0;
            for (Object accountId : accountIds) {
                int num;
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, (String)accountId);
                rs = pstmt.executeQuery();
                if (rs.next() && (num = rs.getInt("FNumber")) > number) {
                    number = num;
                    id = rs.getString("FID");
                }
                rs.close();
                pstmt.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)"SQL ERROR", (Throwable)e);
            throw new BOSException("SQL ERROR", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
        }
        if (id != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("account.id");
            selector.add("period.id");
            selector.add("period.number");
            selector.add("period.periodYear");
            selector.add("period.periodNumber");
            selector.add("period.isAdjustPeriod");
            selector.add("before.id");
            selector.add("after.id");
            selector.add("entries.id");
            selector.add("entries.asstActType.id");
            selector.add("entries.asstAct");
            return AsstAccountChangeFactory.getLocalInstance(ctx).getAsstAccountChangeInfo((IObjectPK)new ObjectUuidPK(id), selector);
        }
        return null;
    }

    private AsstAccountChangeInfo buildAsstAccountChange(Context ctx, AccountViewInfo account, PeriodInfo period, String oldCaa, String newCaa, Map defaultVal) throws BOSException, EASBizException {
        AsstAccountInfo asstAccount;
        AsstAccountChangeInfo info = new AsstAccountChangeInfo();
        info.setAccount(account);
        if (oldCaa != null) {
            asstAccount = new AsstAccountInfo();
            asstAccount.setId(BOSUuid.read((String)oldCaa));
            info.setBefore(asstAccount);
        }
        if (newCaa != null) {
            asstAccount = new AsstAccountInfo();
            asstAccount.setId(BOSUuid.read((String)newCaa));
            info.setAfter(asstAccount);
        }
        info.setPeriod(period);
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        info.setCreator(user);
        info.setLastUpdateUser(user);
        Timestamp current = new Timestamp(System.currentTimeMillis());
        info.setCreateTime(current);
        info.setLastUpdateTime(current);
        if (defaultVal != null && defaultVal.size() > 0) {
            AsstAccountChangeEntryCollection entries = info.getEntries();
            Set keyset = defaultVal.keySet();
            for (AsstActTypeInfo aat : keyset) {
                AsstAccountChangeEntryInfo entry = new AsstAccountChangeEntryInfo();
                entries.add(entry);
                entry.setParent(info);
                entry.setAsstActType(aat);
                Object obj = defaultVal.get(aat);
                String asstAct = null;
                if (obj != null) {
                    if (obj instanceof IObjectValue) {
                        asstAct = ((IObjectValue)obj).get("id").toString();
                    } else if (obj instanceof String) {
                        asstAct = (String)obj;
                    } else if (obj instanceof BOSUuid) {
                        asstAct = ((BOSUuid)obj).toString();
                    }
                }
                entry.setAsstAct(asstAct);
            }
        }
        return info;
    }

    private void fixAsstAccountChange(Context ctx, AsstAccountChangeInfo change, AsstAccountChangeInfo last) throws BOSException {
        change.setBefore(last.getBefore());
        if (change.getAfter() == null) {
            return;
        }
        HashMap<String, AsstAccountChangeEntryInfo> entries = new HashMap<String, AsstAccountChangeEntryInfo>();
        for (int i = 0; i < change.getEntries().size(); ++i) {
            AsstAccountChangeEntryInfo entry = change.getEntries().get(i);
            if (entry.getAsstActType() == null) continue;
            entries.put(entry.getAsstActType().getId().toString(), entry);
        }
        HashMap<String, String> asstActs = new HashMap<String, String>();
        for (int i = 0; i < last.getEntries().size(); ++i) {
            AsstAccountChangeEntryInfo entry = last.getEntries().get(i);
            if (entry.getAsstActType() == null) continue;
            asstActs.put(entry.getAsstActType().getId().toString(), entry.getAsstAct());
        }
        Set<Object> oldIds = new HashSet();
        if (change.getBefore() != null) {
            oldIds = this.getAsstActTypeIds(ctx, change.getBefore().getId().toString());
        }
        for (String id : entries.keySet()) {
            AsstAccountChangeEntryInfo entry;
            if (oldIds.contains(id) || (entry = (AsstAccountChangeEntryInfo)entries.get(id)).getAsstAct() != null) continue;
            entry.setAsstAct((String)asstActs.get(id));
        }
    }

    private Set<String> getAsstActTypeIds(Context ctx, String asstAccountId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select aat.FID \n");
        sql.append("FROM T_BD_AsstActGroupDetail gd \n");
        sql.append("join T_BD_AsstActType aat on aat.FID = gd.FASSTACTTYPEID \n");
        sql.append("where gd.FASSTACCOUNTID = ? \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{asstAccountId});
        HashSet<String> asstActTypeIds = new HashSet<String>();
        try {
            while (rs.next()) {
                asstActTypeIds.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return asstActTypeIds;
    }

    @Override
    protected String _getCAAIdByPeriod(Context ctx, String accountId, String periodId) throws BOSException, EASBizException {
        HashSet<String> accountIds = new HashSet<String>();
        accountIds.add(accountId);
        Map caas = this._getCAAIdsByPeriod(ctx, accountIds, periodId);
        return (String)caas.get(accountId);
    }

    @Override
    protected String _getCAAIdByPeriod(Context ctx, String accountId, int period) throws BOSException, EASBizException {
        HashSet<String> accountIds = new HashSet<String>();
        accountIds.add(accountId);
        Map caas = this._getCAAIdsByPeriod(ctx, accountIds, period);
        return (String)caas.get(accountId);
    }

    @Override
    protected Map _getCAAIdsByPeriod(Context ctx, Set accountIds, String periodId) throws BOSException, EASBizException {
        if (accountIds.size() == 0) {
            return new HashMap();
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId), selector);
        return this._getCAAIdsByPeriod(ctx, accountIds, period.getNumber());
    }

    @Override
    protected Map _getCAAIdsByPeriod(Context ctx, Set accountIds, int period) throws BOSException, EASBizException {
        Iterator iterator;
        if (accountIds.size() == 0) {
            return new HashMap();
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("select \n");
            sql.append("    c.FAccountID, c.FBeforeID, c.FAfterID, p.FNumber \n");
            sql.append("from T_BD_AsstAccountChange c \n");
            sql.append("join T_BD_Period p on p.FID = c.FPeriodID \n");
            if (accountIds.size() == 1) {
                sql.append("where c.FAccountID = ? \n");
            } else {
                sql.append("where c.FAccountID in ( \n");
                for (Object accountId : accountIds) {
                    sql.append("'" + accountId + "',");
                }
                sql.deleteCharAt(sql.length() - 1);
                sql.append(") \n");
            }
            sql.append("    and p.FNumber >= ? \n");
            sql.append("order by c.FAccountID, p.FNumber asc \n");
            int index = 1;
            pstmt = conn.prepareStatement(sql.toString());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next().toString());
            }
            pstmt.setInt(index++, period);
            rs = pstmt.executeQuery();
            HashMap<String, String> caas = new HashMap<String, String>();
            while (rs.next()) {
                String FAccountID = rs.getString("FAccountID");
                if (caas.containsKey(FAccountID)) continue;
                String FBeforeID = rs.getString("FBeforeID");
                String string = rs.getString("FAfterID");
                int FPeriod = rs.getInt("FNumber");
                String asstAccountId = period == FPeriod ? string : (period < FPeriod ? FBeforeID : string);
                caas.put(FAccountID, asstAccountId);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
            HashSet<String> noChangeIds = new HashSet<String>();
            for (Object e : accountIds) {
                String accountId = (String)e;
                if (caas.containsKey(accountId)) continue;
                noChangeIds.add(accountId);
            }
            if (noChangeIds.size() > 0) {
                sql.setLength(0);
                sql.append("select \n");
                sql.append("    FID, FCAA \n");
                sql.append("from T_BD_AccountView \n");
                if (noChangeIds.size() == 1) {
                    sql.append("where FID = ? \n");
                } else {
                    sql.append("where FID in ( \n");
                    for (Object e : noChangeIds) {
                        sql.append("'" + e + "',");
                    }
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append(") \n");
                }
                index = 1;
                pstmt = conn.prepareStatement(sql.toString());
                if (noChangeIds.size() == 1) {
                    pstmt.setString(index++, ((String)noChangeIds.iterator().next()).toString());
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    caas.put(rs.getString("FID"), rs.getString("FCAA"));
                }
            }
            iterator = caas;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"SQL ERROR", (Throwable)e);
                throw new BOSException("SQL ERROR", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return iterator;
    }

    @Override
    protected Map _getCAAsByPeriod(Context ctx, Set accountIds, String periodId) throws BOSException, EASBizException {
        Map caaIds = this._getCAAIdsByPeriod(ctx, accountIds, periodId);
        return this.getCAAs(ctx, accountIds, caaIds, null);
    }

    @Override
    protected Map _getCAAsByPeriod(Context ctx, Set accountIds, int period) throws BOSException, EASBizException {
        Map caaIds = this._getCAAIdsByPeriod(ctx, accountIds, period);
        return this.getCAAs(ctx, accountIds, caaIds, null);
    }

    @Override
    protected Map _getCAAsByPeriod(Context ctx, Set accountIds, String periodId, SelectorItemCollection selector) throws BOSException, EASBizException {
        Map caaIds = this._getCAAIdsByPeriod(ctx, accountIds, periodId);
        return this.getCAAs(ctx, accountIds, caaIds, selector);
    }

    private Map getCAAs(Context ctx, Set accountIds, Map caaIds, SelectorItemCollection selector) throws BOSException, EASBizException {
        HashMap<String, AsstAccountInfo> caaInfos = new HashMap<String, AsstAccountInfo>();
        HashSet<String> asstAccountIds = new HashSet<String>();
        for (Object asstAccountId : caaIds.values()) {
            if (asstAccountId == null) continue;
            asstAccountIds.add((String)asstAccountId);
        }
        HashMap<String, AsstAccountInfo> asstAccounts = new HashMap<String, AsstAccountInfo>();
        if (asstAccountIds.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            if (selector == null) {
                selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("number"));
                selector.add(new SelectorItemInfo("name"));
                selector.add(new SelectorItemInfo("isQty"));
                selector.add(new SelectorItemInfo("count"));
                selector.add(new SelectorItemInfo("measureUnit.id"));
                selector.add(new SelectorItemInfo("measureUnit.number"));
                selector.add(new SelectorItemInfo("measureUnit.name"));
                selector.add(new SelectorItemInfo("measureUnit.coefficient"));
                selector.add(new SelectorItemInfo("measureUnitGroup.id"));
                selector.add(new SelectorItemInfo("measureUnitGroup.defaultUnit.id"));
                selector.add(new SelectorItemInfo("measureUnitGroup.defaultUnit.number"));
                selector.add(new SelectorItemInfo("measureUnitGroup.defaultUnit.name"));
                selector.add(new SelectorItemInfo("measureUnitGroup.defaultUnit.coefficient"));
            }
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", asstAccountIds, CompareType.INCLUDE));
            view.setFilter(filter);
            AsstAccountCollection coll = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstAccountCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                asstAccounts.put(coll.get(i).getId().toString(), coll.get(i));
            }
        }
        for (Object object : accountIds) {
            String accountId = (String)object;
            AsstAccountInfo asstAccount = null;
            String asstAccountId = (String)caaIds.get(accountId);
            if (asstAccountId != null) {
                asstAccount = (AsstAccountInfo)asstAccounts.get(asstAccountId);
            }
            caaInfos.put(accountId, asstAccount);
        }
        return caaInfos;
    }

    @Override
    protected Set _getCAAIds(Context ctx, String accountId) throws BOSException, EASBizException {
        return this._getCAAIdsByPeriodRange(ctx, accountId, -1, -1);
    }

    @Override
    protected Map _getCAAIds(Context ctx, Set accountIds) throws BOSException, EASBizException {
        return this._getCAAIdsByPeriodRange(ctx, accountIds, -1, -1);
    }

    @Override
    protected Set _getCAAIdsByPeriodRange(Context ctx, String accountId, int startPeriod, int endPeriod) throws BOSException, EASBizException {
        HashSet<String> accountIds = new HashSet<String>();
        accountIds.add(accountId);
        Map changeIds = this._getCAAIdsByPeriodRange(ctx, accountIds, startPeriod, endPeriod);
        return (Set)changeIds.get(accountId);
    }

    @Override
    protected Map _getCAAIdsByPeriodRange(Context ctx, Set accountIds, int startPeriod, int endPeriod) throws BOSException, EASBizException {
        HashMap hashMap;
        HashMap idss = new HashMap();
        if (accountIds.size() <= 0) {
            return idss;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("select \n");
            sql.append("    c.FAccountID, c.FBeforeID, c.FAfterID, p.FNumber \n");
            sql.append("from T_BD_AsstAccountChange c \n");
            sql.append("join T_BD_Period p on p.FID = c.FPeriodID \n");
            if (accountIds.size() == 1) {
                sql.append("where c.FAccountID = ? \n");
            } else {
                sql.append("where c.FAccountID in ( \n");
                for (Object accountId : accountIds) {
                    sql.append("'" + accountId + "',");
                }
                sql.deleteCharAt(sql.length() - 1);
                sql.append(") \n");
            }
            if (startPeriod > 0) {
                sql.append("    and p.FNumber >= ? \n");
            }
            if (endPeriod > 0) {
                sql.append("order by c.FAccountID, p.FNumber asc \n");
            }
            int index = 1;
            pstmt = conn.prepareStatement(sql.toString());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next().toString());
            }
            if (startPeriod > 0) {
                pstmt.setInt(index++, startPeriod);
            }
            rs = pstmt.executeQuery();
            HashSet<String> changeIds = new HashSet<String>();
            while (rs.next()) {
                String accountId = rs.getString("FAccountID");
                Iterator beforeId = rs.getString("FBeforeID");
                String string = rs.getString("FAfterID");
                int number = rs.getInt("FNumber");
                HashSet<Object> ids = (HashSet<Object>)idss.get(accountId);
                if (ids == null) {
                    ids = new HashSet<Object>();
                    idss.put(accountId, ids);
                }
                if (endPeriod > 0) {
                    if (number <= endPeriod) {
                        if (beforeId != null) {
                            ids.add(beforeId);
                        }
                        if (string != null) {
                            ids.add(string);
                        }
                        changeIds.add(accountId);
                        continue;
                    }
                    if (changeIds.contains(accountId)) continue;
                    if (beforeId != null) {
                        ids.add(beforeId);
                    }
                    changeIds.add(accountId);
                    continue;
                }
                if (beforeId != null) {
                    ids.add(beforeId);
                }
                if (string != null) {
                    ids.add(string);
                }
                changeIds.add(accountId);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
            HashSet<String> noChangeIds = new HashSet<String>();
            for (Object e : accountIds) {
                String accountId = (String)e;
                if (changeIds.contains(accountId)) continue;
                noChangeIds.add(accountId);
            }
            if (noChangeIds.size() > 0) {
                sql.setLength(0);
                sql.append("select \n");
                sql.append("    FID, FCAA \n");
                sql.append("from T_BD_AccountView \n");
                if (noChangeIds.size() == 1) {
                    sql.append("where FID = ? \n");
                } else {
                    sql.append("where FID in ( \n");
                    for (Object e : noChangeIds) {
                        sql.append("'" + e + "',");
                    }
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append(") \n");
                }
                index = 1;
                pstmt = conn.prepareStatement(sql.toString());
                if (noChangeIds.size() == 1) {
                    pstmt.setString(index++, ((String)noChangeIds.iterator().next()).toString());
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    HashSet<String> ids = new HashSet<String>();
                    String string = rs.getString("FCAA");
                    if (string != null) {
                        ids.add(string);
                    }
                    idss.put(rs.getString("FID"), ids);
                }
            }
            hashMap = idss;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"SQL ERROR", (Throwable)e);
                throw new BOSException("SQL ERROR", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return hashMap;
    }

    @Override
    protected String _batchChangeAsst(Context ctx, List changeList) throws BOSException, EASBizException {
        if (changeList.size() < 1) {
            return "SUCCESS";
        }
        AccountViewInfo accInfo = ((AsstChangeInfo)changeList.get(0)).getAccountView();
        StringBuilder detailLog = new StringBuilder();
        detailLog.append(ResourceBase.getString((String)this.allResource, (String)"changeAsstAccount", (Locale)ctx.getLocale()) + "\u3010").append(accInfo.getNumber() + ":" + accInfo.getName() + "\u3011\n").append(ResourceBase.getString((String)this.allResource, (String)"chooseCompany", (Locale)ctx.getLocale()) + "\u3010");
        for (int i = 0; i < changeList.size(); ++i) {
            CompanyOrgUnitInfo comInfo = ((AsstChangeInfo)changeList.get(i)).getAccountView().getCompanyID();
            detailLog.append(comInfo.getNumber() + ":" + comInfo.getName() + ";");
        }
        detailLog.append("\u3011");
        IObjectPK logPK = LogUtil.beginLogWithDescription((Context)ctx, (String)"asstBatchChange", (BOSObjectType)new BOSObjectType("9DA99826"), null, (String)detailLog.toString(), (String)ResourceBase.getString((String)this.allResource, (String)"asstBatchChange", (Locale)ctx.getLocale()));
        for (int i = 0; i < changeList.size(); ++i) {
            AsstChangeInfo changeInfo = (AsstChangeInfo)changeList.get(i);
            this.updateCaa(ctx, changeInfo.getNewAsstAccount(), "'" + changeInfo.getAccountView().getId().toString() + "'");
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < changeList.size(); ++i) {
            AsstChangeInfo changeInfo = (AsstChangeInfo)changeList.get(i);
            if (changeInfo.getAccountView() == null || changeInfo.getAccountView().getId() == null) continue;
            AsstAccountInfo oldCaa = changeInfo.getAccountView().getCAA();
            String warn = this._changeAsst(ctx, changeInfo.getAccountView(), oldCaa == null ? null : oldCaa.getId().toString(), changeInfo.getNewAsstAccount(), changeInfo.getDefaultValue(), changeInfo.getNewEffectiveTime());
            if (!StringUtils.isEmpty((String)warn)) {
                throw new BOSException(warn);
            }
            idList.add(changeInfo.getAccountView().getId().toString());
        }
        this.updateLastUpdateTime(ctx, idList);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return "SUCCESS";
    }

    @Override
    protected Map _findAsstActByCompany(Context ctx, Map asstActTypeMap, List companyIds) throws BOSException, EASBizException {
        try {
            Class<?> processClass = Class.forName("com.kingdee.eas.fi.gl.app.AsstActFinder");
            Object finder = processClass.newInstance();
            Method method = processClass.getMethod("findAsstActByIds", Context.class, AsstActTypeInfo.class, Set.class, CompanyOrgUnitInfo.class, String.class, String.class);
            HashMap map = new HashMap(companyIds.size());
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < companyIds.size(); ++i) {
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("where id='" + companyIds.get(i) + "'");
                HashMap inner = new HashMap();
                for (AsstActTypeInfo asstActType : asstActTypeMap.keySet()) {
                    String value = (String)asstActTypeMap.get(asstActType);
                    set.add(value);
                    Map result = (Map)method.invoke(finder, ctx, asstActType, set, company, null, null);
                    inner.put(asstActType.getId().toString(), result.get(value));
                    set.clear();
                }
                map.put(companyIds.get(i).toString(), inner);
            }
            return map;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _batchSyncInferiorProperties(Context ctx, String srcAccountID, String prop, List orgList) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("number");
        selectors.add("accountTableID.id");
        selectors.add(prop);
        IAccountView instance = AccountViewFactory.getLocalInstance(ctx);
        AccountViewInfo info = instance.getAccountViewInfo((IObjectPK)new ObjectUuidPK(srcAccountID), selectors);
        String updateField = null;
        Object updateValue = null;
        if ("borrowerMainCashFlowItem".equals(prop)) {
            updateField = "FBorrowerMainCashFlowItemID";
            updateValue = info.getBorrowerMainCashFlowItem() == null ? null : info.getBorrowerMainCashFlowItem().getId().toString();
        } else if ("borrowerAttCashFlowItem".equals(prop)) {
            updateField = "FBorrowerAttCashFlowItemID";
            updateValue = info.getBorrowerAttCashFlowItem() == null ? null : info.getBorrowerAttCashFlowItem().getId().toString();
        } else if ("lenderMainCashFlowItem".equals(prop)) {
            updateField = "FLenderMainCashFlowItemID";
            updateValue = info.getLenderMainCashFlowItem() == null ? null : info.getLenderMainCashFlowItem().getId().toString();
        } else if ("lenderAttCashFlowItem".equals(prop)) {
            updateField = "FLenderAttCashFlowItemID";
            updateValue = info.getLenderAttCashFlowItem() == null ? null : info.getLenderAttCashFlowItem().getId().toString();
        } else if ("helpCode".equals(prop)) {
            updateField = "FHelpCode";
            updateValue = info.getHelpCode();
        } else if ("isAllowCA".equals(prop)) {
            updateField = "FIsAllowCA";
            updateValue = info.isIsAllowCA();
        } else {
            throw new BOSException("not supported prop " + prop);
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if ("isAllowCA".equals(prop)) {
            StringBuilder sb = new StringBuilder();
            sb.append("update t_bd_accountview set " + updateField + "= ? ,FIsUpperAllowCA = ?");
            sb.append(",flastupdateuserid = ? , flastupdatetime  = getdate()");
            sb.append(" where FAccountTableID =? and FNumber =? and FCompanyID =?");
            ArrayList<Object[]> params = new ArrayList<Object[]>(orgList.size());
            for (int i = 0; i < orgList.size(); ++i) {
                params.add(new Object[]{updateValue, updateValue, userId, info.getAccountTableID().getId().toString(), info.getNumber(), orgList.get(i)});
            }
            DbUtil.executeBatch((Context)ctx, (String)sb.toString(), params);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("update t_bd_accountview set " + updateField + "= ?");
            sb.append(",flastupdateuserid = ? , flastupdatetime  = getdate()");
            sb.append(" where FAccountTableID =? and FNumber =? and FCompanyID =?");
            ArrayList<Object[]> params = new ArrayList<Object[]>(orgList.size());
            for (int i = 0; i < orgList.size(); ++i) {
                params.add(new Object[]{updateValue, userId, info.getAccountTableID().getId().toString(), info.getNumber(), orgList.get(i)});
            }
            DbUtil.executeBatch((Context)ctx, (String)sb.toString(), params);
        }
    }

    @Override
    protected IObjectCollection _getChildCompanyWithSealUp(Context ctx, IObjectValue currentCompany, boolean isDisplayAll, String filter, boolean isDisplaySealUp) throws BOSException {
        CompanyOrgUnitInfo currCompany = (CompanyOrgUnitInfo)currentCompany;
        StringBuffer sql = new StringBuffer();
        String rootId = currCompany.getId().toString();
        String longNumber = currCompany.getLongNumber();
        String longNumberSub = longNumber + "!%";
        Locale l = ctx.getLocale();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("select fid id,fnumber number,flongnumber longnumber,fparentid parentid,fcontrolunitid cu,faccounttableid accttable,fname_").append(l.toString()).append(" name,fisbizunit isbizunit,flevel levl,fisassistantorg  isassistantorg from t_org_company where 1=1 ");
        if (!isDisplaySealUp) {
            sql.append(" and fisSealUp = ? ");
            params.add(0);
        }
        if (isDisplayAll) {
            sql.append(" and flongnumber like ? ");
            params.add(longNumberSub);
        } else {
            sql.append(" and fparentid=? ");
            params.add(rootId);
        }
        if (!StringUtils.isEmpty((String)filter)) {
            sql.append(filter);
        }
        sql.append(" order by flongnumber asc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        CompanyOrgUnitCollection childCompanyCol = new CompanyOrgUnitCollection();
        try {
            AccountTableInfo acctTableInfo = new AccountTableInfo();
            while (rs.next()) {
                String cuId;
                String acctTableId;
                CompanyOrgUnitInfo child = new CompanyOrgUnitInfo();
                child.setId(BOSUuid.read((String)rs.getString("id")));
                child.setName(rs.getString("name"));
                child.setNumber(rs.getString("number"));
                child.setLongNumber(rs.getString("longnumber"));
                child.setIsBizUnit(rs.getBoolean("isbizunit"));
                child.setLevel(rs.getInt("levl"));
                child.setIsAssistantOrg(rs.getBoolean("isassistantorg"));
                String parentId = rs.getString("parentid");
                if (!StringUtils.isEmpty((String)parentId)) {
                    CompanyOrgUnitInfo parent = new CompanyOrgUnitInfo();
                    parent.setId(BOSUuid.read((String)parentId));
                    child.setParent(parent);
                }
                if (!StringUtils.isEmpty((String)(acctTableId = rs.getString("accttable")))) {
                    acctTableInfo.setId(BOSUuid.read((String)acctTableId));
                    child.setAccountTable(acctTableInfo);
                }
                if (!StringUtils.isEmpty((String)(cuId = rs.getString("cu")))) {
                    CtrlUnitInfo cu = new CtrlUnitInfo();
                    cu.setId(BOSUuid.read((String)cuId));
                    child.setCU(cu);
                }
                childCompanyCol.add(child);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return childCompanyCol;
    }
}

