/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountUserLevelCollection;
import com.kingdee.eas.basedata.master.account.AccountUserLevelInfo;
import com.kingdee.eas.basedata.master.account.AccountUtils;
import com.kingdee.eas.basedata.master.account.Account_ControlCollection;
import com.kingdee.eas.basedata.master.account.Account_ControlFactory;
import com.kingdee.eas.basedata.master.account.Account_ControlInfo;
import com.kingdee.eas.basedata.master.account.IAccount_Control;
import com.kingdee.eas.basedata.master.account.app.AbstractAccountTableControllerBean;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.RowSet;

public class AccountTableControllerBean
extends AbstractAccountTableControllerBean {
    private static final String EAS_MODE_NUM = "G000";

    private void checkTableNumByEASGlobalModeParam(Context ctx) throws BOSException, EASBizException {
        IObjectPK[] pks;
        if (AccountUtils.getEASModeValue(ctx) == 0 && (pks = this._getPKList(ctx)) != null && pks.length > 0) {
            throw new AccountException(AccountException.TABLE_NOT_UNIQUE);
        }
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AccountTableInfo Info = null;
        Info = (AccountTableInfo)model;
        if (!this.isCUBDAllowAddnew(ctx, Info)) {
            throw new AccountException(AccountException.CUBD_CANNOT_ADDNEWACCOUNTTABLE);
        }
        ((ObjectBaseInfo)model).setCU(AccountTools.getCurrentCU(ctx));
        if (Info.getCompany() == null) {
            Info.setCompany(AccountTools.getCurrentCompany(ctx));
        }
        super._checkNameBlank(ctx, (IObjectValue)Info);
        super._checkNumberBlank(ctx, (IObjectValue)Info);
        super._checkNameDup(ctx, (IObjectValue)Info);
        super._checkNumberDup(ctx, (IObjectValue)Info);
        this._checkSeparatorAndLevel(Info);
        this.checkUserLevelsValid(Info);
        super._addnew(ctx, pk, (IObjectValue)Info);
        this.setAcctControlInfo(Info, ctx);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AccountTableInfo Info = null;
        Info = (AccountTableInfo)model;
        if (!this.isCUBDAllowAddnew(ctx, Info)) {
            throw new AccountException(AccountException.CUBD_CANNOT_ADDNEWACCOUNTTABLE);
        }
        ((ObjectBaseInfo)model).setCU(AccountTools.getCurrentCU(ctx));
        if (Info.getCompany() == null) {
            Info.setCompany(AccountTools.getCurrentCompany(ctx));
        }
        super._checkNameBlank(ctx, (IObjectValue)Info);
        super._checkNumberBlank(ctx, (IObjectValue)Info);
        super._checkNameDup(ctx, (IObjectValue)Info);
        super._checkNumberDup(ctx, (IObjectValue)Info);
        this._checkSeparatorAndLevel(Info);
        this.checkUserLevelsValid(Info);
        IObjectPK pk = null;
        pk = super._addnew(ctx, (IObjectValue)Info);
        this.setAcctControlInfo(Info, ctx);
        return pk;
    }

    private void setAcctControlInfo(AccountTableInfo info, Context ctx) throws EASBizException, BOSException {
        Account_ControlInfo acctCtrlInfo = new Account_ControlInfo();
        acctCtrlInfo.setAccountTableID(info);
        acctCtrlInfo.setSrcCu(null);
        acctCtrlInfo.setDestCu(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        acctCtrlInfo.setSrcCompany(null);
        acctCtrlInfo.setDestCompany(info.getCompany());
        acctCtrlInfo.setIsDefaultForRefer(false);
        IAccount_Control acctCtrl = Account_ControlFactory.getLocalInstance(ctx);
        acctCtrl.addnew((CoreBaseInfo)acctCtrlInfo);
        acctCtrlInfo.setId(null);
        acctCtrlInfo.setIsDefaultForRefer(true);
        acctCtrl.addnew((CoreBaseInfo)acctCtrlInfo);
    }

    private void checkTableCanAddedByCompany(Context ctx) throws AccountException {
        CompanyOrgUnitInfo currentCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        boolean canAddTable = true;
        if (!canAddTable) {
            throw new AccountException(AccountException.CURRENTCUCANNOTADDTABLE);
        }
    }

    private void checkTableCanAddedByCU(Context ctx) throws AccountException {
        CtrlUnitInfo currentCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        boolean canAddTable = true;
        if (!canAddTable) {
            throw new AccountException(AccountException.CURRENTCUCANNOTADDTABLE);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AccountTableInfo Info = null;
        Info = (AccountTableInfo)model;
        if (!this.isCUBDAllowEdit(ctx, Info)) {
            throw new AccountException(AccountException.CUBD_CANNOT_EDITACCOUNTTABLE);
        }
        AccountTableInfo oldModel = this.getAccountTableInfo(ctx, pk);
        ((ObjectBaseInfo)model).setCU(AccountTools.getCurrentCU(ctx));
        if (Info.getCompany() == null) {
            Info.setCompany(AccountTools.getCurrentCompany(ctx));
        }
        super._checkNameBlank(ctx, (IObjectValue)Info);
        super._checkNumberBlank(ctx, (IObjectValue)Info);
        super._checkNameDup(ctx, (IObjectValue)Info);
        super._checkNumberDup(ctx, (IObjectValue)Info);
        this._checkSeparatorAndLevel(Info);
        this.checkUserLevelsValid(Info);
        if (this._usedByAccountView(ctx, pk)) {
            if (!oldModel.getSeparator().equals(Info.getSeparator())) {
                throw new AccountException(AccountException.USEDBYACCOUNTVIEW);
            }
            if (oldModel.isIsUserLevel()) {
                this.checkUserLevelsChangeIsValid(ctx, Info, oldModel);
            }
        }
        super._update(ctx, pk, (IObjectValue)Info);
    }

    private void checkUserLevelsValid(AccountTableInfo newTable) throws AccountException {
        AccountUserLevelCollection newLevels = newTable.getUserLevel();
        for (int i = 0; i < newLevels.size(); ++i) {
            AccountUserLevelInfo newLevel = newLevels.get(i);
            if (newLevel.getLevel() >= 1 && newLevel.getLength() >= 1) continue;
            throw new AccountException(AccountException.TABLE_ADDNEW_LEVELS_INVALID);
        }
    }

    private void checkUserLevelsChangeIsValid(Context ctx, AccountTableInfo newTable, AccountTableInfo oldTable) throws AccountException, EASBizException, BOSException {
        AccountUserLevelCollection oldLevels = oldTable.getUserLevel();
        AccountUserLevelCollection newLevels = newTable.getUserLevel();
        if (newLevels.size() < oldLevels.size() && newLevels.size() < this._getMaxAccoutLevel(ctx, (IObjectPK)new ObjectUuidPK(oldTable.getId()))) {
            throw new AccountException(AccountException.TABLE_USED_NOT_ALLOW_MODIFY_ORIGINAL_LEVELS);
        }
        int oldSize = oldLevels.size();
        for (int i = 0; i < newLevels.size(); ++i) {
            AccountUserLevelInfo newLevel = AccountTools.getAccountUserLevelInfoByLevel(i + 1, newLevels);
            if (i < oldSize) {
                AccountUserLevelInfo oldLevel = AccountTools.getAccountUserLevelInfoByLevel(i + 1, oldLevels);
                if (newLevel.getAccountTable() != null && newLevel.getAccountTable().getId().toString().equals(oldTable.getId().toString()) && newLevel.getLevel() == oldLevel.getLevel() && newLevel.getLength() == oldLevel.getLength() || !this.isLevelRef(ctx, oldLevel)) continue;
                throw new AccountException(AccountException.TABLE_USED_NOT_ALLOW_MODIFY_ORIGINAL_LEVELS);
            }
            if (newLevel.getLevel() >= 1 && newLevel.getLength() >= 1) continue;
            throw new AccountException(AccountException.TABLE_ADDNEW_LEVELS_INVALID);
        }
    }

    private boolean isLevelRef(Context ctx, AccountUserLevelInfo levelInfo) throws BOSException {
        if (levelInfo == null) {
            return false;
        }
        if (levelInfo.getAccountTable() != null && levelInfo.getAccountTable().getId() != null) {
            String accountTableId = levelInfo.getAccountTable().getId().toString();
            String sql = "select fid from t_bd_accountview where faccounttableid =? and flevel =?";
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{accountTableId, new Integer(levelInfo.getLevel())});
                if (rowSet != null && rowSet.next()) {
                    return true;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return false;
    }

    protected void _checkSeparatorAndLevel(AccountTableInfo model) throws BOSException, EASBizException {
        if (!model.isIsUseSeparator() && !model.isIsUserLevel()) {
            throw new AccountException(AccountException.MUSTHASONECHECKED);
        }
        if (model.isIsUserLevel() && model.getUserLevel().size() < 1) {
            throw new AccountException(AccountException.MUSTHASONEUSERLEVEL);
        }
    }

    @Override
    protected boolean _usedByAccountView(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            String sql = "SELECT TOP 1 1 FROM T_BD_AccountView WHERE FAccountTableID=?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
            try {
                if (rs.next()) {
                    return true;
                }
            }
            catch (SQLException err) {
                throw new BOSException((Throwable)err);
            }
        }
        return false;
    }

    @Override
    protected void _canControlGroup(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AccountTableInfo accountTable = this.getAccountTableInfo(ctx, pk);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM T_BD_AccountView WHERE FAccountTableID='");
        sql.append(pk.toString());
        sql.append("'");
        RowSet rowSet = this._getRowSet(ctx, sql.toString());
        try {
            for (int i = 0; i < rowSet.getMaxRows(); ++i) {
                if (!rowSet.next()) continue;
            }
        }
        catch (SQLException err) {
            throw new BOSException((Throwable)err);
        }
    }

    protected void _canControlGroup2(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AccountTableInfo accountTable = this.getAccountTableInfo(ctx, pk);
        String sql = "SELECT * FROM T_BD_AccountView WHERE FAccountTableID=?'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        try {
            for (int i = 0; i < rowSet.getMaxRows(); ++i) {
                if (!rowSet.next()) continue;
            }
        }
        catch (SQLException err) {
            throw new BOSException((Throwable)err);
        }
    }

    protected RowSet _getRowSet(Context ctx, String sql) throws BOSException, EASBizException {
        RowSet rowSet;
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            rowSet = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql.toString());
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return rowSet;
    }

    @Override
    protected int _getMaxAccoutLevel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        int maxLevel = -1;
        if (pk != null) {
            String sql = "SELECT MAX(FLevel) AS maxLevel FROM T_BD_AccountView WHERE FAccountTableID=?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
            try {
                if (rs.next()) {
                    maxLevel = rs.getInt("maxLevel");
                }
            }
            catch (SQLException err) {
                throw new BOSException((Throwable)err);
            }
        }
        return maxLevel;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        Account_ControlInfo acctCtrlInfo;
        AccountTableInfo accountTableInfo = (AccountTableInfo)AccountTableFactory.getLocalInstance(ctx).getValue(pk);
        String methodName = "";
        IObjectPK instancePK = pk;
        BOSObjectType bizObjType = accountTableInfo.getBOSType();
        String instanceDetail = accountTableInfo.getNumber() + "  " + accountTableInfo.getName();
        String logItemName = "bd_account_accountTable_delete";
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)bizObjType, (IObjectPK)instancePK, (String)instanceDetail, (String)logItemName);
        if (!this.isCUBDAllowDelete(ctx, accountTableInfo)) {
            throw new AccountException(AccountException.CUBD_CANNOT_DELETEACCOUNTTABLE);
        }
        CompanyOrgUnitInfo currentCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        IAccount_Control acctCtrl = Account_ControlFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)pk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)currentCompany.getId().toString()));
        evi.setFilter(filter);
        Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
        if (acctCtrlCols != null && acctCtrlCols.size() > 0 && (acctCtrlInfo = acctCtrlCols.get(0)) != null) {
            if (acctCtrlInfo.getSrcCompany() == null) {
                this.deleteSelfTable(ctx, pk, currentCompany);
            } else {
                this.deleteUpperTable(ctx, pk, currentCompany);
            }
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk, IObjectValue company) throws BOSException, EASBizException {
        Account_ControlInfo acctCtrlInfo;
        AccountTableInfo accountTableInfo = (AccountTableInfo)AccountTableFactory.getLocalInstance(ctx).getValue(pk);
        String methodName = "";
        IObjectPK instancePK = pk;
        BOSObjectType bizObjType = accountTableInfo.getBOSType();
        String instanceDetail = accountTableInfo.getNumber() + "  " + accountTableInfo.getName();
        String logItemName = "bd_account_accountTable_delete";
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)bizObjType, (IObjectPK)instancePK, (String)instanceDetail, (String)logItemName);
        if (!this.isCUBDAllowDelete(ctx, accountTableInfo)) {
            throw new AccountException(AccountException.CUBD_CANNOT_DELETEACCOUNTTABLE);
        }
        CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)company;
        IAccount_Control acctCtrl = Account_ControlFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)pk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)currentCompany.getId().toString()));
        evi.setFilter(filter);
        Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
        if (acctCtrlCols != null && acctCtrlCols.size() > 0 && (acctCtrlInfo = acctCtrlCols.get(0)) != null) {
            if (acctCtrlInfo.getSrcCompany() == null) {
                this.deleteSelfTable(ctx, pk, currentCompany);
            } else {
                this.deleteUpperTable(ctx, pk, currentCompany);
            }
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private void deleteUpperTable(Context ctx, IObjectPK pk, CtrlUnitInfo currentCU) throws EASBizException, BOSException {
        boolean canDeleteTable = AccountTools.checkTableCanDeletedByCU(currentCU);
        if (canDeleteTable) {
            String sql = "SELECT TOP 1 1 FROM T_BD_ACCOUNTVIEW WHERE FAccountTableID=? and FControlUnitID=?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString(), currentCU.getId().toString()});
            try {
                if (rs.next()) {
                    throw new AccountException(AccountException.TABLEHASACCOUNTVIEW);
                }
                String sqlForCheckAssignment = "SELECT TOP 1 1 FROM T_BD_Acct_Contorl WHERE FAccountTableID=? and FSrcCu=?";
                IRowSet rsForCheckAssignment = DbUtil.executeQuery((Context)ctx, (String)sqlForCheckAssignment, (Object[])new Object[]{pk.toString(), currentCU.getId().toString()});
                if (rs.next()) {
                    throw new AccountException(AccountException.TABLEHASASSIGNEDTOCHILD);
                }
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)pk.toString()));
                filter.getFilterItems().add(new FilterItemInfo("destCu", (Object)currentCU.getId().toString()));
                IAccount_Control acctCtrl = Account_ControlFactory.getLocalInstance(ctx);
                acctCtrl.delete(filter);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void deleteUpperTable(Context ctx, IObjectPK pk, CompanyOrgUnitInfo currentCompany) throws EASBizException, BOSException {
        boolean canDeleteTable = AccountTools.checkTableCanDeletedByCompany(currentCompany);
        if (canDeleteTable) {
            try {
                String sql = "SELECT TOP 1 1 FROM T_BD_ACCOUNTVIEW WHERE FAccountTableID=? and FCompanyID=?";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString(), currentCompany.getId().toString()});
                if (rs.next()) {
                    throw new AccountException(AccountException.TABLEHASACCOUNTVIEW);
                }
                String sqlForCheckAssignment = "SELECT TOP 1 1 FROM T_BD_Acct_Contorl WHERE FAccountTableID=? and FSrcCompanyID=?";
                IRowSet rsForCheckAssignment = DbUtil.executeQuery((Context)ctx, (String)sqlForCheckAssignment, (Object[])new Object[]{pk.toString(), currentCompany.getId().toString()});
                if (rsForCheckAssignment.next()) {
                    throw new AccountException(AccountException.TABLEHASASSIGNEDTOCHILD);
                }
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)pk.toString()));
                filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)currentCompany.getId().toString()));
                IAccount_Control acctCtrl = Account_ControlFactory.getLocalInstance(ctx);
                acctCtrl.delete(filter);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void deleteSelfTable(Context ctx, IObjectPK pk, CtrlUnitInfo currentCU) throws EASBizException, BOSException {
        String sql = "SELECT TOP 1 1 FROM T_BD_Acct_Contorl WHERE FAccountTableID=? and FDestCu!=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString(), currentCU.getId().toString()});
        try {
            if (rs.next()) {
                throw new AccountException(AccountException.TABLEHASASSIGNEDTOCHILD);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)pk.toString()));
            filter.getFilterItems().add(new FilterItemInfo("destCu", (Object)currentCU.getId().toString()));
            IAccount_Control acctCtrl = Account_ControlFactory.getLocalInstance(ctx);
            acctCtrl.delete(filter);
            super._delete(ctx, pk);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void deleteSelfTable(Context ctx, IObjectPK pk, CompanyOrgUnitInfo currentCompany) throws EASBizException, BOSException {
        try {
            String sql = "SELECT TOP 1 1 FROM T_BD_ACCOUNTVIEW WHERE FAccountTableID=? and FCompanyID=?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString(), currentCompany.getId().toString()});
            if (rs.next()) {
                throw new AccountException(AccountException.TABLEHASACCOUNTVIEW);
            }
            sql = "SELECT TOP 1 1 FROM T_BD_Acct_Contorl WHERE FAccountTableID=? and FDestCompanyID!=?";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString(), currentCompany.getId().toString()});
            if (rs.next()) {
                throw new AccountException(AccountException.TABLEHASASSIGNEDTOCHILD);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)pk.toString()));
            filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)currentCompany.getId().toString()));
            IAccount_Control acctCtrl = Account_ControlFactory.getLocalInstance(ctx);
            acctCtrl.delete(filter);
            super._delete(ctx, pk);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private boolean isCUBDAllowEdit(Context ctx, AccountTableInfo acctTableInfo) throws BOSException, EASBizException {
        boolean isAllowEdit = true;
        ICUBDControl cubdControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        try {
            CUBDControlInfo cubdControlInfo = cubdControl.getBDCtrlInfo(acctTableInfo.getBOSType().toString(), acctTableInfo.getCU().getId().toString());
            isAllowEdit = cubdControlInfo.isIsSubordinateEditable();
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return isAllowEdit;
    }

    private boolean isCUBDAllowAddnew(Context ctx, AccountTableInfo acctTableInfo) throws BOSException, EASBizException {
        boolean isAllowAddnew = true;
        ICUBDControl cubdControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        try {
            CUBDControlInfo cubdControlInfo = cubdControl.getBDCtrlInfo(acctTableInfo.getBOSType().toString(), acctTableInfo.getCU().getId().toString());
            isAllowAddnew = cubdControlInfo.isIsSubordinateAddnewable();
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return isAllowAddnew;
    }

    private boolean isCUBDAllowDelete(Context ctx, AccountTableInfo acctTableInfo) throws BOSException, EASBizException {
        boolean isAllowDelete = true;
        ICUBDControl cubdControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        try {
            CUBDControlInfo cubdControlInfo = cubdControl.getBDCtrlInfo(acctTableInfo.getBOSType().toString(), acctTableInfo.getCU().getId().toString());
            isAllowDelete = cubdControlInfo.isIsSubordinateDeletable();
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return isAllowDelete;
    }
}

