/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTypeFactory;
import com.kingdee.eas.basedata.master.account.AccountTypeInfo;
import com.kingdee.eas.basedata.master.account.IAccountTable;
import com.kingdee.eas.basedata.master.account.common.AccountConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Locale;

public class AccountTypeDataImport
extends AbstractDataTransmission {
    private static String TYPE = "ACCOUNTTYPE";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return AccountTypeFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(TYPE, (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String name_l3;
        String name_l2;
        AccountTypeInfo acctInfo = new AccountTypeInfo();
        String numbers = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        acctInfo.setNumber(numbers);
        AccountTableInfo acctTblInfo = null;
        String acctTblId = "";
        if (this.getContextParameter("varAccountTableInfo") != null) {
            acctTblInfo = (AccountTableInfo)this.getContextParameter("varAccountTableInfo");
            acctInfo.setAccountTableID(acctTblInfo);
            acctTblId = acctTblInfo.getId().toString();
        } else {
            try {
                IAccountTable acctTbl = AccountTableFactory.getLocalInstance(ctx);
                AccountTableCollection acctTblCols = acctTbl.getAccountTableCollection();
                acctTblId = this.getContextParameter("varAccountTableID").toString();
                if (acctTblCols != null && acctTblCols.size() > 0) {
                    acctTblInfo = acctTblCols.get(0);
                    acctTblInfo.setId(BOSUuid.read((String)acctTblId));
                }
                acctInfo.setAccountTableID(acctTblInfo);
                this.getContextParameter().put("varAccountTableInfo", acctTblInfo);
            }
            catch (Exception e) {
                throw new TaskExternalException(TYPE, (Throwable)e);
            }
        }
        String sqlToGetAcctTypeId = "SELECT TOP 1 FID FROM T_BD_ACCOUNTTYPE WHERE FACCOUNTTABLEID = ? AND FNUMBER = ?";
        if (this.isSltImportUpdate()) {
            try {
                IRowSet rsToGetAcctTypeId = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAcctTypeId, (Object[])new Object[]{acctTblId, numbers});
                if (rsToGetAcctTypeId != null && rsToGetAcctTypeId.next()) {
                    String acctId = rsToGetAcctTypeId.getString("FID");
                    acctInfo.setId(BOSUuid.read((String)acctId));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String FParentID = null;
        if (((DataToken)hsData.get((Object)"Fname_L1")).data != null) {
            String Fname_L1 = ((DataToken)hsData.get((Object)"Fname_L1")).data.toString();
            acctInfo.setName(Fname_L1, new Locale("l1"));
        }
        if ((name_l2 = (String)((DataToken)hsData.get((Object)"Fname_L2")).data) != null && name_l2.trim().length() != 0) {
            acctInfo.setName(name_l2, new Locale("L2"));
        }
        if ((name_l3 = (String)((DataToken)hsData.get((Object)"Fname_L3")).data) != null && name_l3.trim().length() != 0) {
            acctInfo.setName(name_l3, new Locale("L3"));
        }
        if (((DataToken)hsData.get((Object)"FParentID")).data != null) {
            try {
                String acctParentNumber = ((DataToken)hsData.get((Object)"FParentID")).data.toString();
                if (acctParentNumber != null) {
                    FParentID = ((DataToken)hsData.get((Object)"FParentID")).data.toString();
                    String sqlToGetAcctParentNumber = "SELECT TOP 1 FID,FProperty FROM T_BD_ACCOUNTTYPE WHERE FNUMBER=? AND FAccountTableID=?";
                    IRowSet rsToGetAcctParentNumber = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAcctParentNumber, (Object[])new Object[]{acctParentNumber, acctTblId});
                    if (rsToGetAcctParentNumber != null && rsToGetAcctParentNumber.next()) {
                        AccountTypeInfo parent = new AccountTypeInfo();
                        parent.setId(BOSUuid.read((String)rsToGetAcctParentNumber.getString("FID")));
                        parent.setProperty(AccountProperty.getEnum(rsToGetAcctParentNumber.getInt("FProperty")));
                        acctInfo.setParent(parent);
                    } else {
                        acctInfo.setParent(null);
                    }
                } else {
                    acctInfo.setParent(null);
                }
            }
            catch (BOSException e) {
                try {
                    throw new AccountException(AccountException.IMPORTOFNULL);
                }
                catch (AccountException e1) {
                    throw new TaskExternalException(TYPE, (Throwable)e);
                }
            }
            catch (Exception e) {
                try {
                    throw new AccountException(AccountException.IMPORTOFNULL);
                }
                catch (AccountException e1) {
                    throw new TaskExternalException(TYPE, (Throwable)e);
                }
            }
        }
        if (((DataToken)hsData.get((Object)"Fproperty")).data != null) {
            String strException;
            String Fpropertys = ((DataToken)hsData.get((Object)"Fproperty")).data.toString();
            if (StringUtils.isEmpty((String)Fpropertys)) {
                String strException2 = "com.kingdee.eas.basedata.master.account.AllAccountResource";
                throw new TaskExternalException(ResourceBase.getString((String)strException2, (String)"FPropertyNotNull", (Locale)ctx.getLocale()));
            }
            Integer val = Integer.valueOf(Fpropertys);
            try {
                String flag = ParamManager.getParamValue((Context)ctx, null, (String)AccountConstant.GovermentAccountingSystem);
                if (!"true".equalsIgnoreCase(flag) && val >= 9 && val <= 13) {
                    String strException3 = "com.kingdee.eas.basedata.master.account.AllAccountResource";
                    throw new TaskExternalException(ResourceBase.getString((String)strException3, (String)"NO_ENABLE_NEW_GOV_ACCOUNT", (Locale)ctx.getLocale()));
                }
            }
            catch (TaskExternalException te) {
                throw te;
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage());
            }
            if (acctInfo.getParent() != null && acctInfo.getParent().getProperty() != null && val != null && acctInfo.getParent().getProperty().getValue() != val.intValue()) {
                strException = "com.kingdee.eas.basedata.master.account.AllAccountResource";
                throw new TaskExternalException(ResourceBase.getString((String)strException, (String)"acctTypeNotSame", (Locale)ctx.getLocale()));
            }
            if (Fpropertys.trim().length() == val.toString().length()) {
                if (AccountProperty.getEnum(val) == null) {
                    try {
                        throw new AccountException(AccountException.PROPERTY_NOT_VALI);
                    }
                    catch (Exception e) {
                        throw new TaskExternalException(e.getMessage());
                    }
                }
                acctInfo.setProperty(AccountProperty.getEnum(val));
            } else {
                if (Fpropertys.trim().length() != val.toString().length()) {
                    strException = "com.kingdee.eas.basedata.master.account.AllAccountResource";
                    throw new TaskExternalException(ResourceBase.getString((String)strException, (String)"AccountProperty_NotExist", (Locale)ctx.getLocale()));
                }
                strException = "com.kingdee.eas.basedata.master.account.AllAccountResource";
                throw new TaskExternalException(ResourceBase.getString((String)strException, (String)"FPropertyNotNull", (Locale)ctx.getLocale()));
            }
        }
        if (((DataToken)hsData.get((Object)"FCreatorNumber")).data != null) {
            String creatorNumber = (String)((DataToken)hsData.get((Object)"FCreatorNumber")).data;
            try {
                String sqlToGetUser = "SELECT TOP 1 FID FROM T_PM_USER WHERE FNUMBER=?";
                IRowSet rsToGetUser = DbUtil.executeQuery((Context)ctx, (String)sqlToGetUser, (Object[])new Object[]{creatorNumber});
                if (rsToGetUser != null && rsToGetUser.next()) {
                    UserInfo userInfo = new UserInfo();
                    userInfo.setId(BOSUuid.read((String)rsToGetUser.getString("FID")));
                    acctInfo.setCreator(userInfo);
                }
                acctInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            }
            catch (Exception e) {
                try {
                    throw new AccountException(AccountException.IMPORTACCTCREATEOR, new Object[]{creatorNumber});
                }
                catch (AccountException e1) {
                    e1.printStackTrace();
                    throw new TaskExternalException(TYPE, (Throwable)e);
                }
            }
        } else {
            acctInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        if (((DataToken)hsData.get((Object)"FCreateTime")).data != null) {
            String period = (String)((DataToken)hsData.get((Object)"FCreateTime")).data;
            if (period.length() > 0) {
                int index = period.indexOf("-");
                int index2 = period.lastIndexOf("-");
                int index3 = period.indexOf(" ");
                if (index < 0 || index2 < 0) {
                    try {
                        throw new AccountException(AccountException.IMPORTACCTCREATETIME, new Object[]{period});
                    }
                    catch (AccountException e) {
                        e.printStackTrace();
                        throw new TaskExternalException(TYPE, (Throwable)((Object)e));
                    }
                }
                int year = Integer.parseInt(period.substring(0, index));
                int month = Integer.parseInt(period.substring(index + 1, index2));
                int date = Integer.parseInt(period.substring(index2 + 1, index3 == -1 ? period.length() : index3));
                Date voucherDate = new Date(year - 1900, month - 1, date);
                acctInfo.setCreateTime(new Timestamp(voucherDate.getTime()));
            }
        } else {
            acctInfo.setCreateTime(new Timestamp(new java.util.Date().getTime()));
        }
        return acctInfo;
    }

    int getIntValueFromAlias(Context ctx, String enumName, String alias) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        if (enumName != null) {
            BizEnumInfo bizEnum = loader.getEnum((IMetaDataPK)new MetaDataPK(enumName));
            BizEnumValueCollection enumItemCol = bizEnum.getEnumValue();
            for (BizEnumValueInfo enumItem : enumItemCol) {
                if (enumItem.getAlias(ctx.getLocale()) == null || !enumItem.getAlias(ctx.getLocale()).equals(alias)) continue;
                if (enumItem.getValue() instanceof Integer) {
                    return (Integer)enumItem.getValue();
                }
                if (!(enumItem.getValue() instanceof String)) continue;
                return Integer.parseInt((String)enumItem.getValue());
            }
            return -1;
        }
        return -1;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> record = new Hashtable<String, Object>();
        try {
            String local = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            record.put("FNumber", rs.getString("number"));
            if ("l1".equalsIgnoreCase(local)) {
                record.put("Fname_L1", this.getStringValueExceptNull(rs.getString("name")));
            }
            if ("l2".equalsIgnoreCase(local)) {
                record.put("Fname_L2", this.getStringValueExceptNull(rs.getString("name")));
            }
            if ("l3".equalsIgnoreCase(local)) {
                record.put("Fname_L3", this.getStringValueExceptNull(rs.getString("name")));
            }
            record.put("FParentID", this.getStringValueExceptNull(rs.getString("parent.number")));
            record.put("Fproperty", String.valueOf(rs.getInt("property")));
            record.put("FCreatorNumber", this.getStringValueExceptNull(rs.getString("creator.number")));
            record.put("FCreateTime", this.getStringValueExceptNull(rs.getTimestamp("createTime")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return record;
    }

    private Object getStringValueExceptNull(Timestamp value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    private String getStringValueExceptNull(Date value) {
        if (value == null) {
            return "";
        }
        return value.getYear() + 1900 + "-" + (value.getMonth() + 1) + "-" + value.getDate();
    }

    private String getStringValueExceptNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    private String getAliasFromIntValue(Context ctx, String enumName, int value) throws AccountException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        BizEnumInfo bizEnum = loader.getEnum((IMetaDataPK)new MetaDataPK(enumName));
        BizEnumValueCollection enumItemCol = bizEnum.getEnumValue();
        for (BizEnumValueInfo enumItem : enumItemCol) {
            if (enumItem.getInt() != value) continue;
            return enumItem.getAlias(ctx.getLocale());
        }
        throw new AccountException(AccountException.ENUMVALUENOTEXIST, new Object[]{enumName, new Integer(value)});
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        String acctTblId = this.getContextParameter("varAccountTableID").toString();
        String cuid = this.getContextParameter("varCUID").toString();
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)acctTblId));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuid));
        filter.setMaskString("#0 and #1");
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.account.app.AccountTypeQuery";
    }
}

