/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.account.AbstractAccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountCategoryEnum;
import com.kingdee.eas.basedata.master.account.AccountControlAttribute;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountCurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountDiffType;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountPLType;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountUserLevelCollection;
import com.kingdee.eas.basedata.master.account.AccountUserLevelInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum;
import com.kingdee.eas.basedata.master.account.AccrualDirectionEnum;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.account.IAccountTable;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class AccountViewDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger(AccountViewDataImport.class);
    private static String type = "ACCOUNTVIEW";
    private Map companyCacheMap = new HashMap();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return AccountViewFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo == null) {
                return;
            }
            if (coreBaseInfo.getId() == null || !this.getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            return this.innerTransform(hsData, ctx);
        }
        catch (AccountException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CoreBaseInfo innerTransform(Hashtable hsData, Context ctx) throws AccountException, TaskExternalException {
        String hasUserProperty;
        AccountViewInfo acctInfo;
        block129: {
            CashFlowItemInfo attCashFlowItem;
            IRowSet rsToGetCashFlowItem;
            String sqlToGetCashFlowItem;
            block128: {
                CashFlowItemInfo mainCashFlowItem;
                block127: {
                    block126: {
                        String measureUnitID;
                        AccountCurrencyCollection acctCurrencyCols;
                        String name_l3;
                        String name_l2;
                        boolean isOnlyShow = false;
                        if (this.getContextParameter("ONLYSHOW") != null) {
                            isOnlyShow = (Boolean)this.getContextParameter("ONLYSHOW");
                        }
                        acctInfo = new AccountViewInfo();
                        if ((DataToken)hsData.get("FNumber") == null) {
                            return null;
                        }
                        String number = ((DataToken)hsData.get((Object)"FNumber")).data.toString();
                        String strParantID = ((DataToken)hsData.get((Object)"FParentID")).data.toString();
                        acctInfo.setNumber(number);
                        String acctTblId = "";
                        String userId = "";
                        AccountTableInfo acctTblInfo = null;
                        acctTblId = this.getContextParameter("varAccountTableID").toString();
                        String cuid = this.getContextParameter("varCUID").toString();
                        String companyId = this.getContextParameter("varCompanyID").toString();
                        if (this.getContextParameter("varAccountTableInfo") != null) {
                            acctTblInfo = (AccountTableInfo)this.getContextParameter("varAccountTableInfo");
                        } else {
                            try {
                                IAccountTable acctTbl = AccountTableFactory.getLocalInstance(ctx);
                                SelectorItemCollection sic = new SelectorItemCollection();
                                sic.add("userLevel.level");
                                sic.add("userLevel.length");
                                sic.add("isUseSeparator");
                                sic.add("separator");
                                sic.add("isUserLevel");
                                acctTblInfo = acctTbl.getAccountTableInfo((IObjectPK)new ObjectUuidPK(acctTblId));
                                this.getContextParameter().put("varAccountTableInfo", acctTblInfo);
                            }
                            catch (Exception e) {
                                throw new AccountException(AccountException.IMPORTACCTTBLERROR, new Object[]{""});
                            }
                        }
                        if (!isOnlyShow) {
                            this.checkCheckIsAllow(number, acctTblInfo, strParantID);
                        }
                        acctInfo.setAccountTableID(acctTblInfo);
                        CompanyOrgUnitInfo companyInfo = null;
                        if (this.companyCacheMap.get(companyId) == null) {
                            try {
                                companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                                this.companyCacheMap.put(companyId, companyInfo);
                            }
                            catch (Exception e) {
                                throw new AccountException(AccountException.FETCHCOMPANYFAIL);
                            }
                        } else {
                            companyInfo = (CompanyOrgUnitInfo)this.companyCacheMap.get(companyId);
                        }
                        acctInfo.setCompanyID(companyInfo);
                        CtrlUnitInfo cu = new CtrlUnitInfo();
                        cu.setId(BOSUuid.read((String)cuid));
                        acctInfo.setCU(cu);
                        Locale zh_cn = new Locale("L2");
                        Locale zh_hk = new Locale("L3");
                        String local = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
                        String name_l1 = (String)((DataToken)hsData.get((Object)"Fname_L1")).data;
                        if (name_l1 != null && name_l1.trim().length() != 0) {
                            acctInfo.setName(name_l1, new Locale("L1"));
                        }
                        if ((name_l2 = (String)((DataToken)hsData.get((Object)"Fname_L2")).data) != null && name_l2.trim().length() != 0) {
                            acctInfo.setName(name_l2, new Locale("L2"));
                        }
                        if ((name_l3 = (String)((DataToken)hsData.get((Object)"Fname_L3")).data) != null && name_l3.trim().length() != 0) {
                            acctInfo.setName(name_l3, new Locale("L3"));
                        }
                        if (!isOnlyShow && this.isSltImportUpdate()) {
                            String sqlToGetAcctId = "SELECT TOP 1 FID,FCreatorID,fcreatetime,FNAME_L1,FNAME_L2,FNAME_L3,FUPPERID,FGLEVEL,FControlLevel,FACCRUALDIRECTION FROM T_BD_ACCOUNTVIEW WHERE FACCOUNTTABLEID = ? AND FCompanyID = ? AND FNUMBER = ?";
                            try {
                                IRowSet rsToGetAcctId = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAcctId, (Object[])new Object[]{acctTblId, companyId, number});
                                if (rsToGetAcctId != null && rsToGetAcctId.next()) {
                                    String acctId = rsToGetAcctId.getString("FID");
                                    int oldGLevel = rsToGetAcctId.getInt("FGLevel");
                                    int oldControlLevel = rsToGetAcctId.getInt("FControlLevel");
                                    String fname_l1 = rsToGetAcctId.getString("FNAME_L1");
                                    String fname_l2 = rsToGetAcctId.getString("FNAME_L2");
                                    String fname_l3 = rsToGetAcctId.getString("FNAME_L3");
                                    if (StringUtils.isEmpty((String)acctInfo.getName(new Locale("L1")))) {
                                        acctInfo.setName(fname_l1, new Locale("L1"));
                                    }
                                    if (StringUtils.isEmpty((String)acctInfo.getName(new Locale("L2")))) {
                                        acctInfo.setName(fname_l2, new Locale("L2"));
                                    }
                                    if (StringUtils.isEmpty((String)acctInfo.getName(new Locale("L3")))) {
                                        acctInfo.setName(fname_l3, new Locale("L3"));
                                    }
                                    userId = rsToGetAcctId.getString("FCreatorID");
                                    acctInfo.setId(BOSUuid.read((String)acctId));
                                    String upperid = rsToGetAcctId.getString("FUPPERID");
                                    if (!StringUtils.isEmpty((String)upperid)) {
                                        AccountViewInfo upperInfo = AccountViewFactory.getLocalInstance(ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(upperid));
                                        acctInfo.setUpper(upperInfo);
                                    }
                                    int accuralDirection = rsToGetAcctId.getInt("FACCRUALDIRECTION");
                                    acctInfo.setAccrualDirection(AccrualDirectionEnum.getEnum(accuralDirection));
                                    if (((DataToken)hsData.get((Object)"FControlLevel")).data != null && ((DataToken)hsData.get((Object)"FControlLevel")).data.toString().trim().length() > 0) {
                                        int newControlLevel = Integer.parseInt(((DataToken)hsData.get((Object)"FControlLevel")).data.toString());
                                        if (newControlLevel < oldControlLevel) throw new AccountException(AccountException.GLEVEL_CANNOT_SMALLER);
                                        acctInfo.setControlLevel(newControlLevel);
                                    } else {
                                        acctInfo.setControlLevel(1);
                                    }
                                    if (((DataToken)hsData.get((Object)"FGLevel")).data != null && ((DataToken)hsData.get((Object)"FGLevel")).data.toString().trim().length() > 0) {
                                        int newGLevel = Integer.parseInt(((DataToken)hsData.get((Object)"FGLevel")).data.toString());
                                        if (newGLevel < oldGLevel) throw new AccountException(AccountException.GLEVEL_CANNOT_SMALLER);
                                        acctInfo.setGLevel(newGLevel);
                                    } else {
                                        acctInfo.setGLevel(acctInfo.getControlLevel());
                                    }
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                throw new AccountException(AccountException.GLEVEL_CANNOT_SMALLER);
                            }
                        }
                        String acctTypeId = "";
                        String acctTypeNumber = ((DataToken)hsData.get((Object)"FAccountType")).data.toString();
                        if (!isOnlyShow) {
                            if (acctTypeNumber.trim().length() != 0) {
                                try {
                                    String sqlToGetAcctType = "SELECT TOP 1 FID,FProperty,FIsLeaf FROM T_BD_ACCOUNTTYPE WHERE FNUMBER=? AND FAccountTableID=?";
                                    IRowSet rsToGetAcctType = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAcctType, (Object[])new Object[]{acctTypeNumber, acctTblId});
                                    if (rsToGetAcctType != null && rsToGetAcctType.next()) {
                                        if (!rsToGetAcctType.getBoolean("fisleaf")) throw new AccountException(AccountException.IMPORTDATA_TYPEISNOTLEAF);
                                        AccountTypeInfo acctTypeInfo = new AccountTypeInfo();
                                        acctTypeId = rsToGetAcctType.getString("FID");
                                        acctTypeInfo.setId(BOSUuid.read((String)acctTypeId));
                                        acctTypeInfo.setProperty(AccountProperty.getEnum(rsToGetAcctType.getInt("FProperty")));
                                        acctInfo.setAccountTypeID(acctTypeInfo);
                                        if (AccountProperty.BUDGET_OUTLAYS.equals((Object)acctTypeInfo.getProperty()) || AccountProperty.BUDGET_RECEIPTS.equals((Object)acctTypeInfo.getProperty()) || AccountProperty.BUDGET_SURPLUS.equals((Object)acctTypeInfo.getProperty())) {
                                            acctInfo.setCategory(AccountCategoryEnum.BUDGET);
                                        }
                                        acctInfo.setCategory(AccountCategoryEnum.FINANCE);
                                    }
                                    acctInfo.setAccountTypeID(null);
                                    String strException = "com.kingdee.eas.basedata.master.account.AllAccountResource";
                                    throw new TaskExternalException(ResourceBase.getString((String)strException, (String)"FAccountTypeNotCriterion", (Locale)ctx.getLocale()));
                                }
                                catch (Exception e) {
                                    if (!(e instanceof TaskExternalException)) throw new AccountException(AccountException.IMPORTACCTTYPEERROR, new Object[]{acctTypeNumber});
                                    throw (TaskExternalException)((Object)e);
                                }
                            } else {
                                String strException = "com.kingdee.eas.basedata.master.account.AllAccountResource";
                                throw new TaskExternalException(ResourceBase.getString((String)strException, (String)"FAccountTypeNOtNull", (Locale)ctx.getLocale()));
                            }
                        }
                        String acctParentId = "";
                        String acctParentNumber = "";
                        try {
                            if (((DataToken)hsData.get((Object)"FParentID")).data != null) {
                                acctParentNumber = ((DataToken)hsData.get((Object)"FParentID")).data.toString();
                                if (acctParentNumber != null && !acctParentNumber.equals("")) {
                                    String sqlToGetAcctParentNumber = "SELECT TOP 1 FID,Flevel, FGLevel,FLongName_l2, FLongName_l3, FAcctCurrency,FIsProfitCenter FROM T_BD_ACCOUNTVIEW WHERE FACCOUNTTABLEID = ? AND FCompanyID = ? AND FNUMBER = ?";
                                    IRowSet rsToGetAcctParentNumber = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAcctParentNumber, (Object[])new Object[]{acctTblId, companyId, acctParentNumber});
                                    if (rsToGetAcctParentNumber == null || !rsToGetAcctParentNumber.next()) throw new AccountException(AccountException.IMPORTACCTPARENTERROR, new Object[]{acctParentNumber});
                                    AccountViewInfo parent = new AccountViewInfo();
                                    parent.setId(BOSUuid.read((String)rsToGetAcctParentNumber.getString("FID")));
                                    parent.setAccountingcurrency(AccountingCurrencyEnum.getEnum(rsToGetAcctParentNumber.getInt("FAcctCurrency")));
                                    parent.setIsProfitCenter(rsToGetAcctParentNumber.getInt("FIsProfitCenter") == 1);
                                    acctInfo.setLevel(rsToGetAcctParentNumber.getInt("Flevel") + 1);
                                    acctInfo.setGLevel(rsToGetAcctParentNumber.getInt("FGLevel"));
                                    if (rsToGetAcctParentNumber.getString("FLongName_l2") != null && acctInfo.getName(zh_cn) != null) {
                                        acctInfo.setLongName(rsToGetAcctParentNumber.getString("FLongName_l2") + "_" + acctInfo.getName(zh_cn), zh_cn);
                                    }
                                    if (rsToGetAcctParentNumber.getString("FLongName_l3") != null && acctInfo.getName(zh_hk) != null) {
                                        acctInfo.setLongName(rsToGetAcctParentNumber.getString("FLongName_l3") + "_" + acctInfo.getName(zh_hk), zh_hk);
                                    }
                                    acctInfo.setParent(parent);
                                } else {
                                    acctInfo.setLevel(1);
                                    acctInfo.setParent(null);
                                    acctInfo.setLongName(acctInfo.getName(zh_cn), zh_cn);
                                    acctInfo.setLongName(acctInfo.getName(zh_hk), zh_hk);
                                }
                            }
                        }
                        catch (Exception e) {
                            throw new AccountException(AccountException.IMPORTACCTPARENTERROR, new Object[]{acctParentNumber});
                        }
                        String isProfitCenter = (String)((DataToken)hsData.get((Object)"FIsProfitCenter")).data;
                        acctInfo.setIsProfitCenter(this.getBooleanFromAlias(isProfitCenter));
                        if (!AccountProperty.PROFIT_CENTER.equals((Object)acctInfo.getAccountTypeID().getProperty()) && acctInfo.isIsProfitCenter()) {
                            throw new AccountException(AccountException.PROFIT_CENTER_CHECK_TYPE);
                        }
                        if (acctInfo.getParent() != null && !acctInfo.getParent().isIsProfitCenter() && acctInfo.isIsProfitCenter()) {
                            throw new AccountException(AccountException.PROFIT_CENTER_CHECK_PARENT_001);
                        }
                        if (acctInfo.getParent() != null && acctInfo.getParent().isIsProfitCenter() && !acctInfo.isIsProfitCenter()) {
                            throw new AccountException(AccountException.PROFIT_CENTER_CHECK_PARENT_002);
                        }
                        if (!isOnlyShow && this.isSltImportUpdate()) {
                            try {
                                this.checkDupName(ctx, acctInfo);
                            }
                            catch (Exception e) {
                                throw new AccountException(AccountException.NAMEALEADYEXIST, new Object[]{acctInfo.getName()});
                            }
                        }
                        if (((DataToken)hsData.get((Object)"FControlLevel")).data != null && ((DataToken)hsData.get((Object)"FControlLevel")).data.toString().trim().length() > 0) {
                            int level;
                            int controlLevel = Integer.parseInt(((DataToken)hsData.get((Object)"FControlLevel")).data.toString());
                            if (controlLevel < (level = acctInfo.getLevel())) {
                                throw new AccountException(AccountException.CONTROLLEVEL_CANNOT_SMALLER);
                            }
                            acctInfo.setControlLevel(controlLevel);
                        } else {
                            acctInfo.setControlLevel(1);
                        }
                        if (((DataToken)hsData.get((Object)"FGLevel")).data != null && ((DataToken)hsData.get((Object)"FGLevel")).data.toString().trim().length() > 0) {
                            int controlLevel;
                            int gLevel = Integer.parseInt(((DataToken)hsData.get((Object)"FGLevel")).data.toString());
                            if (gLevel < (controlLevel = acctInfo.getControlLevel())) {
                                acctInfo.setGLevel(controlLevel);
                            } else {
                                acctInfo.setGLevel(gLevel);
                            }
                        } else {
                            acctInfo.setGLevel(acctInfo.getControlLevel());
                        }
                        String gaaId = "";
                        if (((DataToken)hsData.get((Object)"FGAA")).data != null) {
                            String gaaNumber = ((DataToken)hsData.get((Object)"FGAA")).data.toString();
                            try {
                                String sqlToGetGaa = "SELECT TOP 1 FID FROM T_BD_AsstAccount WHERE FNUMBER=?";
                                IRowSet rsToGetGaa = DbUtil.executeQuery((Context)ctx, (String)sqlToGetGaa, (Object[])new Object[]{gaaNumber});
                                if (rsToGetGaa != null && rsToGetGaa.next()) {
                                    AsstAccountInfo gaa = new AsstAccountInfo();
                                    gaa.setId(BOSUuid.read((String)rsToGetGaa.getString("FID")));
                                    acctInfo.setGAA(gaa);
                                } else {
                                    acctInfo.setGAA(null);
                                }
                            }
                            catch (Exception e) {
                                throw new AccountException(AccountException.IMPORTACCTGAAERROR, new Object[]{gaaNumber});
                            }
                        }
                        String helpCode = (String)((DataToken)hsData.get((Object)"FHelpCode")).data;
                        acctInfo.setHelpCode(helpCode);
                        String dc = (String)((DataToken)hsData.get((Object)"FDC")).data;
                        acctInfo.setDC(BalanceDirectionEnum.getEnum(this.getIntValueFromAlias(ctx, "com.kingdee.eas.basedata.master.account.BalanceDirectionEnum", dc)));
                        String accountingCurrency = ((DataToken)hsData.get((Object)"FAcctCurrency")).data.toString();
                        int id = this.getIntValueFromAlias(ctx, "com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum", accountingCurrency.toString());
                        if (AccountingCurrencyEnum.getEnum(id) != null) {
                            acctInfo.setAccountingcurrency(AccountingCurrencyEnum.getEnum(id));
                        }
                        if ((acctCurrencyCols = acctInfo.getAccountCurrency()) == null) {
                            acctCurrencyCols = new AccountCurrencyCollection();
                        }
                        if (((DataToken)hsData.get((Object)"Fcurrency")).data != null) {
                            String currencyNumber = ((DataToken)hsData.get((Object)"Fcurrency")).data.toString();
                            if (currencyNumber == null) {
                                currencyNumber = "";
                            }
                            if (id == 1) {
                                for (String Imports : currencyNumber.split("/")) {
                                    try {
                                        String sqlToGetCurrency = "SELECT TOP 1 FID,Fname_" + local + "  FROM T_BD_CURRENCY WHERE FNUMBER=?";
                                        IRowSet rsToGetCurrency = DbUtil.executeQuery((Context)ctx, (String)sqlToGetCurrency, (Object[])new Object[]{Imports});
                                        if (rsToGetCurrency == null || !rsToGetCurrency.next()) continue;
                                        AccountCurrencyInfo accountcurrencyinfo = new AccountCurrencyInfo();
                                        accountcurrencyinfo.setAccountView(acctInfo);
                                        CurrencyInfo currencyInfo = new CurrencyInfo();
                                        currencyInfo.setId(BOSUuid.read((String)rsToGetCurrency.getString("FID")));
                                        accountcurrencyinfo.setCurrency(currencyInfo);
                                        acctCurrencyCols.add(accountcurrencyinfo);
                                    }
                                    catch (Exception e) {
                                        throw new AccountException(AccountException.IMPORTACCTCURCYERROR, new Object[]{Imports});
                                    }
                                }
                                if (acctCurrencyCols.size() == 0) {
                                    throw new AccountException(AccountException.IMPORTZDACCTCURCYERROR, new Object[]{currencyNumber});
                                }
                            }
                        }
                        String isGFreeze = (String)((DataToken)hsData.get((Object)"FIsFreeze")).data;
                        acctInfo.setIsGFreeze(this.getBooleanFromAlias(isGFreeze));
                        String isCFreeze = (String)((DataToken)hsData.get((Object)"FIsCompanyFreeze")).data;
                        acctInfo.setIsCFreeze(this.getBooleanFromAlias(isCFreeze));
                        acctInfo.setIsSelfFreeze(this.getBooleanFromAlias(isCFreeze));
                        String isChangeCurrency = (String)((DataToken)hsData.get((Object)"FIsChangeCurrency")).data;
                        acctInfo.setIsChangeCurrency(this.getBooleanFromAlias(isChangeCurrency));
                        String isCash = (String)((DataToken)hsData.get((Object)"FIsCash")).data;
                        acctInfo.setIsCash(this.getBooleanFromAlias(isCash));
                        String isBank = (String)((DataToken)hsData.get((Object)"FIsBank")).data;
                        acctInfo.setIsBank(this.getBooleanFromAlias(isBank));
                        String isCashEquivalent = (String)((DataToken)hsData.get((Object)"FIsCashEquivalent")).data;
                        acctInfo.setIsCashEquivalent(this.getBooleanFromAlias(isCashEquivalent));
                        String isQty = (String)((DataToken)hsData.get((Object)"FIsQty")).data;
                        acctInfo.setIsQty(this.getBooleanFromAlias(isQty));
                        String isProfileCenter = (String)((DataToken)hsData.get((Object)"FIsProfitCenter")).data;
                        acctInfo.setIsProfitCenter(this.getBooleanFromAlias(isProfileCenter));
                        if (((DataToken)hsData.get((Object)"FMeasureUnitGroupID")).data != null) {
                            String measureUnitGroup = (String)((DataToken)hsData.get((Object)"FMeasureUnitGroupID")).data;
                            try {
                                String sqlToGetMeasureUnitGroup = "SELECT TOP 1 FID FROM T_BD_MEASUREUNITGROUP WHERE FNUMBER=?";
                                IRowSet rsToGetMeasureUnitGroup = DbUtil.executeQuery((Context)ctx, (String)sqlToGetMeasureUnitGroup, (Object[])new Object[]{measureUnitGroup});
                                if (rsToGetMeasureUnitGroup != null && rsToGetMeasureUnitGroup.next()) {
                                    MeasureUnitGroupInfo measureUnitGrp = new MeasureUnitGroupInfo();
                                    measureUnitGrp.setId(BOSUuid.read((String)rsToGetMeasureUnitGroup.getString("FID")));
                                    acctInfo.setMeasureUnitGroupID(measureUnitGrp);
                                } else {
                                    acctInfo.setMeasureUnitGroupID(null);
                                }
                            }
                            catch (Exception e) {
                                throw new AccountException(AccountException.IMPORTACCTMEAGRPERROR, new Object[]{measureUnitGroup});
                            }
                        }
                        if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)(measureUnitID = com.kingdee.bos.ctrl.swing.StringUtils.cnulls((Object)((DataToken)hsData.get((Object)"FMeasureUnitID")).data)))) {
                            String measureGroupID = null;
                            if (acctInfo.getMeasureUnitGroupID() != null) {
                                measureGroupID = acctInfo.getMeasureUnitGroupID().getId().toString();
                                if (com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)measureGroupID)) {
                                    throw new AccountException(AccountException.MEASUREGROUP_BLANK, new Object[]{acctInfo.getNumber(), "  ", measureUnitID});
                                }
                                try {
                                    String sqlToGetMeasureUnit = "SELECT TOP 1 FID FROM T_BD_MEASUREUNIT WHERE FNUMBER=? AND FGROUPID = ?";
                                    IRowSet rsToGetMeasureUnit = DbUtil.executeQuery((Context)ctx, (String)sqlToGetMeasureUnit, (Object[])new Object[]{measureUnitID, measureGroupID});
                                    if (rsToGetMeasureUnit == null || !rsToGetMeasureUnit.next()) {
                                        throw new AccountException(AccountException.MEASUREGROUP_BLANK, new Object[]{acctInfo.getNumber(), measureGroupID, measureUnitID});
                                    }
                                    MeasureUnitInfo measureUnitInfo = new MeasureUnitInfo();
                                    measureUnitInfo.setId(BOSUuid.read((String)rsToGetMeasureUnit.getString("FID")));
                                    acctInfo.setMeasureUnitID(measureUnitInfo);
                                }
                                catch (Exception e) {
                                    throw new AccountException(AccountException.IMPORTACCTMEASERROR, new Object[]{measureUnitID});
                                }
                            }
                        }
                        String ac = (String)((DataToken)hsData.get((Object)"FAC")).data;
                        acctInfo.setAC(this.getBooleanFromAlias(ac));
                        String bw = (String)((DataToken)hsData.get((Object)"FBW")).data;
                        acctInfo.setBw(bw.trim().length() == 0 ? false : this.getBooleanFromAlias(bw));
                        if (!AccountProperty.BIAOWAI.equals((Object)acctInfo.getAccountTypeID().getProperty()) && acctInfo.isBw()) {
                            throw new AccountException(AccountException.BW_CHECK_TYPE1);
                        }
                        if (AccountProperty.BIAOWAI.equals((Object)acctInfo.getAccountTypeID().getProperty()) && !acctInfo.isBw()) {
                            throw new AccountException(AccountException.BW_CHECK_TYPE2);
                        }
                        if (!StringUtils.isEmpty((String)strParantID) && this.isSltImportUpdate()) {
                            AbstractAccountViewInfo parentInfo = null;
                            try {
                                parentInfo = AccountViewFactory.getLocalInstance(ctx).getAccountViewInfo("select id,bw where accountTableID = '" + acctTblId + "' and companyID = '" + companyId + "' and number ='" + strParantID + "'");
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                            if (parentInfo != null && parentInfo.isBw() != acctInfo.isBw()) {
                                throw new AccountException(AccountException.BWNOTEQUALPARENT, new Object[]{acctInfo.getNumber()});
                            }
                        }
                        String acnotice = (String)((DataToken)hsData.get((Object)"FIC")).data;
                        acctInfo.setACNotice(this.getBooleanFromAlias(acnotice));
                        String plType = ((DataToken)hsData.get((Object)"FPLType")).data.toString();
                        int ipp = this.getIntValueFromAlias(ctx, "com.kingdee.eas.basedata.master.account.AccountPLType", plType);
                        if (AccountPLType.getEnum(ipp) != null) {
                            acctInfo.setPLType(AccountPLType.getEnum(ipp));
                        }
                        String caaNumber = (String)((DataToken)hsData.get((Object)"FCAA")).data;
                        try {
                            String sqlToGetCaa;
                            IRowSet rsToGetCaa;
                            if (caaNumber == null) {
                                caaNumber = "";
                            }
                            if ((rsToGetCaa = DbUtil.executeQuery((Context)ctx, (String)(sqlToGetCaa = "SELECT TOP 1 FID FROM T_BD_AsstAccount WHERE FNUMBER=?"), (Object[])new Object[]{caaNumber})) != null && rsToGetCaa.next()) {
                                AsstAccountInfo caa = new AsstAccountInfo();
                                caa.setId(BOSUuid.read((String)rsToGetCaa.getString("FID")));
                                acctInfo.setCAA(caa);
                                if (this.isSltImportUpdate() && acctInfo.getId() != null) {
                                    acctInfo.put("importModel", "true");
                                    String warnMsg = AccountFacadeFactory.getLocalInstance(ctx).checkAccountAsst(acctInfo, caa.getId().toString());
                                    if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)warnMsg)) {
                                        throw new TaskExternalException(warnMsg);
                                    }
                                }
                            }
                        }
                        catch (TaskExternalException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new AccountException(AccountException.IMPORTACCTCAAERROR, new Object[]{caaNumber});
                        }
                        String isAllowCa = (String)((DataToken)hsData.get((Object)"FIsAllowCA")).data;
                        acctInfo.setIsAllowCA(this.getBooleanFromAlias(isAllowCa));
                        String isOutDailyAccount = (String)((DataToken)hsData.get((Object)"FIsOutDailyAccount")).data;
                        acctInfo.setIsOutDailyAccount(isOutDailyAccount.trim().length() == 0 ? false : this.getBooleanFromAlias(isOutDailyAccount));
                        String control = ((DataToken)hsData.get((Object)"FControl")).data.toString();
                        int icontrol = this.getIntValueFromAlias(ctx, "com.kingdee.eas.basedata.master.account.AccountControlAttribute", control);
                        if (AccountPLType.getEnum(ipp) != null) {
                            acctInfo.setControl(AccountControlAttribute.getEnum(icontrol));
                        }
                        String creatorNumber = (String)((DataToken)hsData.get((Object)"FCreatorNumber")).data;
                        if (((DataToken)hsData.get((Object)"FCreatorNumber")).data != null && !this.isSltImportUpdate()) {
                            try {
                                String sqlToGetUser = "SELECT TOP 1 FID FROM T_PM_USER WHERE FNUMBER=?";
                                IRowSet rsToGetUser = DbUtil.executeQuery((Context)ctx, (String)sqlToGetUser, (Object[])new Object[]{creatorNumber});
                                if (rsToGetUser != null && rsToGetUser.next()) {
                                    UserInfo userInfo = new UserInfo();
                                    userInfo.setId(BOSUuid.read((String)rsToGetUser.getString("FID")));
                                    acctInfo.setCreator(userInfo);
                                }
                                acctInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                            }
                            catch (Exception e) {
                                throw new AccountException(AccountException.IMPORTACCTCREATEOR, new Object[]{creatorNumber});
                            }
                        } else if (!this.isSltImportUpdate()) {
                            acctInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                        } else if (this.isSltImportUpdate()) {
                            UserInfo userInfo = new UserInfo();
                            if (!StringUtils.isEmpty((String)userId)) {
                                userInfo.setId(BOSUuid.read((String)userId));
                                acctInfo.setCreator(userInfo);
                            } else {
                                acctInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                            }
                        }
                        if (((DataToken)hsData.get((Object)"FBorrowerMainCashFlowItemNumber")).data != null) {
                            String borrowerMainCashFlowItemNumber = null;
                            try {
                                borrowerMainCashFlowItemNumber = ((DataToken)hsData.get((Object)"FBorrowerMainCashFlowItemNumber")).data.toString();
                                if (borrowerMainCashFlowItemNumber == null || borrowerMainCashFlowItemNumber.trim().length() == 0) {
                                    acctInfo.setMainCashFlowItem(null);
                                    acctInfo.setBorrowerMainCashFlowItem(null);
                                    break block126;
                                }
                                sqlToGetCashFlowItem = "SELECT TOP 1 FID FROM T_BD_CashFlowItem WHERE FType = 0 AND FNUMBER=?";
                                rsToGetCashFlowItem = DbUtil.executeQuery((Context)ctx, (String)sqlToGetCashFlowItem, (Object[])new Object[]{borrowerMainCashFlowItemNumber});
                                if (rsToGetCashFlowItem != null && rsToGetCashFlowItem.next()) {
                                    mainCashFlowItem = new CashFlowItemInfo();
                                    mainCashFlowItem.setId(BOSUuid.read((String)rsToGetCashFlowItem.getString("FID")));
                                    acctInfo.setBorrowerMainCashFlowItem(mainCashFlowItem);
                                    break block126;
                                }
                                acctInfo.setBorrowerMainCashFlowItem(null);
                                throw new AccountException(AccountException.IMPORTACCTBORROWERMAINITEMERROR, new Object[]{borrowerMainCashFlowItemNumber});
                            }
                            catch (Exception e) {
                                throw new AccountException(AccountException.IMPORTACCTBORROWERMAINITEMERROR, new Object[]{borrowerMainCashFlowItemNumber});
                            }
                        }
                    }
                    if (((DataToken)hsData.get((Object)"FBorrowerAttCashFlowItemNumber")).data != null) {
                        String borrowerAttCashFlowItemNumber = null;
                        try {
                            borrowerAttCashFlowItemNumber = ((DataToken)hsData.get((Object)"FBorrowerAttCashFlowItemNumber")).data.toString();
                            if (borrowerAttCashFlowItemNumber == null || borrowerAttCashFlowItemNumber.trim().length() == 0) {
                                acctInfo.setAttCashFlowItem(null);
                                acctInfo.setBorrowerAttCashFlowItem(null);
                                break block127;
                            }
                            sqlToGetCashFlowItem = "SELECT TOP 1 FID FROM T_BD_CashFlowItem WHERE FType = 1 AND FNUMBER=?";
                            rsToGetCashFlowItem = DbUtil.executeQuery((Context)ctx, (String)sqlToGetCashFlowItem, (Object[])new Object[]{borrowerAttCashFlowItemNumber});
                            if (rsToGetCashFlowItem != null && rsToGetCashFlowItem.next()) {
                                attCashFlowItem = new CashFlowItemInfo();
                                attCashFlowItem.setId(BOSUuid.read((String)rsToGetCashFlowItem.getString("FID")));
                                acctInfo.setAttCashFlowItem(attCashFlowItem);
                                acctInfo.setBorrowerAttCashFlowItem(attCashFlowItem);
                                break block127;
                            }
                            acctInfo.setBorrowerAttCashFlowItem(null);
                            throw new AccountException(AccountException.IMPORTACCTBORROWERATTACHITEMERROR, new Object[]{borrowerAttCashFlowItemNumber});
                        }
                        catch (Exception e) {
                            throw new AccountException(AccountException.IMPORTACCTBORROWERATTACHITEMERROR, new Object[]{borrowerAttCashFlowItemNumber});
                        }
                    }
                }
                if (((DataToken)hsData.get((Object)"FLenderMainCashFlowItemNumber")).data != null) {
                    String lenderMainCashFlowItemNumber = null;
                    try {
                        lenderMainCashFlowItemNumber = ((DataToken)hsData.get((Object)"FLenderMainCashFlowItemNumber")).data.toString();
                        if (lenderMainCashFlowItemNumber == null || lenderMainCashFlowItemNumber.trim().length() == 0) {
                            acctInfo.setMainCashFlowItem(null);
                            acctInfo.setLenderMainCashFlowItem(null);
                            break block128;
                        }
                        sqlToGetCashFlowItem = "SELECT TOP 1 FID FROM T_BD_CashFlowItem WHERE FType = 0 AND FNUMBER=?";
                        rsToGetCashFlowItem = DbUtil.executeQuery((Context)ctx, (String)sqlToGetCashFlowItem, (Object[])new Object[]{lenderMainCashFlowItemNumber});
                        if (rsToGetCashFlowItem != null && rsToGetCashFlowItem.next()) {
                            mainCashFlowItem = new CashFlowItemInfo();
                            mainCashFlowItem.setId(BOSUuid.read((String)rsToGetCashFlowItem.getString("FID")));
                            acctInfo.setLenderMainCashFlowItem(mainCashFlowItem);
                            break block128;
                        }
                        acctInfo.setLenderMainCashFlowItem(null);
                        throw new AccountException(AccountException.IMPORTACCTLENDERMAINITEMERROR, new Object[]{lenderMainCashFlowItemNumber});
                    }
                    catch (Exception e) {
                        throw new AccountException(AccountException.IMPORTACCTLENDERMAINITEMERROR, new Object[]{lenderMainCashFlowItemNumber});
                    }
                }
            }
            if (((DataToken)hsData.get((Object)"FLenderAttCashFlowItemNumber")).data != null) {
                String lenderAttCashFlowItemNumber = null;
                try {
                    lenderAttCashFlowItemNumber = ((DataToken)hsData.get((Object)"FLenderAttCashFlowItemNumber")).data.toString();
                    if (lenderAttCashFlowItemNumber == null || lenderAttCashFlowItemNumber.trim().length() == 0) {
                        acctInfo.setAttCashFlowItem(null);
                        acctInfo.setLenderAttCashFlowItem(null);
                        break block129;
                    }
                    sqlToGetCashFlowItem = "SELECT TOP 1 FID FROM T_BD_CashFlowItem WHERE FType = 1 AND FNUMBER=?";
                    rsToGetCashFlowItem = DbUtil.executeQuery((Context)ctx, (String)sqlToGetCashFlowItem, (Object[])new Object[]{lenderAttCashFlowItemNumber});
                    if (rsToGetCashFlowItem != null && rsToGetCashFlowItem.next()) {
                        attCashFlowItem = new CashFlowItemInfo();
                        attCashFlowItem.setId(BOSUuid.read((String)rsToGetCashFlowItem.getString("FID")));
                        acctInfo.setAttCashFlowItem(attCashFlowItem);
                        acctInfo.setLenderAttCashFlowItem(attCashFlowItem);
                        break block129;
                    }
                    acctInfo.setLenderAttCashFlowItem(null);
                    throw new AccountException(AccountException.IMPORTACCTLENDERATTACHITEMERROR, new Object[]{lenderAttCashFlowItemNumber});
                }
                catch (Exception e) {
                    throw new AccountException(AccountException.IMPORTACCTLENDERATTACHITEMERROR, new Object[]{lenderAttCashFlowItemNumber});
                }
            }
        }
        if (hsData.get("FhasUserProperty") != null && !"".equals(hasUserProperty = (String)((DataToken)hsData.get((Object)"FhasUserProperty")).data)) {
            if ("1".equals(hasUserProperty) || "Y".equals(hasUserProperty)) {
                acctInfo.setHasUserProperty(true);
            } else {
                acctInfo.setHasUserProperty(false);
            }
        }
        String diffType = (String)((DataToken)hsData.get((Object)"FDiffType")).data;
        acctInfo.setDiffType(AccountDiffType.getEnum(this.getIntValueFromAlias(ctx, "com.kingdee.eas.basedata.master.account.AccountDiffType", diffType)));
        return acctInfo;
    }

    private void checkCheckIsAllow(String number, AccountTableInfo acctTblInfo, String strParantID) throws AccountException {
        int i;
        if (com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)number)) {
            throw new AccountException(AccountException.ACCOUNTTABLENUMBLANK);
        }
        if (!acctTblInfo.isIsUserLevel()) {
            return;
        }
        String separator = "";
        if (acctTblInfo != null && acctTblInfo.isIsUseSeparator()) {
            separator = acctTblInfo.getSeparator();
        }
        AccountUserLevelCollection userLevel = acctTblInfo.getUserLevel();
        StringBuffer buffer = new StringBuffer();
        buffer.append("[0-9a-zA-Z]");
        int[] Level2 = new int[10];
        String[] regRule = new String[10];
        if (userLevel.size() > 0) {
            for (i = 0; i < userLevel.size(); ++i) {
                Level2[i] = this.getLevelLength(i + 1, userLevel);
                if (i > 0) {
                    if (!separator.equals("")) {
                        buffer.append("[");
                        buffer.append(separator);
                        buffer.append("]");
                        buffer.append("{1}");
                    }
                    buffer.append("[0-9a-zA-Z]");
                }
                buffer.append("{");
                buffer.append(Level2[i]);
                buffer.append("}");
                regRule[i] = buffer.toString();
            }
        } else {
            for (i = 0; i < 10; ++i) {
                if (i > 0) {
                    if (!separator.equals("")) {
                        buffer.append("[");
                        buffer.append(separator);
                        buffer.append("]{1}");
                    }
                    buffer.append("[0-9a-zA-Z]");
                }
                buffer.append("*");
                regRule[i] = buffer.toString();
            }
        }
        int index = this.getIndex(number, userLevel, separator);
        int sum = 0;
        int lSum = 0;
        for (int i2 = 0; i2 <= index; ++i2) {
            sum += Level2[i2];
            lSum = Level2[index];
        }
        sum += (index - 1) * separator.length();
        if (strParantID == null || strParantID.trim().equals("")) {
            if (index > 0) {
                throw new AccountException(AccountException.PARENTNUMBER_BLANK);
            }
        } else if (strParantID.length() != sum - lSum || !number.substring(0, sum - lSum).equals(strParantID)) {
            throw new AccountException(AccountException.FATHERACCOUNTFALSENESS);
        }
        if (userLevel.size() > 0 && index > userLevel.size() || regRule[index] == null) {
            throw new AccountException(AccountException.LEVEL_TOO_LONG);
        }
        Pattern patt = Pattern.compile(regRule[index]);
        Matcher matcher = patt.matcher(number);
        boolean matched = matcher.matches();
        if (!matched) {
            throw new AccountException(AccountException.NOT_VALID_TO_TABLE_NUMBER_RULE);
        }
    }

    private int getLevelLength(int level, AccountUserLevelCollection userLevels) {
        for (int i = 0; i < userLevels.size(); ++i) {
            AccountUserLevelInfo levelInfo = userLevels.get(i);
            if (levelInfo == null || levelInfo.getLevel() != level) continue;
            return levelInfo.getLength();
        }
        return -1;
    }

    private int getIndex(String number, AccountUserLevelCollection userLevel, String separator) {
        int index = 0;
        String[] num = null;
        int len = 0;
        if (!separator.equals("")) {
            num = com.kingdee.bos.ctrl.swing.StringUtils.split((String)number, (String)separator);
            index = num.length - 1;
        } else {
            for (int i = 0; i < userLevel.size(); ++i) {
                if ((len += userLevel.get(i).getLength()) != number.length()) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    private boolean getBooleanFromAlias(String isFreeze) {
        return !isFreeze.equals("N");
    }

    int getIntValueFromAlias(Context ctx, String enumName, String alias) throws AccountException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        BizEnumInfo bizEnum = loader.getEnum((IMetaDataPK)new MetaDataPK(enumName));
        BizEnumValueCollection enumItemCol = bizEnum.getEnumValue();
        for (BizEnumValueInfo enumItem : enumItemCol) {
            LanguageInfo lan = BOSLocaleUtil.getLanguage((Locale)ctx.getLocale());
            String enumAlias = (String)enumItem.getStateManager().getLocaleValue("alias", lan.getLocaleString());
            if (enumAlias == null || !enumAlias.equals(alias)) continue;
            if (enumItem.getValue() instanceof Integer) {
                return (Integer)enumItem.getValue();
            }
            if (!(enumItem.getValue() instanceof String)) continue;
            return Integer.parseInt((String)enumItem.getValue());
        }
        if (enumName.equalsIgnoreCase("com.kingdee.eas.basedata.master.account.BalanceDirectionEnum")) {
            throw new AccountException(AccountException.BALANCEDIRECTIONENUMNOTEXIST);
        }
        if (enumName.equalsIgnoreCase("com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum")) {
            throw new AccountException(AccountException.ACCOUNTINGCURRENCYENUMNOTEXIST);
        }
        if (enumName.equalsIgnoreCase("com.kingdee.eas.basedata.master.account.AccountPLType")) {
            throw new AccountException(AccountException.ACCOUNTPLTYPEENUMNOTEXIST);
        }
        if (enumName.equalsIgnoreCase("com.kingdee.eas.basedata.master.account.AccountControlAttribute")) {
            throw new AccountException(AccountException.ACCOUNTCONTROLATTRIBUTEENUMNOTEXIST);
        }
        throw new AccountException(AccountException.ENUMVALUENOTEXIST, new Object[]{enumName, alias});
    }

    public void putContextParameter(String key, Object value) {
        Hashtable<String, Object> ctx = new Hashtable<String, Object>();
        ctx.put(key, value);
        this.setContextParameter(ctx);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> record = new Hashtable<String, String>();
        try {
            String acctId = rs.getString("id");
            record.put("FNumber", rs.getString("number"));
            record.put("FAccountType", rs.getString("accountTypeID.number"));
            String local = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            if ("l1".equalsIgnoreCase(local)) {
                record.put("Fname_L1", this.getStringValueExceptNull(rs.getString("name")));
            }
            if ("l2".equalsIgnoreCase(local)) {
                record.put("Fname_L2", this.getStringValueExceptNull(rs.getString("name")));
            }
            if ("l3".equalsIgnoreCase(local)) {
                record.put("Fname_L3", this.getStringValueExceptNull(rs.getString("name")));
            }
            record.put("FParentID", this.getStringValueExceptNull(rs.getString("parent.number")));
            record.put("FControlLevel", this.getStringValueExceptNull(rs.getString("controlLevel")));
            record.put("FGLevel", this.getStringValueExceptNull(rs.getString("gLevel")));
            record.put("FHelpCode", this.getStringValueExceptNull(rs.getString("helpCode")));
            record.put("FDC", this.getAliasFromIntValue(ctx, "com.kingdee.eas.basedata.master.account.BalanceDirectionEnum", rs.getInt("DC")));
            int accountingCurrencyEnumValue = rs.getInt("accountingcurrency");
            record.put("FAcctCurrency", this.getAliasFromIntValue(ctx, "com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum", accountingCurrencyEnumValue));
            if (accountingCurrencyEnumValue == 1) {
                String sqlToGetCurrencyNum = "SELECT CUR.FNUMBER FROM T_BD_AccountCurrency ACCTCUR INNER JOIN T_BD_CURRENCY CUR ON ACCTCUR.FCURRENCYID = CUR.FID WHERE ACCTCUR.FACCOUNTVIEWID = ?";
                StringBuffer currencyNum = new StringBuffer();
                IRowSet rsToGetCurrencyNum = DbUtil.executeQuery((Context)ctx, (String)sqlToGetCurrencyNum, (Object[])new Object[]{acctId});
                boolean isFirst = true;
                while (rsToGetCurrencyNum.next()) {
                    if (isFirst) {
                        currencyNum.append(rsToGetCurrencyNum.getString("FNUMBER"));
                        isFirst = false;
                        continue;
                    }
                    currencyNum.append("/");
                    currencyNum.append(rsToGetCurrencyNum.getString("FNUMBER"));
                }
                record.put("Fcurrency", currencyNum.toString());
            }
            record.put("FIsChangeCurrency", this.getAliasFromBooleanValue(rs.getBoolean("isChangeCurrency")));
            record.put("FIsOutDailyAccount", this.getAliasFromBooleanValue(rs.getBoolean("isOutDailyAccount")));
            record.put("FIsCash", this.getAliasFromBooleanValue(rs.getBoolean("isCash")));
            record.put("FIsBank", this.getAliasFromBooleanValue(rs.getBoolean("isBank")));
            record.put("FIsCashEquivalent", this.getAliasFromBooleanValue(rs.getBoolean("isCashEquivalent")));
            record.put("FIsQty", this.getAliasFromBooleanValue(rs.getBoolean("isQty")));
            record.put("FBW", this.getAliasFromBooleanValue(rs.getBoolean("bw")));
            record.put("FMeasureUnitGroupID", this.getStringValueExceptNull(rs.getString("measureUnitGroupID.number")));
            record.put("FMeasureUnitID", this.getStringValueExceptNull(rs.getString("measureUnitID.number")));
            record.put("FAC", this.getAliasFromBooleanValue(rs.getBoolean("AC")));
            record.put("FCAA", this.getStringValueExceptNull(rs.getString("CAA.number")));
            record.put("FGAA", this.getStringValueExceptNull(rs.getString("GAA.number")));
            record.put("FIC", this.getAliasFromBooleanValue(rs.getBoolean("ACNotice")));
            record.put("FParentAAID", this.getStringValueExceptNull(rs.getString("parentAA.number")));
            record.put("FPLType", this.getAliasFromIntValue(ctx, "com.kingdee.eas.basedata.master.account.AccountPLType", rs.getInt("PLType")));
            record.put("FControl", this.getAliasFromIntValue(ctx, "com.kingdee.eas.basedata.master.account.AccountControlAttribute", rs.getInt("control")));
            record.put("FIsAllowCA", this.getAliasFromBooleanValue(rs.getBoolean("isAllowCA")));
            record.put("FIsUpperAllowCA", this.getAliasFromBooleanValue(rs.getBoolean("isUpperAllowCA")));
            record.put("FIsFreeze", this.getAliasFromBooleanValue(rs.getBoolean("isGFreeze")));
            record.put("FIsCompanyFreeze", this.getAliasFromBooleanValue(rs.getBoolean("isCFreeze")));
            record.put("FIsSelfFreeze", this.getAliasFromBooleanValue(rs.getBoolean("isSelfFreeze")));
            record.put("FIsParentFreeze", this.getAliasFromBooleanValue(rs.getBoolean("isParentFreeze")));
            record.put("FCreatorNumber", this.getStringValueExceptNull(rs.getString("creator.number")));
            record.put("FBorrowerMainCashFlowItemNumber", this.getStringValueExceptNull(rs.getString("borrowerMainCashFlowItem.number")));
            record.put("FBorrowerAttCashFlowItemNumber", this.getStringValueExceptNull(rs.getString("borrowerAttCashFlowItem.number")));
            record.put("FLenderMainCashFlowItemNumber", this.getStringValueExceptNull(rs.getString("lenderMainCashFlowItem.number")));
            record.put("FLenderAttCashFlowItemNumber", this.getStringValueExceptNull(rs.getString("lenderAttCashFlowItem.number")));
            record.put("FIsProfitCenter", this.getAliasFromBooleanValue(rs.getBoolean("isProfitCenter")));
            record.put("FDiffType", this.getAliasFromIntValue(ctx, "com.kingdee.eas.basedata.master.account.AccountDiffType", rs.getInt("diffType")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (AccountException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return record;
    }

    private Object getStringValueExceptNull(Timestamp value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    private String getStringValueExceptNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    private String getStringValueExceptNull(Date value) {
        if (value == null) {
            return "";
        }
        return value.getYear() + 1900 + "-" + (value.getMonth() + 1) + "-" + value.getDate();
    }

    private String getAliasFromBooleanValue(boolean value) {
        if (value) {
            return "Y";
        }
        return "N";
    }

    private String getAliasFromIntValue(Context ctx, String enumName, int value) throws AccountException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        BizEnumInfo bizEnum = loader.getEnum((IMetaDataPK)new MetaDataPK(enumName));
        BizEnumValueCollection enumItemCol = bizEnum.getEnumValue();
        for (BizEnumValueInfo enumItem : enumItemCol) {
            if (enumItem.getInt() != value) continue;
            LanguageInfo lan = BOSLocaleUtil.getLanguage((Locale)ctx.getLocale());
            String enumAlias = (String)enumItem.getStateManager().getLocaleValue("alias", lan.getLocaleString());
            if (enumAlias == null) {
                throw new AccountException(AccountException.ENUMVALUENOTEXIST, new Object[]{enumName, new Integer(value)});
            }
            return enumAlias;
        }
        throw new AccountException(AccountException.ENUMVALUENOTEXIST, new Object[]{enumName, new Integer(value)});
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        String acctTblId = this.getContextParameter("varAccountTableID").toString();
        String companyId = this.getContextParameter("varCompanyID").toString();
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)acctTblId));
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyId));
        filter.setMaskString("#0 and #1");
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.account.app.AccountForExportQuery";
    }

    private void checkDupName(Context ctx, AccountViewInfo acctInfo) throws BOSException, EASBizException {
        if (acctInfo == null || acctInfo.getCompanyID() == null || acctInfo.getAccountTableID() == null || acctInfo.getName() == null || acctInfo.getId() == null) {
            return;
        }
        String sql = "select id where companyID.id='" + acctInfo.getCompanyID().getId().toString() + "' and accountTableID.id='" + acctInfo.getAccountTableID().getId().toString() + "' and name='" + acctInfo.getName().trim() + "' and level = " + (acctInfo.getLevel() < 1 ? 1 : acctInfo.getLevel()) + (acctInfo.getParent() != null ? " and parent.id = '" + acctInfo.getParent().getId().toString() + "'" : " ") + (acctInfo.getId() != null ? " and id != '" + acctInfo.getId().toString() + "'" : "");
        if (AccountViewFactory.getLocalInstance(ctx).exists(sql)) {
            throw new AccountException(AccountException.NAMEALEADYEXIST, new Object[]{acctInfo.getName()});
        }
    }
}

