/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AcctRefContrastException;
import com.kingdee.eas.basedata.master.account.IAccountRefContrastProcess;
import com.kingdee.eas.common.BizHasDealException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class AcctRefContrastHelper {
    protected static final String BOSTYPE_ACCTREFENTRY = "0EC0F8BE";
    protected static String BOSTYPE_ACCTVIEW = "9DA99826";
    private static Logger logger = Logger.getLogger(AcctRefContrastHelper.class);

    public static void copyAcctRef(Context ctx, String acctRefHeadID, String upperCompany, AccountViewCollection accountViewCollection) throws EASBizException, BOSException {
        if (acctRefHeadID == null || upperCompany == null || accountViewCollection == null || accountViewCollection.size() == 0) {
            return;
        }
        AccountViewInfo acctInfo = null;
        Statement stmt = null;
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.createStatement();
            String sql = null;
            int count = accountViewCollection.size();
            for (int i = 0; i < count; ++i) {
                acctInfo = accountViewCollection.get(i);
                if (acctInfo == null || acctInfo.getUpper() == null || acctInfo.getLevel() != 1 || acctInfo.getId() == null) continue;
                sql = AcctRefContrastHelper.getCopyAcctRefSQL(acctRefHeadID, upperCompany, acctInfo).toString();
                logger.info((Object)("sql: " + sql));
                stmt.addBatch(sql);
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    public static void copyAcctRef(Context ctx, String acctRefHeadID, String upperCompany, AccountViewInfo acctInfo) throws EASBizException, BOSException {
        if (acctInfo == null || upperCompany == null || acctInfo.getUpper() == null) {
            return;
        }
        if (acctInfo.getLevel() == 1 && acctInfo.getId() != null) {
            Object[] sqlParaCopyAcctRef = new Object[]{acctInfo.getCompanyID().getId().toString(), acctInfo.getAccountTableID().getId().toString(), acctInfo.getNumber(), upperCompany, acctInfo.getAccountTableID().getId().toString(), acctInfo.getUpper().getId().toString(), acctInfo.getCompanyID().getId().toString()};
            String sql = AcctRefContrastHelper.getCopyAcctRefSQL(acctRefHeadID, acctInfo.getNumber()).toString();
            logger.debug((Object)sql);
            logger.debug((Object)sqlParaCopyAcctRef);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])sqlParaCopyAcctRef);
        }
    }

    public static void delAcctRef(Context ctx, String acctRefHeadID, AccountViewInfo acctInfo) throws EASBizException, BOSException {
        if (acctInfo == null || acctInfo.getUpper() == null) {
            return;
        }
        if (acctInfo.getLevel() == 1) {
            Object[] sqlParaDelAcctRef = new Object[]{acctRefHeadID, acctInfo.getId().toString().toString()};
            DbUtil.execute((Context)ctx, (String)"DELETE FROM t_bd_acctrefcontrastentry WHERE facctrefcontrastid = ? AND fnewacctid = ?", (Object[])sqlParaDelAcctRef);
        }
    }

    public static void delAcctRef(Context ctx, String acctRefHeadID, AccountViewCollection acctForDeleteCon) throws EASBizException, BOSException {
        if (acctRefHeadID == null || acctForDeleteCon == null || acctForDeleteCon.size() == 0) {
            return;
        }
        StringBuffer idSet = new StringBuffer();
        int count = acctForDeleteCon.size();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                idSet.append(",");
            }
            idSet.append("'").append(acctForDeleteCon.get(i).getId().toString()).append("'");
        }
        Object[] sqlParaDelAcctRef = new Object[]{acctRefHeadID};
        String sql = "DELETE FROM t_bd_acctrefcontrastentry WHERE facctrefcontrastid = ? AND fnewacctid in(select fid from t_bd_accountview where FLevel = 1 and fid in(" + idSet.toString() + "))";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])sqlParaDelAcctRef);
    }

    public static void delAcctRef(Context ctx, String acctInfoID) throws EASBizException, BOSException {
        if (acctInfoID == null || acctInfoID.length() == 0) {
            return;
        }
        Statement stmt = null;
        Connection cn = null;
        try {
            String sql = "SELECT distinct facctrefcontrastid FROM t_bd_acctrefcontrastentry WHERE fnewacctid = ?";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{acctInfoID});
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.createStatement();
            sql = "DELETE FROM t_bd_acctrefcontrastentry WHERE fnewacctid = '" + acctInfoID + "'";
            stmt.addBatch(sql);
            while (rowSet.next()) {
                String headID = rowSet.getString(1);
                sql = "DELETE FROM t_bd_acctrefcontrast WHERE fid = '" + headID + "' AND NOT EXISTS (SELECT top 1 fid FROM t_bd_acctrefcontrastentry WHERE facctrefcontrastid = '" + headID + "')";
                stmt.addBatch(sql);
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    public static boolean isInAdjPeriod(Context ctx, String companyID) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT top 1 a.fid \n");
        sql.append("FROM t_bd_systemstatusctrol a, t_org_company b, t_bd_period d \n");
        sql.append("WHERE a.fcurrentperiodid = d.fid \n");
        sql.append(" AND a.fcompanyid = b.fid \n");
        sql.append(" AND a.fisstart = 1 \n");
        sql.append(" AND a.fsystemstatusid IN (SELECT fid AS fsystemstatusid \n");
        sql.append("                             FROM t_bd_systemstatus \n");
        sql.append("                            WHERE fname = " + SystemEnum.GENERALLEDGER.getValue() + ") \n");
        sql.append(" AND d.fisadjustperiod = 1 \n");
        sql.append(" AND b.fid = ? \n");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID});
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return false;
    }

    public static boolean isAlreadyAssign(Context ctx, String acctTableID, String currentCompanyID) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT top 1 fid \n");
        sql.append("  FROM t_bd_acctrefcontrast \n");
        sql.append(" WHERE FCompanyID in (SELECT fdestcompanyid \n");
        sql.append("                           FROM t_bd_acct_contorl \n");
        sql.append("                          WHERE faccounttableid = ? AND FSrcCompanyID = ?) \n");
        sql.append("   AND fenabledaccttableid = ? \n");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{acctTableID, currentCompanyID, acctTableID});
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return false;
    }

    public static boolean isAlreadyAssigned(Context ctx, String acctRefId) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT top 1 fid  FROM t_bd_acctrefcontrast WHERE FupperID = ? ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{acctRefId});
            if (rowSet != null && rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return false;
    }

    public static void checkAcctAlreadyInUse(Context ctx, String acctTableID, String currentCompanyID) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT top 1 a.fid AS acctid, b.fnumber AS comnumber, c.fnumber AS accttablenumber \n");
        sql.append("  FROM t_bd_accountview a INNER JOIN T_ORG_Company b ON a.FCompanyID = b.fid \n");
        sql.append("       INNER JOIN t_bd_accounttable c ON a.faccounttableid = c.fid \n");
        sql.append(" WHERE a.FCompanyID IN (SELECT fdestcompanyid \n");
        sql.append("                              FROM t_bd_acct_contorl \n");
        sql.append("                             WHERE faccounttableid = ? AND FSrcCompanyID = ?) AND a.faccounttableid = ?\n");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{acctTableID, currentCompanyID, acctTableID});
            if (rowSet.next()) {
                throw new AcctRefContrastException(AcctRefContrastException.ACCTALREADYINUSE, new Object[]{rowSet.getString(2), rowSet.getString(3)});
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
    }

    public static void updateContrastInfo(Context ctx, String companyID, String acctrefHeadID) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE t_bd_acctrefcontrast \n");
        sql.append("   SET fisEnabled = 1, fenabledTime =?, \n");
        sql.append("       fenabledperiodid = (SELECT fcurrentperiodid \n");
        sql.append("                             FROM t_bd_systemstatusctrol \n");
        sql.append("                            WHERE fcompanyid = (select top 1 fid from t_org_company WHERE fid = ? and fisbizunit = 1) \n");
        sql.append("                             AND fsystemstatusid = (SELECT fid AS fsystemstatusid \n");
        sql.append("                                                      FROM t_bd_systemstatus \n");
        sql.append("                                                     WHERE fname = " + SystemEnum.GENERALLEDGER.getValue() + ")) \n");
        sql.append(" WHERE fid = ? \n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{DateUtil.getSQLBegin((java.util.Date)DateUtil.getDayBegin()), companyID, acctrefHeadID});
    }

    public static void updateContrastInfo1(Context ctx, String companyID, String acctrefHeadID) throws EASBizException, BOSException {
        DateFormat sdf = BOSLocaleUtil.getDateFormat();
        String nowTime = sdf.format(new java.util.Date());
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE t_bd_acctrefcontrast \n");
        sql.append("   SET fisEnabled = 1,  fenabledTime = to_date('" + nowTime + "'),\n");
        sql.append("    fenabledperiodid = (SELECT fcurrentperiodid \n");
        sql.append("    FROM t_bd_systemstatusctrol \n");
        sql.append("    WHERE fcompanyid = (select top 1 fid from t_org_company WHERE fid = ? and fisbizunit = 1) \n");
        sql.append("    AND fsystemstatusid = (SELECT fid AS fsystemstatusid \n");
        sql.append("    FROM t_bd_systemstatus \n");
        sql.append("    WHERE fname = " + SystemEnum.GENERALLEDGER.getValue() + ")) \n");
        sql.append(" WHERE fid = ? \n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID, acctrefHeadID});
    }

    public static boolean isAcctRefAlreadyDisabled(Context ctx, String companyID, String acctrefHeadID) throws EASBizException, BOSException {
        SelectorItemCollection seleColl = new SelectorItemCollection();
        seleColl.add(new SelectorItemInfo("*"));
        seleColl.add(new SelectorItemInfo("disabledAcctTable.*"));
        AccountRefContrastInfo acctRefContrastInfo = AccountRefContrastFactory.getLocalInstance(ctx).getAccountRefContrastInfo((IObjectPK)new ObjectUuidPK(acctrefHeadID), seleColl);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT top 1 fid \n");
        sql.append("  FROM t_bd_acctrefcontrast \n");
        sql.append(" WHERE fdisabledaccttableid = (SELECT fenabledaccttableid \n");
        sql.append("  FROM t_bd_acctrefcontrast \n");
        sql.append("  WHERE fid = ?) AND FCompanyID = ? AND FRefType in (1,2) \n");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{acctrefHeadID, companyID});
            if (rowSet.next()) {
                return true;
            }
            sql = new StringBuffer();
            sql.append("SELECT top 1 fid \n");
            sql.append("  FROM t_bd_acctrefcontrast \n");
            sql.append(" WHERE fdisabledaccttableid = ? AND FCompanyID = ? AND FIsEnabled =1 AND FRefType in (1,2) \n");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{acctRefContrastInfo.getDisabledAcctTable().getId().toString(), companyID});
            if (rowSet != null && rowSet.next()) {
                throw new AcctRefContrastException(AcctRefContrastException.DISABLEDACCTTABLEALREADYUSED);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return false;
    }

    public static void changeAcctRefEntry(Context ctx, String companyID, String acctTableID, String newAcctID, String oldAcctID) throws EASBizException, BOSException {
        StringBuffer newAcctsql = new StringBuffer();
        newAcctsql.append("UPDATE t_bd_acctrefcontrastentry \n");
        newAcctsql.append("   SET fnewacctid = ? \n");
        newAcctsql.append(" WHERE facctrefcontrastid IN (SELECT fid \n");
        newAcctsql.append("                               FROM t_bd_acctrefcontrast \n");
        newAcctsql.append("                              WHERE FCompanyID = ? AND fenabledaccttableid = ?) AND fnewacctid = ? \n");
        DbUtil.execute((Context)ctx, (String)newAcctsql.toString(), (Object[])new Object[]{newAcctID, companyID, acctTableID, oldAcctID});
        StringBuffer oldAcctsql = new StringBuffer();
        oldAcctsql.append("UPDATE t_bd_acctrefcontrastentry \n");
        oldAcctsql.append("   SET foldacctid = ? \n");
        oldAcctsql.append(" WHERE facctrefcontrastid IN (SELECT fid \n");
        oldAcctsql.append("                               FROM t_bd_acctrefcontrast \n");
        oldAcctsql.append("                              WHERE FCompanyID = ? AND fdisabledaccttableid = ?) AND foldacctid = ? \n");
        DbUtil.execute((Context)ctx, (String)oldAcctsql.toString(), (Object[])new Object[]{newAcctID, companyID, acctTableID, oldAcctID});
    }

    public static void delAllAcctRef(Context ctx, String companyID, String acctTableID, String acctRefHeadID) throws EASBizException, BOSException {
        String delEntry = "DELETE FROM t_bd_acctrefcontrastentry WHERE facctrefcontrastid = ? AND fnewacctid NOT IN (SELECT fid FROM t_bd_accountview WHERE FCompanyID = ? AND faccounttableid = ?)";
        DbUtil.execute((Context)ctx, (String)delEntry, (Object[])new Object[]{acctRefHeadID, companyID, acctTableID});
        String delHead = "DELETE FROM t_bd_acctrefcontrast WHERE fid = ? AND NOT EXISTS (SELECT top 1 fid FROM t_bd_acctrefcontrastentry WHERE facctrefcontrastid = ?)";
        DbUtil.execute((Context)ctx, (String)delHead, (Object[])new Object[]{acctRefHeadID, acctRefHeadID});
    }

    public static void delAllAcctRef(Context ctx, AccountRefContrastEntryInfo acctRefEntry, AccountTableInfo newTable, AccountTableInfo oldTable, String curCompanyID) throws EASBizException, BOSException {
        if (acctRefEntry.getOldAcct().getLevel() == 1) {
            DbUtil.execute((Context)ctx, (String)("DELETE FROM t_bd_accountview WHERE flevel >1 AND FCompanyID = ? AND faccounttableid = ? AND flongnumber like '" + acctRefEntry.getNewAcct().getLongNumber() + "!%'"), (Object[])new Object[]{curCompanyID, newTable.getId().toString()});
            DbUtil.execute((Context)ctx, (String)("DELETE FROM t_bd_acctrefcontrastentry WHERE fid IN (SELECT a.fid FROM t_bd_acctrefcontrastentry a  INNER JOIN t_bd_accountview oldacct ON oldacct.fid = a.foldacctid WHERE oldacct.flevel > 1 AND a.facctrefcontrastid = ? AND oldacct.flongnumber like '" + acctRefEntry.getOldAcct().getLongNumber() + "!%')"), (Object[])new Object[]{acctRefEntry.getAcctRefContrast().getId().toString()});
            DbUtil.execute((Context)ctx, (String)"UPDATE t_bd_accountview SET fisleaf = 1 WHERE FCompanyID = ? AND faccounttableid = ? AND fnumber=?", (Object[])new Object[]{curCompanyID, newTable.getId().toString(), acctRefEntry.getNewAcct().getNumber()});
        }
    }

    private static boolean hasBank(boolean hasBank, AccountViewInfo oldAccount) {
        if (hasBank) {
            return true;
        }
        if (oldAccount.isIsBank() || oldAccount.isIsCash()) {
            return false;
        }
        return hasBank;
    }

    public static void copyAllRefAcct(Context ctx, AccountRefContrastEntryInfo acctRefEntry, AccountTableInfo newTable, AccountTableInfo oldTable, String upperCompanyID, String curCompanyID, boolean isIncludeFreezeAcct) throws EASBizException, BOSException {
        String companyid = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        boolean hasBank = AccountTools.getDefaultGLParam(ctx, companyid, "AccountRefBank");
        if (acctRefEntry.getOldAcct().getLevel() == 1 && AcctRefContrastHelper.hasBank(hasBank, acctRefEntry.getOldAcct())) {
            DbUtil.execute((Context)ctx, (String)("DELETE FROM t_bd_accountview WHERE flevel >1 AND FCompanyID = ? AND faccounttableid = ? AND flongnumber like '" + acctRefEntry.getNewAcct().getLongNumber() + "!%'"), (Object[])new Object[]{curCompanyID, newTable.getId().toString()});
            DbUtil.execute((Context)ctx, (String)("DELETE FROM t_bd_acctrefcontrastentry WHERE fid IN (SELECT a.fid FROM t_bd_acctrefcontrastentry a  INNER JOIN t_bd_accountview oldacct ON oldacct.fid = a.foldacctid WHERE oldacct.flevel > 1 AND a.facctrefcontrastid = ? AND oldacct.flongnumber like '" + acctRefEntry.getOldAcct().getLongNumber() + "!%')"), (Object[])new Object[]{acctRefEntry.getAcctRefContrast().getId().toString()});
            AccountViewCollection oldAcctCol = AccountViewFactory.getLocalInstance(ctx).getAccountViewCollection("select *,accountTypeID.*,accountCurrency.* where companyID.id='" + curCompanyID + "' and accountTableID.id='" + oldTable.getId().toString() + "' and longnumber like '" + acctRefEntry.getOldAcct().getLongNumber() + "!%'" + (isIncludeFreezeAcct ? "" : " and isCFreeze = 0 ") + " order by longnumber");
            AcctRefContrastHelper.dealLevel1AcctInfo(ctx, acctRefEntry, newTable, oldTable, upperCompanyID, curCompanyID);
            AcctRefContrastHelper.dealNoneLevel1AcctInfo(ctx, oldAcctCol, acctRefEntry, newTable, oldTable, upperCompanyID, curCompanyID);
            DbUtil.execute((Context)ctx, (String)("UPDATE t_bd_accountview SET fisleaf = " + (oldAcctCol.size() < 1 ? 1 : 0) + " WHERE FCompanyID = ? AND faccounttableid = ? AND fnumber=?"), (Object[])new Object[]{curCompanyID, newTable.getId().toString(), acctRefEntry.getNewAcct().getNumber()});
        }
    }

    public static void dealLevel1AcctInfo(Context ctx, AccountRefContrastEntryInfo acctRefEntry, AccountTableInfo newTable, AccountTableInfo oldTable, String upperCompanyID, String curCompanyID) throws EASBizException, BOSException {
        AccountViewInfo level1AcctInfo = AccountViewFactory.getLocalInstance(ctx).getAccountViewInfo("select *,accountTypeID.*,accountCurrency.* where companyID.id='" + curCompanyID + "' and accountTableID.id='" + oldTable.getId().toString() + "' and number = '" + acctRefEntry.getOldAcct().getNumber() + "'");
        AcctRefContrastHelper.dealAcctInfo(ctx, level1AcctInfo, acctRefEntry, newTable, oldTable, upperCompanyID, curCompanyID);
        level1AcctInfo.setId(acctRefEntry.getNewAcct().getId());
        level1AcctInfo.setNumber(acctRefEntry.getNewAcct().getNumber());
        level1AcctInfo.setLongNumber(acctRefEntry.getNewAcct().getLongNumber());
        level1AcctInfo.setName(acctRefEntry.getNewAcct().getName());
        level1AcctInfo.setLongName(acctRefEntry.getNewAcct().getLongName());
        level1AcctInfo.setDisplayName(acctRefEntry.getNewAcct().getLongName());
        AccountViewFactory.getLocalInstance(ctx).updateSelf((IObjectPK)new ObjectUuidPK(level1AcctInfo.getId().toString()), (IObjectValue)level1AcctInfo);
    }

    public static void dealNoneLevel1AcctInfo(Context ctx, AccountViewCollection oldAcctCol, AccountRefContrastEntryInfo acctRefEntry, AccountTableInfo newTable, AccountTableInfo oldTable, String upperCompanyID, String curCompanyID) throws EASBizException, BOSException {
        for (int i = 0; i < oldAcctCol.size(); ++i) {
            AccountViewInfo acctInfo = (AccountViewInfo)oldAcctCol.get(i).clone();
            AcctRefContrastHelper.dealAcctInfo(ctx, acctInfo, acctRefEntry, newTable, oldTable, upperCompanyID, curCompanyID);
            AccountViewFactory.getLocalInstance(ctx).submitSelf((IObjectValue)acctInfo);
            AccountRefContrastEntryInfo newRef = (AccountRefContrastEntryInfo)acctRefEntry.clone();
            newRef.setOldAcct(oldAcctCol.get(i));
            newRef.setNewAcct(acctInfo);
            newRef.setOldAcctName(oldAcctCol.get(i).getName());
            newRef.setOldAcctNumber(oldAcctCol.get(i).getNumber());
            newRef.setId(null);
            AccountRefContrastEntryFactory.getLocalInstance(ctx).submit((CoreBaseInfo)newRef);
        }
    }

    public static void dealAcctInfo(Context ctx, AccountViewInfo acctInfo, AccountRefContrastEntryInfo acctRefEntry, AccountTableInfo newTable, AccountTableInfo oldTable, String upperCompanyID, String curCompanyID) throws EASBizException, BOSException {
        AccountViewCollection acctCol = new AccountViewCollection();
        String newNumber = AcctRefContrastHelper.dealNumber(acctInfo.getNumber(), acctInfo.getLevel(), newTable, oldTable);
        AcctRefContrastHelper.checkAcctNumber(acctInfo.getNumber(), acctInfo.getLevel(), oldTable);
        AcctRefContrastHelper.checkAcctNumber(newNumber, acctInfo.getLevel(), newTable);
        String longNumber = "";
        StringTokenizer st = new StringTokenizer(acctInfo.getLongNumber(), "!");
        int count2 = st.countTokens();
        for (int count1 = 0; count1 < count2; ++count1) {
            String tmp = (String)st.nextElement();
            longNumber = longNumber + (longNumber.length() == 0 ? "" : "!") + AcctRefContrastHelper.dealNumber(tmp, count1 + 1, newTable, oldTable);
        }
        acctInfo.setId(null);
        acctInfo.setNumber(newNumber.replaceAll(acctRefEntry.getOldAcct().getNumber(), acctRefEntry.getNewAcct().getNumber()));
        acctInfo.setLongNumber(longNumber.replaceAll(acctRefEntry.getOldAcct().getNumber(), acctRefEntry.getNewAcct().getNumber()));
        acctInfo.setName(acctInfo.getName().replaceAll(acctRefEntry.getOldAcct().getName(), acctRefEntry.getNewAcct().getName()));
        acctInfo.setLongName(acctInfo.getLongName().replaceAll(acctRefEntry.getOldAcct().getName(), acctRefEntry.getNewAcct().getName()));
        acctInfo.setDisplayName(acctInfo.getDisplayName().replaceAll(acctRefEntry.getOldAcct().getName(), acctRefEntry.getNewAcct().getName()));
        acctInfo.setAccountTableID(newTable);
        acctInfo.setAccountTypeID(acctRefEntry.getNewAcct().getAccountTypeID());
        if (upperCompanyID != null && upperCompanyID.length() > 0) {
            acctCol = AccountViewFactory.getLocalInstance(ctx).getAccountViewCollection("select id where companyID.id='" + upperCompanyID + "' and accountTableID.id='" + newTable.getId().toString() + "' and number='" + acctInfo.getNumber() + "'");
        }
        acctInfo.setUpper(acctInfo.getUpper() != null && acctInfo.getUpper().getId() != null && acctCol.size() > 0 ? acctCol.get(0) : null);
        if (curCompanyID != null && curCompanyID.length() > 0) {
            acctCol = AccountViewFactory.getLocalInstance(ctx).getAccountViewCollection("select id where companyID.id='" + curCompanyID + "' and accountTableID.id='" + newTable.getId().toString() + "' and number='" + AcctRefContrastHelper.getParentNumber(acctInfo.getNumber(), acctInfo.getLevel(), newTable) + "'");
        }
        if (acctCol.size() < 1 && acctInfo.getLevel() > 1) {
            throw new AcctRefContrastException(AcctRefContrastException.NOACCTPARENT, new Object[]{newTable.getName(), acctInfo.getNumber(), new Integer(acctInfo.getLevel()), AcctRefContrastHelper.getParentNumber(acctInfo.getNumber(), acctInfo.getLevel(), newTable)});
        }
        acctInfo.setParent(acctCol.size() > 0 ? acctCol.get(0) : null);
        acctInfo.setIsLeaf(acctInfo.getParent() == null);
        for (int count = 0; count < acctInfo.getAccountCurrency().size(); ++count) {
            acctInfo.getAccountCurrency().get(count).setId(null);
            acctInfo.getAccountCurrency().get(count).setAccountView(acctInfo);
        }
    }

    public static String getParentNumber(String number, int level, AccountTableInfo acctTable) {
        String result = "";
        String tmp = number;
        for (int i = 1; i < level; ++i) {
            for (int j = 0; j < acctTable.getUserLevel().size(); ++j) {
                if (acctTable.getUserLevel().get(j).getLevel() != i) continue;
                result = result + (i != 1 && acctTable.isIsUseSeparator() ? acctTable.getSeparator() : "") + tmp.substring(0, acctTable.getUserLevel().get(j).getLength());
                tmp = tmp.substring(acctTable.getUserLevel().get(j).getLength() + (acctTable.isIsUseSeparator() ? acctTable.getSeparator().length() : 0), tmp.length());
            }
        }
        return result;
    }

    public static void checkAcctNumber(String number, int level, AccountTableInfo acctTable) throws EASBizException {
        int length = 0;
        for (int i = 1; i <= level; ++i) {
            for (int j = 0; j < acctTable.getUserLevel().size(); ++j) {
                if (acctTable.getUserLevel().get(j).getLevel() != i) continue;
                length += acctTable.getUserLevel().get(j).getLength() + (i < level && acctTable.isIsUseSeparator() ? acctTable.getSeparator().length() : 0);
            }
        }
        if (length != number.length()) {
            throw new AcctRefContrastException(AcctRefContrastException.ACCTNUMBERLENGTHERR, new Object[]{number, String.valueOf(length)});
        }
    }

    public static String dealNumber(String number, int level, AccountTableInfo newTable, AccountTableInfo oldTable) throws EASBizException {
        if (!oldTable.isIsUseSeparator() && !newTable.isIsUseSeparator()) {
            return number;
        }
        String tmp = number;
        String result = "";
        for (int i = 1; i <= level; ++i) {
            for (int j = 0; j < oldTable.getUserLevel().size(); ++j) {
                if (oldTable.getUserLevel().get(j).getLevel() != i) continue;
                result = result + (i != 1 && newTable.isIsUseSeparator() ? newTable.getSeparator() : "") + tmp.substring(0, oldTable.getUserLevel().get(j).getLength());
                tmp = tmp.substring(oldTable.getUserLevel().get(j).getLength() + (level != i && oldTable.isIsUseSeparator() ? oldTable.getSeparator().length() : 0), tmp.length());
            }
        }
        return result;
    }

    public static StringBuffer getCopyAcctRefSQL(String acctRefHeadID, String upperCompany, AccountViewInfo acctInfo) {
        StringBuffer result = new StringBuffer();
        result.append("INSERT INTO t_bd_acctrefcontrastentry \n").append("    (fid, facctrefcontrastid, foldacctid, fnewacctid, foldacctnumber, foldacctname_l1, foldacctname_l2, foldacctname_l3, fseq)\n").append("\t   SELECT newbosid ('0EC0F8BE'), '").append(acctRefHeadID).append("', acct.fid AS oldacctid, ").append("(select top 1 fid from t_bd_accountview where FCompanyID ='").append(acctInfo.getCompanyID().getId().toString()).append("' and faccounttableid='").append(acctInfo.getAccountTableID().getId().toString()).append("' and fnumber='").append(acctInfo.getNumber()).append("' ),acct.fnumber, acct.fname_l1, acct.fname_l2, acct.fname_l3,\n").append("\t          (SELECT MAX (fseq) FROM t_bd_acctrefcontrastentry WHERE facctrefcontrastid = '" + acctRefHeadID + "') \n").append("\t     FROM t_bd_accountview acct\n").append("\t    WHERE acct.fupperid =  \n").append("\t             (SELECT top 1 b.foldacctid \n").append("\t                FROM t_bd_acctrefcontrast a INNER JOIN t_bd_acctrefcontrastentry b ON a.fid = b.facctrefcontrastid \n").append("\t               WHERE a.FCompanyID = '").append(upperCompany).append("' AND a.fenabledaccttableid = '").append(acctInfo.getAccountTableID().getId().toString()).append("'  AND b.fnewacctid = '").append(acctInfo.getUpper().getId().toString()).append("') \n").append("\t      AND acct.FCompanyID = '").append(acctInfo.getCompanyID().getId().toString()).append("' \n");
        return result;
    }

    public static StringBuffer getCopyAcctRefSQL(String acctRefHeadID, String accountid) {
        StringBuffer result = new StringBuffer();
        result.append("INSERT INTO t_bd_acctrefcontrastentry \n");
        result.append("    (fid, facctrefcontrastid, foldacctid, fnewacctid, foldacctnumber, foldacctname_l1, foldacctname_l2, foldacctname_l3, fseq)\n");
        result.append("\t   SELECT newbosid ('0EC0F8BE'), '" + acctRefHeadID + "', acct.fid AS oldacctid, (select fid from t_bd_accountview where FCompanyID =? and faccounttableid=? and fnumber=? ),acct.fnumber, acct.fname_l1, acct.fname_l2, acct.fname_l3,\n");
        result.append("\t          (SELECT MAX (fseq) FROM t_bd_acctrefcontrastentry WHERE facctrefcontrastid = '" + acctRefHeadID + "')\n");
        result.append("\t     FROM t_bd_accountview acct\n");
        result.append("\t    WHERE acct.fupperid =  \n");
        result.append("\t             (SELECT b.foldacctid             \n");
        result.append("\t                FROM t_bd_acctrefcontrast a INNER JOIN t_bd_acctrefcontrastentry b ON a.fid = b.facctrefcontrastid  \n");
        result.append("\t               WHERE a.FCompanyID = ? AND a.fenabledaccttableid = ?  AND b.fnewacctid = ?     )                     \n");
        result.append("\t      AND acct.FCompanyID = ? \n");
        return result;
    }

    public static void enable(Context ctx, BOSUuid objID) throws EASBizException, BOSException {
        String[] checkers = null;
        String companyid = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        String acrefid = objID.toString();
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)objID.getType().toString(), IAccountRefContrastProcess.class);
        }
        catch (EASDBException e) {
            throw new BizHasDealException(BizHasDealException.SQL_ERR, (Throwable)e);
        }
        if (checkers == null || checkers.length == 0) {
            return;
        }
        String checkerName = "";
        try {
            int i;
            for (i = 0; i < checkers.length; ++i) {
                if (checkers[i].toLowerCase().indexOf("fi.gl.") >= 0) continue;
                checkerName = checkers[i];
                ((IAccountRefContrastProcess)Class.forName(checkerName).newInstance()).enable(ctx, companyid, acrefid);
            }
            for (i = 0; i < checkers.length; ++i) {
                if (checkers[i].toLowerCase().indexOf("fi.gl.") < 0) continue;
                checkerName = checkers[i];
                ((IAccountRefContrastProcess)Class.forName(checkerName).newInstance()).enable(ctx, companyid, acrefid);
            }
        }
        catch (Exception e) {
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new BOSException((Throwable)e);
        }
    }

    public static void disEnable(Context ctx, BOSUuid objID) throws EASBizException, BOSException {
        String[] checkers = null;
        String companyid = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        String acrefid = objID.toString();
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)objID.getType().toString(), IAccountRefContrastProcess.class);
        }
        catch (EASDBException e) {
            throw new BizHasDealException(BizHasDealException.SQL_ERR, (Throwable)e);
        }
        if (checkers == null || checkers.length == 0) {
            return;
        }
        String checkerName = "";
        try {
            int i;
            for (i = 0; i < checkers.length; ++i) {
                if (checkers[i].toLowerCase().indexOf("fi.gl.") >= 0) continue;
                checkerName = checkers[i];
                ((IAccountRefContrastProcess)Class.forName(checkerName).newInstance()).disEnable(ctx, companyid, acrefid);
            }
            for (i = 0; i < checkers.length; ++i) {
                if (checkers[i].toLowerCase().indexOf("fi.gl.") < 0) continue;
                checkerName = checkers[i];
                ((IAccountRefContrastProcess)Class.forName(checkerName).newInstance()).disEnable(ctx, companyid, acrefid);
            }
        }
        catch (Exception e) {
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            String errorMessage = e.getMessage();
            if (!StringUtils.isEmpty((String)errorMessage) && errorMessage.indexOf("is:") > 0) {
                int index = errorMessage.indexOf("is:");
                errorMessage = errorMessage.substring(index + 3);
            }
            throw new AcctRefContrastException(AcctRefContrastException.DISABLEFAIL, new Object[]{errorMessage});
        }
    }

    private static String getParentFullName(String fullname) {
        String result = "";
        if (fullname.indexOf(".app.") >= 0) {
            result = fullname.substring(0, fullname.indexOf(".app."));
        } else if (fullname.indexOf(".client.") >= 0) {
            result = fullname.substring(0, fullname.indexOf(".client."));
        } else if (fullname.indexOf(".") != -1) {
            result = fullname.substring(0, fullname.lastIndexOf("."));
        }
        return result + (result.lastIndexOf(".") < 0 ? "" : result.substring(result.lastIndexOf(".")));
    }

    public static String getSubSystemName(Context ctx, String fullName) {
        if (fullName == null || fullName.length() == 0) {
            return "";
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        AbstractMetaDataValue info = (AbstractMetaDataValue)loader.get(MetaDataTypeList.PACKAGE, (IMetaDataPK)new MetaDataPK(AcctRefContrastHelper.getParentFullName(fullName)));
        return info == null ? "" : (info.getAlias() != null ? info.getAlias() : info.getName());
    }

    public static Date isSrcAcctEndEqAdjustPeriod(Context ctx, String acctRefID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct per.fenddate as enddate from t_bd_acctrefcontrast renf ").append("inner join T_BD_AccountTable acct on renf.FDisabledAcctTableID=acct.fid ").append("inner join T_BD_period per on to_char(per.fenddate,'yyyy-mm-dd')=to_char(acct.FAvailDataTo,'yyyy-mm-dd')").append(" where renf.fid='" + acctRefID + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        Date date = null;
        if (rs.size() == 0 || rs == null) {
            return null;
        }
        try {
            while (rs.next()) {
                date = rs.getDate("enddate");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return date;
    }
}

