/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AbstractMulDataTransmission;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AcctRefContrastException;
import com.kingdee.eas.basedata.master.account.AcctRefContrastImportException;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.RefTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.Hashtable;
import java.util.Locale;

public class NewOldAcctRefDataImport
extends AbstractMulDataTransmission {
    protected CoreBaseInfo createHead(Hashtable hsData, Context ctx) throws Exception {
        Locale locale = ctx.getLocale();
        AccountRefContrastInfo info = new AccountRefContrastInfo();
        info.setRefType(RefTypeEnum.NEWOLD);
        CompanyOrgUnitInfo curCompany = this.getCompany(hsData, ctx);
        info.setCompany(curCompany);
        info.setIsIncludeFreezeAcct(true);
        info.setIsEnabled(false);
        boolean hasPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "bd_account_accountRefContrast_addNew");
        if (!hasPermission) {
            throw new AcctRefContrastException(AcctRefContrastException.NOT_HAS_ADD_PERMISSION, new Object[]{info.getCompany().getName()});
        }
        String srcAccountTableNumber = (String)((DataToken)hsData.get((Object)"FSrcAccountTableNumber")).data;
        String destAccountTableNumber = (String)((DataToken)hsData.get((Object)"FDestAccountTableNumber")).data;
        if (!StringUtils.isEmpty((String)srcAccountTableNumber) && !StringUtils.isEmpty((String)destAccountTableNumber) && srcAccountTableNumber.equals(destAccountTableNumber)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.basedata.master.account.AcctRefContrastResource.sameAcctTable", (Locale)locale));
        }
        AccountTableCollection desAccountTable = AccountTableFactory.getLocalInstance(ctx).getAccountTableCollection(this.buildAccountTableFilter(curCompany, destAccountTableNumber));
        if (desAccountTable.size() < 1) {
            throw new AcctRefContrastException(AcctRefContrastException.DEST_ACCOUNTTABLE_NOT_IN_COMPANY, new Object[]{curCompany.getName(), destAccountTableNumber});
        }
        info.setEnabledAcctTable(desAccountTable.get(0));
        AccountTableInfo destTable = desAccountTable.get(0);
        AccountTableCollection srcAccountTable = AccountTableFactory.getLocalInstance(ctx).getAccountTableCollection(this.buildAccountTableFilter(curCompany, srcAccountTableNumber));
        if (srcAccountTable.size() < 1) {
            throw new AcctRefContrastException(AcctRefContrastException.SRC_ACCOUNTTABLE_NOT_IN_COMPANY, new Object[]{curCompany.getName(), srcAccountTableNumber});
        }
        info.setDisabledAcctTable(srcAccountTable.get(0));
        AccountTableInfo srcTable = srcAccountTable.get(0);
        for (int i = 0; i < srcTable.getUserLevel().size(); ++i) {
            for (int j = 0; j < destTable.getUserLevel().size(); ++j) {
                if (srcTable.getUserLevel().get(i).getLevel() != destTable.getUserLevel().get(j).getLevel() || srcTable.getUserLevel().get(i).getLength() == destTable.getUserLevel().get(j).getLength()) continue;
                throw new AcctRefContrastException(AcctRefContrastException.ACCTTABLELENGTHDIF);
            }
        }
        boolean exitAcctRef = AccountRefContrastFactory.getLocalInstance(ctx).exists("select fid where ( (disabledAcctTable.id='" + srcTable.getId().toString() + "' and enabledAcctTable.id='" + destTable.getId().toString() + "' ) or ( disabledAcctTable.id='" + destTable.getId().toString() + "' and enabledAcctTable.id='" + srcTable.getId().toString() + "')) and company.id='" + curCompany.getId().toString() + "' and refType= 1 ");
        if (exitAcctRef) {
            throw new AcctRefContrastException(AcctRefContrastException.ALREADYREF, new Object[]{srcTable.getName(), destTable.getName()});
        }
        return info;
    }

    public CompanyOrgUnitInfo getCompany(Hashtable hsData, Context ctx) throws Exception {
        CompanyOrgUnitInfo curCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        return curCompany;
    }

    private EntityViewInfo buildAccountTableFilter(CompanyOrgUnitInfo company, String accountTableNumber) {
        FilterInfo filter = new FilterInfo();
        String sql = "select faccounttableid  from t_bd_acct_contorl where fdestcompanyid ='" + company.getId().toString() + "'";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountTableNumber, CompareType.EQUALS));
        EntityViewInfo entryViewInfo = new EntityViewInfo();
        entryViewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("userLevel.*"));
        return entryViewInfo;
    }

    private EntityViewInfo buildAccountFilter(CompanyOrgUnitInfo company, AccountTableInfo accountTable, String acctNumber) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)acctNumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString(), CompareType.EQUALS));
        EntityViewInfo entryViewInfo = new EntityViewInfo();
        entryViewInfo.setFilter(filter);
        entryViewInfo.setSelector(sic);
        return entryViewInfo;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        StringBuilder msg = new StringBuilder();
        try {
            CoreBaseInfo head = null;
            String srcAccountTableNumber = "";
            String destAccountTableNumber = "";
            for (int i = 0; i < hsData.size(); ++i) {
                Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
                if (i == 0) {
                    head = this.createHead(lineData, ctx);
                    if (head == null) {
                        return null;
                    }
                    srcAccountTableNumber = (String)((DataToken)lineData.get((Object)"FSrcAccountTableNumber")).data;
                    destAccountTableNumber = (String)((DataToken)lineData.get((Object)"FDestAccountTableNumber")).data;
                } else if (!srcAccountTableNumber.equals((String)((DataToken)lineData.get((Object)"FSrcAccountTableNumber")).data) || !destAccountTableNumber.equals((String)((DataToken)lineData.get((Object)"FDestAccountTableNumber")).data)) {
                    throw new AcctRefContrastImportException(AcctRefContrastImportException.SAMEBLOCKCANNOTSAME);
                }
                try {
                    this.createEntry(head, lineData, ctx);
                    continue;
                }
                catch (EASBizException ee) {
                    msg.append(EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importNo", (Locale)ctx.getLocale()));
                    msg.append(i + 5);
                    msg.append(EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"lineData", (Locale)ctx.getLocale()));
                    msg.append(ee.getMessage());
                    msg.append(";\n");
                }
            }
            if (msg.length() != 0) {
                throw new TaskExternalException(msg.toString());
            }
            return head;
        }
        catch (TaskExternalException te) {
            throw te;
        }
        catch (EASBizException ee) {
            throw new TaskExternalException(ee.getMessage());
        }
        catch (Exception e) {
            String excLinkStackTrace = ExceptionUtil.getExcLinkStackTrace((Throwable)e);
            throw new TaskExternalException(excLinkStackTrace);
        }
    }

    protected void createEntry(CoreBaseInfo head, Hashtable hsData, Context ctx) throws Exception {
        Locale locale = ctx.getLocale();
        AccountRefContrastInfo parent = (AccountRefContrastInfo)head;
        AccountRefContrastEntryInfo entry = new AccountRefContrastEntryInfo();
        String srcAccountNumber = (String)((DataToken)hsData.get((Object)"FSrcAccountNumber")).data;
        String destAccountNumber = (String)((DataToken)hsData.get((Object)"FDestAccountNumber")).data;
        IAccountView instance = AccountViewFactory.getLocalInstance(ctx);
        AccountViewCollection srcAccount = instance.getAccountViewCollection(this.buildAccountFilter(parent.getCompany(), parent.getDisabledAcctTable(), srcAccountNumber));
        if (srcAccount.size() < 1) {
            throw new AcctRefContrastException(AcctRefContrastException.ACCOUNTTABLE_NOT_HAS_ACCOUNT, new Object[]{parent.getCompany().getName(), parent.getDisabledAcctTable().getName(), srcAccountNumber});
        }
        AccountViewInfo srcAccountInfo = srcAccount.get(0);
        if (srcAccountInfo.isIsCFreeze()) {
            throw new AcctRefContrastException(AcctRefContrastException.SRC_ACCOUNT_IS_NOT_ENABLE, new Object[]{srcAccountNumber});
        }
        entry.setOldAcct(srcAccountInfo);
        AccountViewCollection destAccount = instance.getAccountViewCollection(this.buildAccountFilter(parent.getCompany(), parent.getEnabledAcctTable(), destAccountNumber));
        if (destAccount.size() < 1) {
            throw new AcctRefContrastException(AcctRefContrastException.ACCOUNTTABLE_NOT_HAS_ACCOUNT, new Object[]{parent.getCompany().getName(), parent.getEnabledAcctTable().getName(), destAccountNumber});
        }
        AccountViewInfo destAccountInfo = destAccount.get(0);
        if (destAccountInfo.isIsCFreeze()) {
            throw new AcctRefContrastException(AcctRefContrastException.DEST_ACCOUNT_IS_NOT_ENABLE, new Object[]{destAccountNumber});
        }
        entry.setNewAcct(destAccountInfo);
        if (destAccountInfo.isBw() && !srcAccountInfo.isBw() || !destAccountInfo.isBw() && srcAccountInfo.isBw()) {
            throw new AcctRefContrastImportException(AcctRefContrastImportException.BWNOTSAME, new Object[]{destAccountInfo.getNumber(), srcAccountInfo.getNumber()});
        }
        if (destAccountInfo.isAC() && !srcAccountInfo.isAC() || !destAccountInfo.isAC() && srcAccountInfo.isAC()) {
            throw new AcctRefContrastImportException(AcctRefContrastImportException.ACNOTSAME, new Object[]{destAccountInfo.getNumber(), srcAccountInfo.getNumber()});
        }
        if (destAccountInfo.isHasUserProperty() && !srcAccountInfo.isHasUserProperty() || !destAccountInfo.isHasUserProperty() && srcAccountInfo.isHasUserProperty()) {
            throw new AcctRefContrastImportException(AcctRefContrastImportException.PROPERTYNOTSAME, new Object[]{destAccountInfo.getNumber(), srcAccountInfo.getNumber()});
        }
        if (destAccountInfo.isIsLeaf() && !srcAccountInfo.isIsLeaf() || !destAccountInfo.isIsLeaf() && srcAccountInfo.isIsLeaf()) {
            throw new AcctRefContrastImportException(AcctRefContrastImportException.LEAFNOTSAME, new Object[]{destAccountInfo.getNumber(), srcAccountInfo.getNumber()});
        }
        if (destAccountInfo.isIsQty() && !srcAccountInfo.isIsQty() || !destAccountInfo.isIsQty() && srcAccountInfo.isIsQty()) {
            throw new AcctRefContrastImportException(AcctRefContrastImportException.QTYNOTSAME, new Object[]{destAccountInfo.getNumber(), srcAccountInfo.getNumber()});
        }
        if (destAccountInfo.getMeasureUnitGroupID() == null && srcAccountInfo.getMeasureUnitGroupID() != null || destAccountInfo.getMeasureUnitGroupID() != null && srcAccountInfo.getMeasureUnitGroupID() == null || destAccountInfo.getMeasureUnitGroupID() != null && !destAccountInfo.getMeasureUnitGroupID().getId().toString().equals(srcAccountInfo.getMeasureUnitGroupID().getId().toString())) {
            throw new AcctRefContrastImportException(AcctRefContrastImportException.MEASURENOTSAME, new Object[]{destAccountInfo.getNumber(), srcAccountInfo.getNumber()});
        }
        parent.getAcctRefContrastEntry().add(entry);
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return AccountRefContrastFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        return true;
    }
}

