/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.cm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.cm.CostItemException;
import com.kingdee.eas.basedata.cm.CostItemInfo;
import com.kingdee.eas.basedata.cm.app.AbstractCostItemControllerBean;
import com.kingdee.eas.basedata.cm.util.STUtils;
import com.kingdee.eas.basedata.master.auxacct.app.AssistUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;

public class CostItemControllerBean
extends AbstractCostItemControllerBean {
    private static final long serialVersionUID = 8877805875215464248L;

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CostItemInfo cii = (CostItemInfo)model;
        cii.setDeletedStatus(DeletedStatusEnum.NORMAL);
        this.addnewCheck(ctx, cii);
        super._addnew(ctx, pk, (IObjectValue)cii);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CostItemInfo cii = (CostItemInfo)model;
        cii.setDeletedStatus(DeletedStatusEnum.NORMAL);
        this.addnewCheck(ctx, cii);
        return super._addnew(ctx, (IObjectValue)cii);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk;
        CostItemInfo cii = (CostItemInfo)model;
        if (cii != null && cii.getId() == null) {
            cii.setDeletedStatus(DeletedStatusEnum.NORMAL);
        }
        if ((pk = super._submit(ctx, (IObjectValue)cii)) != null && cii != null) {
            AssistUtil.updateAssist((Context)ctx, (String)pk.toString(), (BOSObjectType)cii.getBOSType());
        }
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._isReferenced(ctx, pk);
        if (pk == null) {
            return;
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"Select FId From T_CM_CostItem Where FId =? And FIsSystem <> 0 ", (Object[])new Object[]{pk.toString()});
        try {
            if (rs != null && rs.next()) {
                throw new CostItemException(CostItemException.EXC_ITEM_SYS_DEL);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)"Select FId From T_CM_CostItem Where FId = ? And FIsLeaf = 0 ", (Object[])new Object[]{pk.toString()});
            if (rs != null && rs.next()) {
                throw new CostItemException(CostItemException.EXC_ITEM_NOT_LEAF_DEL);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CostItemInfo oldModel = this.getCostItemInfo(ctx, pk);
        if (!((DataBaseInfo)model).getName().equals(oldModel.getName())) {
            this.checkNameDup(ctx, (CostItemInfo)model);
        }
        if (!((DataBaseInfo)model).getNumber().equals(oldModel.getNumber())) {
            this.checkNumberDup(ctx, (CostItemInfo)model);
        }
        if (pk != null && model != null) {
            AssistUtil.updateAssist((Context)ctx, (String)pk.toString(), (BOSObjectType)model.getBOSType());
        }
        super._update(ctx, pk, model);
    }

    protected void addnewCheck(Context ctx, CostItemInfo model) throws BOSException, EASBizException {
        this.checkNumberDup(ctx, model);
        this.checkNameDup(ctx, model);
    }

    protected void checkNumberDup(Context ctx, CostItemInfo model) throws BOSException, EASBizException {
        if (model != null) {
            String number = model.getNumber();
            if (StringUtils.isEmpty((String)number)) {
                throw new EASBizException(EASBizException.CHECKNUMBLANK);
            }
            ArrayList<String> params = new ArrayList<String>();
            StringBuffer strSQL = new StringBuffer();
            strSQL.append("Select top 1 FId From T_CM_CostItem Where FNumber = ? ");
            params.add(number);
            if (model.getId() != null) {
                strSQL.append(" And FId <> ? ");
                params.add(model.getId().toString());
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])params.toArray());
            try {
                if (rs != null && rs.next()) {
                    throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    protected void checkNameDup(Context ctx, CostItemInfo model) throws BOSException, EASBizException {
        if (model != null) {
            String name = model.getName();
            if (StringUtils.isEmpty((String)name)) {
                throw new EASBizException(EASBizException.CHECKNAMEBLANK);
            }
            StringBuffer s = new StringBuffer("_");
            if (STUtils.isNotNull(ctx.getLocale())) {
                s.append(ctx.getLocale().getLanguage());
            } else {
                s.append("L2");
            }
            ArrayList<String> params = new ArrayList<String>();
            StringBuffer strSQL = new StringBuffer();
            strSQL.append("Select top 1 FId From T_CM_CostItem Where FName").append(s.toString()).append(" = ? ");
            params.add(name);
            if (model.getId() != null) {
                strSQL.append(" And FId <> ? ");
                params.add(model.getId().toString());
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])params.toArray());
            try {
                if (rs != null && rs.next()) {
                    throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    protected IRowSet _buildTreeRowSetByCUFilter(Context ctx, String cuID, String companyOrgUnitID) throws BOSException {
        String nameFieldName = "FName_" + LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        String descriptionFieldName = "FDescription_" + LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("SELECT FID as id,").append(nameFieldName).append(" as name,FLongNumber as longnumber,FNumber as number,");
        strSQL.append(" FLevel as level1,FIsLeaf isLeaf,").append(descriptionFieldName).append(" as description,FParentID as parentID ");
        strSQL.append(" FROM T_CM_CostItem ");
        strSQL.append(" WHERE (FControlUnitID = ?)");
        if (companyOrgUnitID != null) {
            strSQL.append(" AND (FCompanyOrgUnitID = ?)");
        }
        strSQL.append(" ORDER BY FLongNumber ");
        ArrayList<String> param = new ArrayList<String>();
        param.add(cuID);
        if (companyOrgUnitID != null) {
            param.add(companyOrgUnitID);
        }
        return DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])param.toArray());
    }
}

