/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.cm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.cm.util.NumericUtils;
import com.kingdee.eas.basedata.cm.util.STConstant;
import com.kingdee.eas.basedata.cm.util.STUtils;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import java.math.BigDecimal;

public abstract class QtyMultiMeasureUtils {
    public static final int POSINDEX_SOURCEBASERATE = 0;
    public static final int POSINDEX_TARGETBASERATE = 1;

    public static BigDecimal baseExchangeRate(MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.multiUnitBaseExchangeRate(QtyMultiMeasureUtils.multiMeasureUnit(null, material, unit));
    }

    public static BigDecimal baseExchangeRate(Context ctx, MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.multiUnitBaseExchangeRate(QtyMultiMeasureUtils.multiMeasureUnit(ctx, material, unit));
    }

    public static int qtyPrecision(MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.multiUnitQTYPrecision(QtyMultiMeasureUtils.multiMeasureUnit(null, material, unit));
    }

    public static int qtyPrecision(Context ctx, MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.multiUnitQTYPrecision(QtyMultiMeasureUtils.multiMeasureUnit(ctx, material, unit));
    }

    public static BigDecimal effectualExchangeRate(BigDecimal v) {
        return NumericUtils.equalsZero(v) ? STConstant.EXCHANGERATE_DEFAULT : v;
    }

    public static int effectualQtyPrecision(int scale) {
        return scale >= 0 ? scale : 16;
    }

    public static MultiMeasureUnitInfo multiMeasureUnit(MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.multiMeasureUnit(null, material, unit);
    }

    public static MultiMeasureUnitInfo multiMeasureUnit(Context ctx, MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        MultiMeasureUnitInfo multiUnit = null;
        if (STUtils.isNotNull(material) && STUtils.isNotNull(material.getId()) && STUtils.isNotNull(unit) && STUtils.isNotNull(unit.getId())) {
            multiUnit = QtyMultiMeasureUtils.getMultiUnitBizInterface(ctx).getMultiUnit(material.getId().toString(), unit.getId().toString());
        }
        return multiUnit;
    }

    public static int multiUnitQTYPrecision(MultiMeasureUnitInfo multiUnit) {
        int scale = 16;
        if (STUtils.isNotNull(multiUnit)) {
            scale = QtyMultiMeasureUtils.effectualQtyPrecision(multiUnit.getQtyPrecision());
        }
        return scale;
    }

    public static BigDecimal multiUnitBaseExchangeRate(MultiMeasureUnitInfo multiUnit) {
        BigDecimal rate = QtyMultiMeasureUtils.effectualExchangeRate(null);
        if (STUtils.isNotNull(multiUnit) && NumericUtils.isDistrustExchangeRate(multiUnit.getBaseConvsRate())) {
            rate = multiUnit.getBaseConvsRate();
        }
        return rate;
    }

    public static BigDecimal calculateQty(MaterialInfo material, MeasureUnitInfo sourceUnit, MeasureUnitInfo targetUnit, BigDecimal qty) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.calculateQty(null, material, sourceUnit, targetUnit, qty);
    }

    public static BigDecimal[] calculateQty(Context ctx, MaterialInfo material, MeasureUnitInfo sourceUnit, MeasureUnitInfo targetUnit, BigDecimal[] qty) throws EASBizException, BOSException {
        if (STUtils.isNull(material) || STUtils.isNull(sourceUnit) || STUtils.isNull(targetUnit) || STUtils.isNull(qty)) {
            return null;
        }
        BigDecimal[] qtys = new BigDecimal[qty.length];
        if (sourceUnit.getId().equals((Object)targetUnit.getId())) {
            for (int i = 0; i < qty.length; ++i) {
                qtys[i] = qty[i];
            }
        } else {
            MultiMeasureUnitInfo[] multiUnits = QtyMultiMeasureUtils.multiMeasureUnits(ctx, material, sourceUnit, targetUnit);
            MultiMeasureUnitInfo sourceMUnit = multiUnits[0];
            MultiMeasureUnitInfo targetMUnit = multiUnits[1];
            BigDecimal sourceMExchangeRate = QtyMultiMeasureUtils.multiUnitBaseExchangeRate(sourceMUnit);
            BigDecimal targetMExchangeRate = QtyMultiMeasureUtils.multiUnitBaseExchangeRate(targetMUnit);
            int multiUnitQTYPrecision = QtyMultiMeasureUtils.multiUnitQTYPrecision(targetMUnit);
            for (int i = 0; i < qty.length; ++i) {
                qtys[i] = STUtils.isNotNull(qty[i]) ? QtyMultiMeasureUtils.calculateQty(sourceMExchangeRate, targetMExchangeRate, qty[i], multiUnitQTYPrecision) : null;
            }
        }
        return qtys;
    }

    public static BigDecimal[] toBaseQty(Context ctx, MaterialInfo material, MeasureUnitInfo unit, BigDecimal[] qty) throws EASBizException, BOSException {
        BigDecimal[] qtys = new BigDecimal[4];
        MaterialInfo m = QtyMultiMeasureUtils.fullUnitMaterialInfo(ctx, material);
        if (unit.getId().equals((Object)m.getBaseUnit().getId())) {
            for (int i = 0; i < qty.length; ++i) {
                qtys[i] = qty[i];
            }
        } else {
            MultiMeasureUnitInfo[] multiUnits = QtyMultiMeasureUtils.multiMeasureUnits(ctx, material, unit, m.getBaseUnit());
            MultiMeasureUnitInfo multiMUnit = multiUnits[0];
            MultiMeasureUnitInfo multiBaseUnit = multiUnits[1];
            int multiUnitQTYPrecision = QtyMultiMeasureUtils.multiUnitQTYPrecision(multiBaseUnit);
            BigDecimal exchange = QtyMultiMeasureUtils.multiUnitBaseExchangeRate(multiMUnit);
            for (int i = 0; i < qty.length; ++i) {
                qtys[i] = STUtils.isNotNull(qty[i]) ? QtyMultiMeasureUtils.toBaseQty(exchange, qty[i], multiUnitQTYPrecision) : null;
            }
        }
        return qtys;
    }

    public static BigDecimal calculateQty(Context ctx, MaterialInfo material, MeasureUnitInfo sourceUnit, MeasureUnitInfo targetUnit, BigDecimal qty) throws EASBizException, BOSException {
        MultiMeasureUnitInfo[] multiUnits = QtyMultiMeasureUtils.multiMeasureUnits(ctx, material, sourceUnit, targetUnit);
        MultiMeasureUnitInfo sourceMUnit = multiUnits[0];
        MultiMeasureUnitInfo targetMUnit = multiUnits[1];
        return QtyMultiMeasureUtils.calculateQty(QtyMultiMeasureUtils.multiUnitBaseExchangeRate(sourceMUnit), QtyMultiMeasureUtils.multiUnitBaseExchangeRate(targetMUnit), qty, QtyMultiMeasureUtils.multiUnitQTYPrecision(targetMUnit));
    }

    public static BigDecimal calculateQty(MaterialInfo material, MeasureUnitInfo sourceUnit, MeasureUnitInfo targetUnit, BigDecimal qty, int scale) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.calculateQty(null, material, sourceUnit, targetUnit, qty, scale);
    }

    public static BigDecimal calculateQty(Context ctx, MaterialInfo material, MeasureUnitInfo sourceUnit, MeasureUnitInfo targetUnit, BigDecimal qty, int scale) throws EASBizException, BOSException {
        MultiMeasureUnitInfo[] multiUnits = QtyMultiMeasureUtils.multiMeasureUnits(ctx, material, sourceUnit, targetUnit);
        return QtyMultiMeasureUtils.calculateQty(QtyMultiMeasureUtils.multiUnitBaseExchangeRate(multiUnits[0]), QtyMultiMeasureUtils.multiUnitBaseExchangeRate(multiUnits[1]), qty, scale);
    }

    public static BigDecimal calculateQty(BigDecimal sourceBaseRate, BigDecimal targetBaseRate, BigDecimal qty, int scale) {
        return QtyMultiMeasureUtils.baseQtyTo(QtyMultiMeasureUtils.toBaseQty(sourceBaseRate, qty), targetBaseRate, scale);
    }

    public static BigDecimal baseQtyTo(BigDecimal baseQty, MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.baseQtyTo(null, baseQty, material, unit);
    }

    public static BigDecimal baseQtyTo(Context ctx, BigDecimal baseQty, MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        MultiMeasureUnitInfo multiUnit = QtyMultiMeasureUtils.multiMeasureUnit(ctx, material, unit);
        return QtyMultiMeasureUtils.baseQtyTo(baseQty, QtyMultiMeasureUtils.multiUnitBaseExchangeRate(multiUnit), QtyMultiMeasureUtils.multiUnitQTYPrecision(multiUnit));
    }

    public static BigDecimal baseQtyTo(MaterialInfo material, MeasureUnitInfo unit, BigDecimal qty, int scale) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.baseQtyTo(null, material, unit, qty, scale);
    }

    public static BigDecimal baseQtyTo(Context ctx, MaterialInfo material, MeasureUnitInfo unit, BigDecimal qty, int scale) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.baseQtyTo(qty, QtyMultiMeasureUtils.baseExchangeRate(ctx, material, unit), scale);
    }

    public static BigDecimal baseQtyTo(BigDecimal baseQty, BigDecimal targetUnitBaseRate) {
        return QtyMultiMeasureUtils.baseQtyTo(baseQty, targetUnitBaseRate, 16);
    }

    public static BigDecimal baseQtyTo(BigDecimal baseQty, BigDecimal targetUnitBaseRate, int scale) {
        return NumericUtils.effectualNumeric(baseQty).divide(QtyMultiMeasureUtils.effectualExchangeRate(targetUnitBaseRate), QtyMultiMeasureUtils.effectualQtyPrecision(scale), 4);
    }

    public static BigDecimal toBaseQty(MaterialInfo material, MeasureUnitInfo unit, BigDecimal qty) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.toBaseQty(null, material, unit, qty);
    }

    public static BigDecimal toBaseQty(Context ctx, MaterialInfo material, MeasureUnitInfo unit, BigDecimal qty) throws EASBizException, BOSException {
        MaterialInfo m = QtyMultiMeasureUtils.fullUnitMaterialInfo(ctx, material);
        MultiMeasureUnitInfo[] multiUnits = QtyMultiMeasureUtils.multiMeasureUnits(ctx, material, unit, m.getBaseUnit());
        return QtyMultiMeasureUtils.toBaseQty(QtyMultiMeasureUtils.multiUnitBaseExchangeRate(multiUnits[0]), qty, QtyMultiMeasureUtils.multiUnitQTYPrecision(multiUnits[1]));
    }

    public static BigDecimal toBaseQty(MaterialInfo material, MeasureUnitInfo unit, BigDecimal qty, int scale) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.toBaseQty(QtyMultiMeasureUtils.baseExchangeRate(null, material, unit), qty, scale);
    }

    public static BigDecimal toBaseQty(Context ctx, MaterialInfo material, MeasureUnitInfo unit, BigDecimal qty, int scale) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.toBaseQty(QtyMultiMeasureUtils.baseExchangeRate(ctx, material, unit), qty, scale);
    }

    public static BigDecimal toBaseQty(BigDecimal baseRate, BigDecimal qty) {
        return QtyMultiMeasureUtils.toBaseQty(baseRate, qty, 16);
    }

    public static BigDecimal toBaseQty(BigDecimal baseRate, BigDecimal qty, int scale) {
        return NumericUtils.effectualNumeric(qty).multiply(QtyMultiMeasureUtils.effectualExchangeRate(baseRate)).setScale(QtyMultiMeasureUtils.effectualQtyPrecision(scale), 4);
    }

    public static MultiMeasureUnitInfo[] multiMeasureUnits(Context ctx, MaterialInfo material, MeasureUnitInfo sourceUnit, MeasureUnitInfo targetUnit) throws EASBizException, BOSException {
        MultiMeasureUnitInfo[] mus = new MultiMeasureUnitInfo[2];
        if (STUtils.isNotNull(material) && STUtils.isNotNull(material.getId())) {
            if (STUtils.isNotNull(sourceUnit) && STUtils.isNotNull(targetUnit)) {
                EntityViewInfo view = new EntityViewInfo();
                view.getSelector().add(new SelectorItemInfo("id"));
                view.getSelector().add(new SelectorItemInfo("material.id"));
                view.getSelector().add(new SelectorItemInfo("measureUnit.id"));
                view.getSelector().add(new SelectorItemInfo("qtyPrecision"));
                view.getSelector().add(new SelectorItemInfo("baseConvsRate"));
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)sourceUnit.getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)targetUnit.getId().toString(), CompareType.EQUALS));
                filter.setMaskString("(#0 AND (#1 OR #2))");
                MultiMeasureUnitCollection ls = QtyMultiMeasureUtils.getMultiUnitBizInterface(ctx).getMultiMeasureUnitCollection(view);
                if (STUtils.isNotNull(ls)) {
                    MultiMeasureUnitInfo mi = null;
                    MeasureUnitInfo unit = null;
                    int size = ls.size();
                    for (int i = 0; i < size; ++i) {
                        mi = ls.get(i);
                        if (!STUtils.isNotNull(mi) || !STUtils.isNotNull(mi.getMeasureUnit())) continue;
                        unit = mi.getMeasureUnit();
                        if (sourceUnit.getId().toString().equalsIgnoreCase(unit.getId().toString())) {
                            mus[0] = mi;
                        }
                        if (!targetUnit.getId().toString().equalsIgnoreCase(unit.getId().toString())) continue;
                        mus[1] = mi;
                    }
                }
            } else if (STUtils.isNotNull(sourceUnit)) {
                mus[0] = QtyMultiMeasureUtils.multiMeasureUnit(ctx, material, sourceUnit);
            } else if (STUtils.isNotNull(targetUnit)) {
                mus[1] = QtyMultiMeasureUtils.multiMeasureUnit(ctx, material, targetUnit);
            }
        }
        return mus;
    }

    public static MaterialInfo fullUnitMaterialInfo(MaterialInfo material) throws BOSException, EASBizException {
        return QtyMultiMeasureUtils.fullUnitMaterialInfo(null, material);
    }

    public static MaterialInfo fullUnitMaterialInfo(Context ctx, MaterialInfo material) throws BOSException, EASBizException {
        MaterialInfo fm = null;
        if (STUtils.isNotNull(material) && STUtils.isNotNull(material.getId())) {
            if (STUtils.isNull(material.getBaseUnit()) || STUtils.isNull(material.getBaseUnit().getId()) || STUtils.isNull(material.getBaseUnit().getNumber()) || STUtils.isNull(material.getBaseUnit().getName()) || STUtils.isNull(material.getAssistUnit()) || STUtils.isNull(material.getAssistUnit().getId()) || STUtils.isNull(material.getAssistUnit().getNumber()) || STUtils.isNull(material.getAssistUnit().getName())) {
                IMaterial ie = null;
                ie = STUtils.isNull(ctx) ? MaterialFactory.getRemoteInstance() : MaterialFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add("id");
                selectors.add("number");
                selectors.add("name");
                selectors.add("model");
                selectors.add("pricePrecision");
                selectors.add("baseUnit.id");
                selectors.add("baseUnit.number");
                selectors.add("baseUnit.name");
                selectors.add("assistUnit.id");
                selectors.add("assistUnit.number");
                selectors.add("assistUnit.name");
                fm = ie.getMaterialInfo((IObjectPK)new ObjectUuidPK(material.getId()), selectors);
            } else {
                fm = material;
            }
        } else {
            fm = new MaterialInfo();
        }
        return fm;
    }

    private static IMultiMeasureUnit getMultiUnitBizInterface(Context ctx) throws BOSException {
        IMultiMeasureUnit ie = null;
        ie = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        return ie;
    }
}

