/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerGroupException;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroup;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;

public class CustomerBrowseGroupDataImport
extends AbstractDataTransmission {
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CSSPGroupFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICSSPGroup iCustomerBrowseGroup = (ICSSPGroup)this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !iCustomerBrowseGroup.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iCustomerBrowseGroup.submit(coreBaseInfo);
            } else {
                this.checkCanEdit(ctx, (CSSPGroupInfo)coreBaseInfo);
                iCustomerBrowseGroup.importUpdate((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), (IObjectValue)coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        CSSPGroupInfo customerBrowseGroupInfo = new CSSPGroupInfo();
        customerBrowseGroupInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        Object numberdata = ((DataToken)hsData.get((Object)"FNumber")).data;
        String str = null;
        if (numberdata == null) throw new TaskExternalException("number  not found!!!!");
        str = numberdata.toString();
        if (str != null && str.trim().length() > 0) {
            customerBrowseGroupInfo.setNumber(str);
            if (super.isSltImportUpdate()) {
                try {
                    ICSSPGroup iCustomerBrowseGroup = (ICSSPGroup)this.getController(ctx);
                    CSSPGroupCollection customerBrowseGroupCollection = iCustomerBrowseGroup.getCSSPGroupCollection("where number ='" + str + "'");
                    if (customerBrowseGroupCollection != null && customerBrowseGroupCollection.size() > 0) {
                        int count = customerBrowseGroupCollection.size();
                        for (int index = 0; index < count; ++index) {
                            BOSUuid cssdBosID = customerBrowseGroupCollection.get(index).getGroupStandard().getId();
                            CSSPGroupStandardInfo cssdInfo = CSSPGroupStandardFactory.getLocalInstance(ctx).getCSSPGroupStandardInfo((IObjectPK)new ObjectUuidPK(cssdBosID));
                            if (cssdInfo.getType() != 1 && cssdInfo.getType() != 0) continue;
                            customerBrowseGroupInfo.setId(customerBrowseGroupCollection.get(index).getId());
                        }
                    }
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                catch (EASBizException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            }
        }
        Object data = null;
        String multiStr = ctx.getLocale().toString().toUpperCase();
        data = ((DataToken)hsData.get((Object)new StringBuilder().append((String)"FName_").append((String)multiStr).toString())).data;
        if (data != null) {
            customerBrowseGroupInfo.setName(data.toString());
        }
        if ((data = ((DataToken)hsData.get((Object)new StringBuilder().append((String)"FDescription_").append((String)multiStr).toString())).data) != null) {
            customerBrowseGroupInfo.setDescription(data.toString());
        }
        try {
            CSSPGroupCollection collection;
            data = ((DataToken)hsData.get((Object)"FCSSPGroupStandardID")).data;
            if (data == null) throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "standardNotExist", ctx));
            str = data.toString();
            if (str == null || str.trim().length() <= 0) throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "standardNotExist", ctx));
            EntityViewInfo viewInfo = DataImportUtils.getViewInfo(str);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)String.valueOf(0), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)String.valueOf(1), CompareType.EQUALS));
            filterInfo.setMaskString("#0 or #1");
            viewInfo.getFilter().mergeFilter(filterInfo, "and");
            ICSSPGroupStandard iStandard = CSSPGroupStandardFactory.getLocalInstance(ctx);
            CSSPGroupStandardCollection collection2 = iStandard.getCSSPGroupStandardCollection(viewInfo);
            if (collection2 == null || collection2.size() <= 0) throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "standardNotExist", ctx));
            CSSPGroupStandardInfo info = collection2.get(0);
            if (info != null) {
                customerBrowseGroupInfo.setGroupStandard(info);
            }
            if (hsData.get("FParentID") == null || (str = (data = ((DataToken)hsData.get((Object)"FParentID")).data).toString()) == null || str.trim().length() <= 0) return customerBrowseGroupInfo;
            ICSSPGroup iCustomerBrowseGroup = (ICSSPGroup)this.getController(ctx);
            StringBuffer oql = new StringBuffer(50);
            oql.append("where number='").append(str).append("'");
            if (customerBrowseGroupInfo.getGroupStandard() != null && customerBrowseGroupInfo.getGroupStandard().getId() != null) {
                oql.append(" and groupStandard.id='").append(customerBrowseGroupInfo.getGroupStandard().getId().toString()).append("'");
            }
            if ((collection = iCustomerBrowseGroup.getCSSPGroupCollection(oql.toString())) == null || collection.size() <= 0) throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DataImport_GroupParent_Error", (Locale)ctx.getLocale()));
            int cont = collection.size();
            for (int i = 0; i < cont; ++i) {
                CSSPGroupStandardInfo cSSPGroupStandardInfo;
                CSSPGroupInfo info2 = collection.get(i);
                if (info2 == null || (cSSPGroupStandardInfo = CSSPGroupStandardFactory.getLocalInstance(ctx).getCSSPGroupStandardInfo((IObjectPK)new ObjectUuidPK(info2.getGroupStandard().getId()))).getType() != 0 && cSSPGroupStandardInfo.getType() != 1) continue;
                customerBrowseGroupInfo.setParent(info2);
                customerBrowseGroupInfo.setLevel(info2.getLevel() + 1);
                customerBrowseGroupInfo.setLongNumber(info2.getLongNumber() + "!" + customerBrowseGroupInfo.getNumber());
                customerBrowseGroupInfo.setDisplayName(info2.getDisplayName() + "_" + customerBrowseGroupInfo.getName());
            }
            return customerBrowseGroupInfo;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            String multiName = "FName_" + ContextUtils.getLocaleFromEnv().toString().toUpperCase();
            String multiDescription = "FDescription_" + ContextUtils.getLocaleFromEnv().toString().toUpperCase();
            result.put("FNumber", DataImportUtils.transformValue(rs.getString("number")));
            result.put("FParentID", DataImportUtils.transformValue(rs.getString("parent.number")));
            result.put("FCSSPGroupStandardID", DataImportUtils.transformValue(rs.getString("groupStandard.number")));
            result.put(multiName, DataImportUtils.transformValue(rs.getString("name")));
            result.put(multiDescription, DataImportUtils.transformValue(rs.getString("description")));
            result.put("FCreatorNumber", DataImportUtils.transformValue(rs.getString("creator.number")));
            result.put("FCreateTime", DataImportUtils.getDateStrByLocale(ctx, rs.getDate("createTime")));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getLongNumber());
        return filterInfoCU;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.cssp.app.CSSPGroupExportQuery";
    }

    private void checkCanEdit(Context ctx, CSSPGroupInfo info) throws BOSException, EASBizException, TaskExternalException {
        ICSSPGroup iSupplierBrowseGroup = (ICSSPGroup)this.getController(ctx);
        CSSPGroupInfo oldInfo = iSupplierBrowseGroup.getCSSPGroupInfo((IObjectPK)new ObjectUuidPK(info.getId()));
        if (!info.getGroupStandard().getId().equals((Object)oldInfo.getGroupStandard().getId())) {
            StringBuffer sbCustomer = new StringBuffer();
            sbCustomer.append(" SELECT   a.fid ");
            sbCustomer.append("   FROM   T_BD_CustomerGroupDetail a, T_BD_CSSPGroup b ");
            sbCustomer.append("  WHERE       A.FCUSTOMERGROUPID = B.FID ");
            sbCustomer.append("          AND B.FCSSPGROUPSTANDARDID = '" + oldInfo.getGroupStandard().getId().toString() + "' ");
            sbCustomer.append("          AND (B.FLONGNUMBER = '" + oldInfo.getLongNumber() + "' OR B.FLONGNUMBER LIKE '" + oldInfo.getLongNumber() + "!%') ");
            IRowSet rsCustomer = DbUtil.executeQuery((Context)ctx, (String)sbCustomer.toString());
            try {
                if (rsCustomer != null && rsCustomer.next()) {
                    throw new CustomerGroupException(CustomerGroupException.CSSPGROUP_HASREFER);
                }
            }
            catch (SQLException e) {
                throw new CustomerGroupException(CustomerGroupException.CSSPGROUP_HASREFER);
            }
        }
    }
}

