/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.exception.MissMatchParticipantException;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.AbstractMulDataTransmission;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.IndustryInfo;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.assistant.RegionInfo;
import com.kingdee.eas.basedata.assistant.TaxDataInfo;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeInfo;
import com.kingdee.eas.basedata.master.cssp.CSParameterCollection;
import com.kingdee.eas.basedata.master.cssp.CSParameterFactory;
import com.kingdee.eas.basedata.master.cssp.CSParameterInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerGroupDetailCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerGroupDetailInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerKindEnum;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.ICSParameter;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.InternalCSSPType;
import com.kingdee.eas.basedata.master.cssp.StandardTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueForEditUIUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;

public class CustomerDataImport
extends AbstractMulDataTransmission {
    String[] INTEGER_FIELDS = new String[]{"FVersion"};
    String[] INTEGER_OBJS = new String[]{"version"};
    String[] BOOLEAN_FIELDS = new String[]{"FIsInternalCompany", "FIsCredited"};
    String[] BOOLEAN_OBJS = new String[]{"isInternalCompany", "isCredited"};
    String[] STRING_FIELDS = new String[]{"FForeignName", "FShortName", "FBarCode", "FMnemonicCode", "FTaxRegisterNo", "FBizRegisterNo", "FBusiLicence", "FGSPAuthentication", "FArtificialPerson", "FAddress", "FBusiExequatur"};
    String[] STRING_OBJS = new String[]{"foreignName", "simpleName", "barCode", "mnemonicCode", "taxRegisterNo", "bizRegisterNo", "busiLicence", "GSPAuthentication", "artificialPerson", "address", "busiExequatur"};
    String[] BIGDECIMAL_FIELDS = new String[]{"FTaxRate"};
    String[] BIGDECIMAL_OBJ = new String[]{"taxRate"};
    private CSParameterInfo currentCSParameterInfo;
    private static final String[] mainFields = new String[]{"FNumber", "FName_L1", "FName_L2", "FName_L3", "FShortName", "FForeignName", "FMnemonicCode", "FBizRegisterNo", "FTaxRegisterNo"};

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CustomerFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    private boolean isAddView(CoreBaseInfo customerInfo, Context ctx) throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String strCompanyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)customerInfo);
        if (this.getBindingProperty() != null && this.getBindingProperty().trim().length() > 0) {
            return iCodingRuleManager.isAddView((IObjectValue)customerInfo, strCompanyID, this.getBindingProperty());
        }
        return iCodingRuleManager.isAddView((IObjectValue)customerInfo, strCompanyID);
    }

    private String customerSupplierNameCheck(String fieldName, String fieldValue, TreeSet dupTreeSet, Context ctx) throws BOSException, EASBizException, Exception {
        StringBuffer sb = new StringBuffer();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("CU.name"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(fieldName, (Object)fieldValue, CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(selector);
        ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
        SupplierCollection supplierColl = iSupplier.getSupplierCollection(view);
        if (supplierColl != null && supplierColl.size() > 0) {
            dupTreeSet.add("SAME_SUPPLIER_NAME");
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"SAME_SUPPLIER_NAME", (Locale)ctx.getOriginLocale()));
            sb.append("\uff08");
            for (int i = 0; i < supplierColl.size(); ++i) {
                SupplierInfo supplierInfo = supplierColl.get(i);
                sb.append(ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"NUMBER", (Locale)ctx.getOriginLocale()));
                sb.append(supplierInfo.getNumber());
                sb.append("\uff0c");
                sb.append(ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"HASEXIST", (Locale)ctx.getOriginLocale()));
                sb.append(supplierInfo.getCU().getName());
                if (i >= supplierColl.size() - 1) continue;
                sb.append("\uff1b");
            }
            sb.append("\uff09");
        }
        return sb.toString();
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICustomer iCustomer = (ICustomer)this.getController(ctx);
        try {
            if (((CustomerInfo)coreBaseInfo).getName() != null && ((CustomerInfo)coreBaseInfo).getName().indexOf(";") != -1) {
                throw new CustomerSupplierException(CustomerSupplierException.SEMICOLONNOTALLOW4IMPORT);
            }
            if (coreBaseInfo.getId() == null) {
                boolean isAutoNumber = this.isAutoNumber((CustomerInfo)coreBaseInfo, ctx);
                boolean isImportByRule = DataImportUtils.getImportParam(ctx);
                coreBaseInfo.put("isImportByRule", (Object)isImportByRule);
                if (isAutoNumber && isImportByRule) {
                    ((CustomerInfo)coreBaseInfo).setNumber(this.createNewNumber((CustomerInfo)coreBaseInfo, ctx));
                }
            }
            coreBaseInfo.put("isImport", (Object)true);
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            this.getCSParamInfo(ctx, cu.getId().toString());
            if (this.currentCSParameterInfo.isCustomerDontSave()) {
                ArrayList<String> csParameterArrayList = new ArrayList<String>();
                if (this.currentCSParameterInfo.isCustomerName()) {
                    csParameterArrayList.add("name");
                }
                if (this.currentCSParameterInfo.isCustomerSimpleName()) {
                    csParameterArrayList.add("simpleName");
                }
                if (this.currentCSParameterInfo.isCustomerForeignName()) {
                    csParameterArrayList.add("foreignName");
                }
                if (this.currentCSParameterInfo.isCustomerMnemonicCode()) {
                    csParameterArrayList.add("mnemonicCode");
                }
                if (this.currentCSParameterInfo.isCustomerBizRegisterNo()) {
                    csParameterArrayList.add("bizRegisterNo");
                }
                if (this.currentCSParameterInfo.isCustomerTaxRegisterNo()) {
                    csParameterArrayList.add("taxRegisterNo");
                }
                if (this.currentCSParameterInfo.isCustomerSuppliperName()) {
                    csParameterArrayList.add("supplierName");
                }
                String nameMessage = "";
                TreeSet<String> dupTreeSet = new TreeSet<String>();
                for (String fieldName : csParameterArrayList) {
                    String fieldValue = (String)coreBaseInfo.get(fieldName);
                    if ("supplierName".equals(fieldName)) {
                        fieldName = "name";
                        fieldValue = (String)coreBaseInfo.get(fieldName);
                        nameMessage = this.customerSupplierNameCheck(fieldName, fieldValue, dupTreeSet, ctx);
                        continue;
                    }
                    if (StringUtils.isEmpty((String)fieldValue)) continue;
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo(fieldName, (Object)fieldValue));
                    filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(3), CompareType.NOTEQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)((String)coreBaseInfo.get("number")), CompareType.NOTEQUALS));
                    if (this.currentCSParameterInfo.isCustomerCUUnique()) {
                        filter.getFilterItems().add(new FilterItemInfo("cu", (Object)cu.getId().toString(), CompareType.EQUALS));
                    }
                    if (!iCustomer.exists(filter)) continue;
                    dupTreeSet.add(fieldName);
                }
                if (!dupTreeSet.isEmpty()) {
                    String dupMsg = "";
                    for (String items : dupTreeSet) {
                        String element = "";
                        element = "SAME_SUPPLIER_NAME".equals(items) ? nameMessage : ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)items, (Locale)ctx.getOriginLocale());
                        dupMsg = dupMsg + element + ",";
                    }
                    dupMsg = dupMsg.substring(0, dupMsg.lastIndexOf(44));
                    dupMsg = ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"customer", (Locale)ctx.getOriginLocale()) + dupMsg;
                    dupTreeSet.clear();
                    throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{dupMsg});
                }
            }
            IObjectPK iObjectPK = iCustomer.submit(coreBaseInfo);
        }
        catch (MissMatchParticipantException ex) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_MissMatchParticipant", (Locale)ctx.getLocale()), (Throwable)ex);
        }
        catch (AlreadyInProcessQueueException ex) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_AlreadyInProcessQueue", (Locale)ctx.getLocale()), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    private CSParameterInfo getCSParamInfo(Context ctx, String cuid) throws BOSException, EASBizException {
        if (this.currentCSParameterInfo != null) {
            return this.currentCSParameterInfo;
        }
        ICSParameter iCSParameter = CSParameterFactory.getLocalInstance(ctx);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu", (Object)cuid, CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        CSParameterCollection collection = iCSParameter.getCSParameterCollection(entityViewInfo);
        this.currentCSParameterInfo = collection != null && collection.size() > 0 ? collection.get(0) : CSParameterInfo.getCustomerDefaultParam();
        return this.currentCSParameterInfo;
    }

    private String createNewNumber(CustomerInfo customerInfo, Context ctx) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String strCompanyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)customerInfo);
        if (this.isAddView((CoreBaseInfo)customerInfo, ctx)) {
            if (this.getBindingProperty() != null && this.getBindingProperty().trim().length() > 0) {
                return iCodingRuleManager.getNumber((IObjectValue)customerInfo, strCompanyID, this.getBindingProperty());
            }
            return iCodingRuleManager.getNumber((IObjectValue)customerInfo, strCompanyID);
        }
        if (this.getBindingProperty() != null && this.getBindingProperty().trim().length() > 0) {
            return iCodingRuleManager.getNumber((IObjectValue)customerInfo, strCompanyID, this.getBindingProperty());
        }
        return iCodingRuleManager.getNumber((IObjectValue)customerInfo, strCompanyID);
    }

    private boolean isAutoNumber(CustomerInfo customerInfo, Context ctx) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String strCompanyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)customerInfo);
        return this.getBindingProperty() != null && this.getBindingProperty().trim().length() > 0 ? iCodingRuleManager.isExist((IObjectValue)customerInfo, strCompanyID, this.getBindingProperty()) : iCodingRuleManager.isExist((IObjectValue)customerInfo, strCompanyID);
    }

    private String getBindingProperty() {
        return null;
    }

    protected CoreBaseInfo createHead(Hashtable hsData, Context ctx) throws Exception {
        int i;
        CustomerInfo customerInfo = new CustomerInfo();
        CustomerInfo oldInfo = null;
        customerInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        customerInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        String importDataModel = DataImportUtils.getImportDataModel(ctx);
        String numberdata = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        if (numberdata != null && numberdata.length() > 0) {
            ICustomer iCustomer;
            CustomerCollection customerCollection;
            customerInfo.setNumber(numberdata);
            if (super.isSltImportUpdate() && (customerCollection = (iCustomer = (ICustomer)this.getController(ctx)).getCustomerCollection("select *,customerGroupDetails.* where number ='" + numberdata + "'")) != null && customerCollection.size() > 0) {
                oldInfo = customerCollection.get(0);
                customerInfo = (CustomerInfo)oldInfo.clone();
            }
        }
        String str = null;
        DataImportUtils.setIntegerData(hsData, this.INTEGER_FIELDS, (CoreBaseInfo)customerInfo, this.INTEGER_OBJS);
        DataImportUtils.setBooleanData(hsData, this.BOOLEAN_FIELDS, (CoreBaseInfo)customerInfo, this.BOOLEAN_OBJS);
        DataImportUtils.setStringData(hsData, this.STRING_FIELDS, (CoreBaseInfo)customerInfo, this.STRING_OBJS);
        Object data = null;
        String value = null;
        String[] multiStr = new String[]{"L1", "L2", "L3"};
        String fnameStr = DataImportTools.getDataString((Hashtable)hsData, (String)("FName_" + DataImportTools.getLoc((Context)ctx)));
        int c = multiStr.length;
        for (i = 0; i < c; ++i) {
            data = ((DataToken)hsData.get((Object)new StringBuilder().append((String)"FName_").append((String)multiStr[i]).toString())).data;
            if (data != null && !StringUtils.isEmpty((String)data.toString())) {
                customerInfo.setName(data.toString(), new Locale(multiStr[i]));
                continue;
            }
            customerInfo.setName(fnameStr, new Locale(multiStr[i]));
        }
        data = ((DataToken)hsData.get((Object)"FUsedStatus")).data;
        if (data != null) {
            value = data.toString();
            customerInfo.setUsedStatus(DataImportUtils.getCustomerStatusValue(value));
        }
        if ((data = ((DataToken)hsData.get((Object)"FInvoiceType")).data) != null) {
            value = data.toString();
            customerInfo.setInvoiceType(DataImportUtils.getInvoiceTypeValue(value));
        }
        if ((data = ((DataToken)hsData.get((Object)"FCustomerKind")).data) != null) {
            value = data.toString();
            customerInfo.setCustomerKind(this.getCustomerKindValue(value));
        }
        for (i = 0; i < this.BIGDECIMAL_FIELDS.length; ++i) {
            try {
                BigDecimal bigDecimalValue;
                Object o = ((DataToken)hsData.get((Object)this.BIGDECIMAL_FIELDS[i])).data;
                if (o == null || o.toString().trim().length() <= 0 || (bigDecimalValue = new BigDecimal(o.toString())) == null) continue;
                customerInfo.setBigDecimal(this.BIGDECIMAL_OBJ[i], bigDecimalValue);
                continue;
            }
            catch (NumberFormatException nex) {
                nex.printStackTrace();
                throw new TaskExternalException(this.BIGDECIMAL_OBJ[i] + DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "FormmaterError", ctx));
            }
        }
        try {
            if (hsData.get("FBizAnalysisCodeID") != null) {
                BizAnalysisCodeInfo info;
                data = ((DataToken)hsData.get((Object)"FBizAnalysisCodeID")).data;
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getBizAnalysisCodeInfoFromNumber(ctx, str)) != null) {
                    customerInfo.setBizAnalysisCode(info);
                }
            }
            if (hsData.get("FParentID") != null) {
                CustomerInfo info;
                data = ((DataToken)hsData.get((Object)"FParentID")).data;
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getCustomerInfoFromNumber(ctx, str)) != null) {
                    customerInfo.setParent(info);
                }
            }
            if (hsData.get("FInternalCustomerType") != null) {
                InternalCSSPType type;
                data = ((DataToken)hsData.get((Object)"FInternalCustomerType")).data;
                if ((data == null || "".equals(data)) && customerInfo.isIsInternalCompany()) {
                    CustomerSupplierException e = new CustomerSupplierException(CustomerSupplierException.INTERNALSUPPTYPENULL);
                    throw new TaskExternalException(e.getMessage(), (Throwable)((Object)e));
                }
                if (data != null) {
                    str = data.toString();
                }
                if ((type = DataImportUtils.getInternalCSSPType(str)) != null) {
                    customerInfo.setInternalCustomerType(type);
                }
            }
            if (hsData.get("FInternalCompanyID") != null) {
                CompanyOrgUnitInfo info;
                data = ((DataToken)hsData.get((Object)"FInternalCompanyID")).data;
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getCompanyOrgUnitInfoFromNumber(ctx, str)) != null && info.get("isbizunit") != null) {
                    Boolean isbizunit = new Boolean(info.get("isbizunit").toString());
                    if (isbizunit.booleanValue()) {
                        customerInfo.setInternalCompany(info);
                    } else {
                        throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "CompanyShoudBeEntity", ctx));
                    }
                }
            }
            if (hsData.get("FInternalProfitCenter") != null) {
                ProfitCenterOrgUnitInfo info;
                data = ((DataToken)hsData.get((Object)"FInternalProfitCenter")).data;
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getProfitCenter(ctx, str)) != null) {
                    customerInfo.setInternalProfitCenter(info);
                }
            }
            if (hsData.get("FTaxDataID") != null) {
                TaxDataInfo info;
                data = ((DataToken)hsData.get((Object)"FTaxDataID")).data;
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getTaxDataInfoFromNumber(ctx, str)) != null) {
                    customerInfo.setTaxData(info);
                }
            }
            if (hsData.get("FIndustryID") != null) {
                IndustryInfo info;
                data = ((DataToken)hsData.get((Object)"FIndustryID")).data;
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getIndustryInfoFromNumber(ctx, str)) != null) {
                    customerInfo.setIndustry(info);
                }
            }
            if (hsData.get("FCountryID") != null) {
                CountryInfo info;
                data = ((DataToken)hsData.get((Object)"FCountryID")).data;
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getCountryInfoFromNumber(ctx, str)) != null) {
                    customerInfo.setCountry(info);
                }
            }
            if (hsData.get("FProvince") != null) {
                ProvinceInfo info;
                data = ((DataToken)hsData.get((Object)"FProvince")).data;
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getProvinceInfoFromNumber(ctx, str)) != null) {
                    customerInfo.setProvince(info);
                }
            }
            if (hsData.get("FCityID") != null) {
                CityInfo info;
                data = ((DataToken)hsData.get((Object)"FCityID")).data;
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getCityInfoFromNumber(ctx, str)) != null) {
                    customerInfo.setCity(info);
                }
            }
            if (hsData.get("FRegionID") != null) {
                RegionInfo info;
                data = ((DataToken)hsData.get((Object)"FRegionID")).data;
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getRegionInfoFromNumber(ctx, str)) != null) {
                    customerInfo.setRegion(info);
                }
            }
            if (hsData.get("FFreezeOrgUnitID") != null) {
                FullOrgUnitInfo info;
                data = ((DataToken)hsData.get((Object)"FFreezeOrgUnitID")).data;
                if (data != null) {
                    str = data.toString();
                }
                if ((info = DataImportUtils.getFullOrgUnitInfoFromNumber(ctx, str)) != null) {
                    customerInfo.setFreezeOrgUnit(info);
                }
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        if (importDataModel.equals("0")) {
            if (oldInfo != null && oldInfo.getUsedStatus() == UsedStatusEnum.APPROVED) {
                CustomerInfo oldSupplier = null;
                CustomerInfo newSupplier = null;
                if (customerInfo != null) {
                    oldSupplier = (CustomerInfo)oldInfo.clone();
                    newSupplier = (CustomerInfo)customerInfo.clone();
                    oldSupplier.getCustomerGroupDetails().clear();
                    newSupplier.getCustomerGroupDetails().clear();
                    if (!ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)oldSupplier, (AbstractObjectValue)newSupplier)) {
                        throw new TaskExternalException(customerInfo.getName() + DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "ApproveInvalid", ctx));
                    }
                }
            }
        } else if (importDataModel.equals("1")) {
            customerInfo.setUsedStatus(UsedStatusEnum.UNAPPROVE);
        } else if (importDataModel.equals("2")) {
            // empty if block
        }
        return customerInfo;
    }

    protected void createEntry(CoreBaseInfo head, Hashtable hsData, Context ctx) throws Exception {
        int pos;
        CustomerInfo customerInfo = (CustomerInfo)head;
        Object data = null;
        Object browseGroupInfo = null;
        CSSPGroupStandardInfo groupStandardInfo = null;
        CustomerGroupDetailInfo detailInfo = new CustomerGroupDetailInfo();
        data = ((DataToken)hsData.get((Object)"FCustomerGroupStandardID")).data;
        if (data == null || data.toString().length() == 0) {
            throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "standardNotExist", ctx));
        }
        String str = data.toString();
        groupStandardInfo = DataImportUtils.getGroupStandardInfoByNumber(ctx, str, "customer");
        if (groupStandardInfo == null) {
            throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "standardNotExist", ctx));
        }
        detailInfo.setCustomerGroupStandard(groupStandardInfo);
        data = ((DataToken)hsData.get((Object)"FCustomerGroupID")).data;
        if (data == null || data.toString().length() == 0) {
            throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "groupNotExist", ctx));
        }
        str = data.toString();
        CSSPGroupInfo groupInfo = DataImportUtils.getGroupInfoByNumber(ctx, str, ((DataToken)hsData.get((Object)"FCustomerGroupStandardID")).data.toString(), "customer");
        if (groupInfo == null) {
            throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "groupNotExist", ctx));
        }
        detailInfo.setCustomerGroup(groupInfo);
        if (groupStandardInfo.getIsBasic() == StandardTypeEnum.basicStandard) {
            customerInfo.setBrowseGroup(groupInfo);
        }
        if ((pos = this.isInCollection(detailInfo, customerInfo.getCustomerGroupDetails())) < 0) {
            customerInfo.getCustomerGroupDetails().add(detailInfo);
        } else {
            customerInfo.getCustomerGroupDetails().set(pos, detailInfo);
        }
    }

    private int isInCollection(CustomerGroupDetailInfo info, CustomerGroupDetailCollection collection) {
        if (collection == null) {
            return -1;
        }
        for (int i = 0; i < collection.size(); ++i) {
            CustomerGroupDetailInfo tempInfo = collection.get(i);
            if (!tempInfo.getCustomerGroupStandard().getId().equals((Object)info.getCustomerGroupStandard().getId())) continue;
            return i;
        }
        return -1;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("fid"));
        sic.add(new SelectorItemInfo("customerGroupDetails.id"));
        sic.add(new SelectorItemInfo("customerGroupDetails.customerGroupStandard.*"));
        sic.add(new SelectorItemInfo("customerGroupDetails.customerGroup.*"));
        sic.add(new SelectorItemInfo("customerGroupDetails.customer.*"));
        return sic;
    }

    private CustomerKindEnum getCustomerKindValue(String value) {
        CustomerKindEnum retval = CustomerKindEnum.DEALER;
        if (value != null) {
            value = value.trim();
            List EnumList = CustomerKindEnum.getEnumList();
            String enumValue = null;
            String enumName = null;
            String enumAlias = null;
            CustomerKindEnum enumeration = null;
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                enumeration = (CustomerKindEnum)((Object)EnumList.get(i));
                enumValue = String.valueOf(enumeration.getValue());
                enumName = enumeration.getName();
                enumAlias = enumeration.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                retval = enumeration;
                break;
            }
        }
        return retval;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            String mutilName = "FName_" + ContextUtils.getLocaleFromEnv().toString().toUpperCase();
            result.put("FNumber", DataImportUtils.transformValue(rs.getString("number")));
            result.put(mutilName, DataImportUtils.transformValue(rs.getString("name")));
            result.put("FMnemonicCode", DataImportUtils.transformValue(rs.getString("mnemonicCode")));
            result.put("FForeignName", DataImportUtils.transformValue(rs.getString("foreignName")));
            result.put("FBarCode", DataImportUtils.transformValue(rs.getString("barCode")));
            result.put("FCustomerKind", (Object)this.getCustomerKindValue(DataImportUtils.transformValue(rs.getString("customerKind")).toString()));
            result.put("FBizAnalysisCodeID", DataImportUtils.transformValue(rs.getString("bizAnalysisCode.number")));
            result.put("FShortName", DataImportUtils.transformValue(rs.getString("simpleName")));
            result.put("FParentID", DataImportUtils.transformValue(rs.getString("parent.number")));
            result.put("FIsInternalCompany", DataImportUtils.transformValue(rs.getString("isInternalCompany")));
            result.put("FInternalCompanyID", DataImportUtils.transformValue(rs.getString("internalCompany.number")));
            result.put("FInternalCustomerType", (Object)DataImportUtils.getInternalCSSPType(DataImportUtils.transformValue(rs.getString("internalCustomerType")).toString()));
            result.put("FInternalProfitCenter_number", DataImportUtils.transformValue(rs.getString("internalProfitCenter.number")));
            result.put("FTaxDataID", DataImportUtils.transformValue(rs.getString("taxData.number")));
            result.put("FTaxRegisterNo", DataImportUtils.transformValue(rs.getString("taxRegisterNo")));
            result.put("FBizRegisterNo", DataImportUtils.transformValue(rs.getString("bizRegisterNo")));
            result.put("FBusiLicence", DataImportUtils.transformValue(rs.getString("busiLicence")));
            result.put("FBusiExequatur", DataImportUtils.transformValue(rs.getString("busiExequatur")));
            result.put("FGSPAuthentication", DataImportUtils.transformValue(rs.getString("GSPAuthentication")));
            result.put("FIndustryID", DataImportUtils.transformValue(rs.getString("industry.number")));
            result.put("FAddress", DataImportUtils.transformValue(rs.getString("address")));
            result.put("FCountryID", DataImportUtils.transformValue(rs.getString("country.number")));
            result.put("FProvince", DataImportUtils.transformValue(rs.getString("province.number")));
            result.put("FCityID", DataImportUtils.transformValue(rs.getString("city.number")));
            result.put("FRegionID", DataImportUtils.transformValue(rs.getString("region.number")));
            result.put("FArtificialPerson", DataImportUtils.transformValue(rs.getString("artificialPerson")));
            result.put("FVersion", DataImportUtils.transformValue(rs.getString("version")));
            result.put("FUsedStatus", (Object)DataImportUtils.getCustomerStatusValue(DataImportUtils.transformValue(rs.getString("usedStatus")).toString()));
            result.put("FFreezeOrgUnitID", DataImportUtils.transformValue(rs.getString("freezeOrgUnit.number")));
            result.put("FCustomerGroupStandardID", DataImportUtils.transformValue(rs.getString("csspGroupStandard.number")));
            result.put("FCustomerGroupID", DataImportUtils.transformValue(rs.getString("browseGroup.number")));
            result.put("FCreatorNumber", DataImportUtils.transformValue(rs.getString("creator.number")));
            result.put("FCreateTime", DataImportUtils.getDateStrByLocale(ctx, rs.getDate("createTime")));
            result.put("FIsCredited", DataImportUtils.transformValue(rs.getString("isCredited")));
            result.put("FTaxRate", DataImportUtils.transformValue(rs.getString("taxRate")));
            result.put("FInvoiceType", (Object)DataImportUtils.getInvoiceTypeValue(DataImportUtils.transformValue(rs.getString("invoiceType")).toString()));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        ObjectUuidPK pk = null;
        try {
            ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
            pk = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
            filterInfo = iCustomer.getDatabaseDFilter((IObjectPK)pk, "id", "adminCU.id");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.cssp.app.CustomerExportBaseQuery";
    }

    protected String[] getMainFields() {
        if (super.isSltImportUpdate()) {
            return new String[]{"FNumber"};
        }
        return mainFields;
    }
}

