/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.StandardTypeEnum;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Hashtable;

public class CustomerGroupStdDataImport
extends AbstractDataTransmission {
    private static final String defaultType = "0";
    private static final String typeForCustomer = "1";
    String[] INTEGER_FIELDS = new String[]{"FType"};
    String[] INTEGER_OBJS = new String[]{"type"};

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CSSPGroupStandardFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), (Throwable)bex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        CSSPGroupStandardInfo standardInfo = new CSSPGroupStandardInfo();
        Object numberdata = ((DataToken)hsData.get((Object)"FNumber")).data;
        ICSSPGroupStandard iSupplierBrowseGroup = (ICSSPGroupStandard)this.getController(ctx);
        CSSPGroupStandardCollection supplierBrowseGroupCollection = null;
        String str = null;
        if (numberdata == null) throw new TaskExternalException("number  not found!!!!");
        str = numberdata.toString();
        if (str != null && str.trim().length() > 0) {
            standardInfo.setNumber(str);
            if (super.isSltImportUpdate()) {
                try {
                    supplierBrowseGroupCollection = iSupplierBrowseGroup.getCSSPGroupStandardCollection("where number ='" + str + "'");
                    if (supplierBrowseGroupCollection != null && supplierBrowseGroupCollection.size() > 0) {
                        int count = supplierBrowseGroupCollection.size();
                        for (int index = 0; index < count; ++index) {
                            int type = supplierBrowseGroupCollection.get(index).getType();
                            if (type != 0 && type != 1) continue;
                            standardInfo.setId(supplierBrowseGroupCollection.get(index).getId());
                        }
                    }
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            }
        }
        Object data = null;
        String multiStr = ctx.getLocale().toString().toUpperCase();
        data = ((DataToken)hsData.get((Object)new StringBuilder().append((String)"FName_").append((String)multiStr).toString())).data;
        if (data != null) {
            standardInfo.setName(data.toString());
        }
        if ((data = ((DataToken)hsData.get((Object)new StringBuilder().append((String)"FDescription_").append((String)multiStr).toString())).data) != null) {
            standardInfo.setDescription(data.toString());
        }
        for (int i = 0; i < this.INTEGER_FIELDS.length; ++i) {
            try {
                Integer value;
                Object o = ((DataToken)hsData.get((Object)this.INTEGER_FIELDS[i])).data;
                if (o == null || o.toString().trim().length() <= 0 || (value = new Integer(o.toString())) == null) continue;
                standardInfo.setInt(this.INTEGER_OBJS[i], value);
                continue;
            }
            catch (NumberFormatException nex) {
                throw new TaskExternalException(this.INTEGER_OBJS[i] + " format error, it must be a number!!!");
            }
        }
        data = ((DataToken)hsData.get((Object)"FIsBasic")).data;
        if (data == null) return standardInfo;
        String value = data.toString();
        StandardTypeEnum type = DataImportUtils.getStandardType(value);
        if (type.equals((Object)StandardTypeEnum.basicStandard)) {
            if (!ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "baseGroupStdMatainByRoot", ctx));
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("isBasic", (Object)String.valueOf(1), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)typeForCustomer, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)defaultType, CompareType.EQUALS));
            if (standardInfo.getId() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)standardInfo.getId().toString(), CompareType.NOTEQUALS));
                filterInfo.setMaskString("#0 and (#1 or #2) and #3");
            } else {
                filterInfo.setMaskString("#0 and (#1 or #2)");
            }
            view.setFilter(filterInfo);
            try {
                supplierBrowseGroupCollection = iSupplierBrowseGroup.getCSSPGroupStandardCollection(view);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            if (supplierBrowseGroupCollection.size() > 0) {
                CustomerSupplierException excep = new CustomerSupplierException(CustomerSupplierException.CSSP_STANDARD_ONLY);
                throw new TaskExternalException(excep.getMessage(), (Throwable)((Object)excep));
            }
        }
        standardInfo.setIsBasic(type);
        return standardInfo;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICSSPGroupStandard iGroupStandard = (ICSSPGroupStandard)this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !iGroupStandard.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iGroupStandard.submit(coreBaseInfo);
            } else {
                iGroupStandard.importUpdate((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), (IObjectValue)coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            String multiName = "FName_" + ContextUtils.getLocaleFromEnv().toString().toUpperCase();
            String multiDescription = "FDescription_" + ContextUtils.getLocaleFromEnv().toString().toUpperCase();
            result.put("FNumber", DataImportUtils.transformValue(rs.getString("number")));
            result.put(multiName, DataImportUtils.transformValue(rs.getString("name")));
            result.put(multiDescription, DataImportUtils.transformValue(rs.getString("description")));
            result.put("FType", DataImportUtils.transformValue(String.valueOf(rs.getInt("type"))));
            result.put("FIsBasic", DataImportUtils.transformValue(String.valueOf(rs.getInt("isBasic"))));
            result.put("FCreatorNumber", DataImportUtils.transformValue(rs.getString("creator.number")));
            result.put("FCreateTime", DataImportUtils.getDateStrByLocale(ctx, rs.getDate("createTime")));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)defaultType, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)typeForCustomer, CompareType.EQUALS));
        filterInfo.setMaskString("#0 or #1");
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getLongNumber());
        try {
            filterInfo.mergeFilter(filterInfoCU, "and");
        }
        catch (BOSException e) {
            Logger.error((Throwable)e, (String)e.getMessage());
        }
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.cssp.app.CSSPGroupStandardExportQuery";
    }
}

