/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.AbstractMulDataTransmission;
import com.kingdee.eas.basedata.assistant.CashDiscountInfo;
import com.kingdee.eas.basedata.assistant.ChannelTypeFactory;
import com.kingdee.eas.basedata.assistant.ChannelTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPUtils;
import com.kingdee.eas.basedata.master.cssp.CustomerDeliveryAddressInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerLinkManInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSalerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerSalerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ICustomerSaleInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CustomerSaleDataImport
extends AbstractMulDataTransmission {
    String[] BOOLEAN_FIELDS = new String[]{"FIsFreezeOrder", "FIsFreezeDelivery"};
    String[] BOOLEAN_OBJS = new String[]{"isFreezeOrder", "isFreezeDelivery"};
    String[] DECIMAL_FIELDS = new String[]{"FTransAdvDay"};
    String[] DECIMAL_OBJS = new String[]{"transAdvanceDay"};
    String[] INTEGER_FIELDS = new String[]{"FDeliveryPriority"};
    String[] INTEGER_OBJS = new String[]{"deliverPriority"};
    private Set PerminsionCheckedCuIds = new HashSet();
    private Map<String, Boolean> userBizOrgRange = new HashMap<String, Boolean>();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CustomerSaleInfoFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICustomerSaleInfo iCustomerSaleInfo = (ICustomerSaleInfo)this.getController(ctx);
        coreBaseInfo.put("isImport", (Object)"true");
        ObjectUuidPK pk = null;
        try {
            if (coreBaseInfo.getId() == null || !iCustomerSaleInfo.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                ((CustomerSaleInfoInfo)coreBaseInfo).setCreateTime(null);
                iCustomerSaleInfo.submit(coreBaseInfo);
            } else {
                pk = new ObjectUuidPK(coreBaseInfo.getId());
                iCustomerSaleInfo.update((IObjectPK)pk, coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CoreBaseInfo createHead(Hashtable hsData, Context ctx) throws Exception {
        CustomerSaleInfoInfo customerSaleInfo = new CustomerSaleInfoInfo();
        customerSaleInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        DataImportUtils.setBooleanData(hsData, this.BOOLEAN_FIELDS, (CoreBaseInfo)customerSaleInfo, this.BOOLEAN_OBJS);
        DataImportUtils.setBigDecimalData(hsData, this.DECIMAL_FIELDS, (CoreBaseInfo)customerSaleInfo, this.DECIMAL_OBJS);
        DataImportUtils.setIntegerData(hsData, this.INTEGER_FIELDS, (CoreBaseInfo)customerSaleInfo, this.INTEGER_OBJS);
        Object data = null;
        String str = null;
        try {
            CashDiscountInfo info;
            SaleOrgUnitInfo curSaleUnit = null;
            data = ((DataToken)hsData.get((Object)"FSaleOrg")).data;
            if (data == null) throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "getSaleOrgUnitFailed", ctx));
            str = data.toString();
            curSaleUnit = DataImportUtils.getSaleOrgUnitInfoFromNumber(ctx, str);
            if (curSaleUnit == null) {
                throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "getSaleOrgUnitFailed", ctx));
            }
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            boolean hasBizOrgRange = false;
            if (this.userBizOrgRange.containsKey(userId + curSaleUnit.getId().toString())) {
                hasBizOrgRange = this.userBizOrgRange.get(userId + curSaleUnit.getId().toString());
            } else {
                hasBizOrgRange = PerminsionUtil.isUserBizOrgRange((Context)ctx, (String)userId, (String)curSaleUnit.getId().toString());
                this.userBizOrgRange.put(userId + curSaleUnit.getId().toString(), hasBizOrgRange);
            }
            if (!hasBizOrgRange) {
                throw new TaskExternalException(new MaterialBaseException(MaterialBaseException.OUT_BIZ_ORG, new Object[]{curSaleUnit.getName()}).getMessage());
            }
            String CuId = curSaleUnit.getCU().getId().toString();
            if (!this.PerminsionCheckedCuIds.contains(CuId)) {
                try {
                    PerminsionUtil.checkCUPerminsion((Context)ctx, (String)CuId, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), (String)"Customersaleinfo_Import");
                }
                catch (EASBizException ee) {
                    throw new TaskExternalException(ee.getMessage(), (Throwable)ee);
                }
                this.PerminsionCheckedCuIds.add(CuId);
            }
            customerSaleInfo.setSaleOrgUnit(curSaleUnit);
            customerSaleInfo.setCU(curSaleUnit.getCU());
            Object numberdata = ((DataToken)hsData.get((Object)"FNumber")).data;
            if (numberdata != null && (str = numberdata.toString()) != null && str.trim().length() > 0) {
                if (super.isSltImportUpdate()) {
                    CustomerInfo customerInfo = DataImportUtils.getCustomerInfoFromNumber(ctx, curSaleUnit.getCU(), str);
                    if (customerInfo == null) throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "customerNotExist", ctx));
                    customerSaleInfo.setCustomer(customerInfo);
                    ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
                    CustomerSaleInfoInfo oldCustomerSaleInfo = iCustomer.getCustomerSaleInfo((IObjectPK)new ObjectUuidPK(customerInfo.getId()), (IObjectPK)new ObjectUuidPK(curSaleUnit.getId()));
                    if (oldCustomerSaleInfo != null) {
                        customerSaleInfo.setId(oldCustomerSaleInfo.getId());
                    }
                    customerSaleInfo.setBillingOrgUnit(customerInfo);
                    customerSaleInfo.setSettlementOrgUnit(customerInfo);
                    customerSaleInfo.setDeliverOrgUnit(customerInfo);
                } else {
                    CustomerInfo customerInfo = DataImportUtils.getCustomerInfoFromNumber(ctx, curSaleUnit.getCU(), str);
                    if (customerInfo == null) throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "customerNotExist", ctx));
                    customerSaleInfo.setCustomer(customerInfo);
                }
            }
            if (hsData.get("FSettlementOrgUnitID") != null) {
                data = ((DataToken)hsData.get((Object)"FSettlementOrgUnitID")).data;
                if ("".equals(data)) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"settlementOrgUnitNotNull", (Locale)ctx.getOriginLocale()));
                }
                str = data.toString();
                CustomerInfo info2 = DataImportUtils.getCustomerInfoFromNumber(ctx, str);
                if (info2 != null) {
                    customerSaleInfo.setSettlementOrgUnit(info2);
                }
            }
            if (hsData.get("FDeliverOrgUnitID") != null) {
                data = ((DataToken)hsData.get((Object)"FDeliverOrgUnitID")).data;
                if ("".equals(data)) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"deliverOrgUnitNotNull", (Locale)ctx.getOriginLocale()));
                }
                str = data.toString();
                CustomerInfo info3 = DataImportUtils.getCustomerInfoFromNumber(ctx, str);
                if (info3 != null) {
                    customerSaleInfo.setDeliverOrgUnit(info3);
                }
            }
            if (hsData.get("FBillingOrgUnitID") != null) {
                data = ((DataToken)hsData.get((Object)"FBillingOrgUnitID")).data;
                if ("".equals(data)) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"billingOrgUnitNotNull", (Locale)ctx.getOriginLocale()));
                }
                str = data.toString();
                CustomerInfo info4 = DataImportUtils.getCustomerInfoFromNumber(ctx, str);
                if (info4 != null) {
                    customerSaleInfo.setBillingOrgUnit(info4);
                }
            }
            if (hsData.get("FCashDiscountID") != null && (info = DataImportUtils.getCashDiscountInfoByNumber(ctx, str = (data = ((DataToken)hsData.get((Object)"FCashDiscountID")).data).toString())) != null) {
                customerSaleInfo.setCashDiscount(info);
            }
            if (hsData.get("FChannelTypeID") != null) {
                data = ((DataToken)hsData.get((Object)"FChannelTypeID")).data;
                String number = data.toString();
                ChannelTypeInfo channelTypeInfo = null;
                if (number != null && number.length() > 0) {
                    try {
                        channelTypeInfo = (ChannelTypeInfo)ChannelTypeFactory.getLocalInstance((Context)ctx).getValue("select id where number = '" + number + "'");
                    }
                    catch (Exception e) {
                        throw new TaskExternalException(e.getMessage());
                    }
                }
                if (channelTypeInfo != null) {
                    customerSaleInfo.setChannelType(channelTypeInfo);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FStatus")).data) == null) return customerSaleInfo;
            String value = data.toString();
            customerSaleInfo.setUsingStatus(DataImportUtils.getCSSPAsstStatusValue(value));
            return customerSaleInfo;
        }
        catch (BOSException ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        catch (EASBizException ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected void createEntry(CoreBaseInfo head, Hashtable hsData, Context ctx) throws Exception {
        CustomerSaleInfoInfo customerSaleInfo = (CustomerSaleInfoInfo)head;
        this.handleCustomerSaleLink(customerSaleInfo, hsData, ctx);
        this.handleCustomerSaleAddress(customerSaleInfo, hsData, ctx);
        this.handleCustomerSaler(customerSaleInfo, hsData, ctx);
    }

    private void handleCustomerSaler(CustomerSaleInfoInfo customerSaleInfo, Hashtable hsData, Context ctx) throws Exception {
        int pos;
        CustomerSalerInfo custSalerInfo = new CustomerSalerInfo();
        Object o = null;
        o = ((DataToken)hsData.get((Object)"FCustomerSalerID")).data;
        if (o != null && o.toString().trim().length() > 0) {
            PersonInfo person = DataImportUtils.getPersonInfoFromNumber(ctx, o.toString().trim());
            custSalerInfo.setPerson(person);
        }
        if (custSalerInfo.getPerson() != null && (pos = this.isInCollection(custSalerInfo, customerSaleInfo.getCustomerSaler())) < 0) {
            customerSaleInfo.getCustomerSaler().add(custSalerInfo);
        }
    }

    private int isInCollection(CustomerSalerInfo info, CustomerSalerCollection collection) {
        if (info == null || info.getPerson() == null || info.getPerson().getId() == null || collection == null) {
            return -1;
        }
        for (int i = 0; i < collection.size(); ++i) {
            CustomerSalerInfo tempInfo = collection.get(i);
            if (tempInfo.getPerson() == null || !info.getPerson().getId().equals((Object)tempInfo.getPerson().getId())) continue;
            return i;
        }
        return -1;
    }

    private void handleCustomerSaleAddress(CustomerSaleInfoInfo customerSaleInfo, Hashtable hsData, Context ctx) throws Exception {
        CustomerDeliveryAddressInfo addressInfo = new CustomerDeliveryAddressInfo();
        Object o = null;
        String[] multiStr = new String[]{"L1", "L2", "L3"};
        int c = multiStr.length;
        for (int i = 0; i < c; ++i) {
            o = ((DataToken)hsData.get((Object)new StringBuilder().append((String)"FAddress_").append((String)multiStr[i]).toString())).data;
            if (o == null || o.toString().trim().length() <= 0) continue;
            addressInfo.setAddress(o.toString(), new Locale(multiStr[i]));
        }
        if (addressInfo.getAddress() != null && addressInfo.getAddress().trim().length() > 0) {
            int pos = CSSPUtils.isInCollection((IObjectValue)addressInfo, (IObjectCollection)customerSaleInfo.getDeliveryAddresses(), "Address");
            if (pos < 0) {
                customerSaleInfo.getDeliveryAddresses().add(addressInfo);
            } else {
                customerSaleInfo.getDeliveryAddresses().set(pos, addressInfo);
            }
        }
    }

    private void handleCustomerSaleLink(CustomerSaleInfoInfo customerSaleInfo, Hashtable hsData, Context ctx) throws Exception {
        String[] STRING_FIELDS = new String[]{"FContactPerson", "FContactPersonPost", "FPhone", "FFax", "FEMail", "FMobile", "FPostalcode", "FAddress"};
        String[] STRING_OBJS = new String[]{"contactPerson", "contactPersonPost", "phone", "fax", "email", "mobile", "postalcode", "address"};
        if (hsData.get("FPostalcode") != null && ((DataToken)hsData.get((Object)"FPostalcode")).data.toString().length() > 10) {
            throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "postZipCode", ctx));
        }
        CustomerLinkManInfo linkManInfo = new CustomerLinkManInfo();
        Object o = null;
        String value = null;
        for (int i = 0; i < STRING_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)STRING_FIELDS[i])).data;
            if (o == null || o.toString().trim().length() <= 0) continue;
            value = o.toString();
            linkManInfo.setString(STRING_OBJS[i], value);
        }
        if (linkManInfo.getContactPerson() != null && linkManInfo.getContactPerson().trim().length() > 0) {
            int pos = CSSPUtils.isInCollection((IObjectValue)linkManInfo, (IObjectCollection)customerSaleInfo.getCustomerLinkMan(), "ContactPerson");
            if (pos < 0) {
                customerSaleInfo.getCustomerLinkMan().add(linkManInfo);
            } else {
                customerSaleInfo.getCustomerLinkMan().set(pos, linkManInfo);
            }
        }
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("fid"));
        sic.add(new SelectorItemInfo("customerLinkMan.*"));
        sic.add(new SelectorItemInfo("customerSaler.*"));
        sic.add(new SelectorItemInfo("deliveryAddresses.*"));
        return sic;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            result.put("FNumber", DataImportUtils.transformValue(rs.getString("number")));
            result.put("FSaleOrg", DataImportUtils.transformValue(rs.getString("orgUnit.number")));
            result.put("FIsFreezeOrder", DataImportUtils.transformValue(rs.getBoolean("customerSale.isFreezeOrder")));
            result.put("FIsFreezeDelivery", DataImportUtils.transformValue(rs.getBoolean("customerSale.isFreDelivery")));
            result.put("FSettlementOrgUnitID", DataImportUtils.transformValue(rs.getString("settlementOrgUnit.number")));
            result.put("FBillingOrgUnitID", DataImportUtils.transformValue(rs.getString("billingOrgUnit.number")));
            result.put("FDeliverOrgUnitID", DataImportUtils.transformValue(rs.getString("deliverOrgUnit.number")));
            result.put("FTransAdvDay", DataImportUtils.transformValue(rs.getString("customerSale.transAdvanceDay")));
            result.put("FDeliveryPriority", DataImportUtils.transformValue(String.valueOf(rs.getInt("customerSale.deliverPriority"))));
            result.put("FCashDiscountID", DataImportUtils.transformValue(rs.getString("cashDiscount.number")));
            result.put("FContactPerson", DataImportUtils.transformValue(rs.getString("customerLink.contactPerson")));
            result.put("FContactPersonPost", DataImportUtils.transformValue(rs.getString("customerLink.contactPersonPost")));
            result.put("FPhone", DataImportUtils.transformValue(rs.getString("customerLink.phone")));
            result.put("FFax", DataImportUtils.transformValue(rs.getString("customerLink.fax")));
            result.put("FEMail", DataImportUtils.transformValue(rs.getString("customerLink.email")));
            result.put("FPostalcode", DataImportUtils.transformValue(rs.getString("customerLink.postalcode")));
            result.put("FMobile", DataImportUtils.transformValue(rs.getString("customerLink.mobile")));
            result.put("FAddress", DataImportUtils.transformValue(rs.getString("customerLink.address")));
            String multiAddress = "FAddress_" + ContextUtils.getLocaleFromEnv().toString().toUpperCase();
            result.put(multiAddress, DataImportUtils.transformValue(rs.getString("deliveryAddress.address")));
            result.put("FCreatorNumber", DataImportUtils.transformValue(rs.getString("creator.number")));
            result.put("FCreateTime", DataImportUtils.getDateStrByLocale(ctx, rs.getDate("customerSaleInfo.createTime")));
            result.put("FCustomerSalerID", DataImportUtils.transformValue(rs.getString("customerSaler.person.number")));
            result.put("FChannelTypeID", DataImportUtils.transformValue(rs.getString("channelType.number")));
            result.put("FStatus", (Object)DataImportUtils.getCSSPAsstStatusValue(DataImportUtils.transformValue(rs.getString("customerSaleInfo.usingStatus")).toString()));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        ObjectUuidPK pk = null;
        try {
            ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
            pk = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
            filterInfo = iCustomer.getDatabaseDFilter((IObjectPK)pk, "id", "adminCU.id");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.cssp.app.CustomerExportSaleQuery";
    }

    protected String[] getMainFields() {
        return new String[]{"FNumber", "FSaleOrg"};
    }
}

