/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSalerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ICustomerSaleInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class CustomerSalerDataImport
extends AbstractDataTransmission {
    private CustomerSaleInfoInfo oldCustomerSaleInfo = null;
    private Set PerminsionCheckedCuIds = new HashSet();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CustomerSaleInfoFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICustomerSaleInfo iCustomerSaleInfo = (ICustomerSaleInfo)this.getController(ctx);
        IObjectPK pk = null;
        try {
            if (coreBaseInfo.getId() == null || !iCustomerSaleInfo.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                pk = iCustomerSaleInfo.submit(coreBaseInfo);
            } else {
                pk = new ObjectUuidPK(coreBaseInfo.getId());
                iCustomerSaleInfo.update(pk, coreBaseInfo);
            }
            this.oldCustomerSaleInfo = iCustomerSaleInfo.getCustomerSaleInfoInfo(pk);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        CustomerSaleInfoInfo customerSaleInfo = new CustomerSaleInfoInfo();
        customerSaleInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        Object data = null;
        String str = null;
        try {
            CustomerSaleInfoInfo currentSaleInfo;
            SaleOrgUnitInfo curSaleUnit = null;
            data = ((DataToken)hsData.get((Object)"FSaleOrg")).data;
            if (data == null) {
                throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "getSaleOrgUnitFailed", ctx));
            }
            str = data.toString();
            curSaleUnit = DataImportUtils.getSaleOrgUnitInfoFromNumber(ctx, str);
            if (curSaleUnit == null) {
                throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "getSaleOrgUnitFailed", ctx));
            }
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            if (!PerminsionUtil.isUserBizOrgRange((Context)ctx, (String)userId, (String)curSaleUnit.getId().toString())) {
                throw new TaskExternalException(new MaterialBaseException(MaterialBaseException.OUT_BIZ_ORG, new Object[]{curSaleUnit.getName()}).getMessage());
            }
            String CuId = curSaleUnit.getCU().getId().toString();
            if (!this.PerminsionCheckedCuIds.contains(CuId)) {
                try {
                    PerminsionUtil.checkCUPerminsion((Context)ctx, (String)CuId, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), (String)"Customersaleinfo_Import");
                }
                catch (EASBizException ee) {
                    throw new TaskExternalException(ee.getMessage(), (Throwable)ee);
                }
                this.PerminsionCheckedCuIds.add(CuId);
            }
            customerSaleInfo.setSaleOrgUnit(curSaleUnit);
            customerSaleInfo.setCU(curSaleUnit.getCU());
            Object numberdata = ((DataToken)hsData.get((Object)"FNumber")).data;
            if (numberdata == null || numberdata.toString().trim().length() == 0) {
                throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "customerNotExist", ctx));
            }
            str = numberdata.toString();
            CustomerInfo customerInfo = DataImportUtils.getCustomerInfoFromNumber(ctx, curSaleUnit.getCU(), str);
            if (customerInfo == null) {
                throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "customerNotExist", ctx));
            }
            customerSaleInfo.setCustomer(customerInfo);
            ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
            CustomerSaleInfoInfo custSaleInfo = iCustomer.getCustomerSaleInfo((IObjectPK)new ObjectUuidPK(customerInfo.getId()), (IObjectPK)new ObjectUuidPK(curSaleUnit.getId()));
            if (custSaleInfo != null && (currentSaleInfo = iCustomer.getCustomerSaleInfo((IObjectPK)new ObjectUuidPK(custSaleInfo.getId()), this.getSelector())) != null) {
                customerSaleInfo.setId(currentSaleInfo.getId());
                if (currentSaleInfo.getDeliveryAddresses() != null) {
                    customerSaleInfo.getDeliveryAddresses().addCollection(currentSaleInfo.getDeliveryAddresses());
                }
                if (currentSaleInfo.getCustomerLinkMan() != null) {
                    customerSaleInfo.getCustomerLinkMan().addCollection(currentSaleInfo.getCustomerLinkMan());
                }
            }
            this.handleCustomerSaler(customerSaleInfo, hsData, ctx);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return customerSaleInfo;
    }

    private void handleCustomerSaler(CustomerSaleInfoInfo customerSaleInfo, Hashtable hsData, Context ctx) throws Exception {
        if (customerSaleInfo.getId() != null) {
            int exsistPos = -1;
            CustomerSalerInfo custSalerInfo = new CustomerSalerInfo();
            Object o = null;
            String customerSalerID = null;
            o = ((DataToken)hsData.get((Object)"FCustomerSalerID")).data;
            if (o == null || o.toString().trim().length() == 0) {
                throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "customerSalerNotExist", ctx));
            }
            PersonInfo person = DataImportUtils.getPersonInfoFromNumber(ctx, o.toString().trim());
            if (person == null) {
                throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "customerSalerNotExist", ctx));
            }
            custSalerInfo.setPerson(person);
            customerSalerID = person.getId().toString();
            if (!this.isSltImportUpdate()) {
                CustomerSaleInfoInfo oldSaleInfo = CustomerSaleInfoFactory.getLocalInstance(ctx).getCustomerSaleInfoInfo((IObjectPK)new ObjectUuidPK(customerSaleInfo.getId()), this.getSelector());
                customerSaleInfo.getCustomerSaler().addCollection(oldSaleInfo.getCustomerSaler());
            } else if (this.oldCustomerSaleInfo != null && this.oldCustomerSaleInfo.getId().equals((Object)customerSaleInfo.getId())) {
                customerSaleInfo.getCustomerSaler().addCollection(this.oldCustomerSaleInfo.getCustomerSaler());
            }
            for (int i = 0; i < customerSaleInfo.getCustomerSaler().size(); ++i) {
                CustomerSalerInfo salerInfo = customerSaleInfo.getCustomerSaler().get(i);
                if (salerInfo == null || !salerInfo.getPerson().getId().toString().equals(customerSalerID)) continue;
                exsistPos = i;
            }
            if (exsistPos < 0) {
                customerSaleInfo.getCustomerSaler().add(custSalerInfo);
            }
        }
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("fid"));
        sic.add(new SelectorItemInfo("customerSaler.*"));
        sic.add(new SelectorItemInfo("customerLinkMan.*"));
        sic.add(new SelectorItemInfo("deliveryAddresses.*"));
        return sic;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            result.put("FNumber", DataImportUtils.transformValue(rs.getString("number")));
            result.put("FSaleOrg", DataImportUtils.transformValue(rs.getString("orgUnit.number")));
            result.put("FCustomerSalerID", DataImportUtils.transformValue(rs.getString("customerSaler.person.number")));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        ObjectUuidPK pk = null;
        try {
            ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
            pk = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
            filterInfo = iCustomer.getDatabaseDFilter((IObjectPK)pk, "id", "adminCU.id");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.cssp.app.CustomerExportSalerQuery";
    }
}

