/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerTaxFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerTaxInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ICustomerTax;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.cssp.TaxPayerType;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class CustomerTaxDataImport
extends AbstractDataTransmission {
    private Set PerminsionCheckedCuIds = new HashSet();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CustomerTaxFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICustomerTax iCustomerTax = (ICustomerTax)this.getController(ctx);
        IObjectPK pk = null;
        try {
            if (coreBaseInfo.getId() == null || !iCustomerTax.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                pk = iCustomerTax.submit(coreBaseInfo);
            } else {
                pk = new ObjectUuidPK(coreBaseInfo.getId());
                iCustomerTax.update(pk, coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        CustomerTaxInfo customerTaxInfo = null;
        String str = null;
        try {
            CustomerInfo customerInfo = null;
            Object numberdata = ((DataToken)hsData.get((Object)"FCustomer_number")).data;
            if (numberdata == null || numberdata.toString().trim().length() == 0) {
                throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "customerNotExist", ctx));
            }
            str = numberdata.toString();
            customerInfo = DataImportUtils.getCustomerInfoFromNumber(ctx, str);
            if (customerInfo == null) {
                throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "customerNotExist", ctx));
            }
            if (customerInfo.getUsedStatus() != UsedStatusEnum.UNAPPROVE) {
                throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "ApproveStatusNotChange", ctx));
            }
            if (customerInfo.getId() != null) {
                customerTaxInfo = new CustomerTaxInfo();
                customerTaxInfo.setCustomer(customerInfo);
                Object o = null;
                o = ((DataToken)hsData.get((Object)"FBillToCompanyName")).data;
                if (o == null || o.toString().trim().length() == 0) {
                    throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "BillToCompanyNotNull", ctx));
                }
                String billToCompanyNameStr = o.toString().trim();
                if (billToCompanyNameStr.length() > 100) {
                    throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "BillToCompantNameLen100", ctx));
                }
                customerTaxInfo.setBillToCompanyName(o.toString().trim());
                o = ((DataToken)hsData.get((Object)"FTaxpayerType")).data;
                if (o == null || o.toString().trim().length() == 0) {
                    throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "TaxPayerTypeNotNull", ctx));
                }
                customerTaxInfo.setTaxpayerType(TaxPayerType.getEnum(o.toString().trim()));
                o = ((DataToken)hsData.get((Object)"FPayInvoiceType")).data;
                if (o == null || o.toString().trim().length() == 0) {
                    throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "PayInvoiceTypeNotNull", ctx));
                }
                customerTaxInfo.setPayInvoiceType(PayInvoiceTypeEnum.getEnum(o.toString().trim()));
                o = ((DataToken)hsData.get((Object)"FCompantTFN")).data;
                if (o == null || o.toString().trim().length() == 0) {
                    if ("1".equals(customerTaxInfo.getPayInvoiceType().getValue())) {
                        throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "PayInvoiceTypeWithoutCompantTFN", ctx));
                    }
                } else {
                    Pattern pattern = Pattern.compile("[0-9a-zA-Z]+");
                    String compantTFNStr = o.toString().trim();
                    ICustomerTax iCustomerTax = CustomerTaxFactory.getLocalInstance(ctx);
                    boolean bool = iCustomerTax.exists("where compantTFN = '" + compantTFNStr + "'");
                    if (bool) {
                        throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "CompantTFNRepeat", ctx));
                    }
                    customerTaxInfo.setCompantTFN(o.toString().trim());
                }
                if ((o = ((DataToken)hsData.get((Object)"FAddress")).data) == null && o.toString().trim().length() > 200) {
                    throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "AddressLen200", ctx));
                }
                customerTaxInfo.setAddress(o.toString().trim());
                o = ((DataToken)hsData.get((Object)"FTelephone")).data;
                if (o != null) {
                    if (o.toString().trim().length() > 20) {
                        throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "TelephoneLen20", ctx));
                    }
                    if (o.toString().trim().length() < 20) {
                        customerTaxInfo.setTelephone(o.toString().trim());
                    }
                }
                if ((o = ((DataToken)hsData.get((Object)"FBankAccount")).data) == null && o.toString().trim().length() > 100) {
                    throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "BankAccountLen200", ctx));
                }
                customerTaxInfo.setBankAccount(o.toString().trim());
                o = ((DataToken)hsData.get((Object)"FDefaultBillToCompany")).data;
                if (o == null) {
                    throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "DefaultBillToCompanyNotSelected", ctx));
                }
                if (!"false".equals(o.toString().trim()) && !"true".equals(o.toString().trim())) {
                    throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "DefaultBillToCompanyNotSelected", ctx));
                }
                numberdata = ((DataToken)hsData.get((Object)"FBank_number")).data;
                if (numberdata != null && numberdata.toString().trim().length() > 0) {
                    str = numberdata.toString();
                    BankInfo bankInfo = DataImportUtils.getBankInfoFromNumer(ctx, str);
                    if (bankInfo == null) {
                        throw new TaskExternalException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "BankNotExist", ctx));
                    }
                    customerTaxInfo.setBank(bankInfo);
                }
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return customerTaxInfo;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("fid"));
        sic.add(new SelectorItemInfo("customerTax.*"));
        sic.add(new SelectorItemInfo("customerTax.bank.*"));
        return sic;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            result.put("FCustomer_number", DataImportUtils.transformValue(rs.getString("number")));
            result.put("FBillToCompanyName", DataImportUtils.transformValue(rs.getString("customerTax.billToCompanyName")));
            result.put("FTaxpayerType", DataImportUtils.transformValue(rs.getString("customerTax.taxpayerType")));
            result.put("FPayInvoiceType", DataImportUtils.transformValue(rs.getString("customerTax.payInvoiceType")));
            result.put("FCompantTFN", DataImportUtils.transformValue(rs.getString("customerTax.compantTFN")));
            result.put("FAddress", DataImportUtils.transformValue(rs.getString("customerTax.address")));
            result.put("FTelephone", DataImportUtils.transformValue(rs.getString("customerTax.telephone")));
            result.put("FBank_number", DataImportUtils.transformValue(rs.getString("bank.number")));
            result.put("FBankAccount", DataImportUtils.transformValue(rs.getString("customerTax.bankAccount")));
            result.put("FDefaultBillToCompany", DataImportUtils.transformValue(rs.getString("customerTax.defaultBillToCompany")));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        ObjectUuidPK pk = null;
        try {
            ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
            pk = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
            filterInfo = iCustomer.getDatabaseDFilter((IObjectPK)pk, "id", "adminCU.id");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.cssp.app.CustomerExportTaxQuery";
    }
}

