/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CashDiscountInfo;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IndustryInfo;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.assistant.RegionInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.TaxDataInfo;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerDeliveryAddressInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerGroupDetailCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerGroupDetailInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerKindEnum;
import com.kingdee.eas.basedata.master.cssp.CustomerLinkManInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroup;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerSaleInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.PaymentItemTypeEnum;
import com.kingdee.eas.basedata.master.cssp.StandardTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierGroupDetailCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierGroupDetailInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.app.AbstractImportCSSPManagerFacadeControllerBean;
import com.kingdee.eas.basedata.master.cssp.app.CustomerBrowseGroupDataImport;
import com.kingdee.eas.basedata.master.cssp.app.CustomerCompanyDataImport;
import com.kingdee.eas.basedata.master.cssp.app.CustomerDataImport;
import com.kingdee.eas.basedata.master.cssp.app.CustomerGroupStdDataImport;
import com.kingdee.eas.basedata.master.cssp.app.CustomerSaleDataImport;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.cssp.app.SupplierCompanyDataImport;
import com.kingdee.eas.basedata.master.cssp.app.SupplierDataImport;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgSwitchFacade;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ImportCSSPManagerFacadeControllerBean
extends AbstractImportCSSPManagerFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.cssp.app.ImportCSSPManagerFacadeControllerBean");
    private boolean isHasBasicStandard = false;

    @Override
    protected String[][] _importCustomerInfo(Context ctx, Hashtable hsData) throws BOSException, EASBizException {
        String[][] result = new String[1][2];
        CustomerDataImport im = new CustomerDataImport();
        ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
        try {
            CustomerInfo info = (CustomerInfo)im.transmit(hsData, ctx);
            iCustomer.submit((CoreBaseInfo)info);
            result[0][0] = "0000";
            result[0][1] = info.getNumber();
        }
        catch (TaskExternalException e) {
            result[0][0] = "1111";
            result[0][1] = e.getMessage();
        }
        return result;
    }

    @Override
    protected String[][] _importCustomerCompanyInfo(Context ctx, Hashtable hsData) throws BOSException, EASBizException {
        String[][] result = new String[1][2];
        CustomerCompanyDataImport im = new CustomerCompanyDataImport();
        ICustomerCompanyInfo iCustomerCompanyInfo = CustomerCompanyInfoFactory.getLocalInstance(ctx);
        try {
            CustomerCompanyInfoInfo info = (CustomerCompanyInfoInfo)im.transmit(hsData, ctx);
            iCustomerCompanyInfo.submit((CoreBaseInfo)info);
            result[0][0] = "0000";
            result[0][1] = info.getNumber();
        }
        catch (TaskExternalException e) {
            result[0][0] = "1111";
            result[0][1] = e.getMessage();
        }
        return result;
    }

    @Override
    protected String[][] _importCustomerSaleInfo(Context ctx, Hashtable hsData) throws BOSException, EASBizException {
        String[][] result = new String[1][2];
        CustomerSaleDataImport im = new CustomerSaleDataImport();
        ICustomerSaleInfo iCustomerSaleInfo = CustomerSaleInfoFactory.getLocalInstance(ctx);
        try {
            CustomerSaleInfoInfo info = (CustomerSaleInfoInfo)im.transmit(hsData, ctx);
            iCustomerSaleInfo.submit((CoreBaseInfo)info);
            result[0][0] = "0000";
            result[0][1] = info.getNumber();
        }
        catch (TaskExternalException e) {
            result[0][0] = "1111";
            result[0][1] = e.getMessage();
        }
        return result;
    }

    @Override
    protected String[][] _importCSSPGroup(Context ctx, Hashtable hsData) throws BOSException, EASBizException {
        String[][] result = new String[1][2];
        CustomerBrowseGroupDataImport im = new CustomerBrowseGroupDataImport();
        ICSSPGroup iCSSPGroup = CSSPGroupFactory.getLocalInstance(ctx);
        try {
            CSSPGroupInfo info = (CSSPGroupInfo)im.transmit(hsData, ctx);
            iCSSPGroup.submit((CoreBaseInfo)info);
            result[0][0] = "0000";
            result[0][1] = info.getNumber();
        }
        catch (TaskExternalException e) {
            result[0][0] = "1111";
            result[0][1] = e.getMessage();
        }
        return result;
    }

    @Override
    protected String[][] _importCSSPStandard(Context ctx, Hashtable hsData) throws BOSException, EASBizException {
        String[][] result = new String[1][2];
        CustomerGroupStdDataImport im = new CustomerGroupStdDataImport();
        ICSSPGroupStandard iStandard = CSSPGroupStandardFactory.getLocalInstance(ctx);
        try {
            CSSPGroupStandardInfo info = (CSSPGroupStandardInfo)im.transmit(hsData, ctx);
            iStandard.submit((CoreBaseInfo)info);
            result[0][0] = "0000";
            result[0][1] = info.getNumber();
        }
        catch (TaskExternalException e) {
            result[0][0] = "1111";
            result[0][1] = e.getMessage();
        }
        return result;
    }

    @Override
    protected String[][] _importSupplierInfo(Context ctx, Hashtable hsData) throws BOSException, EASBizException {
        String[][] result = new String[1][2];
        SupplierDataImport im = new SupplierDataImport();
        ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
        try {
            SupplierInfo info = (SupplierInfo)im.transmit(hsData, ctx);
            iSupplier.submit((CoreBaseInfo)info);
            result[0][0] = "0000";
            result[0][1] = info.getNumber();
        }
        catch (TaskExternalException e) {
            result[0][0] = "1111";
            result[0][1] = e.getMessage();
        }
        return result;
    }

    @Override
    protected String[][] _importSupplierCompanyInfo(Context ctx, Hashtable hsData) throws BOSException, EASBizException {
        String[][] result = new String[1][2];
        SupplierCompanyDataImport im = new SupplierCompanyDataImport();
        ISupplierCompanyInfo iSupplierCompany = SupplierCompanyInfoFactory.getLocalInstance(ctx);
        try {
            SupplierCompanyInfoInfo info = (SupplierCompanyInfoInfo)im.transmit(hsData, ctx);
            iSupplierCompany.submit((CoreBaseInfo)info);
            result[0][0] = "0000";
            result[0][1] = info.getNumber();
        }
        catch (TaskExternalException e) {
            result[0][0] = "1111";
            result[0][1] = e.getMessage();
        }
        return result;
    }

    @Override
    protected String[][] _importCustomerInfo(Context ctx, String number, String name, String foreignName, String shortName, int customerKind, String barCode, String memonicCode, String bizAnalysisCodeNumber, String parentNumber, boolean isInternalCompany, String interNumber, String bizRegisterNo, String busiLicence, String busiExequatur, String authentication, String taxNumber, String industryNumber, String address, String countryNumber, String provinceNumber, String cityNumber, String regionNumber, String artificialPerson, int version, String freezeOrgUnit, int usedStatus, String[] standardNum, String[] groupNumber) throws BOSException, EASBizException {
        return this.importCustomerInfo(ctx, number, name, foreignName, shortName, customerKind, barCode, memonicCode, bizAnalysisCodeNumber, parentNumber, isInternalCompany, interNumber, bizRegisterNo, busiLicence, busiExequatur, authentication, taxNumber, industryNumber, address, countryNumber, provinceNumber, cityNumber, regionNumber, artificialPerson, version, freezeOrgUnit, usedStatus, standardNum, groupNumber, null);
    }

    private void handleCustomerGroupDetail(CustomerInfo customerInfo, String standardNum, String groupNumber, Context ctx) throws Exception {
        Serializable info;
        boolean isAddNew = true;
        CustomerGroupDetailCollection oldCollection = null;
        if (customerInfo.getId() != null) {
            CustomerInfo oldCustomerInfo = CustomerFactory.getLocalInstance(ctx).getCustomerInfo((IObjectPK)new ObjectUuidPK(customerInfo.getId()), this.getCustomerSelector());
            oldCollection = oldCustomerInfo.getCustomerGroupDetails();
            isAddNew = false;
        }
        CustomerGroupDetailInfo detailInfo = new CustomerGroupDetailInfo();
        Object data = null;
        CSSPGroupInfo browseGroupInfo = null;
        if (standardNum != null && standardNum.trim().length() > 0) {
            info = DataImportUtils.getGroupStandardInfoByNumber(ctx, standardNum, "customer");
            if (info != null) {
                detailInfo.setCustomerGroupStandard((CSSPGroupStandardInfo)info);
            } else {
                throw new BOSException(standardNum + DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "standardNotExist", ctx));
            }
        }
        if (groupNumber != null && groupNumber.trim().length() > 0) {
            info = DataImportUtils.getGroupInfoByNumber(ctx, groupNumber, standardNum);
            if (info != null) {
                detailInfo.setCustomerGroup((CSSPGroupInfo)info);
            } else {
                throw new BOSException(groupNumber + DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "groupNotExist", ctx));
            }
        }
        if (isAddNew) {
            customerInfo.getCustomerGroupDetails().add(detailInfo);
            if (detailInfo.getCustomerGroupStandard().getIsBasic().equals((Object)StandardTypeEnum.basicStandard)) {
                this.isHasBasicStandard = true;
                browseGroupInfo = detailInfo.getCustomerGroup();
            }
        } else {
            CustomerGroupDetailInfo oldDetailInfo = new CustomerGroupDetailInfo();
            boolean isAddNewGroupDetail = true;
            if (null != oldCollection) {
                int c = oldCollection.size();
                for (int i = 0; i < c; ++i) {
                    oldDetailInfo = oldCollection.get(i);
                    if (oldDetailInfo.getCustomerGroupStandard().getIsBasic().equals((Object)StandardTypeEnum.basicStandard)) {
                        this.isHasBasicStandard = true;
                        browseGroupInfo = detailInfo.getCustomerGroup();
                    }
                    if (oldDetailInfo.getCustomerGroupStandard().getNumber().equals(detailInfo.getCustomerGroupStandard().getNumber())) {
                        oldDetailInfo.setCustomerGroup(detailInfo.getCustomerGroup());
                        isAddNewGroupDetail = false;
                    }
                    customerInfo.getCustomerGroupDetails().add(oldDetailInfo);
                }
            }
            if (isAddNewGroupDetail) {
                customerInfo.getCustomerGroupDetails().add(detailInfo);
            }
        }
        if (this.isHasBasicStandard && customerInfo.getBrowseGroup() == null) {
            customerInfo.setBrowseGroup(browseGroupInfo);
        }
        if (!this.isHasBasicStandard) {
            throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "baseGroupStandardNotNull", ctx));
        }
    }

    private SelectorItemCollection getCustomerSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("fid"));
        sic.add(new SelectorItemInfo("customerGroupDetails.id"));
        sic.add(new SelectorItemInfo("customerGroupDetails.customerGroupStandard.*"));
        sic.add(new SelectorItemInfo("customerGroupDetails.customerGroup.*"));
        sic.add(new SelectorItemInfo("customerGroupDetails.customer.*"));
        return sic;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String[][] _importCustomerCompanyInfo(Context ctx, String number, String orgNumber, String paymentTypeNumber, String currencyNumber, String settlementTypeNum, String accountClassNum, String contactPerson, String contactPersonPost, String phone, String mobile, String fax, String email, String postalcode, String bank, String bankAccount, String bankAddress, boolean isTicketFreezed, String freezeOrgUnitNum) throws BOSException, EASBizException {
        boolean[] BOOLEAN_FIELDS = new boolean[]{isTicketFreezed};
        String[] BOOLEAN_OBJS = new String[]{"isFreezeIssueInvoice"};
        String[] STRING_FIELDS = new String[]{contactPerson, contactPersonPost, phone, mobile, fax, email, postalcode, bank, bankAccount, bankAddress};
        String[] STRING_OBJS = new String[]{"contactPerson", "contactPersonPost", "phone", "mobile", "fax", "email", "postalcode", "bank", "bankAccount", "bankAddress"};
        String[][] result = new String[1][2];
        CustomerCompanyInfoInfo customerCompanyInfo = new CustomerCompanyInfoInfo();
        customerCompanyInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        customerCompanyInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        try {
            PaymentTypeInfo info;
            this.setBooleanData(BOOLEAN_FIELDS, (CoreBaseInfo)customerCompanyInfo, BOOLEAN_OBJS);
            if (postalcode != null && postalcode.length() > 10) {
                throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "postZipCode", ctx));
            }
            this.setStringData(STRING_FIELDS, (CoreBaseInfo)customerCompanyInfo, STRING_OBJS);
            CompanyOrgUnitInfo curCompany = DataImportUtils.getCompanyOrgUnitInfoFromNumber(ctx, orgNumber);
            if (curCompany == null) {
                curCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
            }
            if (curCompany == null) {
                throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "getCompanyOrgUnitFailed", ctx));
            }
            customerCompanyInfo.setCompanyOrgUnit(curCompany);
            if (number == null || number.length() <= 0) throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "customerNotExist", ctx));
            if (DataImportUtils.getCustomerInfoFromNumber(ctx, number) == null) throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "customerNotExist", ctx));
            CustomerInfo customerInfo = DataImportUtils.getCustomerInfoFromNumber(ctx, number);
            customerCompanyInfo.setCustomer(customerInfo);
            ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
            CustomerCompanyInfoInfo oldCustomerCompanyInfo = iCustomer.getCustomerCompanyInfo((IObjectPK)new ObjectUuidPK(customerInfo.getId()), (IObjectPK)new ObjectUuidPK(curCompany.getId()));
            if (oldCustomerCompanyInfo != null) {
                customerCompanyInfo.setId(oldCustomerCompanyInfo.getId());
            }
            if (paymentTypeNumber != null && paymentTypeNumber.length() > 0 && (info = DataImportUtils.getPaymentTypeInfoFromNumber(ctx, paymentTypeNumber)) != null) {
                customerCompanyInfo.setPaymentType(info);
            }
            if (currencyNumber != null && currencyNumber.length() > 0) {
                info = DataImportUtils.getCurrencyInfoFromNumber(ctx, currencyNumber);
                if (info == null) throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "SupplierCurrency", ctx));
                customerCompanyInfo.setSettlementCurrency((CurrencyInfo)info);
            }
            if (settlementTypeNum != null && settlementTypeNum.length() > 0 && (info = DataImportUtils.getSettlementTypeInfoFromNumber(ctx, settlementTypeNum)) != null) {
                customerCompanyInfo.setSettlementType((SettlementTypeInfo)info);
            }
            if (accountClassNum != null && accountClassNum.length() > 0) {
                info = DataImportUtils.getKAClassficationInfoFromNumber(ctx, accountClassNum, curCompany, "customer");
                if (info == null) throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "SupplierAccountingClassification", ctx));
                customerCompanyInfo.setAccountingClassfication((KAClassficationInfo)info);
            }
            if (freezeOrgUnitNum != null && freezeOrgUnitNum.length() > 0 && (info = DataImportUtils.getFullOrgUnitInfoFromNumber(ctx, freezeOrgUnitNum)) != null) {
                customerCompanyInfo.setFreezeOrgUnit((FullOrgUnitInfo)info);
                customerCompanyInfo.setIsFreezeIssueInvoice(true);
            }
            ICustomerCompanyInfo iCustomerCompanyInfo = CustomerCompanyInfoFactory.getLocalInstance(ctx);
            if (customerCompanyInfo.getId() == null) {
                iCustomerCompanyInfo.submit((CoreBaseInfo)customerCompanyInfo);
            } else {
                iCustomerCompanyInfo.update((IObjectPK)new ObjectUuidPK(customerCompanyInfo.getId()), (CoreBaseInfo)customerCompanyInfo);
            }
            result[0][0] = "0000";
            result[0][1] = number;
            return result;
        }
        catch (Exception e) {
            result[0][0] = "1111";
            result[0][1] = e.getMessage();
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String[][] _importCustomerSaleInfo(Context ctx, String number, String orgNumber, boolean isSubsale, boolean isFreezeOrder, boolean isFreezeDelivery, String settlementOrgUnitNum, String billingOrgUnitNum, String deliverOrgUnitNum, BigDecimal transAdvDay, int deliveryPriority, String cashDiscountNum, int cashKind, int monthBancance, int dayBancance, String[] linkMan, String[] contactPersonPost, String[] phone, String[] fax, String[] mobile, String[] email, String[] postalcode, String[] postAddress, String[] deliveryAddress) throws BOSException, EASBizException {
        boolean[] BOOLEAN_FIELDS = new boolean[]{isFreezeOrder, isFreezeDelivery};
        String[] BOOLEAN_OBJS = new String[]{"isFreezeOrder", "isFreezeDelivery"};
        int[] INTEGER_FIELDS = new int[]{deliveryPriority};
        String[] INTEGER_OBJS = new String[]{"deliverPriority"};
        BigDecimal[] DECIMAL_FIELDS = new BigDecimal[]{transAdvDay};
        String[] DECIMAL_OBJS = new String[]{"transAdvanceDay"};
        String[][] result = new String[1][2];
        try {
            int i;
            PaymentItemTypeEnum paymentTypeEnum;
            CustomerInfo info;
            CustomerSaleInfoInfo customerSaleInfo = new CustomerSaleInfoInfo();
            customerSaleInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            customerSaleInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
            this.setBooleanData(BOOLEAN_FIELDS, (CoreBaseInfo)customerSaleInfo, BOOLEAN_OBJS);
            this.setIntData(INTEGER_FIELDS, (CoreBaseInfo)customerSaleInfo, INTEGER_OBJS);
            this.setBigDecimalData(DECIMAL_FIELDS, (CoreBaseInfo)customerSaleInfo, DECIMAL_OBJS);
            SaleOrgUnitInfo curSaleUnit = DataImportUtils.getSaleOrgUnitInfoFromNumber(ctx, orgNumber);
            if (curSaleUnit == null) {
                curSaleUnit = ContextUtil.getCurrentSaleUnit((Context)ctx);
            }
            if (curSaleUnit == null) {
                throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "getSaleOrgUnitFailed", ctx));
            }
            customerSaleInfo.setSaleOrgUnit(curSaleUnit);
            if (number == null || number.length() <= 0) throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "customerNotExist", ctx));
            CustomerInfo customerInfo = DataImportUtils.getCustomerInfoFromNumber(ctx, number);
            if (customerInfo == null) throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "customerNotExist", ctx));
            customerSaleInfo.setCustomer(customerInfo);
            ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
            CustomerSaleInfoInfo oldCustomerSaleInfo = iCustomer.getCustomerSaleInfo((IObjectPK)new ObjectUuidPK(customerInfo.getId()), (IObjectPK)new ObjectUuidPK(curSaleUnit.getId()));
            if (oldCustomerSaleInfo != null) {
                customerSaleInfo.setId(oldCustomerSaleInfo.getId());
            }
            customerSaleInfo.setBillingOrgUnit(customerInfo);
            customerSaleInfo.setSettlementOrgUnit(customerInfo);
            customerSaleInfo.setDeliverOrgUnit(customerInfo);
            if (settlementOrgUnitNum != null && settlementOrgUnitNum.length() > 0 && (info = DataImportUtils.getCustomerInfoFromNumber(ctx, settlementOrgUnitNum)) != null) {
                customerSaleInfo.setSettlementOrgUnit(info);
            }
            if (deliverOrgUnitNum != null && deliverOrgUnitNum.length() > 0 && (info = DataImportUtils.getCustomerInfoFromNumber(ctx, deliverOrgUnitNum)) != null) {
                customerSaleInfo.setDeliverOrgUnit(info);
            }
            if (billingOrgUnitNum != null && billingOrgUnitNum.length() > 0 && (info = DataImportUtils.getCustomerInfoFromNumber(ctx, billingOrgUnitNum)) != null) {
                customerSaleInfo.setBillingOrgUnit(info);
            }
            if (cashDiscountNum != null && cashDiscountNum.length() > 0 && (info = DataImportUtils.getCashDiscountInfoByNumber(ctx, cashDiscountNum)) != null) {
                customerSaleInfo.setCashDiscount((CashDiscountInfo)info);
            }
            if (cashKind > 2 || cashKind < 0) {
                cashKind = 0;
            }
            if ((paymentTypeEnum = DataImportUtils.getPaymentItemEnum(String.valueOf(cashKind))) != null) {
                customerSaleInfo.setCashKind(paymentTypeEnum);
                if (monthBancance < 0) {
                    monthBancance = 0;
                }
                if (dayBancance < 0) {
                    dayBancance = 0;
                }
                if (paymentTypeEnum.equals((Object)PaymentItemTypeEnum.BALANCE)) {
                    customerSaleInfo.setMonthBancanceMonth(monthBancance);
                    customerSaleInfo.setMonthBancanceDay(dayBancance);
                } else if (paymentTypeEnum.equals((Object)PaymentItemTypeEnum.DELIVERY)) {
                    customerSaleInfo.setMonthBancanceDay(dayBancance);
                }
            }
            int[] len = new int[]{linkMan.length, contactPersonPost.length, phone.length, fax.length, mobile.length, email.length, postalcode.length, postAddress.length};
            int max = this.getMaxOfArrary(len);
            String[] linkManTemp = new String[max];
            String[] contactPersonPostTemp = new String[max];
            String[] phoneTemp = new String[max];
            String[] faxTemp = new String[max];
            String[] mobileTemp = new String[max];
            String[] emailTemp = new String[max];
            String[] postalcodeTemp = new String[max];
            String[] postAddressTemp = new String[max];
            this.reConstructLinkArray(linkManTemp, linkMan);
            this.reConstructLinkArray(contactPersonPostTemp, contactPersonPost);
            this.reConstructLinkArray(phoneTemp, phone);
            this.reConstructLinkArray(faxTemp, fax);
            this.reConstructLinkArray(mobileTemp, mobile);
            this.reConstructLinkArray(postalcodeTemp, postalcode);
            this.reConstructLinkArray(postAddressTemp, postAddress);
            this.reConstructLinkArray(emailTemp, email);
            for (i = 0; i < max; ++i) {
                try {
                    this.handleCustomerSaleLinkMan(customerSaleInfo, linkManTemp[i], contactPersonPostTemp[i], phoneTemp[i], faxTemp[i], emailTemp[i], mobileTemp[i], postalcodeTemp[i], postAddressTemp[i], ctx);
                    continue;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            for (i = 0; i < deliveryAddress.length; ++i) {
                try {
                    this.handleCustomerDeliverAddress(customerSaleInfo, deliveryAddress[i], ctx);
                    continue;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            ICustomerSaleInfo iCustomersaleInfo = CustomerSaleInfoFactory.getLocalInstance(ctx);
            if (customerSaleInfo.getId() == null) {
                iCustomersaleInfo.submit((CoreBaseInfo)customerSaleInfo);
            } else {
                iCustomersaleInfo.update((IObjectPK)new ObjectUuidPK(customerSaleInfo.getId()), (CoreBaseInfo)customerSaleInfo);
            }
            result[0][0] = "0000";
            result[0][1] = number;
            return result;
        }
        catch (Exception e) {
            result[0][0] = "1111";
            result[0][1] = e.getMessage();
        }
        return result;
    }

    private void handleCustomerSaleLinkMan(CustomerSaleInfoInfo customerSaleInfo, String linkMan, String personPost, String phone, String fax, String mobile, String email, String postalCode, String address, Context ctx) throws Exception {
        String[] STRING_FIELDS = new String[]{linkMan, personPost, phone, fax, email, mobile, postalCode, address};
        String[] STRING_OBJS = new String[]{"contactPerson", "contactPersonPost", "phone", "fax", "email", "mobile", "postalcode", "address"};
        if (postalCode != null && postalCode.toString().length() > 10) {
            throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "postZipCode", ctx));
        }
        if (customerSaleInfo.getId() != null) {
            CustomerSaleInfoInfo oldPurchaseInfo = CustomerSaleInfoFactory.getLocalInstance(ctx).getCustomerSaleInfoInfo((IObjectPK)new ObjectUuidPK(customerSaleInfo.getId()), this.getCustomerSelector());
            customerSaleInfo.getCustomerLinkMan().addCollection(oldPurchaseInfo.getCustomerLinkMan());
        }
        CustomerLinkManInfo linkManInfo = new CustomerLinkManInfo();
        for (int i = 0; i < STRING_FIELDS.length; ++i) {
            linkManInfo.setString(STRING_OBJS[i], STRING_FIELDS[i]);
        }
        customerSaleInfo.getCustomerLinkMan().add(linkManInfo);
    }

    private void handleCustomerDeliverAddress(CustomerSaleInfoInfo customerSaleInfo, String address, Context ctx) throws Exception {
        if (customerSaleInfo.getId() != null) {
            CustomerSaleInfoInfo oldPurchaseInfo = CustomerSaleInfoFactory.getLocalInstance(ctx).getCustomerSaleInfoInfo((IObjectPK)new ObjectUuidPK(customerSaleInfo.getId()), this.getCustomerSelector());
            customerSaleInfo.getDeliveryAddresses().addCollection(oldPurchaseInfo.getDeliveryAddresses());
        }
        CustomerDeliveryAddressInfo addressInfo = new CustomerDeliveryAddressInfo();
        String[] multiStr = new String[]{"L1", "L2", "L3"};
        int c = multiStr.length;
        for (int i = 0; i < c; ++i) {
            addressInfo.setAddress(address, new Locale(multiStr[i]));
        }
        customerSaleInfo.getDeliveryAddresses().add(addressInfo);
    }

    private void reConstructLinkArray(String[] newLink, String[] oldLink) {
        for (int i = 0; i < newLink.length; ++i) {
            newLink[i] = oldLink.length > i ? oldLink[i] : "";
        }
    }

    private int getMaxOfArrary(int[] len) {
        int max = 0;
        int c = len.length;
        for (int i = 0; i < c; ++i) {
            max = Math.max(len[i], max);
        }
        return max;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String[][] _importCSSPGroup(Context ctx, String number, String name, String parentNumber, String standardNumber, String description) throws BOSException, EASBizException {
        CSSPGroupInfo groupInfo = new CSSPGroupInfo();
        ICSSPGroup iGroup = CSSPGroupFactory.getLocalInstance(ctx);
        groupInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        groupInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        String[][] result = new String[1][2];
        try {
            EntityViewInfo viewInfo;
            if (number == null) throw new DataBaseException(DataBaseException.NUMBERNOTNULL);
            if (number != null && number.trim().length() > 0) {
                groupInfo.setNumber(number);
                CSSPGroupCollection collection = iGroup.getCSSPGroupCollection("where number ='" + number + "'");
                if (collection != null && collection.size() > 0) {
                    groupInfo.setId(collection.get(0).getId());
                }
            }
            if (name == null || name.trim().length() <= 0) {
                throw new CustomerSupplierException(CustomerSupplierException.NAMENOTNULL);
            }
            groupInfo.setName(name);
            if (parentNumber != null && parentNumber.trim().length() > 0) {
                CSSPGroupInfo info;
                viewInfo = DataImportUtils.getViewInfo(parentNumber);
                ICSSPGroup iCustomerBrowseGroup = CSSPGroupFactory.getLocalInstance(ctx);
                CSSPGroupCollection collection = iCustomerBrowseGroup.getCSSPGroupCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    groupInfo.setParent(info);
                    groupInfo.setLevel(info.getLevel() + 1);
                    groupInfo.setLongNumber(info.getLongNumber() + "!" + groupInfo.getNumber());
                    groupInfo.setDisplayName(info.getDisplayName() + "_" + groupInfo.getName());
                }
            }
            if (standardNumber == null || standardNumber.trim().length() <= 0) throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "standardNotExist", ctx));
            viewInfo = DataImportUtils.getViewInfo(standardNumber);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)String.valueOf(0), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)String.valueOf(1), CompareType.EQUALS));
            filterInfo.setMaskString("#0 or #1");
            viewInfo.getFilter().mergeFilter(filterInfo, "and");
            ICSSPGroupStandard iStandard = CSSPGroupStandardFactory.getLocalInstance(ctx);
            CSSPGroupStandardCollection collection = iStandard.getCSSPGroupStandardCollection(viewInfo);
            if (collection == null || collection.size() <= 0) throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "standardNotExist", ctx));
            CSSPGroupStandardInfo info = collection.get(0);
            if (info != null) {
                if (info.getIsBasic().equals((Object)StandardTypeEnum.basicStandard) && !ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                    throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "baseGroupMatainByRoot", ctx));
                }
                groupInfo.setGroupStandard(info);
            }
            if (groupInfo.getId() == null) {
                iGroup.submit((CoreBaseInfo)groupInfo);
            } else {
                iGroup.update((IObjectPK)new ObjectUuidPK(groupInfo.getId()), (CoreBaseInfo)groupInfo);
            }
            result[0][0] = "0000";
            result[0][1] = number;
            return result;
        }
        catch (BOSException e) {
            result[0][0] = "1111";
            result[0][1] = e.getMessage();
            return result;
        }
        catch (EASBizException e) {
            result[0][0] = "1111";
            result[0][1] = e.getMessage();
            return result;
        }
        catch (Exception e) {
            result[0][0] = "1111";
            result[0][1] = e.getMessage();
        }
        return result;
    }

    @Override
    protected String[][] _importCSSPStandard(Context ctx, String number, String name, String description, int type, boolean isBasic) throws BOSException, EASBizException {
        if (type > 2 || type < 0) {
            type = 0;
        }
        int[] INTEGER_FIELDS = new int[]{type};
        String[] INTEGER_OBJS = new String[]{"type"};
        boolean[] BOOLEAN_FIELDS = new boolean[]{isBasic};
        String[] BOOLEAN_OBJS = new String[]{"isBasic"};
        CSSPGroupStandardInfo standardInfo = new CSSPGroupStandardInfo();
        ICSSPGroupStandard iStandard = CSSPGroupStandardFactory.getLocalInstance(ctx);
        standardInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        String[][] result = new String[1][2];
        try {
            if (number != null) {
                if (number != null && number.trim().length() > 0) {
                    standardInfo.setNumber(number);
                    CSSPGroupStandardCollection collection = iStandard.getCSSPGroupStandardCollection("where number ='" + number + "'");
                    if (collection != null && collection.size() > 0) {
                        standardInfo.setId(collection.get(0).getId());
                    }
                }
            } else {
                throw new DataBaseException(DataBaseException.NUMBERNOTNULL);
            }
            if (name == null || name.trim().length() <= 0) {
                throw new CustomerSupplierException(CustomerSupplierException.NAMENOTNULL);
            }
            standardInfo.setName(name);
            this.setIntData(INTEGER_FIELDS, (CoreBaseInfo)standardInfo, INTEGER_OBJS);
            this.setBooleanData(BOOLEAN_FIELDS, (CoreBaseInfo)standardInfo, BOOLEAN_OBJS);
            if (standardInfo.getId() == null) {
                iStandard.submit((CoreBaseInfo)standardInfo);
            } else {
                iStandard.update((IObjectPK)new ObjectUuidPK(standardInfo.getId()), (CoreBaseInfo)standardInfo);
            }
            result[0][0] = "0000";
            result[0][1] = number;
        }
        catch (Exception e) {
            result[0][0] = "1111";
            result[0][1] = e.getMessage();
        }
        return result;
    }

    @Override
    protected String[][] _importSupplierInfo(Context ctx, String number, String name, String memonicCode, String foreignName, String bizAnalysisCodeNumber, String shortName, String parentNumber, boolean isInternalCompany, String interNumber, String taxNumber, String taxRegisterNo, String bizRegisterNo, String busiLicence, String busiExequatur, String authentication, String industryNumber, String address, String countryNumber, String provinceNumber, String cityNumber, String regionNumber, String artificialPerson, int version, String freezeOrgUnit, int usedStatus, String[] standardNum, String[] groupNumber) throws BOSException, EASBizException {
        return this.importSupplierInfo(ctx, number, name, memonicCode, foreignName, bizAnalysisCodeNumber, shortName, parentNumber, isInternalCompany, interNumber, taxNumber, taxRegisterNo, bizRegisterNo, busiLicence, busiExequatur, authentication, industryNumber, address, countryNumber, provinceNumber, cityNumber, regionNumber, artificialPerson, version, freezeOrgUnit, usedStatus, standardNum, groupNumber, null);
    }

    private void handleSupplierGroupDetail(SupplierInfo supplierInfo, String standardNum, String groupNumber, Context ctx) throws Exception {
        Serializable info;
        boolean isAddNew = true;
        SupplierGroupDetailCollection oldCollection = null;
        if (supplierInfo.getId() != null) {
            SupplierInfo oldSupplierInfo = SupplierFactory.getLocalInstance(ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(supplierInfo.getId()), this.getSupplierSelector());
            oldCollection = oldSupplierInfo.getSupplierGroupDetails();
            isAddNew = false;
        }
        SupplierGroupDetailInfo detailInfo = new SupplierGroupDetailInfo();
        Object data = null;
        CSSPGroupInfo browseGroupInfo = null;
        if (standardNum != null && standardNum.trim().length() > 0) {
            info = DataImportUtils.getGroupStandardInfoByNumber(ctx, standardNum, "supplier");
            if (info != null) {
                detailInfo.setSupplierGroupStandard((CSSPGroupStandardInfo)info);
            } else {
                throw new BOSException(standardNum + DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "standardNotExist", ctx));
            }
        }
        if (groupNumber != null && groupNumber.trim().length() > 0) {
            info = DataImportUtils.getGroupInfoByNumber(ctx, groupNumber, standardNum);
            if (info != null) {
                detailInfo.setSupplierGroup((CSSPGroupInfo)info);
            } else {
                throw new BOSException(groupNumber + DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "groupNotExist", ctx));
            }
        }
        if (isAddNew) {
            supplierInfo.getSupplierGroupDetails().add(detailInfo);
            if (detailInfo.getSupplierGroupStandard().getIsBasic().equals((Object)StandardTypeEnum.basicStandard)) {
                this.isHasBasicStandard = true;
                browseGroupInfo = detailInfo.getSupplierGroup();
            }
        } else {
            SupplierGroupDetailInfo oldDetailInfo = new SupplierGroupDetailInfo();
            boolean isAddNewGroupDetail = true;
            if (null != oldCollection) {
                int c = oldCollection.size();
                for (int i = 0; i < c; ++i) {
                    oldDetailInfo = oldCollection.get(i);
                    if (oldDetailInfo.getSupplierGroupStandard().getIsBasic().equals((Object)StandardTypeEnum.basicStandard)) {
                        this.isHasBasicStandard = true;
                        browseGroupInfo = detailInfo.getSupplierGroup();
                    }
                    if (oldDetailInfo.getSupplierGroupStandard().getNumber().equals(detailInfo.getSupplierGroupStandard().getNumber())) {
                        oldDetailInfo.setSupplierGroup(detailInfo.getSupplierGroup());
                        isAddNewGroupDetail = false;
                    }
                    supplierInfo.getSupplierGroupDetails().add(oldDetailInfo);
                }
            }
            if (isAddNewGroupDetail) {
                supplierInfo.getSupplierGroupDetails().add(detailInfo);
            }
        }
        if (this.isHasBasicStandard && supplierInfo.getBrowseGroup() == null) {
            supplierInfo.setBrowseGroup(browseGroupInfo);
        }
        if (!this.isHasBasicStandard) {
            throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "baseGroupStandardNotNull", ctx));
        }
    }

    private SelectorItemCollection getSupplierSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("fid"));
        sic.add(new SelectorItemInfo("supplierGroupDetails.id"));
        sic.add(new SelectorItemInfo("supplierGroupDetails.supplierGroupStandard.*"));
        sic.add(new SelectorItemInfo("supplierGroupDetails.supplierGroup.*"));
        sic.add(new SelectorItemInfo("supplierGroupDetails.supplier.*"));
        return sic;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String[][] _importSupplierCompanyInfo(Context ctx, String number, String orgNumber, boolean isFreezePayment, String paymentTypeNumber, String settlementTypeNumber, String bankName, String bankAccount, String currencyNumber, String accountClassNumber, String contactPerson, String contactPersonPost, String phone, String fax, String email, String postalcode, String mobile, String freezeOrgUnitNum) throws BOSException, EASBizException {
        boolean[] BOOLEAN_FIELDS = new boolean[]{isFreezePayment};
        String[] BOOLEAN_OBJS = new String[]{"isFreezePayment"};
        String[] STRING_FIELDS = new String[]{bankName, bankAccount, contactPerson, contactPersonPost, phone, email, postalcode, mobile, fax};
        String[] STRING_OBJS = new String[]{"bankName", "bankAccount", "contactPerson", "contactPersonPost", "phone", "email", "postalcode", "mobile", "fax"};
        String[][] result = new String[1][2];
        SupplierCompanyInfoInfo supplierCompanyInfo = new SupplierCompanyInfoInfo();
        supplierCompanyInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        supplierCompanyInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        try {
            PaymentTypeInfo info;
            this.setBooleanData(BOOLEAN_FIELDS, (CoreBaseInfo)supplierCompanyInfo, BOOLEAN_OBJS);
            if (postalcode != null && postalcode.length() > 10) {
                throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "postZipCode", ctx));
            }
            this.setStringData(STRING_FIELDS, (CoreBaseInfo)supplierCompanyInfo, STRING_OBJS);
            CompanyOrgUnitInfo curCompany = DataImportUtils.getCompanyOrgUnitInfoFromNumber(ctx, orgNumber);
            if (curCompany == null) {
                curCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
            }
            if (curCompany == null) {
                throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "getCompanyOrgUnitFailed", ctx));
            }
            supplierCompanyInfo.setCompanyOrgUnit(curCompany);
            if (number == null || number.length() <= 0) throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "supplierNotExist", ctx));
            if (DataImportUtils.getSupplierInfoFromNumber(ctx, number) == null) throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "supplierNotExist", ctx));
            SupplierInfo supplierInfo = DataImportUtils.getSupplierInfoFromNumber(ctx, number);
            supplierCompanyInfo.setSupplier(supplierInfo);
            ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
            SupplierCompanyInfoInfo oldSupplierCompanyInfo = iSupplier.getCompanyInfo((IObjectPK)new ObjectUuidPK(supplierInfo.getId()), (IObjectPK)new ObjectUuidPK(curCompany.getId()));
            if (oldSupplierCompanyInfo != null) {
                supplierCompanyInfo.setId(oldSupplierCompanyInfo.getId());
            }
            if (paymentTypeNumber != null && paymentTypeNumber.length() > 0 && (info = DataImportUtils.getPaymentTypeInfoFromNumber(ctx, paymentTypeNumber)) != null) {
                supplierCompanyInfo.setPaymentType(info);
            }
            if (currencyNumber != null && currencyNumber.length() > 0) {
                info = DataImportUtils.getCurrencyInfoFromNumber(ctx, currencyNumber);
                if (info == null) throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "SupplierCurrency", ctx));
                supplierCompanyInfo.setSettlementCurrency((CurrencyInfo)info);
            }
            if (settlementTypeNumber != null && settlementTypeNumber.length() > 0 && (info = DataImportUtils.getSettlementTypeInfoFromNumber(ctx, settlementTypeNumber)) != null) {
                supplierCompanyInfo.setSettlementType((SettlementTypeInfo)info);
            }
            if (accountClassNumber != null && accountClassNumber.length() > 0) {
                info = DataImportUtils.getKAClassficationInfoFromNumber(ctx, accountClassNumber, curCompany, "supplier");
                if (info == null) throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "SupplierAccountingClassification", ctx));
                supplierCompanyInfo.setAccountingClassification((KAClassficationInfo)info);
            }
            if (freezeOrgUnitNum != null && freezeOrgUnitNum.length() > 0 && (info = DataImportUtils.getFullOrgUnitInfoFromNumber(ctx, freezeOrgUnitNum)) != null) {
                supplierCompanyInfo.setFreezeOrgUnit((FullOrgUnitInfo)info);
                supplierCompanyInfo.setIsFreezePayment(true);
            }
            ISupplierCompanyInfo iSupplierCompanyInfo = SupplierCompanyInfoFactory.getLocalInstance(ctx);
            if (supplierCompanyInfo.getId() == null) {
                iSupplierCompanyInfo.submit((CoreBaseInfo)supplierCompanyInfo);
            } else {
                iSupplierCompanyInfo.update((IObjectPK)new ObjectUuidPK(supplierCompanyInfo.getId()), (CoreBaseInfo)supplierCompanyInfo);
            }
            result[0][0] = "0000";
            result[0][1] = number;
            return result;
        }
        catch (Exception e) {
            result[0][0] = "1111";
            result[0][1] = e.getMessage();
        }
        return result;
    }

    private CoreBaseInfo setStringData(String[] hsField, CoreBaseInfo info, String[] infoFieldNames) {
        int c = infoFieldNames.length;
        for (int i = 0; i < c; ++i) {
            info.setString(infoFieldNames[i], hsField[i]);
        }
        return info;
    }

    private CoreBaseInfo setBigDecimalData(BigDecimal[] hsField, CoreBaseInfo info, String[] infoFieldNames) {
        int c = infoFieldNames.length;
        for (int i = 0; i < c; ++i) {
            info.setBigDecimal(infoFieldNames[i], hsField[i]);
        }
        return info;
    }

    private CoreBaseInfo setIntData(int[] hsField, CoreBaseInfo info, String[] infoFieldNames) {
        int c = infoFieldNames.length;
        for (int i = 0; i < c; ++i) {
            info.setInt(infoFieldNames[i], hsField[i]);
        }
        return info;
    }

    private CoreBaseInfo setBooleanData(boolean[] hsField, CoreBaseInfo info, String[] infoFieldNames) {
        int c = infoFieldNames.length;
        for (int i = 0; i < c; ++i) {
            info.setBoolean(infoFieldNames[i], hsField[i]);
        }
        return info;
    }

    private CustomerKindEnum getCustomerKindValue(String value) {
        CustomerKindEnum retval = CustomerKindEnum.DEALER;
        if (value != null) {
            value = value.trim();
            List EnumList = CustomerKindEnum.getEnumList();
            String enumValue = null;
            String enumName = null;
            String enumAlias = null;
            CustomerKindEnum enumeration = null;
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                enumeration = (CustomerKindEnum)((Object)EnumList.get(i));
                enumValue = String.valueOf(enumeration.getValue());
                enumName = enumeration.getName();
                enumAlias = enumeration.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                retval = enumeration;
                break;
            }
        }
        return retval;
    }

    @Override
    protected String[][] _importCustomerInfo(Context ctx, String number, String name, String foreignName, String shortName, int customerKind, String barCode, String memonicCode, String bizAnalysisCodeNumber, String parentNumber, boolean isInternalCompany, String interNumber, String bizRegisterNo, String busiLicence, String busiExequatur, String authentication, String taxNumber, String industryNumber, String address, String countryNumber, String provinceNumber, String cityNumber, String regionNumber, String artificialPerson, int version, String freezeOrgUnit, int usedStatus, String[] standardNum, String[] groupNumber, String cuNumber) throws BOSException, EASBizException {
        int[] INTEGER_FIELDS = new int[]{version};
        String[] INTEGER_OBJS = new String[]{"version"};
        boolean[] BOOLEAN_FIELDS = new boolean[]{isInternalCompany};
        String[] BOOLEAN_OBJS = new String[]{"isInternalCompany"};
        String[] STRING_FIELDS = new String[]{foreignName, shortName, barCode, memonicCode, bizRegisterNo, busiLicence, authentication, artificialPerson, address};
        String[] STRING_OBJS = new String[]{"foreignName", "simpleName", "barCode", "mnemonicCode", "bizRegisterNo", "busiLicence", "GSPAuthentication", "artificialPerson", "address"};
        String[][] result = new String[1][2];
        try {
            DataBaseDInfo info;
            CustomerInfo customerInfo = new CustomerInfo();
            ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
            if (number != null && number.trim().length() > 0) {
                customerInfo.setNumber(number);
                CustomerCollection customerCollection = iCustomer.getCustomerCollection("where number ='" + number + "'");
                if (customerCollection != null && customerCollection.size() > 0) {
                    customerInfo = customerCollection.get(0);
                }
            }
            customerInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
            if (cuNumber != null && !cuNumber.trim().equals("")) {
                CtrlUnitInfo cuInfo = DataImportUtils.getCtrlUnitInfoFromNumber(ctx, cuNumber);
                if (cuInfo != null) {
                    customerInfo.setCU(cuInfo);
                    customerInfo.setAdminCU(cuInfo);
                } else {
                    customerInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                }
            } else {
                customerInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            }
            this.setStringData(STRING_FIELDS, (CoreBaseInfo)customerInfo, STRING_OBJS);
            this.setIntData(INTEGER_FIELDS, (CoreBaseInfo)customerInfo, INTEGER_OBJS);
            this.setBooleanData(BOOLEAN_FIELDS, (CoreBaseInfo)customerInfo, BOOLEAN_OBJS);
            customerInfo.setUsedStatus(DataImportUtils.getCustomerStatusValue(String.valueOf(usedStatus)));
            customerInfo.setCustomerKind(this.getCustomerKindValue(String.valueOf(customerKind)));
            if (name == null || name.trim().length() <= 0) {
                throw new CustomerSupplierException(CustomerSupplierException.NAMENOTNULL);
            }
            customerInfo.setName(name);
            if (parentNumber != null && parentNumber.trim().length() > 0 && (info = DataImportUtils.getCustomerInfoFromNumber(ctx, parentNumber)) != null) {
                customerInfo.setParent((CustomerInfo)info);
            }
            if (bizAnalysisCodeNumber != null && bizAnalysisCodeNumber.trim().length() > 0 && (info = DataImportUtils.getBizAnalysisCodeInfoFromNumber(ctx, bizAnalysisCodeNumber)) != null) {
                customerInfo.setBizAnalysisCode((BizAnalysisCodeInfo)info);
            }
            if (interNumber != null && interNumber.trim().length() > 0 && (info = DataImportUtils.getCompanyOrgUnitInfoFromNumber(ctx, interNumber)) != null) {
                customerInfo.setInternalCompany((CompanyOrgUnitInfo)info);
            }
            if (taxNumber != null && taxNumber.trim().length() > 0 && (info = DataImportUtils.getTaxDataInfoFromNumber(ctx, taxNumber)) != null) {
                customerInfo.setTaxData((TaxDataInfo)info);
            }
            if (industryNumber != null && industryNumber.trim().length() > 0 && (info = DataImportUtils.getIndustryInfoFromNumber(ctx, industryNumber)) != null) {
                customerInfo.setIndustry((IndustryInfo)info);
            }
            if (countryNumber != null && countryNumber.trim().length() > 0 && (info = DataImportUtils.getCountryInfoFromNumber(ctx, countryNumber)) != null) {
                customerInfo.setCountry((CountryInfo)info);
            }
            if (provinceNumber != null && provinceNumber.trim().length() > 0 && (info = DataImportUtils.getProvinceInfoFromNumber(ctx, provinceNumber)) != null) {
                customerInfo.setProvince((ProvinceInfo)info);
            }
            if (cityNumber != null && cityNumber.trim().length() > 0 && (info = DataImportUtils.getCityInfoFromNumber(ctx, cityNumber)) != null) {
                customerInfo.setCity((CityInfo)info);
            }
            if (regionNumber != null && regionNumber.trim().length() > 0 && (info = DataImportUtils.getRegionInfoFromNumber(ctx, regionNumber)) != null) {
                customerInfo.setRegion((RegionInfo)info);
            }
            if (freezeOrgUnit != null && freezeOrgUnit.trim().length() > 0 && (info = DataImportUtils.getFullOrgUnitInfoFromNumber(ctx, freezeOrgUnit)) != null) {
                customerInfo.setFreezeOrgUnit((FullOrgUnitInfo)info);
            }
            if (standardNum.length != groupNumber.length) {
                throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "groupNotFitStandard", ctx));
            }
            int c = standardNum.length;
            for (int i = 0; i < c; ++i) {
                try {
                    this.handleCustomerGroupDetail(customerInfo, standardNum[i], groupNumber[i], ctx);
                    continue;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            CustomerDataImport im = new CustomerDataImport();
            im.submit((CoreBaseInfo)customerInfo, ctx);
            result[0][0] = "0000";
            result[0][1] = customerInfo.getNumber();
        }
        catch (Exception e) {
            result[0][0] = "1111";
            result[0][1] = e.getMessage();
        }
        return result;
    }

    @Override
    protected String[][] _importSupplierInfo(Context ctx, String number, String name, String memonicCode, String foreignName, String bizAnalysisCodeNumber, String shortName, String parentNumber, boolean isInternalCompany, String interNumber, String taxNumber, String taxRegisterNo, String bizRegisterNo, String busiLicence, String busiExequatur, String authentication, String industryNumber, String address, String countryNumber, String provinceNumber, String cityNumber, String regionNumber, String artificialPerson, int version, String freezeOrgUnit, int usedStatus, String[] standardNum, String[] groupNumber, String cuNumber) throws BOSException, EASBizException {
        int[] INTEGER_FIELDS = new int[]{version};
        String[] INTEGER_OBJS = new String[]{"version"};
        String[] STRING_FIELDS = new String[]{memonicCode, foreignName, shortName, taxRegisterNo, bizRegisterNo, busiLicence, busiExequatur, authentication, address, artificialPerson};
        String[] STRING_OBJS = new String[]{"mnemonicCode", "foreignName", "simpleName", "taxRegisterNo", "bizRegisterNo", "busiLicence", "busiExequatur", "GSPAuthentication", "address", "artificialPerson"};
        boolean[] BOOLEAN_FIELDS = new boolean[]{isInternalCompany};
        String[] BOOLEAN_OBJS = new String[]{"isInternalCompany"};
        String[][] result = new String[1][2];
        ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
        try {
            DataBaseDInfo info;
            SupplierInfo supplierInfo = new SupplierInfo();
            if (number != null && number.trim().length() > 0) {
                supplierInfo.setNumber(number);
                SupplierCollection supplierCollection = iSupplier.getSupplierCollection("where number ='" + number + "'");
                if (supplierCollection != null && supplierCollection.size() > 0) {
                    supplierInfo = supplierCollection.get(0);
                }
            }
            supplierInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
            supplierInfo.setUsedStatus(DataImportUtils.getCustomerStatusValue(String.valueOf(usedStatus)));
            if (cuNumber != null && !cuNumber.trim().equals("")) {
                CtrlUnitInfo cuInfo = DataImportUtils.getCtrlUnitInfoFromNumber(ctx, cuNumber);
                if (cuInfo != null) {
                    supplierInfo.setCU(cuInfo);
                    supplierInfo.setAdminCU(cuInfo);
                } else {
                    supplierInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                }
            } else {
                supplierInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                supplierInfo.setAdminCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            }
            this.setStringData(STRING_FIELDS, (CoreBaseInfo)supplierInfo, STRING_OBJS);
            this.setIntData(INTEGER_FIELDS, (CoreBaseInfo)supplierInfo, INTEGER_OBJS);
            this.setBooleanData(BOOLEAN_FIELDS, (CoreBaseInfo)supplierInfo, BOOLEAN_OBJS);
            if (name == null || name.trim().length() <= 0) {
                throw new CustomerSupplierException(CustomerSupplierException.NAMENOTNULL);
            }
            supplierInfo.setName(name);
            if (parentNumber != null && parentNumber.trim().length() > 0 && (info = DataImportUtils.getSupplierInfoFromNumber(ctx, parentNumber)) != null) {
                supplierInfo.setParent((SupplierInfo)info);
            }
            if (bizAnalysisCodeNumber != null && bizAnalysisCodeNumber.trim().length() > 0 && (info = DataImportUtils.getBizAnalysisCodeInfoFromNumber(ctx, bizAnalysisCodeNumber)) != null) {
                supplierInfo.setBizAnalysisCode((BizAnalysisCodeInfo)info);
            }
            if (interNumber != null && interNumber.trim().length() > 0 && (info = DataImportUtils.getCompanyOrgUnitInfoFromNumber(ctx, interNumber)) != null) {
                supplierInfo.setInternalCompany((CompanyOrgUnitInfo)info);
            }
            if (taxNumber != null && taxNumber.trim().length() > 0 && (info = DataImportUtils.getTaxDataInfoFromNumber(ctx, taxNumber)) != null) {
                supplierInfo.setTaxData((TaxDataInfo)info);
            }
            if (industryNumber != null && industryNumber.trim().length() > 0 && (info = DataImportUtils.getIndustryInfoFromNumber(ctx, industryNumber)) != null) {
                supplierInfo.setIndustry((IndustryInfo)info);
            }
            if (countryNumber != null && countryNumber.trim().length() > 0 && (info = DataImportUtils.getCountryInfoFromNumber(ctx, countryNumber)) != null) {
                supplierInfo.setCountry((CountryInfo)info);
            }
            if (provinceNumber != null && provinceNumber.trim().length() > 0 && (info = DataImportUtils.getProvinceInfoFromNumber(ctx, provinceNumber)) != null) {
                supplierInfo.setProvince((ProvinceInfo)info);
            }
            if (cityNumber != null && cityNumber.trim().length() > 0 && (info = DataImportUtils.getCityInfoFromNumber(ctx, cityNumber)) != null) {
                supplierInfo.setCity((CityInfo)info);
            }
            if (regionNumber != null && regionNumber.trim().length() > 0 && (info = DataImportUtils.getRegionInfoFromNumber(ctx, regionNumber)) != null) {
                supplierInfo.setRegion((RegionInfo)info);
            }
            if (freezeOrgUnit != null && freezeOrgUnit.trim().length() > 0 && (info = DataImportUtils.getFullOrgUnitInfoFromNumber(ctx, freezeOrgUnit)) != null) {
                supplierInfo.setFreezeOrgUnit((FullOrgUnitInfo)info);
            }
            if (standardNum.length != groupNumber.length) {
                throw new BOSException(DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "groupNotFitStandard", ctx));
            }
            int c = standardNum.length;
            for (int i = 0; i < c; ++i) {
                try {
                    this.handleSupplierGroupDetail(supplierInfo, standardNum[i], groupNumber[i], ctx);
                    continue;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            SupplierDataImport im = new SupplierDataImport();
            im.submit((CoreBaseInfo)supplierInfo, ctx);
            result[0][0] = "0000";
            result[0][1] = supplierInfo.getNumber();
        }
        catch (Exception e) {
            result[0][0] = "1111";
            result[0][1] = e.getMessage();
        }
        return result;
    }

    @Override
    protected String[][] _assignCustomer(Context ctx, String sourceCUNum, String[] destCUNum, String databaseNum) throws BOSException, EASBizException {
        String[][] result = new String[1][2];
        try {
            CtrlUnitInfo sourceCU = DataImportUtils.getCtrlUnitInfoFromNumber(ctx, sourceCUNum);
            CtrlUnitInfo destCU = null;
            CustomerInfo customerInfo = DataImportUtils.getCustomerInfoFromNumber(ctx, databaseNum);
            if (sourceCU == null || !sourceCU.isIsCU()) {
                result[0][0] = "2222";
                result[0][1] = sourceCU + DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "CUNOTEXISTS", ctx);
                return result;
            }
            if (customerInfo == null) {
                result[0][0] = "3333";
                result[0][1] = databaseNum + DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "CUSTOMERNOTEXISTSIM", ctx);
                return result;
            }
            if (!customerInfo.getCU().getId().equals((Object)sourceCU.getId())) {
                result[0][0] = "4444";
                result[0][1] = DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "CUNOTHASBASEINFO", ctx);
                return result;
            }
            ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
            for (int i = 0; i < destCUNum.length; ++i) {
                destCU = DataImportUtils.getCtrlUnitInfoFromNumber(ctx, destCUNum[i]);
                if (destCU == null || !destCU.isIsCU()) continue;
                iCustomer.assign((IObjectPK)new ObjectUuidPK(sourceCU.getId()), (IObjectPK)new ObjectUuidPK(customerInfo.getId()), (IObjectPK)new ObjectUuidPK(destCU.getId()));
            }
            result[0][0] = "0000";
            result[0][1] = databaseNum;
        }
        catch (Exception e) {
            result[0][0] = "1111";
            result[0][1] = e.getMessage();
        }
        return result;
    }

    @Override
    protected String[][] _assignSupplier(Context ctx, String sourceCUNum, String[] destCUNum, String dataBaseNum) throws BOSException, EASBizException {
        String[][] result = new String[1][2];
        try {
            CtrlUnitInfo sourceCU = DataImportUtils.getCtrlUnitInfoFromNumber(ctx, sourceCUNum);
            CtrlUnitInfo destCU = null;
            SupplierInfo supplierInfo = DataImportUtils.getSupplierInfoFromNumber(ctx, dataBaseNum);
            if (sourceCU == null || !sourceCU.isIsCU()) {
                result[0][0] = "2222";
                result[0][1] = sourceCU + DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "CUNOTEXISTS", ctx);
                return result;
            }
            if (supplierInfo == null) {
                result[0][0] = "3333";
                result[0][1] = dataBaseNum + DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "SUPPLIERNOTEXISTSIM", ctx);
                return result;
            }
            if (!supplierInfo.getCU().getId().equals((Object)sourceCU.getId())) {
                result[0][0] = "4444";
                result[0][1] = DataImportUtils.getResource("com.kingdee.eas.basedata.master.cssp.CSSPResource", "CUNOTHASBASEINFO", ctx);
                return result;
            }
            ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
            for (int i = 0; i < destCUNum.length; ++i) {
                destCU = DataImportUtils.getCtrlUnitInfoFromNumber(ctx, destCUNum[i]);
                if (destCU == null || !destCU.isIsCU()) continue;
                iSupplier.assign((IObjectPK)new ObjectUuidPK(sourceCU.getId()), (IObjectPK)new ObjectUuidPK(supplierInfo.getId()), (IObjectPK)new ObjectUuidPK(destCU.getId()));
            }
            result[0][0] = "0000";
            result[0][1] = dataBaseNum;
        }
        catch (Exception e) {
            result[0][0] = "1111";
            result[0][1] = e.getMessage();
        }
        return result;
    }

    @Override
    public String[][] _deleteCustomer(Context ctx, String[] numbers, boolean ignoreCU) throws BOSException {
        if (numbers == null || numbers.length <= 0) {
            return null;
        }
        Hashtable<String, String> hsMessage = new Hashtable<String, String>();
        try {
            this.switchOrg(ctx, ContextUtil.getCurrentUserInfo((Context)ctx).getDefOrgUnit().getId().toString());
        }
        catch (Exception e1) {
            logger.error((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)e1));
            e1.printStackTrace();
            throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e1));
        }
        ICustomer iCustomer = CustomerFactory.getLocalInstance(ctx);
        for (int i = 0; i < numbers.length; ++i) {
            String number = numbers[i];
            if (number == null || number.trim().length() <= 0) continue;
            try {
                CustomerCollection customerCollection = iCustomer.getCustomerCollection("where number ='" + number + "'");
                if (customerCollection == null || customerCollection.size() <= 0) {
                    throw new CustomerSupplierException(CustomerSupplierException.CSBASE_NUMBER_NOT_EXIST, new String[]{number});
                }
                ObjectUuidPK custPK = new ObjectUuidPK(customerCollection.get(0).getId());
                iCustomer.delete((IObjectPK)custPK, ignoreCU);
                continue;
            }
            catch (EASBizException e) {
                e.printStackTrace();
                logger.error((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)e));
                hsMessage.put(number, e.getMessage());
            }
        }
        String[][] sMessage = new String[hsMessage.size()][2];
        Iterator itr = hsMessage.keySet().iterator();
        int i = 0;
        while (itr.hasNext()) {
            String key = (String)itr.next();
            String value = (String)hsMessage.get(key);
            sMessage[i][0] = key;
            sMessage[i][1] = value;
            ++i;
        }
        return sMessage;
    }

    @Override
    public String[][] _deleteSupplier(Context ctx, String[] numbers, boolean ignoreCU) throws BOSException {
        if (numbers == null || numbers.length <= 0) {
            return null;
        }
        Hashtable<String, String> hsMessage = new Hashtable<String, String>();
        try {
            this.switchOrg(ctx, ContextUtil.getCurrentUserInfo((Context)ctx).getDefOrgUnit().getId().toString());
        }
        catch (Exception e1) {
            logger.error((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)e1));
            e1.printStackTrace();
            throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e1));
        }
        ISupplier iSupplier = SupplierFactory.getLocalInstance(ctx);
        for (int i = 0; i < numbers.length; ++i) {
            String number = numbers[i];
            if (number == null || number.trim().length() <= 0) continue;
            try {
                SupplierCollection supplierCollection = iSupplier.getSupplierCollection("where number ='" + number + "'");
                if (supplierCollection == null || supplierCollection.size() <= 0) {
                    throw new CustomerSupplierException(CustomerSupplierException.CSBASE_NUMBER_NOT_EXIST, new String[]{number});
                }
                ObjectUuidPK suppPK = new ObjectUuidPK(supplierCollection.get(0).getId());
                iSupplier.delete((IObjectPK)suppPK, ignoreCU);
                continue;
            }
            catch (EASBizException e) {
                e.printStackTrace();
                hsMessage.put(number, e.getMessage());
            }
        }
        String[][] sMessage = new String[hsMessage.size()][2];
        Iterator itr = hsMessage.keySet().iterator();
        int i = 0;
        while (itr.hasNext()) {
            String key = (String)itr.next();
            String value = (String)hsMessage.get(key);
            sMessage[i][0] = key;
            sMessage[i][1] = value;
            ++i;
        }
        return sMessage;
    }

    private void switchOrg(Context ctx, String orgID) throws Exception {
        if (ctx == null) {
            ctx = new Context();
        }
        IOrgSwitchFacade iswitch = OrgSwitchFacadeFactory.getLocalInstance((Context)ctx);
        HashMap map = iswitch.getSwitchOrgs(orgID);
        for (OrgType orgType : OrgType.getEnumList()) {
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)map.get(orgType);
            if (!OrgCommonUtils.isBasicOrgType((OrgType)orgType)) continue;
            ctx.put((Object)orgType, (Object)orgUnitInfo);
        }
        FullOrgUnitInfo ouInfo = (FullOrgUnitInfo)map.get("CurOU");
        ctx.put((Object)"CurOU", (Object)ouInfo);
    }
}

