/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.util;

import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.Map;

public class ShowTradeInfoUtil {
    public static final String CUSTOMERTRADEUI = "com.kingdee.eas.scm.sd.sale.report.client.CustomerTradeUI";
    public static final String SUPPLIERTRADEUI = "com.kingdee.eas.scm.sm.report.client.SupplierTradeUI";

    protected static boolean isExistsClass(String fullClassName) {
        boolean flag = true;
        try {
            Class.forName(fullClassName);
        }
        catch (ClassNotFoundException e) {
            flag = false;
        }
        return flag;
    }

    public static boolean beforeInvoke(String fullClassName) {
        boolean flag = ShowTradeInfoUtil.isExistsClass(fullClassName);
        if (!flag) {
            ShowTradeInfoUtil.exceptionHandle(fullClassName);
        }
        return flag;
    }

    public static void exceptionHandle(String fullClassName) {
        if (fullClassName.equals(CUSTOMERTRADEUI) || fullClassName.equals(SUPPLIERTRADEUI)) {
            // empty if block
        }
    }

    public static void showCustomerTradeUI(UIContext ctx, String customerNumber, CompanyOrgUnitInfo companyOrgUnitInfo) {
        if (!ShowTradeInfoUtil.beforeInvoke(CUSTOMERTRADEUI)) {
            return;
        }
        try {
            String uiClass = CUSTOMERTRADEUI;
            ctx.put((Object)"CHECK_RESOLVE", (Object)"RESOLVECUSTOMERTRADEUIBYINFO");
            ctx.put((Object)"CHECK_CUSTOMERNUMBER", (Object)customerNumber);
            ctx.put((Object)"CHECK_COMPANYORGUNITINFO", (Object)companyOrgUnitInfo);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(uiClass, (Map)ctx, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void showCustomerTradeUI(UIContext ctx, String customerNumber, CompanyOrgUnitCollection companyOrgUnitInfo) {
        if (!ShowTradeInfoUtil.beforeInvoke(CUSTOMERTRADEUI)) {
            return;
        }
        try {
            String uiClass = CUSTOMERTRADEUI;
            ctx.put((Object)"CHECK_RESOLVE", (Object)"RESOLVECUSTOMERTRADEUIBYCOLLECTION");
            ctx.put((Object)"CHECK_CUSTOMERNUMBER", (Object)customerNumber);
            ctx.put((Object)"CHECK_COMPANYORGUNITINFO", (Object)companyOrgUnitInfo);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(uiClass, (Map)ctx, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void showSupplierTradeUI(UIContext ctx, String supplierNumber, PurchaseOrgUnitInfo purchaseOrgUnitInfo) {
        if (!ShowTradeInfoUtil.beforeInvoke(SUPPLIERTRADEUI)) {
            return;
        }
        try {
            String uiClass = SUPPLIERTRADEUI;
            ctx.put((Object)"CHECK_RESOLVE", (Object)"RESOLVESUPPLIERTRADEUIBYINFO");
            ctx.put((Object)"CHECK_SUPPLIERNUMBER", (Object)supplierNumber);
            ctx.put((Object)"CHECK_PURCHASEORGUNITINFO", (Object)purchaseOrgUnitInfo);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(uiClass, (Map)ctx, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (UIException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void showSupplierTradeUI(UIContext ctx, String supplierNumber, PurchaseOrgUnitCollection purchaseOrgUnitInfo) {
        if (!ShowTradeInfoUtil.beforeInvoke(SUPPLIERTRADEUI)) {
            return;
        }
        try {
            String uiClass = SUPPLIERTRADEUI;
            ctx.put((Object)"CHECK_RESOLVE", (Object)"RESOLVESUPPLIERTRADEUIBYCOLLECTION");
            ctx.put((Object)"CHECK_SUPPLIERNUMBER", (Object)supplierNumber);
            ctx.put((Object)"CHECK_PURCHASEORGUNITINFO", (Object)purchaseOrgUnitInfo);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(uiClass, (Map)ctx, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (UIException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }
}

