/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.IEasVarListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AddressFactory;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableFactory;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IAddress;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeTable;
import com.kingdee.eas.basedata.assistant.IIndustry;
import com.kingdee.eas.basedata.assistant.IndustryFactory;
import com.kingdee.eas.basedata.assistant.IndustryInfo;
import com.kingdee.eas.basedata.framework.OrgPrintProp;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitLayerType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeFactory;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.app.ContextUtil;
import org.apache.log4j.Logger;

public class EasVarListener
extends OrgPrintProp
implements IEasVarListener {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.framework.EasVarListener");
    private String defaultValue = "";
    private Context _ctx = null;
    private static String[] keysArray = new String[]{"companyName", "companyDesc", "companyAddr", "companyTel", "companyFax", "companyZipCode", "companyAccount"};

    public EasVarListener() {
        this(null);
    }

    public EasVarListener(Context ctx) {
        this._ctx = ctx;
    }

    public String requestVar(String varName, String orgType) {
        String value = null;
        value = this._ctx == null ? this.innerClientRequestVar(varName, orgType) : this.innerServerRequestVar(varName, orgType);
        return value == null ? this.defaultValue : value;
    }

    private String innerServerRequestVar(String varName, String orgType) {
        AdminOrgUnitInfo adminInfo = ContextUtil.getCurrentAdminUnit((Context)this._ctx);
        OrgUnitInfo ouInfo = ContextUtil.getCurrentOrgUnit((Context)this._ctx);
        CompanyOrgUnitInfo comInfo = ContextUtil.getCurrentFIUnit((Context)this._ctx);
        if (this.isSameVarName("companyAddr", varName)) {
            if (adminInfo == null || adminInfo.getAddress() == null) {
                return this.defaultValue;
            }
            return this.getAddressName(this._ctx, adminInfo.getAddress().getId());
        }
        if (this.isSameVarName("companyAccount", varName)) {
            return ContextUtil.getCurrentUserInfo((Context)this._ctx).getName();
        }
        if (this.isSameVarName("companyName", varName)) {
            return adminInfo == null ? this.defaultValue : adminInfo.getName();
        }
        if (this.isSameVarName("companyTel", varName)) {
            return adminInfo == null ? this.defaultValue : adminInfo.getPhoneNumber();
        }
        if (this.isSameVarName("companyFax", varName)) {
            return adminInfo == null ? this.defaultValue : adminInfo.getFax();
        }
        if (this.isSameVarName("companyZipCode", varName)) {
            return adminInfo == null ? this.defaultValue : adminInfo.getZipCode();
        }
        if (this.isSameVarName("helpCode", varName)) {
            return ouInfo == null ? this.defaultValue : ouInfo.getCode();
        }
        if (this.isSameVarName("simpleName", varName)) {
            return ouInfo == null ? this.defaultValue : ouInfo.getSimpleName();
        }
        if (this.isSameVarName("englishName", varName)) {
            if (ouInfo instanceof FullOrgUnitInfo) {
                FullOrgUnitInfo fouInfo = (FullOrgUnitInfo)ouInfo;
                return fouInfo == null ? this.defaultValue : fouInfo.getEnglishName();
            }
        } else {
            if (this.isSameVarName("companyDesc", varName)) {
                return ouInfo == null ? this.defaultValue : ouInfo.getDescription();
            }
            if (this.isSameVarName("startTime", varName)) {
                return ouInfo == null ? this.defaultValue : (ouInfo.getEffectDate() == null ? this.defaultValue : ouInfo.getEffectDate().toString());
            }
            if (this.isSameVarName("parentAdminName", varName)) {
                return adminInfo == null ? this.defaultValue : (adminInfo.getParent() == null ? this.defaultValue : this.getAdminOrgUnitName(this._ctx, adminInfo.getParent().getId()));
            }
            if (this.isSameVarName("orgUnitType", varName)) {
                return adminInfo == null ? this.defaultValue : this.getOrgUnitLayerTypeName(this._ctx, adminInfo.getUnitLayerType().getId());
            }
            if (this.isSameVarName("naturalCurrency", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getBaseCurrency() == null ? this.defaultValue : this.getCurrencyName(this._ctx, comInfo.getBaseCurrency().getId()));
            }
            if (this.isSameVarName("baseExgTable", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getBaseExchangeTable() == null ? this.defaultValue : this.getExchangeTableName(this._ctx, comInfo.getBaseExchangeTable().getId()));
            }
            if (this.isSameVarName("adjustExgTable", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getAdjustExchangeTable() == null ? this.defaultValue : this.getExchangeTableName(this._ctx, comInfo.getAdjustExchangeTable().getId()));
            }
            if (this.isSameVarName("reportCurrency", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getReportCurrency() == null ? this.defaultValue : this.getCurrencyName(this._ctx, comInfo.getReportCurrency().getId()));
            }
            if (this.isSameVarName("reportExgTable", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getReportExchangeTable() == null ? this.defaultValue : this.getExchangeTableName(this._ctx, comInfo.getReportExchangeTable().getId()));
            }
            if (this.isSameVarName("ecomonicType", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getEconomicType() == null ? this.defaultValue : comInfo.getEconomicType().getAlias());
            }
            if (this.isSameVarName("reportConvertMode", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getReportConvertMode() == null ? this.defaultValue : comInfo.getReportConvertMode().getAlias());
            }
            if (this.isSameVarName("industry", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getIndustry() == null ? this.defaultValue : this.getIndustryName(this._ctx, comInfo.getIndustry().getId()));
            }
            if (this.isSameVarName("territory", varName)) {
                return comInfo == null ? this.defaultValue : comInfo.getTerritory();
            }
            if (this.isSameVarName("juridicalPerson", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getJuridicalPerson() == null ? this.defaultValue : this.getPersonName(this._ctx, comInfo.getJuridicalPerson().getId()));
            }
            if (this.isSameVarName("taxCode", varName)) {
                return comInfo == null ? this.defaultValue : comInfo.getTaxNumber();
            }
            if (this.isSameVarName("registerCapital", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getRegisteredCapital() == null ? this.defaultValue : comInfo.getRegisteredCapital().toString());
            }
            if (this.isSameVarName("registerCode", varName)) {
                return comInfo == null ? this.defaultValue : comInfo.getRegisteredCode();
            }
            if (this.isSameVarName("setupDate", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getSetupDate() == null ? this.defaultValue : (comInfo.getSetupDate() == null ? this.defaultValue : comInfo.getSetupDate().toString()));
            }
            if (this.isSameVarName("businessAvbPeriod", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getEndupDate() == null ? this.defaultValue : (comInfo.getEndupDate() == null ? this.defaultValue : comInfo.getEndupDate().toString()));
            }
            if (this.isSameVarName("businessStatus", varName)) {
                StorageOrgUnitInfo storeInfo = SysContext.getSysContext().getCurrentStorageUnit();
                return storeInfo == null ? this.defaultValue : (storeInfo.getStatus() == null ? this.defaultValue : (storeInfo.getStatus() == null ? this.defaultValue : storeInfo.getStatus().getAlias()));
            }
            if (this.isSameVarName("storeAddr", varName)) {
                StorageOrgUnitInfo storeInfo = SysContext.getSysContext().getCurrentStorageUnit();
                return storeInfo == null ? this.defaultValue : (storeInfo.getAddress() == null ? this.defaultValue : this.getAddressName(this._ctx, storeInfo.getAddress().getId()));
            }
            if (this.isSameVarName("storeType", varName)) {
                StorageOrgUnitInfo storeInfo = SysContext.getSysContext().getCurrentStorageUnit();
                return storeInfo == null ? this.defaultValue : (storeInfo.getType() == null ? this.defaultValue : (storeInfo.getType() == null ? this.defaultValue : storeInfo.getType().getAlias()));
            }
            if (this.isSameVarName("costPrincipal", varName)) {
                CostCenterOrgUnitInfo costInfo = SysContext.getSysContext().getCurrentCostUnit();
                return costInfo == null ? this.defaultValue : (costInfo.getLeader() == null ? this.defaultValue : this.getPersonName(this._ctx, costInfo.getLeader().getId()));
            }
            if (this.isSameVarName("costType", varName)) {
                CostCenterOrgUnitInfo costInfo = SysContext.getSysContext().getCurrentCostUnit();
                return costInfo == null ? this.defaultValue : (costInfo.getCostCenterType() == null ? this.defaultValue : (costInfo.getCostCenterType() == null ? this.defaultValue : costInfo.getCostCenterType().getAlias()));
            }
            if (this.isSameVarName("profitPrincipal", varName)) {
                ProfitCenterOrgUnitInfo profitInfo = SysContext.getSysContext().getCurrentProfitUnit();
                return profitInfo == null ? this.defaultValue : (profitInfo.getLeader() == null ? this.defaultValue : this.getPersonName(this._ctx, profitInfo.getLeader().getId()));
            }
        }
        return this.defaultValue;
    }

    private String innerClientRequestVar(String varName, String orgType) {
        AdminOrgUnitInfo adminInfo = SysContext.getSysContext().getCurrentAdminUnit();
        OrgUnitInfo ouInfo = SysContext.getSysContext().getCurrentOrgUnit();
        CompanyOrgUnitInfo comInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (this.isSameVarName("companyAddr", varName)) {
            if (adminInfo == null || adminInfo.getAddress() == null) {
                return this.defaultValue;
            }
            return this.getAddressName(null, adminInfo.getAddress().getId());
        }
        if (this.isSameVarName("companyAccount", varName)) {
            return SysContext.getSysContext().getCurrentUserInfo().getName();
        }
        if (this.isSameVarName("companyName", varName)) {
            return adminInfo == null ? this.defaultValue : adminInfo.getName();
        }
        if (this.isSameVarName("companyTel", varName)) {
            return adminInfo == null ? this.defaultValue : adminInfo.getPhoneNumber();
        }
        if (this.isSameVarName("companyFax", varName)) {
            return adminInfo == null ? this.defaultValue : adminInfo.getFax();
        }
        if (this.isSameVarName("companyZipCode", varName)) {
            return adminInfo == null ? this.defaultValue : adminInfo.getZipCode();
        }
        if (this.isSameVarName("helpCode", varName)) {
            return ouInfo == null ? this.defaultValue : ouInfo.getCode();
        }
        if (this.isSameVarName("simpleName", varName)) {
            return ouInfo == null ? this.defaultValue : ouInfo.getSimpleName();
        }
        if (this.isSameVarName("englishName", varName)) {
            if (ouInfo instanceof FullOrgUnitInfo) {
                FullOrgUnitInfo fouInfo = (FullOrgUnitInfo)ouInfo;
                return fouInfo == null ? this.defaultValue : fouInfo.getEnglishName();
            }
        } else {
            if (this.isSameVarName("companyDesc", varName)) {
                return ouInfo == null ? this.defaultValue : ouInfo.getDescription();
            }
            if (this.isSameVarName("startTime", varName)) {
                return ouInfo == null ? this.defaultValue : (ouInfo.getEffectDate() == null ? this.defaultValue : ouInfo.getEffectDate().toString());
            }
            if (this.isSameVarName("parentAdminName", varName)) {
                return adminInfo == null ? this.defaultValue : (adminInfo.getParent() == null ? this.defaultValue : this.getAdminOrgUnitName(null, adminInfo.getParent().getId()));
            }
            if (this.isSameVarName("orgUnitType", varName)) {
                return adminInfo == null ? this.defaultValue : this.getOrgUnitLayerTypeName(null, adminInfo.getUnitLayerType().getId());
            }
            if (this.isSameVarName("naturalCurrency", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getBaseCurrency() == null ? this.defaultValue : this.getCurrencyName(null, comInfo.getBaseCurrency().getId()));
            }
            if (this.isSameVarName("baseExgTable", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getBaseExchangeTable() == null ? this.defaultValue : this.getExchangeTableName(null, comInfo.getBaseExchangeTable().getId()));
            }
            if (this.isSameVarName("adjustExgTable", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getAdjustExchangeTable() == null ? this.defaultValue : this.getExchangeTableName(null, comInfo.getAdjustExchangeTable().getId()));
            }
            if (this.isSameVarName("reportCurrency", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getReportCurrency() == null ? this.defaultValue : this.getCurrencyName(null, comInfo.getReportCurrency().getId()));
            }
            if (this.isSameVarName("reportExgTable", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getReportExchangeTable() == null ? this.defaultValue : this.getExchangeTableName(null, comInfo.getReportExchangeTable().getId()));
            }
            if (this.isSameVarName("ecomonicType", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getEconomicType() == null ? this.defaultValue : comInfo.getEconomicType().getAlias());
            }
            if (this.isSameVarName("reportConvertMode", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getReportConvertMode() == null ? this.defaultValue : comInfo.getReportConvertMode().getAlias());
            }
            if (this.isSameVarName("industry", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getIndustry() == null ? this.defaultValue : this.getIndustryName(null, comInfo.getIndustry().getId()));
            }
            if (this.isSameVarName("territory", varName)) {
                return comInfo == null ? this.defaultValue : comInfo.getTerritory();
            }
            if (this.isSameVarName("juridicalPerson", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getJuridicalPerson() == null ? this.defaultValue : this.getPersonName(null, comInfo.getJuridicalPerson().getId()));
            }
            if (this.isSameVarName("taxCode", varName)) {
                return comInfo == null ? this.defaultValue : comInfo.getTaxNumber();
            }
            if (this.isSameVarName("registerCapital", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getRegisteredCapital() == null ? this.defaultValue : comInfo.getRegisteredCapital().toString());
            }
            if (this.isSameVarName("registerCode", varName)) {
                return comInfo == null ? this.defaultValue : comInfo.getRegisteredCode();
            }
            if (this.isSameVarName("setupDate", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getSetupDate() == null ? this.defaultValue : (comInfo.getSetupDate() == null ? this.defaultValue : comInfo.getSetupDate().toString()));
            }
            if (this.isSameVarName("businessAvbPeriod", varName)) {
                return comInfo == null ? this.defaultValue : (comInfo.getEndupDate() == null ? this.defaultValue : (comInfo.getEndupDate() == null ? this.defaultValue : comInfo.getEndupDate().toString()));
            }
            if (this.isSameVarName("businessStatus", varName)) {
                StorageOrgUnitInfo storeInfo = SysContext.getSysContext().getCurrentStorageUnit();
                return storeInfo == null ? this.defaultValue : (storeInfo.getStatus() == null ? this.defaultValue : (storeInfo.getStatus() == null ? this.defaultValue : storeInfo.getStatus().getAlias()));
            }
            if (this.isSameVarName("storeAddr", varName)) {
                StorageOrgUnitInfo storeInfo = SysContext.getSysContext().getCurrentStorageUnit();
                return storeInfo == null ? this.defaultValue : (storeInfo.getAddress() == null ? this.defaultValue : this.getAddressName(null, storeInfo.getAddress().getId()));
            }
            if (this.isSameVarName("storeType", varName)) {
                StorageOrgUnitInfo storeInfo = SysContext.getSysContext().getCurrentStorageUnit();
                return storeInfo == null ? this.defaultValue : (storeInfo.getType() == null ? this.defaultValue : (storeInfo.getType() == null ? this.defaultValue : storeInfo.getType().getAlias()));
            }
            if (this.isSameVarName("costPrincipal", varName)) {
                CostCenterOrgUnitInfo costInfo = SysContext.getSysContext().getCurrentCostUnit();
                return costInfo == null ? this.defaultValue : (costInfo.getLeader() == null ? this.defaultValue : this.getPersonName(null, costInfo.getLeader().getId()));
            }
            if (this.isSameVarName("costType", varName)) {
                CostCenterOrgUnitInfo costInfo = SysContext.getSysContext().getCurrentCostUnit();
                return costInfo == null ? this.defaultValue : (costInfo.getCostCenterType() == null ? this.defaultValue : (costInfo.getCostCenterType() == null ? this.defaultValue : costInfo.getCostCenterType().getAlias()));
            }
            if (this.isSameVarName("profitPrincipal", varName)) {
                ProfitCenterOrgUnitInfo profitInfo = SysContext.getSysContext().getCurrentProfitUnit();
                return profitInfo == null ? this.defaultValue : (profitInfo.getLeader() == null ? this.defaultValue : this.getPersonName(null, profitInfo.getLeader().getId()));
            }
        }
        return this.defaultValue;
    }

    private String getCurrencyName(Context ctx, BOSUuid id) {
        if (id == null) {
            return this.defaultValue;
        }
        try {
            ICurrency currency = null;
            currency = ctx == null ? CurrencyFactory.getRemoteInstance() : CurrencyFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection coll = new SelectorItemCollection();
            coll.add(new SelectorItemInfo("name"));
            CurrencyInfo info = currency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(id), coll);
            return info == null ? this.defaultValue : info.getName();
        }
        catch (Exception exception) {
            return this.defaultValue;
        }
    }

    private String getExchangeTableName(Context ctx, BOSUuid id) {
        if (id == null) {
            return this.defaultValue;
        }
        try {
            IExchangeTable ecTable = null;
            ecTable = ctx == null ? ExchangeTableFactory.getRemoteInstance() : ExchangeTableFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection coll = new SelectorItemCollection();
            coll.add(new SelectorItemInfo("name"));
            ExchangeTableInfo info = ecTable.getExchangeTableInfo((IObjectPK)new ObjectUuidPK(id), coll);
            return info == null ? this.defaultValue : info.getName();
        }
        catch (Exception exception) {
            return this.defaultValue;
        }
    }

    private String getIndustryName(Context ctx, BOSUuid id) {
        if (id == null) {
            return this.defaultValue;
        }
        try {
            IIndustry industry = null;
            industry = ctx == null ? IndustryFactory.getRemoteInstance() : IndustryFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection coll = new SelectorItemCollection();
            coll.add(new SelectorItemInfo("name"));
            IndustryInfo info = industry.getIndustryInfo((IObjectPK)new ObjectUuidPK(id), coll);
            return info == null ? this.defaultValue : info.getName();
        }
        catch (Exception exception) {
            return this.defaultValue;
        }
    }

    private String getPersonName(Context ctx, BOSUuid id) {
        if (id == null) {
            return this.defaultValue;
        }
        try {
            IPerson industry = null;
            industry = ctx == null ? PersonFactory.getRemoteInstance() : PersonFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection coll = new SelectorItemCollection();
            coll.add(new SelectorItemInfo("name"));
            PersonInfo info = industry.getPersonInfo((IObjectPK)new ObjectUuidPK(id), coll);
            return info == null ? this.defaultValue : info.getName();
        }
        catch (Exception exception) {
            return this.defaultValue;
        }
    }

    private String getAddressName(Context ctx, BOSUuid id) {
        if (id == null) {
            return this.defaultValue;
        }
        try {
            IAddress address = null;
            address = ctx == null ? AddressFactory.getRemoteInstance() : AddressFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK pk = new ObjectUuidPK(id);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("name"));
            AddressInfo ainfo = address.getAddressInfo((IObjectPK)pk, selector);
            return ainfo.getName();
        }
        catch (Exception exception) {
            return this.defaultValue;
        }
    }

    private String getAdminOrgUnitName(Context ctx, BOSUuid id) {
        if (id == null) {
            return this.defaultValue;
        }
        try {
            IAdminOrgUnit address = null;
            address = ctx == null ? AdminOrgUnitFactory.getRemoteInstance() : AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK pk = new ObjectUuidPK(id);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("name"));
            AdminOrgUnitInfo ainfo = address.getAdminOrgUnitInfo((IObjectPK)pk, selector);
            return ainfo.getName();
        }
        catch (Exception exception) {
            return this.defaultValue;
        }
    }

    private String getOrgUnitLayerTypeName(Context ctx, BOSUuid id) {
        if (id == null) {
            return this.defaultValue;
        }
        try {
            IOrgUnitLayerType address = null;
            address = ctx == null ? OrgUnitLayerTypeFactory.getRemoteInstance() : OrgUnitLayerTypeFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK pk = new ObjectUuidPK(id);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("name"));
            OrgUnitLayerTypeInfo ainfo = address.getOrgUnitLayerTypeInfo((IObjectPK)pk, selector);
            return ainfo.getName();
        }
        catch (Exception exception) {
            return this.defaultValue;
        }
    }

    private boolean isSameVarName(String standardName, String varName) {
        return standardName.equalsIgnoreCase(varName);
    }

    public String test() {
        StringBuffer sb = new StringBuffer();
        String[] varNames = EasVarListener.getAllVarNames();
        for (int i = 0; i < varNames.length; ++i) {
            String value = this.requestVar(varNames[i], null);
            sb.append(varNames[i]).append(":").append(value).append("\r\n");
            logger.info((Object)(varNames[i] + ":" + value));
        }
        return sb.toString();
    }
}

