/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.framework.DatabaseDCanInfo;
import com.kingdee.eas.basedata.framework.IDataBaseControlMode;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.framework.app.DServerControlStrategy;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.ContextUtil;
import org.apache.log4j.Logger;

public class DListServerControlStrategy
extends DServerControlStrategy {
    private static final Logger logger = CoreUIObject.getLogger(DListServerControlStrategy.class);
    private DatabaseDCanInfo canInfo = null;

    private void canBeAssignedOrUpOrAssign(ICoreBase cb, IObjectPK bizPK) throws EASBizException, BOSException {
        if (cb instanceof IDataBaseD) {
            this.canInfo = ((IDataBaseD)cb).allCan(cb.getType(), bizPK);
        } else if (cb instanceof IDataBaseControlMode) {
            this.canInfo = ((IDataBaseControlMode)cb).allCan(cb.getType(), bizPK);
        }
    }

    public void setStatus(Context ctx, ICoreBase cb, IObjectPK bizPK) throws EASBizException, BOSException {
        this.canBeAssignedOrUpOrAssign(cb, bizPK);
        boolean canBeAssigned = this.canBeAssigned();
        boolean canBeRefered = this.canBeRefered();
        int UpgradeMode = 1;
        String bosType = cb.getType().toString();
        boolean canBeUpgrade = this.isUpgradeDisplayed(ctx, UpgradeMode, bosType);
    }

    private boolean isUpgradeDisplayed(Context ctx, int UpgradeMode, String bosType) {
        if (UpgradeMode == 1) {
            return this.canBeUpgraded();
        }
        return this.canUpgradeSubordinate(ctx, bosType);
    }

    private boolean canUpgradeSubordinate(Context ctx, String bosType) {
        boolean can = false;
        try {
            String longNumber = ContextUtil.getCurrentCtrlUnit((Context)ctx).getLongNumber();
            StringBuffer oql = new StringBuffer(100);
            oql.append("where id in (").append("select a.FID from T_ORG_CtrlUnit a inner join T_ORG_CUBDControl b ").append("on a.FID=b.FControlUnitID where a.FLongNumber like '").append(longNumber).append("!%' ").append("and b.FBDBOSType='").append(bosType).append("' and b.FIsSubordinateUpgradable=1").append(")");
            if (FullOrgUnitFactory.getRemoteInstance().exists(oql.toString())) {
                can = true;
            }
        }
        catch (Exception e) {
            logger.debug((Object)e);
        }
        return can;
    }

    private boolean canBeUpgraded() {
        return this.canInfo.isCanUpgrade();
    }

    private boolean canBeAssigned() {
        return this.canInfo.isCanAssign();
    }

    private boolean canBeRefered() {
        return this.canInfo.isCanRefer();
    }

    private boolean canReferenceSuperior() {
        return this.canInfo.isCanRefer();
    }

    @Override
    public FilterInfo getDefaultFilterForControlType(Context ctx, IObjectPK ctrlUnitPK) {
        FilterInfo fi = null;
        try {
            fi = this.getDataBaseDFilter(ctx, ctrlUnitPK);
        }
        catch (Exception e) {
            logger.error((Object)"EXCEPION", (Throwable)e);
        }
        return fi;
    }

    private FilterInfo getDataBaseDFilter(Context ctx, IObjectPK ctrlUnitPK) throws Exception {
        ICoreBase cb = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)this.getBizType());
        if (cb instanceof IDataBaseD) {
            FilterInfo databaseDFilter = ((IDataBaseD)cb).getDatabaseDFilter(ctrlUnitPK, "id", "CU.id");
            return databaseDFilter;
        }
        if (cb instanceof IDataBaseControlMode) {
            FilterInfo databaseDFilter = ((IDataBaseControlMode)cb).getDatabaseDFilter(ctrlUnitPK, "id", "CU.id");
            return databaseDFilter;
        }
        return new FilterInfo();
    }
}

