/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.framework.DataBaseControlModeCollection;
import com.kingdee.eas.basedata.framework.DataBaseControlModeInfo;
import com.kingdee.eas.basedata.framework.DataBaseDAssignFactory;
import com.kingdee.eas.basedata.framework.DataBaseDAssignInfo;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.DatabaseDCanInfo;
import com.kingdee.eas.basedata.framework.IDataBaseDAssign;
import com.kingdee.eas.basedata.framework.app.AbstractDataBaseControlModeControllerBean;
import com.kingdee.eas.basedata.framework.app.DataBaseDNewImpl;
import com.kingdee.eas.basedata.framework.app.ServerControlModeUtil;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.CUBDDispatchPattern;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.RefChkFilter;
import com.kingdee.eas.common.RefChkFilterItemEnum;
import com.kingdee.eas.common.RefChkFilterSet;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class DataBaseControlModeControllerBean
extends AbstractDataBaseControlModeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.framework.app.DataBaseControlModeControllerBean");
    protected String controlType = null;

    protected String getControlType(BOSObjectType type, Context ctx) throws BOSException {
        if (this.controlType == null) {
            this.controlType = ServerControlModeUtil.getControlType(type, ctx);
        }
        return this.controlType;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        DataBaseControlModeInfo dataBaseControlModeInfo = (DataBaseControlModeInfo)model;
        if ("D".equals(this.getControlType(dataBaseControlModeInfo.getBOSType(), ctx))) {
            if (dataBaseControlModeInfo != null && (dataBaseControlModeInfo.getCU() == null || dataBaseControlModeInfo.getCU().getId() == null)) {
                dataBaseControlModeInfo.setCU(this.getDefaultCU(ctx));
            }
            dataBaseControlModeInfo.setId(BOSUuid.read((String)pk.toString()));
            this.checkAddPolicy(ctx, (IObjectPK)new ObjectUuidPK(dataBaseControlModeInfo.getCU().getId()), dataBaseControlModeInfo.getBOSType());
        }
        super._addnew(ctx, (IObjectValue)dataBaseControlModeInfo);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        if (super._exists(ctx, filter)) {
            view.getSelector().add(new SelectorItemInfo("cu.name"));
            DataBaseCollection dcoll = super.getDataBaseCollection(ctx, view);
            DataBaseInfo dInfo = dcoll.get(0);
            String cuName = dInfo.getCU().getName();
            String name = dataBaseInfo.getName();
            throw new DataBaseDException(DataBaseDException.CHECKNAMEDUP, new Object[]{name, cuName});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        if (super._exists(ctx, filter)) {
            view.getSelector().add(new SelectorItemInfo("cu.name"));
            DataBaseCollection dcoll = super.getDataBaseCollection(ctx, view);
            DataBaseInfo dInfo = dcoll.get(0);
            String cuName = dInfo.getCU().getName();
            String number = dataBaseInfo.getNumber();
            throw new DataBaseDException(DataBaseDException.CHECKNUMDUP, new Object[]{number, cuName});
        }
    }

    private void checkAddPolicy(Context ctx, IObjectPK ctrlUnitPK, BOSObjectType objectType) throws EASBizException, BOSException {
        boolean flag;
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitPK.toString());
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateAddnewable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADD);
        }
    }

    protected void checkUpdatePolicy(Context ctx, IObjectPK ctrlUnitPK, BOSObjectType objectType) throws EASBizException, BOSException {
        boolean flag;
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitPK.toString());
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateEditable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
    }

    private void checkDelPolicy(Context ctx, IObjectPK ctrlUnitPK, BOSObjectType objectType, IObjectPK dataPK) throws EASBizException, BOSException {
        boolean flag;
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitPK.toString());
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateDeletable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
        }
        boolean isReferencedInCU = false;
        HashSet<String> filterValues = new HashSet<String>();
        filterValues.add(ctrlUnitPK.toString());
        RefChkFilterSet filters = new RefChkFilterSet();
        filters.add(new RefChkFilter(RefChkFilterItemEnum.IncludedCUIDList, filterValues));
        BOSUuid dataID = BOSUuid.create((String)dataPK.toString());
        isReferencedInCU = ReferenceDAO.isReferenced((Context)ctx, (BOSUuid)dataID, (RefChkFilterSet)filters);
        if (isReferencedInCU) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_IN_THIS_CU);
        }
    }

    private IObjectPK getDefaultCUPK(Context ctx) {
        return new ObjectUuidPK(this.getDefaultCU(ctx).getId());
    }

    private CtrlUnitInfo getDefaultCU(Context ctx) {
        return ContextUtil.getCurrentCtrlUnit((Context)ctx);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseControlModeInfo dataBaseControlModeInfo = (DataBaseControlModeInfo)model;
        if ("D".equals(this.getControlType(dataBaseControlModeInfo.getBOSType(), ctx))) {
            if (dataBaseControlModeInfo != null && (dataBaseControlModeInfo.getCU() == null || dataBaseControlModeInfo.getCU().getId() == null)) {
                dataBaseControlModeInfo.setCU(this.getDefaultCU(ctx));
            }
            this.checkAddPolicy(ctx, (IObjectPK)new ObjectUuidPK(dataBaseControlModeInfo.getCU().getId()), dataBaseControlModeInfo.getBOSType());
        }
        return super._addnew(ctx, (IObjectValue)dataBaseControlModeInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _update(Context ctx, IObjectPK dataBaseDPK, IObjectValue model) throws BOSException, EASBizException {
        DataBaseControlModeInfo value = (DataBaseControlModeInfo)model;
        if ("D".equals(this.getControlType(value.getBOSType(), ctx))) {
            IObjectPK ctrlUnitPK = this.getDefaultCUPK(ctx);
            assert (value != null && value.getCU() != null && value.getCU().getId() != null);
            boolean hasAdminRight = ctrlUnitPK.toString().equals(value.getCU().getId().toString());
            if (hasAdminRight) {
                super._update(ctx, dataBaseDPK, (IObjectValue)value);
                return;
            } else {
                IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
                boolean isDataBaseDAssigned = iDataBaseDAssign.checkAssignment(ctrlUnitPK, dataBaseDPK);
                if (!isDataBaseDAssigned) throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE_UNASSIGNED_DATABASED);
                this.checkUpdatePolicy(ctx, ctrlUnitPK, value.getBOSType());
                super._update(ctx, dataBaseDPK, (IObjectValue)value);
            }
            return;
        } else {
            super._update(ctx, dataBaseDPK, (IObjectValue)value);
        }
    }

    protected void _isReferenced(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
        boolean isAssigned = iDataBaseDAssign.existAssignment(pk);
        if (isAssigned) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_ASSIGNED_DATABASED);
        }
        super._isReferenced(ctx, pk);
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        DataBaseControlModeInfo dataBaseControlModeInfo = (DataBaseControlModeInfo)model;
        if ("D".equals(this.getControlType(dataBaseControlModeInfo.getBOSType(), ctx)) && (dataBaseControlModeInfo.getCU() == null || dataBaseControlModeInfo.getCU().getId() == null)) {
            dataBaseControlModeInfo.setCU(this.getDefaultCU(ctx));
        }
        super._save(ctx, pk, model);
    }

    protected void _submit(Context ctx, IObjectPK dataBasePK, IObjectValue model) throws BOSException, EASBizException {
        DataBaseControlModeInfo dataBaseControlModeInfo = (DataBaseControlModeInfo)model;
        if ("D".equals(this.getControlType(dataBaseControlModeInfo.getBOSType(), ctx))) {
            IObjectPK ctrlUnitPK = this.getDefaultCUPK(ctx);
            if (this._isExistPropertyName(ctx, (CoreBaseInfo)dataBaseControlModeInfo, "effectedStatus")) {
                dataBaseControlModeInfo.setInt("effectedStatus", 2);
            }
            ServiceStateManager.getInstance().enableNextCallServices();
            if (dataBaseControlModeInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(dataBaseControlModeInfo.getId()))) {
                this._updateDataBaseDInfo(ctx, ctrlUnitPK, dataBasePK, dataBaseControlModeInfo);
            } else {
                this._addnew(ctx, (IObjectValue)dataBaseControlModeInfo);
            }
        } else {
            super._submit(ctx, dataBasePK, model);
        }
    }

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        IObjectPK[] arrayPK = this.getPKList(ctx, filter, null);
        IObjectPK ctrlUnitPK = this.getDefaultCUPK(ctx);
        if (arrayPK.length > 0) {
            BOSObjectType type = BOSUuid.read((String)arrayPK[0].toString()).getType();
            if ("D".equals(this.getControlType(type, ctx))) {
                int length = arrayPK.length;
                for (int i = 0; i < length; ++i) {
                    boolean isAssigned;
                    IObjectPK dataBaseDPK = arrayPK[i];
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("adminCU.id"));
                    DataBaseControlModeInfo dataBaseDInfo = (DataBaseControlModeInfo)super._getValue(ctx, dataBaseDPK, sic);
                    boolean hasAdminRight = ctrlUnitPK.toString().equals(dataBaseDInfo.getCU().getId().toString());
                    IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
                    if (hasAdminRight) {
                        isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
                        if (isAssigned) {
                            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_ASSIGNED_DATABASED);
                        }
                        super._delete(ctx, dataBaseDPK);
                        continue;
                    }
                    isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
                    if (isAssigned) {
                        this.checkDelPolicy(ctx, ctrlUnitPK, dataBaseDInfo.getBOSType(), dataBaseDPK);
                        iDataBaseDAssign.delete(ctrlUnitPK, dataBaseDPK);
                        this.unassignBizOrgRelatedInfosOfTypeD3(ctx, dataBaseDPK, (IObjectPK)new ObjectUuidPK(dataBaseDInfo.getCU().getId().toString()), ctrlUnitPK);
                        continue;
                    }
                    throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_UNASSIGNED_DATABASED);
                }
                return arrayPK;
            }
            return super._delete(ctx, filter);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _delete(Context ctx, IObjectPK dataBaseDPK) throws BOSException, EASBizException {
        IObjectPK ctrlUnitPK = this.getDefaultCUPK(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("adminCU.id"));
        DataBaseControlModeInfo dataBaseControlModeInfo = (DataBaseControlModeInfo)super._getValue(ctx, dataBaseDPK, sic);
        if ("D".equals(this.getControlType(dataBaseControlModeInfo.getBOSType(), ctx))) {
            boolean hasAdminRight = ctrlUnitPK.toString().equals(dataBaseControlModeInfo.getCU().getId().toString());
            IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
            if (hasAdminRight) {
                boolean isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
                if (isAssigned) {
                    throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_ASSIGNED_DATABASED);
                }
                super._delete(ctx, dataBaseDPK);
                return;
            } else {
                boolean isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
                if (!isAssigned) throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_UNASSIGNED_DATABASED);
                this.checkDelPolicy(ctx, ctrlUnitPK, dataBaseControlModeInfo.getBOSType(), dataBaseDPK);
                iDataBaseDAssign.delete(ctrlUnitPK, dataBaseDPK);
                this.unassignBizOrgRelatedInfosOfTypeD3(ctx, dataBaseDPK, (IObjectPK)new ObjectUuidPK(dataBaseControlModeInfo.getCU().getId().toString()), ctrlUnitPK);
            }
            return;
        } else {
            super._delete(ctx, dataBaseDPK);
        }
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        BOSObjectType type;
        IObjectPK ctrlUnitPK = this.getDefaultCUPK(ctx);
        if (arrayPK.length > 0 && "D".equals(this.getControlType(type = BOSUuid.read((String)arrayPK[0].toString()).getType(), ctx))) {
            for (IObjectPK dataBaseDPK : arrayPK) {
                boolean isAssigned;
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("adminCU.id"));
                DataBaseControlModeInfo dataBaseDInfo = (DataBaseControlModeInfo)super._getValue(ctx, dataBaseDPK, sic);
                boolean hasAdminRight = ctrlUnitPK.toString().equals(dataBaseDInfo.getCU().getId().toString());
                IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
                if (hasAdminRight) {
                    isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
                    if (isAssigned) {
                        throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_ASSIGNED_DATABASED);
                    }
                    super._delete(ctx, dataBaseDPK);
                    continue;
                }
                isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
                if (isAssigned) {
                    this.checkDelPolicy(ctx, ctrlUnitPK, dataBaseDInfo.getBOSType(), dataBaseDPK);
                    iDataBaseDAssign.delete(ctrlUnitPK, dataBaseDPK);
                    this.unassignBizOrgRelatedInfosOfTypeD3(ctx, dataBaseDPK, (IObjectPK)new ObjectUuidPK(dataBaseDInfo.getCU().getId().toString()), ctrlUnitPK);
                    continue;
                }
                throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_UNASSIGNED_DATABASED);
            }
        }
    }

    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        BOSObjectType type;
        IObjectPK[] arrayPK = this.getPKList(ctx, oql);
        IObjectPK ctrlUnitPK = this.getDefaultCUPK(ctx);
        if (arrayPK.length > 0 && "D".equals(this.getControlType(type = BOSUuid.read((String)arrayPK[0].toString()).getType(), ctx))) {
            int length = arrayPK.length;
            for (int i = 0; i < length; ++i) {
                boolean isAssigned;
                IObjectPK dataBaseDPK = arrayPK[i];
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("adminCU.id"));
                DataBaseControlModeInfo dataBaseDInfo = (DataBaseControlModeInfo)super._getValue(ctx, dataBaseDPK, sic);
                boolean hasAdminRight = ctrlUnitPK.toString().equals(dataBaseDInfo.getCU().getId().toString());
                IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
                if (hasAdminRight) {
                    isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
                    if (isAssigned) {
                        throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_ASSIGNED_DATABASED);
                    }
                    super._delete(ctx, dataBaseDPK);
                    continue;
                }
                isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
                if (isAssigned) {
                    this.checkDelPolicy(ctx, ctrlUnitPK, dataBaseDInfo.getBOSType(), dataBaseDPK);
                    iDataBaseDAssign.delete(ctrlUnitPK, dataBaseDPK);
                    this.unassignBizOrgRelatedInfosOfTypeD3(ctx, dataBaseDPK, (IObjectPK)new ObjectUuidPK(dataBaseDInfo.getCU().getId().toString()), ctrlUnitPK);
                    continue;
                }
                throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_UNASSIGNED_DATABASED);
            }
        }
        return arrayPK;
    }

    protected void _updateDataBaseDInfo(Context ctx, IObjectPK ctrlUnitPK, IObjectPK dataBaseDPK, DataBaseControlModeInfo value) throws BOSException, EASBizException {
        assert (ctrlUnitPK != null);
        assert (value != null && value.getCU() != null && value.getCU().getId() != null);
        boolean hasAdminRight = ctrlUnitPK.toString().equals(value.getCU().getId().toString());
        if (hasAdminRight) {
            super._update(ctx, dataBaseDPK, (IObjectValue)value);
        } else {
            IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
            boolean isDataBaseDAssigned = iDataBaseDAssign.checkAssignment(ctrlUnitPK, dataBaseDPK);
            if (isDataBaseDAssigned) {
                this.checkUpdatePolicy(ctx, ctrlUnitPK, value.getBOSType());
                super._update(ctx, dataBaseDPK, (IObjectValue)value);
            } else {
                throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE_UNASSIGNED_DATABASED);
            }
        }
    }

    protected boolean _exists(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        return super._exists(ctx, filter);
    }

    protected boolean _exists(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return super._exists(ctx, pk);
    }

    protected boolean _exists(Context ctx, String oql) throws BOSException, EASBizException {
        return super._exists(ctx, oql);
    }

    protected IObjectPK[] getRefDataBaseDPKs(Context ctx, IObjectPK dataBaseDPK) throws BOSException, EASBizException {
        return null;
    }

    private void checkCanBeAssigned(Context ctx, IObjectPK[] refDataBaseDPKs, IObjectPK assignCUPK) throws BOSException, EASBizException {
        if (refDataBaseDPKs != null && refDataBaseDPKs.length > 0) {
            IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
            IObjectPK[] unAssignedPKs = iDataBaseDAssign.getUnAssignedPKs(assignCUPK, refDataBaseDPKs);
            if (unAssignedPKs == null || unAssignedPKs.length == 0) {
                return;
            }
            DataBaseDAssignInfo assignInfo = null;
            CtrlUnitInfo assignCU = null;
            int n = unAssignedPKs.length;
            for (int i = 0; i < n; ++i) {
                assignInfo = new DataBaseDAssignInfo();
                assignCU = new CtrlUnitInfo();
                assignCU.setId(BOSUuid.read((String)assignCUPK.toString()));
                assignInfo.setAssignCU(assignCU);
                assignInfo.setDataBaseDID(BOSUuid.read((String)unAssignedPKs[i].toString()));
                assignInfo.setBosObjectType(((ObjectUuidPK)unAssignedPKs[i]).getObjectType().toString());
                iDataBaseDAssign.addnew((CoreBaseInfo)assignInfo);
            }
        }
    }

    protected void checkCanBeAssignedByExtraBizRules(Context ctx, IObjectPK fromCUPK, IObjectPK dataPK, IObjectPK toCUPK) throws BOSException, EASBizException {
    }

    @Override
    protected void _assign(Context ctx, IObjectPK ctrlUnitPK, IObjectPK dataBaseDPK, IObjectPK assignCUPK) throws BOSException, EASBizException {
        this.checkCanBeAssignedByExtraBizRules(ctx, ctrlUnitPK, dataBaseDPK, assignCUPK);
        IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
        if (iDataBaseDAssign.checkAssignment(assignCUPK, dataBaseDPK)) {
            return;
        }
        SelectorItemCollection tempSIC = new SelectorItemCollection();
        tempSIC.add(new SelectorItemInfo("adminCU.id"));
        DataBaseControlModeInfo tempDataBaseDInfo = (DataBaseControlModeInfo)super._getValue(ctx, dataBaseDPK, tempSIC);
        boolean hasAdminRight = ctrlUnitPK.toString().equals(tempDataBaseDInfo.getCU().getId().toString());
        if (!hasAdminRight) {
            throw new DataBaseDException(DataBaseDException.ASSIGN_OR_REFER_DATABASED_NOT_RGIHT);
        }
        this.checkCanBeAssigned(ctx, this.getRefDataBaseDPKs(ctx, dataBaseDPK), assignCUPK);
        DataBaseDAssignInfo dataBaseDAssignInfo = new DataBaseDAssignInfo();
        dataBaseDAssignInfo.setDataBaseDID(BOSUuid.read((String)dataBaseDPK.toString()));
        CtrlUnitInfo assignCU = new CtrlUnitInfo();
        assignCU.setId(BOSUuid.read((String)assignCUPK.toString()));
        dataBaseDAssignInfo.setAssignCU(assignCU);
        dataBaseDAssignInfo.setBosObjectType(((ObjectUuidPK)dataBaseDPK).getObjectType().toString());
        iDataBaseDAssign.addnew((CoreBaseInfo)dataBaseDAssignInfo);
        this.assignBizOrgRelatedInfosOfTypeD3(ctx, dataBaseDPK, ctrlUnitPK, assignCUPK);
    }

    protected void assignBizOrgRelatedInfosOfTypeD3(Context ctx, IObjectPK dataID, IObjectPK sourceCUID, IObjectPK targetCUID) throws BOSException, EASBizException {
    }

    protected void unassignBizOrgRelatedInfosOfTypeD3(Context ctx, IObjectPK dataID, IObjectPK sourceCUID, IObjectPK targetCUID) throws BOSException, EASBizException {
    }

    @Override
    protected void _refer(Context ctx, IObjectPK ctrlUnitPK, IObjectPK dataBaseDPK, IObjectPK assignCUPK) throws BOSException, EASBizException {
        IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
        if (iDataBaseDAssign.checkAssignment(assignCUPK, dataBaseDPK)) {
            return;
        }
        SelectorItemCollection tempSIC = new SelectorItemCollection();
        tempSIC.add(new SelectorItemInfo("adminCU.id"));
        this.checkCanBeAssigned(ctx, this.getRefDataBaseDPKs(ctx, dataBaseDPK), assignCUPK);
        DataBaseDAssignInfo dataBaseDAssignInfo = new DataBaseDAssignInfo();
        dataBaseDAssignInfo.setDataBaseDID(BOSUuid.read((String)dataBaseDPK.toString()));
        CtrlUnitInfo assignCU = new CtrlUnitInfo();
        assignCU.setId(BOSUuid.read((String)assignCUPK.toString()));
        dataBaseDAssignInfo.setAssignCU(assignCU);
        dataBaseDAssignInfo.setBosObjectType(((ObjectUuidPK)dataBaseDPK).getObjectType().toString());
        iDataBaseDAssign.addnew((CoreBaseInfo)dataBaseDAssignInfo);
        this.assignBizOrgRelatedInfosOfTypeD3(ctx, dataBaseDPK, ctrlUnitPK, assignCUPK);
    }

    protected DataBaseControlModeCollection _getDataBaseControlModeCollection(Context ctx, IObjectPK ctrlUnitPK, String oql) throws BOSException, EASBizException {
        EntityViewInfo viewInfo;
        assert (!StringUtils.isEmpty((String)oql));
        try {
            viewInfo = new EntityViewInfo(oql);
        }
        catch (ParserException e) {
            throw new DataBaseDException(DataBaseDException.GET_FILTER_FAIL, e);
        }
        FilterInfo filterInfo = this.getDatabaseDFilter(ctx, ctrlUnitPK, "id", "adminCU.id");
        if (filterInfo != null && filterInfo.getFilterItems().size() > 0) {
            if (viewInfo.getFilter() != null && viewInfo.getFilter().getFilterItems().size() > 0) {
                viewInfo.getFilter().mergeFilter(filterInfo, "AND");
            } else {
                viewInfo.setFilter(filterInfo);
            }
        }
        return super.getDataBaseControlModeCollection(ctx, viewInfo);
    }

    @Override
    protected FilterInfo _getDatabaseDFilter(Context ctx, IObjectPK ctrlUnitPK, String idFieldName, String adminCUFieldame) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(adminCUFieldame, (Object)ctrlUnitPK.toString()));
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FDataBaseDID FROM T_BD_DataBaseDAssign ").append(" WHERE FBOSObjectType = '").append(this.getBOSType()).append("' ").append(" AND FAssignCUID = '").append(ctrlUnitPK.toString()).append("' ");
        filterInfo.getFilterItems().add(new FilterItemInfo(idFieldName, (Object)sql.toString(), CompareType.INNER));
        Set visibleOrgIDs = this.getVisibleOrgIDs(ctx, this.getBOSType(), ctrlUnitPK);
        if (visibleOrgIDs == null || visibleOrgIDs.size() == 0) {
            filterInfo.setMaskString(" #0 OR #1");
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo(adminCUFieldame, (Object)visibleOrgIDs, CompareType.INCLUDE));
            filterInfo.setMaskString(" #0 OR #1 OR #2 ");
        }
        return filterInfo;
    }

    @Override
    protected FilterInfo _getDatabaseDFilter(Context ctx, IObjectPK ctrlUnitPK, String idFieldName, String adminCUFieldame, String mainObjName) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(adminCUFieldame, (Object)ctrlUnitPK.toString()));
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FDataBaseDID FROM T_BD_DataBaseDAssign ").append(" WHERE FBOSObjectType = '").append(this.getBOSType()).append("' ").append(" AND FAssignCUID = '").append(ctrlUnitPK.toString()).append("' ").append(" AND FDataBaseDID = ").append(mainObjName).append(".F").append(idFieldName);
        filterInfo.getFilterItems().add(new FilterItemInfo(idFieldName, (Object)sql.toString(), CompareType.EXISTS));
        Set visibleOrgIDs = this.getVisibleOrgIDs(ctx, this.getBOSType(), ctrlUnitPK);
        if (visibleOrgIDs == null || visibleOrgIDs.size() == 0) {
            filterInfo.setMaskString(" #0 OR #1");
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo(adminCUFieldame, (Object)visibleOrgIDs, CompareType.INCLUDE));
            filterInfo.setMaskString(" #0 OR #1 OR #2 ");
        }
        return filterInfo;
    }

    private Set getVisibleOrgIDs(Context ctx, BOSObjectType objectType, IObjectPK ctrlUnitPK) throws EASBizException, BOSException {
        HashSet<String> set = new HashSet<String>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("level"));
        CtrlUnitInfo cui = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo(ctrlUnitPK, sic);
        String longNumber = cui.getLongNumber();
        int level = cui.getLevel();
        StringBuffer sql = new StringBuffer(500);
        sql.append("select cu.FID,cu.FLevel,cu.FParentID from T_ORG_CtrlUnit cu inner join T_ORG_CUBDControl bd ").append("on bd.FControlUnitID=cu.FID ").append("where bd.FIsSuperiorViewable=1 and cu.FLongNumber like ? and bd.FBDBOSType=? ").append("order by cu.FLevel asc");
        Object[] params = new String[]{longNumber + "!%", objectType.toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        int baselevel = -1;
        int currentlevel = -1;
        String ctrlUnitID = "";
        String parentCtrlUnitID = "";
        try {
            while (rs.next()) {
                currentlevel = rs.getInt("FLevel");
                ctrlUnitID = rs.getString("FID").trim();
                parentCtrlUnitID = rs.getString("FParentID");
                if (baselevel == -1) {
                    if (currentlevel != level + 1) break;
                    baselevel = currentlevel;
                }
                if (currentlevel == baselevel) {
                    set.add(ctrlUnitID);
                    continue;
                }
                assert (currentlevel > baselevel);
                if (StringUtils.isEmpty((String)parentCtrlUnitID) || !set.contains(parentCtrlUnitID.trim())) continue;
                set.add(ctrlUnitID);
            }
        }
        catch (SQLException e) {
            throw new DataBaseDException(DataBaseDException.GET_FILTER_FAIL, e);
        }
        StringBuffer debuginfo = new StringBuffer();
        Object[] array = set.toArray();
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            debuginfo.append(array[i].toString() + ",");
        }
        logger.debug((Object)("CUBDControl visible CU list : " + debuginfo.toString()));
        return set;
    }

    private String getCULongNumber(Context ctx, IObjectPK orgPK) throws BOSException, SQLException {
        String longNumber = null;
        String treeID = "00000000-0000-0000-0000-0000000000014F2827FD";
        String orgID = orgPK.toString();
        Object[] params = new Object[]{treeID, orgID};
        StringBuffer sql = new StringBuffer(500);
        sql.append(" SELECT FLongNumber FROM T_ORG_Structure ").append(" WHERE\tFTreeId = ? ").append(" AND FUnitId = ? ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        if (rowSet.next()) {
            longNumber = rowSet.getString("FLongNumber");
        }
        return longNumber;
    }

    @Override
    protected void _cancelAssign(Context ctx, IObjectPK ctrlUnitPK, IObjectPK dataBaseDPK, IObjectPK cancelAssignCUPK) throws BOSException, EASBizException {
        SelectorItemCollection tempSIC = new SelectorItemCollection();
        tempSIC.add(new SelectorItemInfo("adminCU.id"));
        DataBaseControlModeInfo tempDataBaseDInfo = (DataBaseControlModeInfo)super._getValue(ctx, dataBaseDPK, tempSIC);
        boolean hasAdminRight = ctrlUnitPK.toString().equals(tempDataBaseDInfo.getCU().getId().toString());
        if (!hasAdminRight) {
            throw new DataBaseDException(DataBaseDException.ASSIGN_OR_REFER_DATABASED_NOT_RGIHT);
        }
        this.checkBizReference(ctx, dataBaseDPK, cancelAssignCUPK);
        IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
        iDataBaseDAssign.delete(ctrlUnitPK, dataBaseDPK);
        this.unassignBizOrgRelatedInfosOfTypeD3(ctx, dataBaseDPK, ctrlUnitPK, cancelAssignCUPK);
    }

    @Override
    protected boolean _canBeAssigned(Context ctx, BOSObjectType bosObjectType, IObjectPK ctrlUnitPK) throws BOSException, EASBizException {
        try {
            String treeID = "00000000-0000-0000-0000-0000000000014F2827FD";
            String longNumber = this.getCULongNumber(ctx, ctrlUnitPK);
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            String ctrlUnitID = iFullOrgUnit.getFullOrgUnitInfo(ctrlUnitPK).getCU().getId().toString();
            StringBuffer sql = new StringBuffer(500);
            sql.append(" SELECT Structure.FUnitId FROM T_ORG_Structure Structure ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = Structure.FUnitId ").append(" WHERE Structure.FTreeId = ? ").append(" AND CHARINDEX( N'").append(longNumber).append("!' , Structure.FLongNumber || N'!' ) > 0 ").append(" AND BaseUnit.FControlUnitID = ? ").append(" ORDER BY Structure.FLongNumber ASC ");
            Object[] params = new Object[]{treeID, ctrlUnitID};
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            while (rowSet.next()) {
                if (!this.canBeAssigned(ctx, bosObjectType, ctrlUnitID)) continue;
                return true;
            }
        }
        catch (SQLException e) {
            throw new DataBaseDException(DataBaseDException.GET_INFO_FAIL, e);
        }
        return false;
    }

    private boolean canBeAssigned(Context ctx, BOSObjectType objectType, String ctrlUnitID) throws EASBizException, BOSException {
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitID);
        return controlInfo == null ? false : controlInfo.getDispatchPattern().equals((Object)CUBDDispatchPattern.DISPATCH) || controlInfo.getDispatchPattern().equals((Object)CUBDDispatchPattern.DISPATCH_REFERENCE);
    }

    @Override
    protected boolean _canBeUpgraded(Context ctx, BOSObjectType bosType, IObjectPK ctrUnitPK) throws BOSException, EASBizException {
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(bosType.toString(), ctrUnitPK.toString());
        return controlInfo == null ? false : controlInfo.isIsSubordinateUpgradable();
    }

    @Override
    protected boolean _canRefer(Context ctx, BOSObjectType bosObjectType, IObjectPK ctrlUnitPK) throws EASBizException, BOSException {
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(bosObjectType.toString(), ctrlUnitPK.toString());
        return controlInfo == null ? false : controlInfo.getDispatchPattern().equals((Object)CUBDDispatchPattern.REFERENCE);
    }

    @Override
    protected void _cancelRefer(Context ctx, IObjectPK cancelReferCUPK, IObjectPK dataBaseDPK) throws BOSException, EASBizException {
        this.checkBizReference(ctx, dataBaseDPK, cancelReferCUPK);
        IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
        iDataBaseDAssign.delete(cancelReferCUPK, dataBaseDPK);
        SelectorItemCollection tempSIC = new SelectorItemCollection();
        tempSIC.add(new SelectorItemInfo("adminCU.id"));
        DataBaseControlModeInfo tempDataBaseDInfo = (DataBaseControlModeInfo)super._getValue(ctx, dataBaseDPK, tempSIC);
        ObjectUuidPK adminCUID = new ObjectUuidPK(tempDataBaseDInfo.getCU().getId().toString());
        this.unassignBizOrgRelatedInfosOfTypeD3(ctx, dataBaseDPK, (IObjectPK)adminCUID, cancelReferCUPK);
    }

    private void checkBizReference(Context ctx, IObjectPK dataBaseDPK, IObjectPK cancelReferCUPK) throws BOSException, EASBizException {
        BOSUuid dataID = BOSUuid.read((String)dataBaseDPK.toString());
        RefChkFilterSet fcfs = new RefChkFilterSet();
        HashSet<String> hs = new HashSet<String>();
        hs.add(cancelReferCUPK.toString());
        fcfs.add(new RefChkFilter(RefChkFilterItemEnum.IncludedCUIDList, hs));
        boolean isReferenced = ReferenceDAO.isReferenced((Context)ctx, (BOSUuid)dataID, (RefChkFilterSet)fcfs);
        if (isReferenced) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("name"));
            String dataName = "[" + this.getValue(ctx, dataBaseDPK, sic).get("name").toString() + "]";
            String cuName = "[" + CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo(cancelReferCUPK, sic).getName() + "]";
            throw new DataBaseDException(DataBaseDException.DATA_USED_IN_CU, new String[]{dataName, cuName});
        }
    }

    @Override
    protected void _batchAssign(Context ctx, String cuid, String[] diddata, String[] cuiddata) throws BOSException, EASBizException {
        String[][] data = this.cuAndDids(cuiddata, diddata);
        if (this.useOptimizedBatchAssginAndUnassign()) {
            this.getDataBaseDNewImpl().batchAssign(this.getBOSType().toString(), this.getConnection(ctx), data);
            return;
        }
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            this.assign(ctx, (IObjectPK)new ObjectUuidPK(cuid), (IObjectPK)new ObjectUuidPK(data[i][1]), (IObjectPK)new ObjectUuidPK(data[i][0]));
        }
    }

    private String[] parsePairOfCUIDAndDataID(String cuid, String dataid) {
        String[] aPair = new String[]{cuid, dataid};
        return aPair;
    }

    private String[][] cuAndDids(String[] cuiddata, String[] diddata) {
        int size = diddata.length;
        int cuSize = cuiddata.length;
        String[][] data = new String[size * cuSize][2];
        for (int i = 0; i < cuSize; ++i) {
            for (int j = 0; j < size; ++j) {
                data[i * size + j] = this.parsePairOfCUIDAndDataID(cuiddata[i].toString(), diddata[j].toString());
            }
        }
        return data;
    }

    protected DataBaseDNewImpl getDataBaseDNewImpl() {
        return new DataBaseDNewImpl();
    }

    @Override
    protected void _batchAssign(Context ctx, String cuid, String sql, HashSet basedata, HashSet cuData) throws BOSException, EASBizException {
        if (this.useOptimizedBatchAssginAndUnassign()) {
            this.getDataBaseDNewImpl().batchAssign(this.getBOSType().toString(), ctx, sql, basedata, cuData);
            return;
        }
        RowSet rs = null;
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
            String dataid = "";
            String cuid2 = "";
            Object[] cuDataArray = cuData.toArray();
            while (rs.next()) {
                dataid = rs.getString("ID");
                if (basedata.contains(dataid)) continue;
                for (int i = 0; i < cuDataArray.length; ++i) {
                    this.assign(ctx, (IObjectPK)new ObjectUuidPK(cuid), (IObjectPK)new ObjectUuidPK(dataid), (IObjectPK)new ObjectUuidPK(cuDataArray[i].toString()));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)cn);
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)cn);
        SQLUtils.cleanup((ResultSet)rs);
    }

    @Override
    protected void _batchUnAssign(Context ctx, String[] diddata, String[] cuiddata) throws BOSException, EASBizException {
        String[][] data = this.cuAndDids(cuiddata, diddata);
        if (this.useOptimizedBatchAssginAndUnassign()) {
            this.getDataBaseDNewImpl().batchUnAssign(ctx, this.getBOSType(), data);
            return;
        }
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            this._deleteDataBaseDInfo(ctx, (IObjectPK)new ObjectUuidPK(data[i][0]), (IObjectPK)new ObjectUuidPK(data[i][1]));
        }
    }

    @Override
    protected void _batchUnAssign(Context ctx, String sql, HashSet basedata, HashSet cuData) throws BOSException, EASBizException {
        if (this.useOptimizedBatchAssginAndUnassign()) {
            this.getDataBaseDNewImpl().batchUnAssign(ctx, this.getBOSType(), sql, basedata, cuData);
            return;
        }
        RowSet rs = null;
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
            String cuid2 = "";
            String dataid = "";
            Object[] cuDataArray = cuData.toArray();
            while (rs.next()) {
                dataid = rs.getString("ID");
                if (basedata.contains(dataid)) continue;
                for (int i = 0; i < cuDataArray.length; ++i) {
                    this._deleteDataBaseDInfo(ctx, (IObjectPK)new ObjectUuidPK(cuDataArray[i].toString()), (IObjectPK)new ObjectUuidPK(dataid));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)cn);
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)cn);
        SQLUtils.cleanup((ResultSet)rs);
    }

    protected void _deleteDataBaseDInfo(Context ctx, IObjectPK ctrlUnitPK, IObjectPK dataBaseDPK) throws BOSException, EASBizException {
        assert (ctrlUnitPK != null);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("adminCU.id"));
        DataBaseControlModeInfo dataBaseDInfo = (DataBaseControlModeInfo)super._getValue(ctx, dataBaseDPK, sic);
        boolean hasAdminRight = ctrlUnitPK.toString().equals(dataBaseDInfo.getCU().getId().toString());
        IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance(ctx);
        if (hasAdminRight) {
            boolean isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
            if (isAssigned) {
                throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_ASSIGNED_DATABASED);
            }
            super._delete(ctx, dataBaseDPK);
        } else {
            boolean isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
            if (isAssigned) {
                this.checkDelPolicy(ctx, ctrlUnitPK, dataBaseDInfo.getBOSType(), dataBaseDPK);
                iDataBaseDAssign.delete(ctrlUnitPK, dataBaseDPK);
                this.unassignBizOrgRelatedInfosOfTypeD3(ctx, dataBaseDPK, (IObjectPK)new ObjectUuidPK(dataBaseDInfo.getCU().getId().toString()), ctrlUnitPK);
            } else {
                throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_UNASSIGNED_DATABASED);
            }
        }
    }

    @Override
    protected void _upgrade(Context ctx, IObjectPK dataPK, IObjectPK subordinateCUPK, IObjectPK superiorCUPK) throws BOSException, EASBizException {
        BOSUuid dataID = BOSUuid.read((String)dataPK.toString());
        CtrlUnitInfo assignCU = new CtrlUnitInfo();
        assignCU.setId(BOSUuid.read((String)subordinateCUPK.toString()));
        String bosType = dataID.getType().toString();
        IDataBaseDAssign idbda = DataBaseDAssignFactory.getLocalInstance(ctx);
        DataBaseDAssignInfo dbdai = new DataBaseDAssignInfo();
        dbdai.setDataBaseDID(dataID);
        dbdai.setAssignCU(assignCU);
        dbdai.setBosObjectType(bosType);
        idbda.addnew((CoreBaseInfo)dbdai);
        CoreBaseInfo dataInfo = (CoreBaseInfo)this._getValue(ctx, dataPK);
        CoreBaseInfo adminCU = (CoreBaseInfo)dataInfo.getObjectValue("adminCU");
        CoreBaseInfo adminCUCopy = (CoreBaseInfo)adminCU.clone();
        adminCUCopy.setId(BOSUuid.read((String)superiorCUPK.toString()));
        dataInfo.put("adminCU", (Object)adminCUCopy);
        super._update(ctx, dataPK, (IObjectValue)dataInfo);
    }

    protected boolean useOptimizedBatchAssginAndUnassign() {
        return false;
    }

    @Override
    protected Set _getReferenced(Context ctx, IObjectPK referenceCUPK, List databaseDPKList) throws BOSException, EASBizException {
        ReferenceDAO rdao = new ReferenceDAO();
        RefChkFilterSet fcfs = new RefChkFilterSet();
        HashSet<String> hs = new HashSet<String>();
        hs.add(referenceCUPK.toString());
        fcfs.add(new RefChkFilter(RefChkFilterItemEnum.IncludedCUIDList, hs));
        return rdao.isReferenced(ctx, databaseDPKList, fcfs, true);
    }

    @Override
    protected DatabaseDCanInfo _allCan(Context ctx, BOSObjectType bosObjectType, IObjectPK ctrlUnitPK) throws BOSException, EASBizException {
        DatabaseDCanInfo info = new DatabaseDCanInfo();
        info.setCanAssign(this._canBeAssigned(ctx, bosObjectType, ctrlUnitPK));
        info.setCanRefer(this._canRefer(ctx, bosObjectType, ctrlUnitPK));
        info.setCanUpgrade(this._canBeUpgraded(ctx, bosObjectType, ctrlUnitPK));
        return info;
    }
}

