/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.framework.DataBaseDAssignFactory;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.app.UnAssignCheckerDAO;
import com.kingdee.eas.basedata.framework.util.FMQuerySqlBuilder;
import com.kingdee.eas.basedata.master.material.util.AssignmentUtil;
import com.kingdee.eas.basedata.master.util.PerfTimer;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.IRefChecker;
import com.kingdee.eas.common.RefCheckerFactory;
import com.kingdee.eas.common.RefChkFilter;
import com.kingdee.eas.common.RefChkFilterItemEnum;
import com.kingdee.eas.common.RefChkFilterSet;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DataBaseDNewImpl {
    private String assignTableName = "T_BD_DataBaseDAssign";
    private final Logger logger = Logger.getLogger(DataBaseDNewImpl.class);
    private String tbl = null;
    private HashMap referencedMap = new HashMap();

    public void setAssignTableName(String assignTableName) {
        this.assignTableName = assignTableName;
    }

    private String getSQLTemplateForAssigning(String bosType) {
        StringBuffer tempSql = new StringBuffer(500);
        tempSql.append("insert into T_BD_DataBaseDAssign (FID ,FCreatorID,FCreateTime ,FLastUpdateUserID,FLastUpdateTime ,FControlUnitID ,FDataBaseDID ,FAssignCUID ,FBOSObjectType ,FStatus) select * from (").append("select newbosid(''").append(bosType).append("'') as \"F1\",").append("''00000000-0000-0000-0000-00000000000013B7DE7F'' as \"F2\",getdate() as \"F3\",").append("''00000000-0000-0000-0000-00000000000013B7DE7F'' as \"F4\",getdate() as \"F5\",").append("''00000000-0000-0000-0000-000000000000CCE7AED4'' as \"F6\",").append("''{1}'' as \"DATAID\",''{0}'' as \"CUID\",''").append(bosType).append("'' as \"F9\",0 as  \"F10\") as \"A\" ");
        return tempSql.toString();
    }

    private String getSQLDeleteAssign(String[][] data) {
        StringBuffer sql = new StringBuffer(" delete from T_BD_DataBaseDAssign where FDataBaseDID in ");
        StringBuffer cuids = new StringBuffer("(");
        StringBuffer dids = new StringBuffer("(");
        if (data.length == 0) {
            return null;
        }
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            String[] tmp = data[i];
            if (i == data.length - 1) {
                cuids.append("'").append(tmp[0]).append("')");
                dids.append("'").append(tmp[1]).append("')");
                continue;
            }
            cuids.append("'").append(tmp[0]).append("',");
            dids.append("'").append(tmp[1]).append("',");
        }
        sql.append(dids).append(" and FAssignCUID in ").append(cuids);
        return sql.toString();
    }

    public void batchAssign(String bosType, Connection cn, String[][] data) throws BOSException, EASBizException {
        LowTimer allTimer = new LowTimer();
        String sqlTemplate = this.getSQLTemplateForAssigning(bosType);
        this.logger.debug((Object)("start executing batchassign time " + allTimer.msValue()));
        Statement stmt = null;
        try {
            stmt = cn.createStatement();
            String deleteSql = this.getSQLDeleteAssign(data);
            if (deleteSql != null) {
                stmt.addBatch(deleteSql);
            }
            int n = data.length;
            for (int i = 0; i < n; ++i) {
                stmt.addBatch(MessageFormat.format(sqlTemplate, data[i]));
            }
            stmt.executeBatch();
            this.logger.debug((Object)("execute batchassign cost time  " + allTimer.msValue()));
        }
        catch (SQLException e) {
            this.logger.error((Object)("sql next exception:" + e.getNextException()));
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
            SQLUtils.cleanup((Connection)cn);
        }
    }

    public String getSQLForAssigning(Context ctx, String bosType, String sql, HashSet basedata, HashSet cuData) throws Exception {
        PerfTimer timer = new PerfTimer();
        Object[] cuDataArray = cuData.toArray();
        Object[] dataBaseDArray = basedata.toArray();
        String tblCU = this.generateCUTable(ctx, cuDataArray);
        timer.addAnalysisResultToLog("generateCUTable", this.logger);
        String viewDataBaseDSelected = this.generateDataBaseDView(ctx, sql, dataBaseDArray);
        timer.addAnalysisResultToLog("generateDataBaseDView", this.logger);
        timer.addAnalysisResultToLog("delete from T_BD_DataBaseDAssign", this.logger);
        StringBuffer sql2 = new StringBuffer(500);
        sql2.append("insert into T_BD_DataBaseDAssign (FID ,FCreatorID,FCreateTime ,FLastUpdateUserID,FLastUpdateTime ,FControlUnitID ,FDataBaseDID ,FAssignCUID ,FBOSObjectType ,FStatus) ");
        sql2.append("select newbosid('").append(bosType).append("') FID,");
        sql2.append("'00000000-0000-0000-0000-00000000000013B7DE7F' FCreatorID,");
        sql2.append("getdate() FCreateTime,");
        sql2.append("'00000000-0000-0000-0000-00000000000013B7DE7F' FLastUpdateUserID,");
        sql2.append("getdate() FLastUpdateTime,");
        sql2.append("'00000000-0000-0000-0000-000000000000CCE7AED4' FControlUnitID,");
        sql2.append("v.FID FDataBaseDID,");
        sql2.append("tcu.FID FAssignCUID,");
        sql2.append("'").append(bosType).append("' FBOSObjectType,");
        sql2.append("0 FStatus");
        sql2.append(" from  ").append(tblCU).append(" tcu,").append(viewDataBaseDSelected).append(" v");
        sql2.append(" where not exists (select FDataBaseDID from T_BD_DataBaseDAssign bd where bd.FASSIGNCUID=tcu.fid and bd.FDATABASEDID=v.fid)");
        timer.addAnalysisResultToLog("getSQLForAssigning over inner", this.logger);
        this.logger.info((Object)("batch assign sql:" + sql2));
        return sql2.toString();
    }

    public String getSQLForAssigning2(Context ctx, String bosType, String sql, HashSet basedata, HashSet cuData) throws Exception {
        PerfTimer timer = new PerfTimer();
        Object[] cuDataArray = cuData.toArray();
        Object[] dataBaseDArray = basedata.toArray();
        String tblCU = this.generateCUTable(ctx, cuDataArray);
        timer.addAnalysisResultToLog("generateCUTable", this.logger);
        String viewDataBaseDSelected = this.generateDataBaseDView(ctx, sql, dataBaseDArray);
        timer.addAnalysisResultToLog("generateDataBaseDView", this.logger);
        timer.addAnalysisResultToLog("delete from T_BD_DataBaseDAssign", this.logger);
        String tbl = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName("TblForAssign");
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("CREATE TABLE ");
        createTableSql.append(tbl);
        createTableSql.append("\t(");
        createTableSql.append("fassigncuid        varchar(44),");
        createTableSql.append("fdatabasedid       varchar(44) ");
        createTableSql.append(")");
        TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(createTableSql.toString());
        StringBuffer tmpSql = new StringBuffer();
        tmpSql.append("insert into " + tbl);
        tmpSql.append(" select /*+ leading(v) */  bd.fassigncuid,bd.fdatabasedid from ");
        tmpSql.append(tblCU).append(" tcu,").append(viewDataBaseDSelected).append(" v,").append("T_BD_DatabasedAssign bd ");
        tmpSql.append("where bd.fassigncuid = tcu.fid and bd.fdatabasedid = v.fid");
        this.logger.info((Object)("batch assign sql:" + tmpSql.toString()));
        DbUtil.execute((Context)ctx, (String)tmpSql.toString());
        String indexSql = "CREATE INDEX IX_BD_" + tbl.substring(tbl.length() - 8, tbl.length()) + " ON " + tbl + "(fassigncuid,fdatabasedid)";
        this.logger.info((Object)("batch assign sql:" + indexSql));
        DbUtil.execute((Context)ctx, (String)indexSql);
        StringBuffer sql2 = new StringBuffer(500);
        sql2.append("insert  /*+ USE_NL(TCU V) */ into T_BD_DataBaseDAssign (FID ,FCreatorID,FCreateTime ,FLastUpdateUserID,FLastUpdateTime ,FControlUnitID ,FDataBaseDID ,FAssignCUID ,FBOSObjectType ,FStatus) ");
        sql2.append("select newbosid('").append(bosType).append("') FID,");
        sql2.append("'00000000-0000-0000-0000-00000000000013B7DE7F' FCreatorID,");
        sql2.append("getdate() FCreateTime,");
        sql2.append("'00000000-0000-0000-0000-00000000000013B7DE7F' FLastUpdateUserID,");
        sql2.append("getdate() FLastUpdateTime,");
        sql2.append("'00000000-0000-0000-0000-000000000000CCE7AED4' FControlUnitID,");
        sql2.append("v.FID FDataBaseDID,");
        sql2.append("tcu.FID FAssignCUID,");
        sql2.append("'").append(bosType).append("' FBOSObjectType,");
        sql2.append("0 FStatus");
        sql2.append(" from  ").append(tblCU).append(" tcu,").append(viewDataBaseDSelected).append(" v");
        sql2.append(" where not exists (select 1 from " + tbl + " bd where bd.FASSIGNCUID=tcu.fid and bd.FDATABASEDID=v.fid)");
        DbUtil.execute((Context)ctx, (String)sql2.toString());
        timer.addAnalysisResultToLog("getSQLForAssigning over inner", this.logger);
        this.logger.info((Object)("batch assign sql:" + sql2));
        return "";
    }

    private String generateDataBaseDView(Context ctx, String sql, Object[] dataBaseDArray) throws BOSException, Exception {
        Object viewDataBaseDSelected = null;
        String diddatasql = "";
        String tblDataBaseDExclude = this.generateDataBaseDTable(ctx, dataBaseDArray);
        diddatasql = sql.indexOf("order by") != -1 ? sql.substring(0, sql.indexOf("order by")) : sql;
        diddatasql = " select v.\"ID\" FID " + diddatasql.substring(diddatasql.indexOf("from"));
        diddatasql = diddatasql + " and v.\"ID\" not in (select FDataBaseDID from " + tblDataBaseDExclude + ")";
        this.tbl = this.createIdTable(ctx);
        FMQuerySqlBuilder insertSb = new FMQuerySqlBuilder();
        insertSb.appendSql("insert into ").appendSql(this.tbl).appendSql(diddatasql);
        insertSb.execute(ctx);
        return this.tbl;
    }

    public void batchAssign(String bosType, Context ctx, String sql, HashSet basedata, HashSet cuData) throws BOSException, EASBizException {
        try {
            Object[] cuDataArray = cuData.toArray();
            PerfTimer timer = new PerfTimer();
            this.getSQLForAssigning2(ctx, bosType, sql, basedata, cuData);
            timer.addAnalysisResultToLog("DbUtil.execute(ctx, getSQLForAssigning(ctx,bosType, sql, basedata, cuData))", this.logger);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String generateCUTable(Context ctx, Object[] cuDataArray) throws Exception {
        String tblCU = this.createIdTable(ctx);
        Connection cn = null;
        Statement stmt = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.createStatement();
            for (int i = 0; i < cuDataArray.length; ++i) {
                stmt.addBatch("insert into " + tblCU + " values ('" + cuDataArray[i].toString() + "')");
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)e);
                throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        return tblCU;
    }

    private String generateDataBaseDTable(Context ctx, Object[] dataBaseDArray) throws BOSException {
        String tbl = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName("BatchAssign");
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("CREATE TABLE ");
        createTableSql.append(tbl);
        createTableSql.append("\t(");
        createTableSql.append("FDataBaseDID\tvarchar(44)");
        createTableSql.append(")");
        TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(createTableSql.toString());
        Connection cn = null;
        Statement stmt = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.createStatement();
            for (int i = 0; i < dataBaseDArray.length; ++i) {
                stmt.addBatch("insert into " + tbl + " values ('" + dataBaseDArray[i] + "')");
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)e);
                throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        return tbl;
    }

    private void unAssign(Context ctx, BOSObjectType bosType, IObjectPK dataBaseDPK, IObjectPK cancelReferCUPK) throws BOSException, EASBizException {
        this.checkBizReference(ctx, bosType, dataBaseDPK, cancelReferCUPK);
        DataBaseDAssignFactory.getLocalInstance(ctx).delete(cancelReferCUPK, dataBaseDPK);
    }

    private void checkBizReference(Context ctx, BOSObjectType bosType, IObjectPK dataBaseDPK, IObjectPK cancelReferCUPK) throws BOSException, EASBizException {
        BOSUuid dataID = BOSUuid.read((String)dataBaseDPK.toString());
        RefChkFilterSet fcfs = new RefChkFilterSet();
        HashSet<String> hs = new HashSet<String>();
        hs.add(cancelReferCUPK.toString());
        fcfs.add(new RefChkFilter(RefChkFilterItemEnum.IncludedCUIDList, hs));
        boolean isReferenced = ReferenceDAO.isReferenced((Context)ctx, (BOSUuid)dataID, (RefChkFilterSet)fcfs);
        if (isReferenced) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("name"));
            String dataName = "[" + DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(bosType, dataBaseDPK, sic).get("name").toString() + "]";
            String cuName = "[" + CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo(cancelReferCUPK, sic).getName() + "]";
            throw new DataBaseDException(DataBaseDException.DATA_USED_IN_CU, new String[]{dataName, cuName});
        }
    }

    public HashMap getReferencedMap() {
        return this.referencedMap;
    }

    public void batchUnAssign(Context ctx, BOSObjectType bosType, String[][] data) throws BOSException, EASBizException {
        ArrayList<String> objListOld = new ArrayList<String>();
        ArrayList<String> cuList = new ArrayList<String>();
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            if (!objListOld.contains(data[i][1])) {
                objListOld.add(data[i][1]);
            }
            if (cuList.contains(data[i][0])) continue;
            cuList.add(data[i][0]);
        }
        this.referencedMap.clear();
        Iterator it = cuList.iterator();
        ArrayList<String> deleteAssignedDataList = new ArrayList<String>();
        while (it.hasNext()) {
            ArrayList objList = new ArrayList(objListOld);
            String cuid = (String)it.next();
            RefChkFilterSet fcfs = new RefChkFilterSet();
            HashSet<String> hs = new HashSet<String>();
            hs.add(cuid);
            fcfs.add(new RefChkFilter(RefChkFilterItemEnum.IncludedCUIDList, hs));
            IRefChecker checker = RefCheckerFactory.getLocalInstance((Context)ctx);
            Set isReferencedObjList = checker.isReferenced(objList, fcfs);
            objList.removeAll(isReferencedObjList);
            if (isReferencedObjList != null && isReferencedObjList.size() > 0) {
                this.referencedMap.put(cuid, isReferencedObjList);
            }
            if (objList.size() <= 0) continue;
            String[] objArray = objList.toArray(new String[0]);
            this._doBatchUnAssign(ctx, cuid, objArray);
            deleteAssignedDataList.add(this.getDeleteAssignedDataSql(ctx, cuid, objArray));
        }
        if (deleteAssignedDataList.size() > 0) {
            DataBaseDNewImpl.executeBatch(ctx, deleteAssignedDataList);
        }
    }

    protected void _doBatchUnAssign(Context ctx, String cuid, String[] objArray) throws BOSException, EASBizException {
    }

    private void deleteAssignedData(Context ctx, String cuid, String[] dataids) throws BOSException {
        StringBuffer dataidStr = new StringBuffer();
        for (int i = 0; i < dataids.length; ++i) {
            if (i == 0) {
                dataidStr.append("'").append(dataids[i]).append("'");
                continue;
            }
            dataidStr.append(",'").append(dataids[i]).append("'");
        }
        DataBaseDNewImpl.deleteAssignedData(ctx, cuid, dataidStr.toString());
    }

    private String getDeleteAssignedDataSql(Context ctx, String cuid, String[] dataids) throws BOSException {
        StringBuffer dataidStr = new StringBuffer();
        for (int i = 0; i < dataids.length; ++i) {
            if (i == 0) {
                dataidStr.append("'").append(dataids[i]).append("'");
                continue;
            }
            dataidStr.append(",'").append(dataids[i]).append("'");
        }
        return this.getDeleteAssignedDataSql(ctx, cuid, dataidStr.toString());
    }

    private static void deleteAssignedData(Context ctx, String cuid, String idsql) throws BOSException {
        StringBuffer sql = new StringBuffer().append("delete from T_BD_DatabaseDAssign where FAssignCUID = '").append(cuid).append("' and FDatabaseDID in (").append(idsql).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String getDeleteAssignedDataSql(Context ctx, String cuid, String idsql) throws BOSException {
        return new StringBuffer().append("delete from ").append(this.assignTableName).append(" where FAssignCUID = '").append(cuid).append("' and FDatabaseDID in (").append(idsql).append(")").toString();
    }

    private static void executeBatch(Context ctx, ArrayList sqlList) throws BOSException {
        Statement stmt = null;
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.createStatement();
            for (int i = 0; i < sqlList.size(); ++i) {
                if (sqlList.get(i) == null) continue;
                stmt.addBatch((String)sqlList.get(i));
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((Connection)cn);
    }

    public void batchUnAssign(Context ctx, BOSObjectType bosType, String sql, HashSet basedata, HashSet cuData) throws BOSException, EASBizException {
        String sqlonlyIdSlt = DataBaseDNewImpl.getSqlOnlyHasIDSlt(sql);
        String idbyDeleteStr = null;
        Object[] cuDataArray = cuData.toArray();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < cuDataArray.length; ++i) {
            Set isReferencedSet = DataBaseDNewImpl.getReferenced(ctx, bosType, cuDataArray[i].toString(), sqlonlyIdSlt);
            idbyDeleteStr = DataBaseDNewImpl.getSqlExceptIsReferenced(ctx, bosType, cuDataArray[i].toString(), sqlonlyIdSlt, basedata, isReferencedSet);
            this._doBatchUnAssignBySql(ctx, idbyDeleteStr, cuDataArray[i].toString());
            list.add(this.getDeleteAssignedDataSql(ctx, cuDataArray[i].toString(), idbyDeleteStr));
        }
        DataBaseDNewImpl.executeBatch(ctx, list);
    }

    public Map batchUnAssignReturnFail(Context ctx, BOSObjectType bosType, String[][] data) throws BOSException, EASBizException {
        ArrayList<String> objListOld = new ArrayList<String>();
        ArrayList<String> cuList = new ArrayList<String>();
        HashMap map = new HashMap();
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            if (!objListOld.contains(data[i][1])) {
                objListOld.add(data[i][1]);
            }
            if (cuList.contains(data[i][0])) continue;
            cuList.add(data[i][0]);
        }
        this.referencedMap.clear();
        Iterator it = cuList.iterator();
        ArrayList<String> deleteAssignedDataList = new ArrayList<String>();
        while (it.hasNext()) {
            ArrayList objList = new ArrayList(objListOld);
            String cuid = (String)it.next();
            RefChkFilterSet fcfs = new RefChkFilterSet();
            HashSet<String> hs = new HashSet<String>();
            hs.add(cuid);
            HashSet<String> boshs = new HashSet<String>();
            boshs.add("418A6CBB");
            fcfs.add(new RefChkFilter(RefChkFilterItemEnum.IncludedCUIDList, hs));
            fcfs.add(new RefChkFilter(RefChkFilterItemEnum.ExcludedRefobjTypeList, boshs));
            IRefChecker checker = RefCheckerFactory.getLocalInstance((Context)ctx);
            Set isReferencedObjList = checker.isReferenced(objList, fcfs);
            StringBuffer selectedIdSql = new StringBuffer(100);
            selectedIdSql.append("select fid from ").append(this.generateIdTable(ctx, objList));
            Set extRefSet = new UnAssignCheckerDAO().getReferenced(ctx, bosType.toString(), cuid, selectedIdSql.toString());
            isReferencedObjList.addAll(extRefSet);
            objList.removeAll(isReferencedObjList);
            if (isReferencedObjList != null && isReferencedObjList.size() > 0) {
                this.referencedMap.put(cuid, isReferencedObjList);
            }
            if (objList.size() <= 0) continue;
            String[] objArray = objList.toArray(new String[0]);
            this._doBatchUnAssign(ctx, cuid, objArray);
            deleteAssignedDataList.add(this.getDeleteAssignedDataSql(ctx, cuid, objArray));
        }
        if (deleteAssignedDataList.size() > 0) {
            DataBaseDNewImpl.executeBatch(ctx, deleteAssignedDataList);
        }
        map = this.referencedMap;
        return map;
    }

    private String createAndfillIdTable(Context ctx, String sql) throws BOSException, EASBizException {
        String tempIdTable = null;
        Connection cn = null;
        Statement stmt = null;
        try {
            tempIdTable = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName("IdTable");
            StringBuffer createTableSql = new StringBuffer();
            createTableSql.append("CREATE TABLE " + tempIdTable);
            createTableSql.append("\t(");
            createTableSql.append("fid        varchar(44)");
            createTableSql.append(")");
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(createTableSql.toString());
            FMQuerySqlBuilder sbInsert = new FMQuerySqlBuilder();
            sbInsert.appendSql("insert into ").appendSql(tempIdTable).appendSql(" ").appendSql(sql);
            sbInsert.execute(ctx);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(stmt, cn);
        }
        return tempIdTable;
    }

    public boolean optimizeUnAssign() {
        return true;
    }

    public Map batchUnAssignReturnFail(Context ctx, BOSObjectType bosType, String sql, HashSet basedata, HashSet cuData) throws BOSException, EASBizException {
        HashMap<String, Set> unAssignFailMap = new HashMap<String, Set>();
        String sqlonlyIdSlt = DataBaseDNewImpl.getSqlOnlyHasIDSlt(sql);
        String tempTable = null;
        long currentTimeMillis = System.currentTimeMillis();
        if (this.optimizeUnAssign()) {
            tempTable = this.createAndfillIdTable(ctx, sqlonlyIdSlt);
            sqlonlyIdSlt = "select fid from " + tempTable;
        }
        this.logger.info((Object)("\u586b\u5145\u4e34\u65f6\u8868\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - currentTimeMillis) + "\u6beb\u79d2"));
        String idbyDeleteStr = null;
        Object[] cuDataArray = cuData.toArray();
        ArrayList<String> list = new ArrayList<String>();
        currentTimeMillis = System.currentTimeMillis();
        boolean flag = DataBaseDNewImpl.isAssignmentSyncParam(ctx);
        for (int i = 0; i < cuDataArray.length; ++i) {
            currentTimeMillis = System.currentTimeMillis();
            Set isReferencedSet = DataBaseDNewImpl.getReferenced(ctx, bosType, cuDataArray[i].toString(), sqlonlyIdSlt);
            Set extRefSet = new UnAssignCheckerDAO().getReferenced(ctx, bosType.toString(), cuDataArray[i].toString(), sqlonlyIdSlt);
            isReferencedSet.addAll(extRefSet);
            idbyDeleteStr = DataBaseDNewImpl.getSqlExceptIsReferenced(ctx, bosType, cuDataArray[i].toString(), sqlonlyIdSlt, basedata, isReferencedSet);
            this.logger.info((Object)("\u53cd\u5206\u914d\u68c0\u9a8c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - currentTimeMillis) + "\u6beb\u79d2"));
            currentTimeMillis = System.currentTimeMillis();
            this._doBatchUnAssignBySql(ctx, idbyDeleteStr, cuDataArray[i].toString());
            this.logger.info((Object)("\u6e05\u7406\u8f85\u52a9\u8868\u8017\u65f6\uff1a" + (System.currentTimeMillis() - currentTimeMillis) + "\u6beb\u79d2"));
            list.add(this.getDeleteAssignedDataSql(ctx, cuDataArray[i].toString(), idbyDeleteStr));
            if (isReferencedSet.size() != 0) {
                if (basedata != null && basedata.size() > 0) {
                    isReferencedSet.removeAll(basedata);
                }
                if (isReferencedSet.size() > 0) {
                    unAssignFailMap.put(cuDataArray[i].toString(), isReferencedSet);
                }
            }
            if (!flag) continue;
            this.unAssignRelationForISC(ctx, bosType.toString(), cuDataArray[i].toString(), idbyDeleteStr);
        }
        this.updateTime(ctx, sqlonlyIdSlt, bosType.toString());
        currentTimeMillis = System.currentTimeMillis();
        DataBaseDNewImpl.executeBatch(ctx, list);
        this.logger.info((Object)("\u6e05\u7406\u5206\u914d\u8868\u8017\u65f6\uff1a" + (System.currentTimeMillis() - currentTimeMillis) + "\u6beb\u79d2"));
        if (this.optimizeUnAssign()) {
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).releaseTableName(tempTable);
        }
        return unAssignFailMap;
    }

    private void unAssignRelationForISC(Context ctx, String bosType, String currentCuId, String findUnAssignIdSql) {
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)findUnAssignIdSql);
            ArrayList<String> list = new ArrayList<String>();
            while (rowSet.next()) {
                String dataId = rowSet.getString("FID");
                list.add(dataId);
            }
            String[] dataIds = list.toArray(new String[0]);
            AssignmentUtil.addSingleSelUnAssignRelationForISC((Context)ctx, (String)bosType, (String[])dataIds, (String[])new String[]{currentCuId}, new HashMap());
        }
        catch (BOSException e) {
            this.logger.error((Object)("unAssignRelationForISC failed:" + e.getMessage()));
        }
        catch (SQLException e) {
            this.logger.error((Object)("unAssignRelationForISC failed:" + e.getMessage()));
        }
        catch (Exception e) {
            this.logger.error((Object)("unAssignRelationForISC failed:" + e.getMessage()));
            e.printStackTrace();
        }
    }

    private static boolean isAssignmentSyncParam(Context ctx) throws EASBizException, BOSException {
        String param = ParamManager.getParamValue((Context)ctx, null, (String)"isUseAssignmentSync");
        return "true".equalsIgnoreCase(param);
    }

    private String geTableName(String bosType) throws BOSException {
        String tableName = "";
        if ("37C67DFC".equalsIgnoreCase(bosType)) {
            tableName = "t_bd_supplier";
        } else if ("BF0C040E".equalsIgnoreCase(bosType)) {
            tableName = "t_bd_customer";
        } else if ("4409E7F0".equalsIgnoreCase(bosType)) {
            tableName = "t_bd_material";
        } else {
            this.logger.error((Object)("BOSTYPE NOT CORRECT ,bosType : " + bosType));
            throw new BOSException("BOSTYPE NOT CORRECT");
        }
        return tableName;
    }

    private void updateTime(Context ctx, String idTable, String bosType) throws BOSException, EASBizException {
        boolean needUpdaetTime;
        String updateTimeAfterass = ParamManager.getParamValue((Context)ctx, null, (String)"updateTimeAfterass");
        boolean bl = needUpdaetTime = updateTimeAfterass == null ? false : Boolean.valueOf(updateTimeAfterass);
        if (!needUpdaetTime) {
            return;
        }
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update ").append(this.geTableName(bosType)).append(" set flastUpdateTime = ?").append(" where fid in (").append(idTable).append(")");
        long currentTimeMillis = System.currentTimeMillis();
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{new Timestamp(new Date().getTime())});
        this.logger.error((Object)("updateLastTime\u8017\u65f6\uff1a" + (System.currentTimeMillis() - currentTimeMillis) + "\u6beb\u79d2"));
    }

    private static Set getReferenced(Context ctx, BOSObjectType bosType, String cuid, String sql) throws BOSException, EASBizException {
        RefChkFilterSet fcfs = new RefChkFilterSet();
        HashSet<String> hs = new HashSet<String>();
        hs.add(cuid);
        fcfs.add(new RefChkFilter(RefChkFilterItemEnum.IncludedCUIDList, hs));
        HashSet<String> boshs = new HashSet<String>();
        boshs.add("418A6CBB");
        fcfs.add(new RefChkFilter(RefChkFilterItemEnum.ExcludedRefobjTypeList, boshs));
        Set isReferencedSet = null;
        IRefChecker checker = RefCheckerFactory.getLocalInstance((Context)ctx);
        isReferencedSet = checker.isReferenced(sql, bosType, fcfs);
        return isReferencedSet;
    }

    protected void _doBatchUnAssignBySql(Context ctx, String idbyDeleteStr, String cuId) throws BOSException, EASBizException {
    }

    private static String getSqlExceptIsReferenced(Context ctx, BOSObjectType bosType, String cuid, String sql, HashSet basedata, Set isReferencedSet) throws BOSException, EASBizException {
        String tbl = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName("materiaAssC");
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("CREATE TABLE ");
        createTableSql.append(tbl);
        createTableSql.append("\t(");
        createTableSql.append("fid        varchar(44)");
        createTableSql.append(")");
        TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(createTableSql.toString());
        FMQuerySqlBuilder sbInsert = new FMQuerySqlBuilder();
        sbInsert.appendSql("insert into " + tbl + " (fid)  ").appendSql(sql);
        sbInsert.execute(ctx);
        isReferencedSet.addAll(basedata);
        if (isReferencedSet.size() > 0 && isReferencedSet.size() < 1000) {
            DataBaseDNewImpl.deleteTmpByArray(ctx, tbl, isReferencedSet.toArray());
        } else if (isReferencedSet.size() >= 1000) {
            ArrayList list = new ArrayList(1000);
            for (Object obj : isReferencedSet) {
                list.add(obj);
                if (list.size() != 1000) continue;
                DataBaseDNewImpl.deleteTmpByArray(ctx, tbl, list.toArray());
                list.clear();
            }
            DataBaseDNewImpl.deleteTmpByArray(ctx, tbl, list.toArray());
        }
        return "select fid from " + tbl;
    }

    private static void deleteTmpByArray(Context ctx, String tbl, Object[] param) throws BOSException, EASBizException {
        FMQuerySqlBuilder sbs = new FMQuerySqlBuilder();
        sbs.appendSql("delete from " + tbl);
        sbs.appendSql(" where fid  in (");
        sbs.appendParam(param);
        sbs.appendSql(" ) ");
        sbs.execute(ctx);
    }

    private static String getSqlOnlyHasIDSlt(String sql) {
        if (sql.indexOf("order by") != -1) {
            sql = sql.substring(0, sql.indexOf("order by"));
        }
        sql = "select v.\"ID\" " + sql.substring(sql.indexOf("from"));
        return sql;
    }

    private String createIdTable(Context ctx) throws Exception {
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("CREATE TABLE SysTable");
        createTableSql.append("\t(");
        createTableSql.append("fid        varchar(44)");
        createTableSql.append(")");
        this.tbl = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql.toString());
        return this.tbl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String generateIdTable(Context ctx, List idList) throws BOSException {
        Connection cn = null;
        PreparedStatement stmt = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            String tbl = this.createIdTable(ctx);
            String insersql = "insert into " + tbl + " (fid)  values (?) ";
            stmt = cn.prepareStatement(insersql);
            for (int i = 0; i < idList.size(); ++i) {
                stmt.setString(1, idList.get(i).toString());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)e);
                throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e));
                catch (Exception e2) {
                    this.logger.error((Object)e2);
                    throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e2));
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        return this.tbl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPretermit(Context ctx, Connection cn, String[][] data) throws BOSException {
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select count(1) from ( ").append(" select t.fid from T_BD_DataBaseDAssign d ").append("\tinner join t_bd_vouchertypes t on  d.FDATABASEDID = t.fid ").append(" where  t.FPRETERMIT =1 and d.FAssignCUID =? ").append(" union ").append(" SELECT fid FROM t_bd_vouchertypes where FPRETERMIT =1 and FCONTROLUNITID = ? ) tb ");
        for (String[] d : data) {
            if (!this.isPretermitVoucherType(ctx, cn, d[1])) continue;
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString(), (Object[])new String[]{d[0], d[0]});
            try {
                row.beforeFirst();
                while (row.next()) {
                    if (row.getInt(1) <= 0) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                SQLUtils.cleanup((Connection)cn);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPretermitVoucherType(Context ctx, Connection cn, String pk) throws BOSException {
        String sql = "SELECT count(1) FROM t_bd_vouchertypes where FPRETERMIT = '1' and fid= ? ";
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{pk});
            row.beforeFirst();
            while (row.next()) {
                if (row.getInt(1) <= 0) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return false;
    }

    public void batchAssign(String bosType, Connection cn, String[] diddata, String[] cuiddata) throws BOSException {
        LowTimer allTimer = new LowTimer();
        String sqlTemplate = this.getSQLTemplateForAssigning(bosType);
        this.logger.debug((Object)("start executing batchassign time " + allTimer.msValue()));
        Statement stmt = null;
        try {
            stmt = cn.createStatement();
            String deleteSql = this.getSQLDeleteAssign(diddata, cuiddata);
            if (deleteSql != null) {
                stmt.addBatch(deleteSql);
            }
            int n = diddata.length;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < cuiddata.length; ++j) {
                    stmt.addBatch(MessageFormat.format(sqlTemplate, cuiddata[j], diddata[i]));
                }
            }
            stmt.executeBatch();
            this.logger.debug((Object)("execute batchassign cost time  " + allTimer.msValue()));
        }
        catch (SQLException e) {
            this.logger.error((Object)("sql next exception:" + e.getNextException()));
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
            SQLUtils.cleanup((Connection)cn);
        }
    }

    private String getSQLDeleteAssign(String[] diddata, String[] cuiddata) {
        int i;
        StringBuffer sql = new StringBuffer(" delete from T_BD_DataBaseDAssign where FDataBaseDID in ");
        StringBuffer cuids = new StringBuffer("(");
        StringBuffer dids = new StringBuffer("(");
        if (diddata.length == 0 || cuiddata.length == 0) {
            return null;
        }
        int n = diddata.length;
        for (i = 0; i < n; ++i) {
            if (i == diddata.length - 1) {
                dids.append("'").append(diddata[i]).append("')");
                continue;
            }
            dids.append("'").append(diddata[i]).append("',");
        }
        n = cuiddata.length;
        for (i = 0; i < n; ++i) {
            if (i == cuiddata.length - 1) {
                cuids.append("'").append(cuiddata[i]).append("')");
                continue;
            }
            cuids.append("'").append(cuiddata[i]).append("',");
        }
        sql.append(dids).append(" and FAssignCUID in ").append(cuids);
        return sql.toString();
    }
}

