/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.framework.util;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;

public class KDTableUtil {
    public static void insertRows(Object[][] rowData, Object[] rowObject, int insertRowIndex, KDTable table) {
        KDTableUtil.insertRows(rowData, rowObject, null, insertRowIndex, table);
    }

    public static void insertRows(Object[][] data, Object[] userRowObjects, Color[] rowColors, int insertRowIndex, KDTable table) {
        if (data.length == 0) {
            return;
        }
        table.setRefresh(false);
        int cols = Math.min(data[0].length, table.getColumnCount());
        for (int i = 0; i < data.length; ++i) {
            IRow row = table.addRow(insertRowIndex++);
            if (userRowObjects != null) {
                row.setUserObject(userRowObjects[i]);
            }
            if (rowColors != null && rowColors[i] != null) {
                row.getStyleAttributes().setBackground(rowColors[i]);
            }
            for (int j = 0; j < cols; ++j) {
                row.getCell(j).setValue(data[i][j]);
            }
        }
        table.setRefresh(true);
        table.reLayoutAndPaint();
    }

    public static void insertRows(Object[][] rowData, Object[] rowObject, int insertRowIndex, KDTable table, QueryInfo query) {
        KDTableUtil.insertRows(rowData, rowObject, null, insertRowIndex, table, query);
    }

    public static void insertRows(RptRowSet rptRowSet, Object[] userRowObjects, Color[] rowColors, int insertRowIndex, KDTable table, QueryInfo query) {
        int rptRowCount = rptRowSet.getRowCount();
        if (rptRowCount == 0) {
            return;
        }
        if (userRowObjects != null && rptRowCount != userRowObjects.length) {
            throw new IllegalArgumentException("userRowObjects length is not equals rptRowCount!!!");
        }
        if (rowColors != null && rptRowCount != rowColors.length) {
            throw new IllegalArgumentException("rowColors length is not equals rptRowCount!!!");
        }
        int columnCount = Math.min(rptRowSet.getColumnCount(), table.getColumnCount());
        table.setRefresh(false);
        int i = 0;
        while (rptRowSet.next()) {
            IRow row = table.addRow(insertRowIndex++);
            if (userRowObjects != null) {
                row.setUserObject(userRowObjects[i]);
            }
            if (rowColors != null && rowColors[i] != null) {
                row.getStyleAttributes().setBackground(rowColors[i]);
            }
            IColumn column = table.getColumn(0);
            ICell tableCell = row.getCell(0);
            tableCell.setValue((Object)(rptRowSet.getInt(0) == 1 ? 1 : 0));
            ArrayList fields = query.getSelector().getFields();
            QueryFieldInfo fieldInfo = null;
            String fieldName = null;
            for (int columnIndex = 0; columnIndex < columnCount - 1; ++columnIndex) {
                fieldInfo = (QueryFieldInfo)fields.get(columnIndex);
                fieldName = fieldInfo.getName();
                fieldName = fieldName.equalsIgnoreCase("id") ? fieldName.toUpperCase() : fieldName;
                tableCell = StringUtils.isEmpty((String)fieldName) ? row.getCell(columnIndex) : row.getCell(fieldName);
                Object columnValue = KDTableUtil.getDisplayValue(StringUtils.isEmpty((String)fieldName) ? rptRowSet.getObject(columnIndex) : rptRowSet.getObject(fieldName.toUpperCase()), columnIndex, query);
                tableCell.setValue(columnValue);
            }
            ++i;
        }
        table.setRefresh(true);
        table.reLayoutAndPaint();
    }

    public static void insertRows(Object[][] data, Object[] userRowObjects, Color[] rowColors, int insertRowIndex, KDTable table, QueryInfo query) {
        if (data.length == 0) {
            return;
        }
        table.setRefresh(false);
        int cols = Math.min(data[0].length, table.getColumnCount());
        for (int i = 0; i < data.length; ++i) {
            IRow row = table.addRow(insertRowIndex++);
            if (userRowObjects != null) {
                row.setUserObject(userRowObjects[i]);
            }
            if (rowColors != null && rowColors[i] != null) {
                row.getStyleAttributes().setBackground(rowColors[i]);
            }
            for (int j = 0; j < cols; ++j) {
                if (j == 0) {
                    row.getCell(j).setValue(data[i][j]);
                    continue;
                }
                row.getCell(j).setValue(KDTableUtil.getDisplayValue(data[i][j], j - 1, query));
            }
        }
        table.setRefresh(true);
        table.reLayoutAndPaint();
    }

    private static Object getDisplayValue(Object value, int position, QueryInfo queryInfo) {
        SelectorInfo selector = queryInfo.getSelector();
        QueryFieldInfo queryFieldInfo = (QueryFieldInfo)selector.getFields().get(position);
        if (value == null) {
            return value;
        }
        try {
            PropertyRefCollection pfc;
            PropertyRefInfo pri;
            PropertyInfo pi;
            ConstDataType cdt = queryFieldInfo.getReturnType();
            if (cdt != null && cdt.equals((Object)ConstDataType.INT) && KDTableUtil.isEnumField(queryFieldInfo) && (pi = (pri = (pfc = queryFieldInfo.getPropertyRefs()).get(0)).getRefProperty()) instanceof OwnPropertyInfo) {
                OwnPropertyInfo opi = (OwnPropertyInfo)pi;
                String className = opi.getMetaDataRef();
                if (value instanceof Integer) {
                    int tmpValue = (Integer)value;
                    IntEnum ie = EnumUtils.getEnum(Class.forName(className), (int)tmpValue);
                    if (ie != null) {
                        return ie.getAlias(SysContext.getSysContext().getLocale());
                    }
                } else if (value instanceof BigDecimal) {
                    int tmpValue = ((BigDecimal)value).intValue();
                    IntEnum ie = EnumUtils.getEnum(Class.forName(className), (int)tmpValue);
                    if (ie != null) {
                        return ie.getAlias(SysContext.getSysContext().getLocale());
                    }
                }
            }
        }
        catch (Exception cdt) {
            // empty catch block
        }
        PropertyInfo pInfo = queryFieldInfo.getPropertyRefs().get(0).getRefProperty();
        if (pInfo instanceof OwnPropertyInfo) {
            OwnPropertyInfo opInfo = (OwnPropertyInfo)pInfo;
            String javaType = opInfo.getJavaType();
            DataType dataType = opInfo.getDataType();
            if (javaType.equals(Boolean.class.getName()) || javaType.equalsIgnoreCase(Boolean.TYPE.getName())) {
                if (value.toString().equals("1")) {
                    return true;
                }
                if (value.toString().equals("0")) {
                    return false;
                }
                return Boolean.valueOf(value.toString());
            }
        }
        return value;
    }

    private static boolean isEnumField(QueryFieldInfo qfi) {
        OwnPropertyInfo opi;
        boolean isEnum = false;
        PropertyRefCollection pfc = qfi.getPropertyRefs();
        PropertyRefInfo pri = pfc.get(0);
        PropertyInfo pi = pri.getRefProperty();
        if (pi instanceof OwnPropertyInfo && (opi = (OwnPropertyInfo)pi).getDataType().equals((Object)DataType.ENUM)) {
            isEnum = true;
        }
        return isEnum;
    }

    public static void clearCells(KDTable kdt, int rowIndex, String[] colNames) {
        IRow row = kdt.getRow(rowIndex);
        if (colNames != null) {
            int n = colNames.length;
            for (int i = 0; i < n; ++i) {
                ICell cell = row.getCell(colNames[i]);
                cell.setValue(null);
            }
        } else {
            int n = kdt.getColumnCount();
            for (int i = 0; i < n; ++i) {
                ICell cell = row.getCell(i);
                cell.setValue(null);
            }
        }
    }

    public static String[] getSelectRowFieldValue(KDTable kdtTable, String fieldname) {
        if (!KDTableUtil.isSelectRow(kdtTable)) {
            return null;
        }
        KDTSelectManager sm = kdtTable.getSelectManager();
        int blockCount = sm.size();
        int keyField = kdtTable.getColumnIndex(fieldname);
        ArrayList<String> retList = new ArrayList<String>();
        Object value = null;
        for (int i = 0; i < blockCount; ++i) {
            KDTSelectBlock block = sm.get(i);
            int bottom = block.getBottom();
            for (int j = block.getTop(); j <= bottom; ++j) {
                IRow row = kdtTable.getRow(j);
                value = row.getCell(keyField).getValue();
                if (value == null || value.toString().trim().length() == 0) continue;
                String retStr = value.toString();
                retList.add(retStr);
            }
        }
        retList.trimToSize();
        if (retList.size() == 0) {
            return null;
        }
        String[] retStrs = new String[retList.size()];
        retStrs = retList.toArray(retStrs);
        return retStrs;
    }

    public static boolean isSelectRow(KDTable kdtTable) {
        KDTSelectManager sm = kdtTable.getSelectManager();
        return sm.size() > 0;
    }
}

