/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.master.material.AsstAttrBasicTypeFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrBasicTypeInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrCompondingTypeDetailCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrCompondingTypeDetailFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrCompondingTypeInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrException;
import com.kingdee.eas.basedata.master.material.AsstAttrValueCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IAsstAttrBasicType;
import com.kingdee.eas.basedata.master.material.IAsstAttrCompondingTypeDetail;
import com.kingdee.eas.basedata.master.material.IAsstAttrValue;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.app.AbstractAsstAttrValueControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class AsstAttrValueControllerBean
extends AbstractAsstAttrValueControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.material.app.AsstAttrValueControllerBean");

    private void checkNameBlank(IObjectValue model) throws BOSException, EASBizException {
        String name = model.get("name").toString();
        if (name == null || name.trim().equals("")) {
            throw new DataBaseException(DataBaseException.NAMENOTNULL);
        }
    }

    private void checkNumberBlank(IObjectValue model) throws BOSException, EASBizException {
        String number = model.get("number").toString();
        if (number == null || number.trim().equals("")) {
            throw new DataBaseException(DataBaseException.NUMBERNOTNULL);
        }
    }

    private void checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AsstAttrValueInfo info = (AsstAttrValueInfo)model;
        String name = info.getName();
        String id = info.getId().toString();
        String basicTypeId = null;
        String comTypeId = null;
        if (info.getBasictype() != null) {
            basicTypeId = info.getBasictype().getId().toString();
        } else {
            comTypeId = info.getCompondingtype().getId().toString();
        }
        Connection cn = this.getConnection(ctx);
        String lang = ContextUtils.getContextFromSession().getLocale().toString();
        String sql = null;
        sql = basicTypeId != null ? "select Top 1 FID from T_BD_AsstAttrValue where FBasictypeID = '" + basicTypeId + "' and FName_" + lang + "='" + name + "'and FID <> '" + id + "'" : "select Top 1 FID from T_BD_AsstAttrValue where FCompondingtypeID = '" + comTypeId + "' and FName_" + lang + "='" + name + "'and FID <> '" + id + "'";
        RowSet rs = null;
        try {
            rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
            if (rs.next()) {
                throw new AsstAttrException(AsstAttrException.VALUE_EXSISTS);
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        catch (EASBizException e2) {
            throw e2;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AsstAttrValueInfo info = (AsstAttrValueInfo)model;
        String number = info.getNumber();
        String id = info.getId().toString();
        String basicTypeId = null;
        String comTypeId = null;
        if (info.getBasictype() != null) {
            basicTypeId = info.getBasictype().getId().toString();
        } else {
            comTypeId = info.getCompondingtype().getId().toString();
        }
        String sql = null;
        Connection cn = this.getConnection(ctx);
        sql = basicTypeId != null ? "select Top 1 FID from T_BD_AsstAttrValue where FBasictypeID = '" + basicTypeId + "' and FNumber='" + number + "'and FID <> '" + id + "'" : "select Top 1 FID from T_BD_AsstAttrValue where FCompondingtypeID = '" + comTypeId + "' and FNumber='" + number + "'and FID <> '" + id + "'";
        RowSet rs = null;
        try {
            rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
            if (rs.next()) {
                throw new AsstAttrException(AsstAttrException.VALUE_EXSISTS);
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        catch (EASBizException e2) {
            throw e2;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkNameAndNumber(ctx, model);
        super._submit(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNameAndNumber(ctx, model);
        return super._submit(ctx, model);
    }

    private void checkNameAndNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNameBlank(model);
        this.checkNumberBlank(model);
    }

    private String getMappingField(Context ctx, AsstAttrValueInfo info) throws BOSException, EASBizException {
        IAsstAttrBasicType iBasic = AsstAttrBasicTypeFactory.getLocalInstance(ctx);
        return iBasic.getAsstAttrBasicTypeInfo((IObjectPK)new ObjectUuidPK(info.getBasictype().getId())).getMappingField().toString();
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        super._canDelete(ctx, pk, cn);
    }

    @Override
    public void cancel(Context ctx, IObjectPK pk, AsstAttrValueInfo model) throws BOSException, EASBizException {
        if (pk == null || pk.toString().length() < 1) {
            throw new MaterialBaseException(MaterialBaseException.ASST_NOT_SAVE_CAN_NOT_CANCEL_CANCEL);
        }
        AsstAttrValueInfo info = (AsstAttrValueInfo)this.getValue(ctx, pk);
        if (info != null) {
            info.setDeletedStatus(DeletedStatusEnum.DELETED);
            this._update(ctx, pk, (IObjectValue)info);
        }
    }

    @Override
    public void cancelCancel(Context ctx, IObjectPK pk, AsstAttrValueInfo model) throws BOSException, EASBizException {
        if (pk == null || pk.toString().length() < 1) {
            throw new MaterialBaseException(MaterialBaseException.ASST_NOT_SAVE_CAN_NOT_CANCEL_CANCEL);
        }
        AsstAttrValueInfo info = (AsstAttrValueInfo)this.getValue(ctx, pk);
        if (info != null) {
            info.setDeletedStatus(DeletedStatusEnum.NORMAL);
            this._update(ctx, pk, (IObjectValue)info);
        }
    }

    public String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return "";
        }
        String retValue = pk.toString();
        AsstAttrValueInfo info = (AsstAttrValueInfo)this.getValue(ctx, pk);
        if (info != null && info.getNumber() != null && info.getName() != null) {
            retValue = info.getNumber() + "  " + info.getName();
        }
        return retValue;
    }

    protected boolean isRefByCompoundingValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AsstAttrValueInfo info = this.getAsstAttrValueInfo(ctx, pk);
        IAsstAttrBasicType iBasicType = AsstAttrBasicTypeFactory.getLocalInstance(ctx);
        AsstAttrBasicTypeInfo basicInfo = iBasicType.getAsstAttrBasicTypeInfo((IObjectPK)new ObjectUuidPK(info.getBasictype().getId()));
        String mappingField = basicInfo.getMappingField();
        IAsstAttrCompondingTypeDetail iDetail = AsstAttrCompondingTypeDetailFactory.getLocalInstance(ctx);
        IAsstAttrValue iValue = AsstAttrValueFactory.getLocalInstance(ctx);
        AsstAttrCompondingTypeDetailCollection details = iDetail.getAsstAttrCompondingTypeDetailCollection("where basictype='" + basicInfo.getId() + "'");
        for (int i = 0; i < details.size(); ++i) {
            AsstAttrCompondingTypeInfo compInfo = details.get(i).getCompondingtype();
            AsstAttrValueCollection valueInfos = iValue.getAsstAttrValueCollection("where compondingtype='" + compInfo.getId().toString() + "'");
            for (int j = 0; j < valueInfos.size(); ++j) {
                AsstAttrValueInfo valueInfo = valueInfos.get(j);
                if (valueInfo.getString(mappingField) == null || !valueInfo.getString(mappingField).equals(pk.toString())) continue;
                return true;
            }
        }
        return false;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (this.getAsstAtrrValueType(ctx, pk) == 1 && this.isRefByCompoundingValue(ctx, pk)) {
            throw new AsstAttrException(AsstAttrException.CAN_NOT_DELETE_BASICTYPE);
        }
        this.innerDelete(ctx, pk);
    }

    protected int getAsstAtrrValueType(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        AsstAttrValueInfo info = this.getAsstAttrValueInfo(ctx, pk);
        if (info.getBasictype() != null) {
            return 1;
        }
        return 2;
    }
}

