/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.app.CopyAssistTask;
import com.kingdee.eas.basedata.master.material.app.CopyInvTask;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class CopyPlanTask
extends CopyAssistTask {
    private Logger logger = Logger.getLogger(CopyInvTask.class);
    private final CtrlUnitCollection centralizedPurchasingCUColl;
    private final Context ctx;
    private final String orginalMaterialID;
    private final String[] matIds;
    private final Connection conn;

    public CopyPlanTask(Context ctx, CtrlUnitCollection centralizedPurchasingCUColl, String orginalMaterialID, String[] matIds, Connection conn) {
        super(ctx, centralizedPurchasingCUColl, orginalMaterialID, matIds, conn);
        this.centralizedPurchasingCUColl = centralizedPurchasingCUColl;
        this.ctx = ctx;
        this.orginalMaterialID = orginalMaterialID;
        this.matIds = matIds;
        this.conn = conn;
    }

    @Override
    public Void call() throws Exception {
        return null;
    }

    private MaterialPlanCollection getCPmatPlanInfo(Context ctx, String originalMatId, CtrlUnitInfo CPCUInfo) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)CPCUInfo.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)originalMatId, CompareType.EQUALS));
        ev.setFilter(filter);
        ev.getSelector().add("id");
        ev.getSelector().add("orgunit.*");
        ev.getSelector().add("CU.id");
        MaterialPlanCollection matPlan = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(ev);
        return matPlan;
    }

    public void batchCopyPlanInfo(Context ctx, String templetMatId, FullOrgUnitInfo sourceOrgUnitInfo, FullOrgUnitInfo targetOrgUnitInfo, Connection conn, String[] idsToDealWithAssist) throws BOSException, EASBizException {
        if (!targetOrgUnitInfo.isIsStorageOrgUnit()) {
            return;
        }
        PreparedStatement stmt = null;
        String srcOrgUnitId = sourceOrgUnitInfo.getId().toString();
        String destCuid = targetOrgUnitInfo.getCU().getId().toString();
        String destOugUnitId = targetOrgUnitInfo.getId().toString();
        StorageOrgUnitInfo targetOrgUnit = this.getStorageUnitInfo(ctx, targetOrgUnitInfo);
        SQLUtil sb = new SQLUtil();
        sb.appendSql("insert into T_BD_MaterialPlan ");
        sb.appendSql(" (FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FStatus,FOrgUnit,FFreezeOrgUnit,FMaterialID,FMaterialAttr,FPlanStrategy,FManufactureStrategyID,FMaterialChar,FProductUnitID,FIsDemandAssign ,FIsMaxBatchMethod,FMaxBatchQty,FIsMinBatchMethod,FMinBatchQty,FIsRoundUpMultiple,FRoundUpMultipleQty,FIsBatchIncMethod,FBatchIncQty,FProduceLeadTime,FRecevingLeadTime,FSupplyOrgUnit ,FYield,FScrapRate,FScrapRateExpression,FOffsetMode,FForwardDaysOffset,FBackwardDaysOffset,FIsProductLinePlan,FIsQuotaControl,FInteval,FOutputType,FDutyDepartment,FIsBackFlush,FLLC,FForwardProcessTime,FBackwardProcessTime,FIssMode,FIssLeadTime,FLeadTimeType,FProvideType,FRCVDispersionBase,FRPTInHightLimit,FRPTInLowLimit,FRCVInHightLimit,FRCVInLowLimit,FISSInHightLimit,FISSInLowLimit,FBatchPolicy,FFixationBatchQty,FConsumeSpeed,FReBookQty,FPlanningMode,FEffectedStatus,FIsStockAllot,FFromInvOrgID,FFromWarehouseID,FIsCentralizedPar,FIsConfigable,FRemainTimeNoPlan,FTransferBatch,FBatchCycle,FPartitionType,FPartitionDays)  ");
        sb.appendSql(" select newbosid('C463FD06') FID , FCreatorID, now() FCreateTime,  FLastUpdateUserID,  now() FLastUpdateTime, '" + destCuid + "'  FControlUnitID,1 FStatus,  '" + destOugUnitId + "' FOrgUnit,null FFreezeOrgUnit,?,FMaterialAttr,FPlanStrategy,FManufactureStrategyID,FMaterialChar,FProductUnitID,FIsDemandAssign ,FIsMaxBatchMethod,FMaxBatchQty,FIsMinBatchMethod,FMinBatchQty,FIsRoundUpMultiple,FRoundUpMultipleQty,FIsBatchIncMethod,FBatchIncQty,FProduceLeadTime,FRecevingLeadTime,case FProvideType when " + String.valueOf(10910) + " then '" + destOugUnitId + "' else FSupplyOrgUnit end,FYield,FScrapRate,FScrapRateExpression,FOffsetMode,FForwardDaysOffset,FBackwardDaysOffset,FIsProductLinePlan,FIsQuotaControl,FInteval,FOutputType,null,FIsBackFlush,FLLC,FForwardProcessTime,FBackwardProcessTime,FIssMode,FIssLeadTime,FLeadTimeType,FProvideType,FRCVDispersionBase,FRPTInHightLimit,FRPTInLowLimit,FRCVInHightLimit,FRCVInLowLimit,FISSInHightLimit,FISSInLowLimit,FBatchPolicy,FFixationBatchQty,FConsumeSpeed,FReBookQty,FPlanningMode,FEffectedStatus,FIsStockAllot,FFromInvOrgID,FFromWarehouseID,FIsCentralizedPar,FIsConfigable,FRemainTimeNoPlan,FTransferBatch,FBatchCycle,FPartitionType,FPartitionDays ");
        sb.appendSql(" from T_BD_MATERIALPLAN mc  where  mc.FStatus=1  ");
        sb.appendSql(" and mc.FMaterialID  = '" + templetMatId + "' ");
        sb.appendSql(" and mc.FOrgUnit='" + srcOrgUnitId + "'  ");
        if (targetOrgUnit != null && !targetOrgUnit.isIsBizUnit()) {
            sb.appendSql(" and mc.FProvideType <> " + String.valueOf(10910));
        }
        sb.appendSql(" and not exists (select 1 from T_BD_MaterialPlan where FMaterialID = ? and FOrgUnit  = '" + destOugUnitId + "' )");
        try {
            stmt = conn.prepareStatement(sb.getSql());
            for (int i = 0; i < idsToDealWithAssist.length; ++i) {
                stmt.setString(1, idsToDealWithAssist[i]);
                stmt.setString(2, idsToDealWithAssist[i]);
                stmt.addBatch(sb.getSql());
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
    }

    private StorageOrgUnitInfo getStorageUnitInfo(Context ctx, FullOrgUnitInfo targetOrgUnitInfo) throws BOSException, EASBizException {
        IStorageOrgUnit istorageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
        StorageOrgUnitInfo storageUnitInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)targetOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        StorageOrgUnitCollection storageOrgUnitColl = istorageOrgUnit.getStorageOrgUnitCollection(view);
        if (storageOrgUnitColl != null && storageOrgUnitColl.size() > 0) {
            storageUnitInfo = storageOrgUnitColl.get(0);
        }
        return storageUnitInfo;
    }
}

