/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.master.material.MaterialProfitCenterInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialProfitCenterInfoFactory;
import com.kingdee.eas.basedata.master.material.app.CopyAssistTask;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class CopyProfitTask
extends CopyAssistTask {
    private Logger logger = Logger.getLogger(CopyProfitTask.class);
    private final CtrlUnitCollection centralizedPurchasingCUColl;
    private final Context ctx;
    private final String orginalMaterialID;
    private final String[] matIds;
    private final Connection conn;

    public CopyProfitTask(Context ctx, CtrlUnitCollection centralizedPurchasingCUColl, String orginalMaterialID, String[] matIds, Connection conn) {
        super(ctx, centralizedPurchasingCUColl, orginalMaterialID, matIds, conn);
        this.centralizedPurchasingCUColl = centralizedPurchasingCUColl;
        this.ctx = ctx;
        this.orginalMaterialID = orginalMaterialID;
        this.matIds = matIds;
        this.conn = conn;
    }

    @Override
    public Void call() throws Exception {
        CtrlUnitInfo threadCPCUInfo = null;
        MaterialProfitCenterInfoCollection matProColl = new MaterialProfitCenterInfoCollection();
        IFullOrgUnit ifullOrgCP = FullOrgUnitFactory.getLocalInstance((Context)this.ctx);
        FullOrgUnitInfo cpouInfo = null;
        String CPMaterialTempleateID = null;
        for (int i = 0; i < this.centralizedPurchasingCUColl.size(); ++i) {
            threadCPCUInfo = this.centralizedPurchasingCUColl.get(i);
            matProColl.addCollection(this.getCPmatProficenterInfo(this.ctx, this.orginalMaterialID, threadCPCUInfo));
        }
        for (int j = 0; j < matProColl.size(); ++j) {
            CPMaterialTempleateID = matProColl.get(j).getMaterial().getId().toString();
            cpouInfo = ifullOrgCP.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(matProColl.get(j).getProfitCenter().getId()));
            this.logger.error((Object)("\u6b63\u5728\u904d\u5386\u7b2c " + j + " \u4e2a\u96c6\u91c7CU\u7ec4\u7ec7,\u5206\u914d\u5229\u6da6\u4e2d\u5fc3\u8d44\u6599 CPOU\u4e3a " + cpouInfo.getId().toString() + "\n"));
            this.batchCopyProficenterInfo(this.ctx, CPMaterialTempleateID, cpouInfo, cpouInfo, this.conn, this.matIds);
        }
        return null;
    }

    private MaterialProfitCenterInfoCollection getCPmatProficenterInfo(Context ctx, String originalMatId, CtrlUnitInfo CPCUInfo) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)CPCUInfo.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)originalMatId, CompareType.EQUALS));
        ev.setFilter(filter);
        ev.getSelector().add("id");
        ev.getSelector().add("proficenter.*");
        ev.getSelector().add("CU.id");
        MaterialProfitCenterInfoCollection matProCenter = MaterialProfitCenterInfoFactory.getLocalInstance(ctx).getMaterialProfitCenterInfoCollection(ev);
        return matProCenter;
    }

    private void batchCopyProficenterInfo(Context ctx, String templetMatId, FullOrgUnitInfo sourceOrgUnitInfo, FullOrgUnitInfo targetOrgUnitInfo, Connection conn, String[] idsToDealWithAssist) throws BOSException, EASBizException {
        if (!targetOrgUnitInfo.isIsProfitOrgUnit()) {
            return;
        }
        PreparedStatement stmt = null;
        String srcOrgUnitId = sourceOrgUnitInfo.getId().toString();
        String destCuid = targetOrgUnitInfo.getCU().getId().toString();
        String destOugUnitId = targetOrgUnitInfo.getId().toString();
        SQLUtil sb = new SQLUtil();
        sb.appendSql("insert into T_BD_MaterialProfitCenterInfo ");
        sb.appendSql(" (FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FStatus,FProfitCenterID, FFreezeOrgUnitID,FMaterialID,FAccountType,FIsLot,FIsAssistProperty,FIsProject,FIsTrackNumber) ");
        sb.appendSql(" select newbosid('B91D1664') FID ,  FCreatorID, now() FCreateTime,  FLastUpdateUserID,  now() FLastUpdateTime, '" + destCuid + "'  FControlUnitID,1 FStatus,  '" + destOugUnitId + "' FProfitCenterID, FFreezeOrgUnitID, ? ,FAccountType,FIsLot,FIsAssistProperty,FIsProject,FIsTrackNumber");
        sb.appendSql(" from T_BD_MaterialProfitCenterInfo mpc  where  mpc.FStatus=1  ");
        sb.appendSql(" and mpc.FMaterialID = '" + templetMatId + "' ");
        sb.appendSql(" and mpc.FProfitCenterID='" + srcOrgUnitId + "'  ");
        sb.appendSql(" and not exists (select 1 from T_BD_MaterialProfitCenterInfo where FMaterialID = ? and FProfitCenterID  = '" + destOugUnitId + "' )");
        try {
            stmt = conn.prepareStatement(sb.getSql());
            for (int i = 0; i < idsToDealWithAssist.length; ++i) {
                stmt.setString(1, idsToDealWithAssist[i]);
                stmt.setString(2, idsToDealWithAssist[i]);
                stmt.addBatch(sb.getSql());
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
    }
}

