/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.AbstractMulDataTransmission;
import com.kingdee.eas.basedata.master.material.AsstAttrValueCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IAsstAttrValue;
import com.kingdee.eas.basedata.master.material.IMaterialAsstAttrValue;
import com.kingdee.eas.basedata.master.material.MaterialAsstAttrValueCollection;
import com.kingdee.eas.basedata.master.material.MaterialAsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.MaterialAsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DataImportMaterialAsstAttr
extends AbstractMulDataTransmission {
    private static final String VALUE_COLLECTION = "MaterialAsstAttrValueCollection";
    private static final String VALUE_COLLECTION_OLD = "oldCollection";
    private Set PerminsionCheckedCuIds = new HashSet();
    Map cacheAssignCU = new HashMap();
    Map cacheMaterial = new HashMap();
    Map cacheAsstAttrValue = new HashMap();

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            ctx.put((Object)"isImport", (Object)"true");
            MaterialInfo materialInfo = (MaterialInfo)coreBaseInfo;
            CoreBaseCollection collection = (CoreBaseCollection)materialInfo.get(VALUE_COLLECTION);
            IMaterialAsstAttrValue iBiz = MaterialAsstAttrValueFactory.getLocalInstance(ctx);
            if (this.isSltImportUpdate()) {
                iBiz.removeByMaterial(materialInfo.getId());
                iBiz.addnew(collection);
            } else {
                iBiz.addnew(collection);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MaterialAsstAttrValueFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected CoreBaseInfo createHead(Hashtable hsData, Context ctx) throws Exception {
        String tempString = null;
        tempString = (String)((DataToken)hsData.get((Object)"FMaterialNumber")).data;
        if (tempString == null || tempString.trim().length() == 0) {
            throw new MaterialBaseException(MaterialBaseException.NUMBER_NOT_NULL);
        }
        MaterialInfo materialInfo = this.getMaterialByNumber(ctx, tempString);
        if (materialInfo == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.basedata.master.material.MATERIALAutoGenerateResource", (String)"0_DataImportMaterialAsstAttr", (Locale)ctx.getLocale()));
        }
        if (materialInfo.getAssistAttr() == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.basedata.master.material.MATERIALAutoGenerateResource", (String)"1_DataImportMaterialAsstAttr", (Locale)ctx.getLocale()));
        }
        CtrlUnitInfo cu = null;
        if (this.getContextParameter() != null) {
            cu = (CtrlUnitInfo)this.getContextParameter().get("cu");
        }
        if (cu == null) {
            cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        }
        String cuId = cu.getId().toString();
        if (!materialInfo.getCU().getId().equals((Object)cu.getId())) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"maintainCU_Check", (Locale)ctx.getOriginLocale()));
        }
        if (!this.PerminsionCheckedCuIds.contains(cuId)) {
            try {
                PerminsionUtil.checkCUPerminsion(ctx, cuId, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), "bd_material_asstAttrValue");
            }
            catch (EASBizException ee) {
                throw new TaskExternalException(ee.getMessage(), (Throwable)ee);
            }
            this.PerminsionCheckedCuIds.add(cuId);
        }
        CoreBaseCollection collection = new CoreBaseCollection();
        materialInfo.put(VALUE_COLLECTION, collection);
        return materialInfo;
    }

    private boolean isMaterialAssignToCU(Context ctx, String materialId, String cuId) throws BOSException {
        if (materialId == null || cuId == null) {
            return false;
        }
        String key = materialId + "&&" + cuId;
        Boolean result = (Boolean)this.cacheAssignCU.get(key);
        if (result == null) {
            boolean isAssigned = DataImportTools.isMaterialAssignForOrg(ctx, materialId, cuId);
            result = isAssigned;
            this.cacheAssignCU.put(key, result);
        }
        return result;
    }

    protected void createEntry(CoreBaseInfo head, Hashtable hsData, Context ctx) throws Exception {
        MaterialInfo materialInfo = (MaterialInfo)head;
        String tempString = null;
        tempString = (String)((DataToken)hsData.get((Object)"FAsstAttrValue")).data;
        if (tempString == null || tempString.trim().length() == 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.basedata.master.material.MATERIALAutoGenerateResource", (String)"2_DataImportMaterialAsstAttr", (Locale)ctx.getLocale()));
        }
        AsstAttrValueInfo asstAttrValueInfo = this.getAsstAttrValue(ctx, materialInfo.getAssistAttr().getId().toString(), tempString);
        if (asstAttrValueInfo == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.basedata.master.material.MATERIALAutoGenerateResource", (String)"3_DataImportMaterialAsstAttr", (Locale)ctx.getLocale()) + tempString);
        }
        if (asstAttrValueInfo.getDeletedStatus() == DeletedStatusEnum.DELETED) {
            String pattern = ResourceBase.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"AttrValueDisabled", (Locale)ctx.getOriginLocale());
            throw new TaskExternalException(MessageFormat.format(pattern, asstAttrValueInfo.getNumber()));
        }
        MaterialAsstAttrValueInfo info = new MaterialAsstAttrValueInfo();
        info.setMaterial(materialInfo);
        info.setValue(asstAttrValueInfo);
        CoreBaseCollection valueCollection = (CoreBaseCollection)materialInfo.get(VALUE_COLLECTION);
        if (this.isSltImportUpdate()) {
            if (!this.isInCollection(info, valueCollection)) {
                valueCollection.add((CoreBaseInfo)info);
            }
        } else {
            IMaterialAsstAttrValue iBiz = MaterialAsstAttrValueFactory.getLocalInstance(ctx);
            MaterialAsstAttrValueCollection oldValueCollection = iBiz.getCollectionByMaterial(materialInfo.getId().toString());
            if (!this.isInCollection(info, valueCollection) && !this.isInCollection(info, oldValueCollection)) {
                valueCollection.add((CoreBaseInfo)info);
            }
        }
    }

    private boolean isInCollection(MaterialAsstAttrValueInfo info, MaterialAsstAttrValueCollection valueCollection) {
        if (valueCollection == null) {
            return false;
        }
        for (int i = 0; i < valueCollection.size(); ++i) {
            MaterialAsstAttrValueInfo tempInfo = valueCollection.get(i);
            if (!tempInfo.getMaterial().getId().equals((Object)info.getMaterial().getId()) || !tempInfo.getValue().getId().equals((Object)info.getValue().getId())) continue;
            return true;
        }
        return false;
    }

    private boolean isInCollection(MaterialAsstAttrValueInfo info, CoreBaseCollection valueCollection) {
        if (valueCollection == null) {
            return false;
        }
        for (int i = 0; i < valueCollection.size(); ++i) {
            MaterialAsstAttrValueInfo tempInfo = (MaterialAsstAttrValueInfo)valueCollection.get(i);
            if (!tempInfo.getMaterial().getId().equals((Object)info.getMaterial().getId()) || !tempInfo.getValue().getId().equals((Object)info.getValue().getId())) continue;
            return true;
        }
        return false;
    }

    private MaterialInfo getMaterialByNumber(Context ctx, String number) throws Exception {
        Object result = this.cacheMaterial.get(number);
        if (result == null) {
            result = DataImportTools.getMaterialInfo(ctx, number);
            this.cacheMaterial.put(number, result);
        }
        return (MaterialInfo)result;
    }

    private AsstAttrValueInfo getAsstAttrValue(Context ctx, String typeId, String number) throws Exception {
        IAsstAttrValue iBiz;
        AsstAttrValueCollection collection;
        Object result = this.cacheMaterial.get(typeId + number);
        if (result == null && (collection = (iBiz = AsstAttrValueFactory.getLocalInstance(ctx)).getAsstAttrValueCollection("where number = '" + number + "' and (basictype='" + typeId + "' or compondingtype='" + typeId + "')")) != null && collection.size() > 0) {
            result = collection.get(0);
            this.cacheAsstAttrValue.put(typeId + number, result);
        }
        return (AsstAttrValueInfo)result;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FMaterialNumber", rs.getString("number"));
            this.putTable(result, "FMaterialName", rs.getString("name"));
            this.putTable(result, "FAsstAttrValue", rs.getString("asstAttrValue.number"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable(htable, key, value);
    }

    public String getMainField() {
        return "FMaterialNumber";
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.material.app.DataImpExpAsstAttrQuery";
    }
}

