/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.MaterialGroupCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;

public class DataImportMaterialGroup
extends AbstractDataTransmission {
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MaterialGroupFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String str = null;
        MaterialGroupInfo info = new MaterialGroupInfo();
        str = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        if (str == null || "".equals(str)) {
            throw new TaskExternalException(DataImportTools.getResString("com.kingdee.eas.basedata.master.material.MaterialResource", "NUMBER_NOT_NULL", ctx.getOriginLocale()));
        }
        info.setNumber(str);
        info.setGroupStandard(DataImportTools.getMaterialGroupStandard(ctx, this.getDataString(hsData, "FGroupStandard")));
        str = this.getDataString(hsData, "Fname_" + "l2".toUpperCase());
        info.setName(str, new Locale("l2"));
        str = this.getDataString(hsData, "Fname_" + "l3".toUpperCase());
        info.setName(str, new Locale("l3"));
        str = this.getDataString(hsData, "Fname_" + "l1".toUpperCase());
        info.setName(str, new Locale("l1"));
        str = this.getDataString(hsData, "FDescription_" + "l2".toUpperCase());
        info.setDescription(str, new Locale("l2"));
        str = this.getDataString(hsData, "FDescription_" + "l3".toUpperCase());
        info.setDescription(str, new Locale("l3"));
        str = this.getDataString(hsData, "FDescription_" + "l1".toUpperCase());
        info.setDescription(str, new Locale("l1"));
        FilterInfo filter = new FilterInfo();
        DataImportTools.AddFilterItemInfo(filter, "number", this.getDataString(hsData, "FNumber"));
        DataImportTools.AddFilterItemInfo(filter, "groupStandard", info.getGroupStandard().getId().toString());
        String oldLongNumber = null;
        if (this.isSltImportUpdate()) {
            try {
                IMaterialGroup iGroup = MaterialGroupFactory.getLocalInstance(ctx);
                MaterialGroupCollection groupCollection = iGroup.getMaterialGroupCollection(DataImportTools.getViewInfo(filter));
                if (groupCollection != null && groupCollection.size() > 0) {
                    info.setId(groupCollection.get(0).getId());
                    oldLongNumber = groupCollection.get(0).getLongNumber();
                }
            }
            catch (BOSException e) {
                throw new TaskExternalException("", (Throwable)e);
            }
        }
        if ((str = this.getDataString(hsData, "FParentId")) != null && !"".equals(str)) {
            StringBuffer oql = new StringBuffer(50);
            oql.append("where number='").append(str).append("'");
            if (info.getGroupStandard() != null && info.getGroupStandard().getId() != null) {
                oql.append(" and groupStandard.id='").append(info.getGroupStandard().getId().toString()).append("'");
            }
            MaterialGroupInfo parInfo = DataImportTools.getMaterialGroup(ctx, oql.toString());
            try {
                ICtrlUnit iCtrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
                CtrlUnitInfo currentCu = iCtrlUnit.getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()));
                CtrlUnitInfo parentCu = iCtrlUnit.getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(parInfo.getCU().getId()));
                if (currentCu != null && parentCu != null && !currentCu.getLongNumber().contains(parentCu.getLongNumber())) {
                    throw new TaskExternalException(DataImportTools.getResString("com.kingdee.eas.basedata.master.material.MaterialResource", "DataImport_GroupParent_Error", ctx.getOriginLocale()));
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
                throw new TaskExternalException(e.getMessage());
            }
            catch (EASBizException e) {
                e.printStackTrace();
                throw new TaskExternalException(e.getMessage());
            }
            if (parInfo == null) throw new TaskExternalException(DataImportTools.getResString("com.kingdee.eas.basedata.master.material.MaterialResource", "DataImport_GroupParent_Error", ctx.getOriginLocale()));
            if (info.getId() != null) {
                if (parInfo.getId().equals((Object)info.getId())) {
                    throw new TaskExternalException(new CustomerSupplierException(CustomerSupplierException.PARENT_IS_CHILFREN).getMessage(ctx.getOriginLocale()));
                }
                if (parInfo != null && parInfo.getLongNumber() != null && oldLongNumber != null && parInfo.getLongNumber().startsWith(oldLongNumber + "!")) {
                    throw new TaskExternalException(new CustomerSupplierException(CustomerSupplierException.PARENT_IS_CHILFREN).getMessage(ctx.getOriginLocale()));
                }
            }
            info.setParent(parInfo);
            info.setLevel(parInfo.getLevel() + 1);
            return info;
        }
        info.setParent(null);
        return info;
    }

    private String getDataString(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataString(hsData, fieldName);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            String multiName = "Fname_" + DataImportTools.getLoc(ctx);
            String multiDescription = "FDescription_" + DataImportTools.getLoc(ctx);
            DataImportTools.putToHashtable(result, "FNumber", rs.getString("number"));
            DataImportTools.putToHashtable(result, multiName, rs.getString("name"));
            DataImportTools.putToHashtable(result, "FGroupStandard", rs.getString("groupStandard.number"));
            DataImportTools.putToHashtable(result, multiDescription, rs.getString("description"));
            DataImportTools.putToHashtable(result, "FParentId", rs.getString("parent.number"));
            DataImportTools.putToHashtable(result, "FCreatorNumber", rs.getString("creator.number"));
            DataImportTools.putToHashtable(result, "FCreateTime", DataImportUtils.getDateStrByLocale((Context)ctx, (Date)rs.getDate("createTime")));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getLongNumber());
        return filterInfoCU;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.material.app.ExpMaterialGroupQuery";
    }
}

