/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Hashtable;
import java.util.Locale;

public class DataImportMaterialGroupStandard
extends AbstractDataTransmission {
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MaterialGroupStandardFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String str = null;
        MaterialGroupStandardInfo info = new MaterialGroupStandardInfo();
        str = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        if (str == null || "".equals(str)) {
            throw new TaskExternalException(DataImportTools.getResString("com.kingdee.eas.basedata.master.material.MaterialResource", "NUMBER_NOT_NULL", ctx.getLocale()));
        }
        info.setNumber(str);
        str = this.getDataString(hsData, "Fname_" + "l2".toUpperCase());
        info.setName(str, new Locale("l2"));
        str = this.getDataString(hsData, "Fname_" + "l3".toUpperCase());
        info.setName(str, new Locale("l3"));
        str = this.getDataString(hsData, "Fname_" + "l1".toUpperCase());
        info.setName(str, new Locale("l1"));
        str = this.getDataString(hsData, "FDescription_" + "l2".toUpperCase());
        info.setDescription(str, new Locale("l2"));
        str = this.getDataString(hsData, "FDescription_" + "l3".toUpperCase());
        info.setDescription(str, new Locale("l3"));
        str = this.getDataString(hsData, "FDescription_" + "l1".toUpperCase());
        info.setDescription(str, new Locale("l1"));
        MaterialGroupStandardTypeEnum standardType = DataImportTools.getMaterialGroupStandardEnum(this.getDataString(hsData, "FStandardType"), ctx);
        if (standardType.equals((Object)MaterialGroupStandardTypeEnum.BasicStandard)) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"CannotIMPortBasicGroupStandard", (Context)ctx));
        }
        info.setStandardType(standardType);
        FilterInfo filter = new FilterInfo();
        DataImportTools.AddFilterItemInfo(filter, "number", this.getDataString(hsData, "FNumber"));
        filter.setMaskString("#0");
        if (this.isSltImportUpdate()) {
            try {
                IMaterialGroupStandard iGroupStandard = MaterialGroupStandardFactory.getLocalInstance(ctx);
                MaterialGroupStandardCollection standardCollection = iGroupStandard.getMaterialGroupStandardCollection(DataImportTools.getViewInfo(filter));
                if (standardCollection == null || standardCollection.size() <= 0) return info;
                info.setId(standardCollection.get(0).getId());
                return info;
            }
            catch (BOSException e) {
                throw new TaskExternalException("", (Throwable)e);
            }
        } else {
            MaterialGroupStandardInfo groupStandardInfo;
            if (!MaterialGroupStandardTypeEnum.NetOrderType.equals((Object)standardType) || (groupStandardInfo = this.getGroupStandardInfoByType(ctx, String.valueOf(2))) == null) return info;
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"CannotIMPortNetOrderType", (Context)ctx));
        }
    }

    private MaterialGroupStandardInfo getGroupStandardInfoByType(Context ctx, String type) throws TaskExternalException {
        MaterialGroupStandardInfo groupStandardInfo = null;
        FilterInfo filter = new FilterInfo();
        DataImportTools.AddFilterItemInfo(filter, "standardType", type);
        filter.setMaskString("#0");
        try {
            IMaterialGroupStandard iGroupStandard = MaterialGroupStandardFactory.getLocalInstance(ctx);
            MaterialGroupStandardCollection standardCollection = iGroupStandard.getMaterialGroupStandardCollection(DataImportTools.getViewInfo(filter));
            if (standardCollection != null && standardCollection.size() > 0) {
                groupStandardInfo = standardCollection.get(0);
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return groupStandardInfo;
    }

    private String getDataString(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataString(hsData, fieldName);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            String multiName = "Fname_" + DataImportTools.getLoc(ctx);
            String multiDescription = "FDescription_" + DataImportTools.getLoc(ctx);
            DataImportTools.putToHashtable(result, "FNumber", rs.getString("number"));
            DataImportTools.putToHashtable(result, multiName, rs.getString("name"));
            DataImportTools.putToHashtable(result, multiDescription, rs.getString("description"));
            DataImportTools.putToHashtable(result, "FStandardType", MaterialGroupStandardTypeEnum.getEnum(rs.getInt("standardType")).getAlias(ctx.getLocale()));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getLongNumber());
        return filterInfoCU;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.material.app.ExpMaterialStandardQuery";
    }
}

