/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.AbstractMulDataTransmission;
import com.kingdee.eas.basedata.assistant.MeasureUnitException;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MeasureUnitTypeEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DataImportMulMeasureUnit
extends AbstractMulDataTransmission {
    private static final String MUL_MEASURE_UNIT_COLLECTION = "MultiMeasureUnitCollection";
    private Set PerminsionCheckedCuIds = new HashSet();
    Map cacheMaterial = new HashMap();
    Map cacheMeasureUnit = new HashMap();

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            ctx.put((Object)"isImport", (Object)"true");
            MaterialInfo materialInfo = (MaterialInfo)coreBaseInfo;
            MultiMeasureUnitCollection newCollection = (MultiMeasureUnitCollection)((Object)materialInfo.get(MUL_MEASURE_UNIT_COLLECTION));
            IMultiMeasureUnit iBiz = MultiMeasureUnitFactory.getLocalInstance(ctx);
            MultiMeasureUnitCollection oldCollection = iBiz.getDataByMaterial(materialInfo.getId().toString());
            MultiMeasureUnitCollection saveCollection = new MultiMeasureUnitCollection();
            saveCollection.addCollection(oldCollection);
            for (int i = 0; i < newCollection.size(); ++i) {
                MultiMeasureUnitInfo newInfo = newCollection.get(i);
                int pos = this.isInCollection(newInfo.getMeasureUnit(), oldCollection);
                if (pos < 0) {
                    saveCollection.add(newInfo);
                    continue;
                }
                if (this.isSltImportUpdate()) {
                    MultiMeasureUnitInfo oldInfo = oldCollection.get(pos);
                    newInfo.setId(oldInfo.getId());
                    newInfo.setMeasureUnitType(oldInfo.getMeasureUnitType());
                    if (oldInfo.isIsBasicUnit()) {
                        newInfo.setIsBasicUnit(true);
                        newInfo.setBaseConvsRate(oldInfo.getBaseConvsRate());
                        newInfo.setIsUseConvsUnit(oldInfo.isIsUseConvsUnit());
                        newInfo.setConvsUnit(oldInfo.getConvsUnit());
                    }
                    saveCollection.set(pos, newInfo);
                    continue;
                }
                throw new MaterialBaseException(MaterialBaseException.EXSISTSMEASUREUNIT, new Object[]{newInfo.getMaterial().getNumber(), newInfo.getMeasureUnit().getNumber()});
            }
            iBiz.saveDataByMaterial(saveCollection);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MultiMeasureUnitFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected CoreBaseInfo createHead(Hashtable hsData, Context ctx) throws Exception {
        String tempString = null;
        tempString = (String)((DataToken)hsData.get((Object)"FMaterialNumber")).data;
        if (tempString == null || tempString.trim().length() == 0) {
            throw new MaterialBaseException(MaterialBaseException.NUMBER_NOT_NULL);
        }
        MaterialInfo materialInfo = this.getMaterialByNumber(ctx, tempString);
        CtrlUnitInfo cu = null;
        if (this.getContextParameter() != null) {
            cu = (CtrlUnitInfo)this.getContextParameter().get("cu");
        }
        if (cu == null) {
            cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        }
        String cuId = cu.getId().toString();
        if (!materialInfo.getCU().getId().equals((Object)cu.getId())) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"maintainCU_Check", (Locale)ctx.getOriginLocale()));
        }
        if (!this.PerminsionCheckedCuIds.contains(cuId)) {
            try {
                PerminsionUtil.checkCUPerminsion(ctx, cuId, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), "bd_material_update");
            }
            catch (EASBizException ee) {
                throw new TaskExternalException(ee.getMessage(), (Throwable)ee);
            }
            this.PerminsionCheckedCuIds.add(cuId);
        }
        MultiMeasureUnitCollection collection = new MultiMeasureUnitCollection();
        materialInfo.put(MUL_MEASURE_UNIT_COLLECTION, (Object)collection);
        return materialInfo;
    }

    protected void createEntry(CoreBaseInfo head, Hashtable hsData, Context ctx) throws Exception {
        int pos;
        MaterialInfo materialInfo = (MaterialInfo)head;
        String tempString = null;
        tempString = (String)((DataToken)hsData.get((Object)"FMeasureUnitNumber")).data;
        if (tempString == null || tempString.trim().length() == 0) {
            throw new MeasureUnitException(MeasureUnitException.NUMBER_NOT_NULL);
        }
        MeasureUnitInfo measureUnitInfo = this.getMeasureUnit(ctx, tempString);
        if (measureUnitInfo.isIsDisabled()) {
            String pattern = ResourceBase.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"UnitDisabled", (Locale)ctx.getOriginLocale());
            throw new TaskExternalException(MessageFormat.format(pattern, measureUnitInfo.getNumber()));
        }
        MultiMeasureUnitInfo info = new MultiMeasureUnitInfo();
        MultiMeasureUnitCollection collection = (MultiMeasureUnitCollection)((Object)materialInfo.get(MUL_MEASURE_UNIT_COLLECTION));
        info.setMaterial(materialInfo);
        info.setMeasureUnit(measureUnitInfo);
        info.setQtyPrecision(DataImportTools.getDataint(hsData, "FQtyPrecision"));
        if (info.getQtyPrecision() < 0 || info.getQtyPrecision() > 8) {
            throw new MaterialBaseException(MaterialBaseException.PRECISIONLESSTHANZERO, new Object[]{measureUnitInfo.getNumber()});
        }
        info.setBaseConvsRate(DataImportTools.getDataBigDecimal(hsData, "FBaseConvsRate"));
        info.setIsUseConvsUnit(DataImportTools.getDataboolean(hsData, "FIsUseConvsUnit"));
        info.setIsStatUnit(DataImportTools.getDataboolean(hsData, "FIsStatUnit"));
        info.setMeasureUnitType(MeasureUnitTypeEnum.COMMON);
        tempString = (String)((DataToken)hsData.get((Object)"FConvsUnitNumber")).data;
        if (tempString != null && tempString.trim().length() > 0) {
            MeasureUnitInfo convsUnitInfo = this.getMeasureUnit(ctx, tempString);
            info.setConvsUnit(convsUnitInfo);
        }
        if ((pos = this.isInCollection(measureUnitInfo, collection)) < 0) {
            collection.add(info);
        } else {
            collection.set(pos, info);
        }
    }

    private int isInCollection(MeasureUnitInfo info, MultiMeasureUnitCollection collection) {
        if (collection == null) {
            return -1;
        }
        for (int i = 0; i < collection.size(); ++i) {
            MeasureUnitInfo tempInfo = collection.get(i).getMeasureUnit();
            if (!tempInfo.getId().equals((Object)info.getId())) continue;
            return i;
        }
        return -1;
    }

    private MaterialInfo getMaterialByNumber(Context ctx, String number) throws Exception {
        Object result = this.cacheMaterial.get(number);
        if (result == null) {
            result = DataImportTools.getMaterialInfo(ctx, number);
            this.cacheMaterial.put(number, result);
        }
        return (MaterialInfo)result;
    }

    private MeasureUnitInfo getMeasureUnit(Context ctx, String number) throws Exception {
        Object result = this.cacheMeasureUnit.get(number);
        if (result == null) {
            result = DataImportTools.getMeasureUnitInfo(ctx, number);
            this.cacheMeasureUnit.put(number, result);
        }
        return (MeasureUnitInfo)result;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FMaterialNumber", rs.getString("number"));
            this.putTable(result, "FMaterialName", rs.getString("name"));
            this.putTable(result, "FMeasureUnitNumber", rs.getString("measureUnit.number"));
            this.putTable(result, "FQtyPrecision", rs.getString("multiMeasureUnit.qtyPrecision"));
            this.putTable(result, "FBaseConvsRate", rs.getString("multiMeasureUnit.baseConvsRate"));
            this.putTable(result, "FIsUseConvsUnit", rs.getString("multiMeasureUnit.isUseConvsUnit"));
            this.putTable(result, "FConvsUnitNumber", rs.getString("convsUnit.number"));
            this.putTable(result, "FIsStatUnit", rs.getString("multiMeasureUnit.isStatUnit"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable(htable, key, value);
    }

    public String getMainField() {
        return "FMaterialNumber";
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.material.app.DataImpExpMulMeasureUnitQuery";
    }
}

