/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.framework.app.Assign2ImpBase;
import com.kingdee.eas.basedata.framework.app.ParallelSqlExecutor;
import com.kingdee.eas.basedata.master.material.MaterialAssitDataEnum;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class MaterialAssign2Imp
extends Assign2ImpBase {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.material.app.MaterialAssign2Imp");
    private static final String MATERIAL_KACLASSTYPE_ID = "7ac99937-00fb-1000-e000-0002c0a81345B999CA39";

    public int batchAssign2Part(Context ctx, String srcOrgId, Set tarOrgIds, String tblBD, Set assistData, int insertBDOneTime) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.createStatement();
            String viewBD = "(select top " + insertBDOneTime + " fid from " + tblBD + ")";
            String userId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
            FullOrgUnitInfo sourceOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(srcOrgId));
            StringBuffer inSql = new StringBuffer(100);
            for (Object oTarOrgId : tarOrgIds) {
                inSql.append(",'").append(oTarOrgId.toString()).append("'");
            }
            inSql.replace(0, 1, "");
            StringBuffer orgSql = new StringBuffer(200);
            orgSql.append("select Fid,FisCompanyOrgUnit,FIsSaleOrgUnit,FIsPurchaseOrgUnit,FIsStorageOrgUnit,FControlUnitId, FIsProfitOrgUnit");
            orgSql.append(" from t_org_baseunit where fid in (");
            orgSql.append(inSql.toString()).append(")");
            ResultSet rs = stmt.executeQuery(orgSql.toString());
            if (this.isParallel()) {
                ExecutorService pool = Executors.newFixedThreadPool(6);
                ParallelSqlExecutor pe = new ParallelSqlExecutor(pool);
                while (rs.next()) {
                    int fIsCompanyOrgUnit = rs.getInt("FisCompanyOrgUnit");
                    int fIsPurchaseOrgUnit = rs.getInt("FIsPurchaseOrgUnit");
                    int fIsSaleOrgUnit = rs.getInt("FIsSaleOrgUnit");
                    int fIsStorageOrgUnit = rs.getInt("FIsStorageOrgUnit");
                    int fIsProfitOrgUnit = rs.getInt("FIsProfitOrgUnit");
                    String destCuId = rs.getString("FControlUnitId");
                    String destOuId = rs.getString("FID");
                    BOSUuid.read((String)userId);
                    BOSUuid.read((String)destOuId);
                    BOSUuid.read((String)srcOrgId);
                    BOSUuid.read((String)destCuId);
                    if ((assistData == null || assistData.contains((Object)MaterialAssitDataEnum.COMPANY)) && fIsCompanyOrgUnit == 1) {
                        pe.getSqlList().add(this.getSQL4AssignCompany(ctx, userId, viewBD, destOuId, srcOrgId, destCuId));
                    }
                    if ((assistData == null || assistData.contains((Object)MaterialAssitDataEnum.PURCHASE)) && fIsPurchaseOrgUnit == 1) {
                        pe.getSqlList().add(this.getSQL4AssignPurchase(ctx, userId, viewBD, destOuId, srcOrgId, destCuId));
                    }
                    if ((assistData == null || assistData.contains((Object)MaterialAssitDataEnum.SALE)) && fIsSaleOrgUnit == 1) {
                        pe.getSqlList().add(this.getSQL4AssignSale(ctx, userId, viewBD, destOuId, srcOrgId, destCuId));
                    }
                    if ((assistData == null || assistData.contains((Object)MaterialAssitDataEnum.INVENTORY)) && fIsStorageOrgUnit == 1) {
                        pe.getSqlList().add(this.getSQL4AssignInventory(ctx, userId, viewBD, destOuId, srcOrgId, destCuId));
                    }
                    if ((assistData == null || assistData.contains((Object)MaterialAssitDataEnum.COST)) && fIsCompanyOrgUnit == 1) {
                        pe.getSqlList().add(this.getSQL4AssignCost(ctx, userId, viewBD, destOuId, srcOrgId, destCuId));
                    }
                    if ((assistData == null || assistData.contains((Object)MaterialAssitDataEnum.PLAN)) && fIsStorageOrgUnit == 1) {
                        pe.getSqlList().add(this.getSQL4AssignPlan(ctx, userId, viewBD, destOuId, srcOrgId, destCuId));
                    }
                    if ((assistData == null || assistData.contains((Object)MaterialAssitDataEnum.PROFITCENTER)) && fIsProfitOrgUnit == 1) {
                        pe.getSqlList().add(this.getSQL4AssignProfit(ctx, userId, viewBD, destOuId, srcOrgId, destCuId));
                    }
                    pe.executeUpdate(ctx);
                }
                pool.shutdown();
                if (pe.getErrorList().size() > 0) {
                    logger.error((Object)(pe.getErrorList().size() + " error occur!"));
                    logger.error((Object)((Exception)pe.getErrorList().get(0)));
                    throw new BOSException((Throwable)((Exception)pe.getErrorList().get(0)));
                }
            } else {
                while (rs.next()) {
                    int fIsCompanyOrgUnit = rs.getInt("FisCompanyOrgUnit");
                    int fIsPurchaseOrgUnit = rs.getInt("FIsPurchaseOrgUnit");
                    int fIsSaleOrgUnit = rs.getInt("FIsSaleOrgUnit");
                    int fIsStorageOrgUnit = rs.getInt("FIsStorageOrgUnit");
                    int fIsProfitOrgUnit = rs.getInt("FIsProfitOrgUnit");
                    String destOuId = rs.getString("FID");
                    String destCuId = rs.getString("FControlUnitId");
                    Statement stmt2 = cn.createStatement();
                    if ((assistData == null || assistData.contains((Object)MaterialAssitDataEnum.COMPANY)) && fIsCompanyOrgUnit == 1) {
                        stmt2.addBatch(this.getSQL4AssignCompany(ctx, userId, viewBD, destOuId, srcOrgId, destCuId));
                    }
                    if ((assistData == null || assistData.contains((Object)MaterialAssitDataEnum.PURCHASE)) && fIsPurchaseOrgUnit == 1) {
                        stmt2.addBatch(this.getSQL4AssignPurchase(ctx, userId, viewBD, destOuId, srcOrgId, destCuId));
                    }
                    if ((assistData == null || assistData.contains((Object)MaterialAssitDataEnum.SALE)) && fIsSaleOrgUnit == 1) {
                        stmt2.addBatch(this.getSQL4AssignSale(ctx, userId, viewBD, destOuId, srcOrgId, destCuId));
                    }
                    if ((assistData == null || assistData.contains((Object)MaterialAssitDataEnum.INVENTORY)) && fIsStorageOrgUnit == 1) {
                        stmt2.addBatch(this.getSQL4AssignInventory(ctx, userId, viewBD, destOuId, srcOrgId, destCuId));
                    }
                    if ((assistData == null || assistData.contains((Object)MaterialAssitDataEnum.COST)) && fIsCompanyOrgUnit == 1) {
                        stmt2.addBatch(this.getSQL4AssignCost(ctx, userId, viewBD, destOuId, srcOrgId, destCuId));
                    }
                    if ((assistData == null || assistData.contains((Object)MaterialAssitDataEnum.PLAN)) && fIsStorageOrgUnit == 1) {
                        stmt2.addBatch(this.getSQL4AssignPlan(ctx, userId, viewBD, destOuId, srcOrgId, destCuId));
                    }
                    if ((assistData == null || assistData.contains((Object)MaterialAssitDataEnum.PROFITCENTER)) && fIsProfitOrgUnit == 1) {
                        stmt2.addBatch(this.getSQL4AssignProfit(ctx, userId, viewBD, destOuId, srcOrgId, destCuId));
                    }
                    stmt2.executeBatch();
                }
            }
            this.deleteTop(ctx, tblBD, insertBDOneTime);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        return 0;
    }

    protected String getSQL4AssignCompany(Context ctx, String userId, String viewBD, String destOuId, String srcOuId, String destCuId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer(200);
        sb.append("insert into t_bd_materialcompanyinfo ");
        sb.append(" (FID,FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FMaterial, FMaterialID, FCompanyID,FKAClassID, FAccountType, FStandardCost, FEffectedStatus, FCalculateType, FFreezeOrgUnit, FStatus,FCreateCOByOrder,FIsLot,FIsAssistProperty,FIsProject,FIsTrackNumber)  ");
        sb.append(" select newbosid('D431F8BB') FID , '" + userId + "' FCreatorID, now() FCreateTime, '" + userId + "' FLastUpdateUserID,  now() FLastUpdateTime, '" + destCuId + "'  FControlUnitID, FMaterial, FMaterialID, '" + destOuId + "' FCompanyID," + this.getKAClassSql(ctx, destOuId) + "   FKAClassID,  FAccountType, FStandardCost, FEffectedStatus, FCalculateType, null FFreezeOrgUnit,1 FStatus,FCreateCOByOrder,FIsLot,FIsAssistProperty,FIsProject,FIsTrackNumber");
        sb.append(" from t_bd_materialcompanyinfo mc ");
        sb.append(" where  mc.FStatus=1  ");
        sb.append(" and mc.FMaterialID in " + viewBD);
        sb.append(" and mc.fcompanyid='" + srcOuId + "'  ");
        sb.append(" and not exists (select 1 from t_bd_materialcompanyinfo mc2 where mc2.fcompanyid='");
        sb.append(destOuId).append("' and mc.FMaterialID=mc2.fmaterialid)");
        return sb.toString();
    }

    protected String getSQL4AssignPurchase(Context ctx, String userId, String viewBD, String destOuId, String srcOuId, String destCuId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer(200);
        sb.append("insert into T_BD_MATERIALPURCHASING ");
        sb.append(" (FID,FIsNotControlTime, FIsNotControlQty,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FStatus,FOrgUnit,FFreezeOrgUnit,FMaterialID,FPurPerson,FSupplier,FProducingArea,FProduceFactory,FPurchaseStrategy,FUnitID,FPrice,FPriceTop,FReceiveTopRatio,FReceiveBottomRatio,FDaydAhead,FDaysDelay,FIsReturn,FAppointPurOrgUnit,FEffectedStatus,FPurchaseCheck,FPurGroup,FUseSupplyList,FUseSupplyPrice,FChangePriceProportion,FFineQualityFairPrice,FQuotaPolicyId,FMinDivisionQty,FQuotaPeriod)  ");
        sb.append(" select newbosid('0193BD9B') FID , FIsNotControlTime, FIsNotControlQty,'" + userId + "' FCreatorID, now() FCreateTime, '" + userId + "' FLastUpdateUserID,  now() FLastUpdateTime, '" + destCuId + "'  FControlUnitID,1 FStatus,  '" + destOuId + "' FOrgUnit,null FFreezeOrgUnit,FMaterialID, FPurPerson,FSupplier,FProducingArea,FProduceFactory,FPurchaseStrategy,FUnitID,FPrice,FPriceTop,FReceiveTopRatio,FReceiveBottomRatio,FDaydAhead,FDaysDelay,FIsReturn,null FAppointPurOrgUnit,FEffectedStatus,FPurchaseCheck,null FPurGroup,FUseSupplyList,FUseSupplyPrice,FChangePriceProportion,FFineQualityFairPrice,FQuotaPolicyId,FMinDivisionQty,FQuotaPeriod");
        sb.append(" from T_BD_MATERIALPURCHASING mc  where  mc.FStatus=1  ");
        sb.append(" and mc.FMaterialID in " + viewBD);
        sb.append(" and mc.FOrgUnit='" + srcOuId + "'  ");
        sb.append(" and not exists (select 1 from T_BD_MATERIALPURCHASING mc2 where mc2.FOrgUnit='");
        sb.append(destOuId).append("' and mc.FMaterialID=mc2.fmaterialid)");
        return sb.toString();
    }

    protected String getSQL4AssignSale(Context ctx, String userId, String viewBD, String destOuId, String srcOuId, String destCuId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer(200);
        sb.append("insert into T_BD_MATERIALSALES ");
        sb.append(" (FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FStatus,FOrgUnit,FFreezeOrgUnit,FMaterialID,FPrice,FIsReturn,FIsnotCheckOnReturn,FIsReceivByCheck,FUnitID,FIssueTopRatio,FIssueBottomRatio,FDaydAhead,FDaysDelay,FLowerQuantity,FTaxData,FTaxRate,FABCType,FEffectedStatus,FIsPurBySale,FCheapRate,FInnerPriceRate )  ");
        sb.append(" select newbosid('C84112CF') FID , '" + userId + "' FCreatorID, now() FCreateTime, '" + userId + "' FLastUpdateUserID,  now() FLastUpdateTime, '" + destCuId + "'  FControlUnitID,1 FStatus,  '" + destOuId + "' FOrgUnit,null FFreezeOrgUnit,FMaterialID, FPrice,FIsReturn,FIsnotCheckOnReturn,FIsReceivByCheck,FUnitID,FIssueTopRatio,FIssueBottomRatio,FDaydAhead,FDaysDelay,FLowerQuantity,FTaxData,FTaxRate,FABCType,FEffectedStatus,FIsPurBySale,FCheapRate,FInnerPriceRate");
        sb.append(" from T_BD_MATERIALSALES mc  where  mc.FStatus=1  ");
        sb.append(" and mc.FMaterialID in " + viewBD);
        sb.append(" and mc.FOrgUnit='" + srcOuId + "'  ");
        sb.append(" and not exists (select 1 from T_BD_MATERIALSALES mc2 where mc2.FOrgUnit='");
        sb.append(destOuId).append("' and mc.FMaterialID=mc2.fmaterialid)");
        return sb.toString();
    }

    protected String getSQL4AssignInventory(Context ctx, String userId, String viewBD, String destOuId, String srcOuId, String destCuId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer(200);
        sb.append("insert into T_BD_MATERIALINVENTORY ");
        sb.append(" (FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FStatus,FOrgUnit,FFreezeOrgUnit,FMaterialID,FIsControl,FQtySafety,FQtyMin,FQtyMax,FDaysBottom,FDaysTop,FDaysTurnover,FIsNegative,FIsBatchNo,FIsSequenceNo,FIsLotNumber,FIsBarcode,FQtyMinPackage,FABCType,FIsCompages,FIssuePriorityMode,FUnitID,FEffectedStatus,FIsPeriodValid,FPeriodValid,FPeriodValidUnit,FInWarehsAhead,FOutWarehsAhead,FPrepWarnAhead,FAheadUnit,FInvPlanner,FPlanningMode,FReBookQty,FConsumeSpeed,FPurchasingAheadDate,FBatchPolicy,FFixationBatchQty,FDefaultWarehouseID,FDaysPlanTurnover,FCheapRate )  ");
        sb.append(" select newbosid('557E499F') FID , '" + userId + "' FCreatorID, now() FCreateTime, '" + userId + "' FLastUpdateUserID,  now() FLastUpdateTime, '" + destCuId + "'  FControlUnitID,1 FStatus,  '" + destOuId + "' FOrgUnit,null FFreezeOrgUnit,FMaterialID, FIsControl,FQtySafety,FQtyMin,FQtyMax,FDaysBottom,FDaysTop,FDaysTurnover,FIsNegative,FIsBatchNo,FIsSequenceNo,FIsLotNumber,FIsBarcode,FQtyMinPackage,FABCType,FIsCompages,FIssuePriorityMode,FUnitID,FEffectedStatus,FIsPeriodValid,FPeriodValid,FPeriodValidUnit,FInWarehsAhead,FOutWarehsAhead,FPrepWarnAhead,FAheadUnit,FInvPlanner,FPlanningMode,FReBookQty,FConsumeSpeed,FPurchasingAheadDate,FBatchPolicy,FFixationBatchQty,null FDefaultWarehouseID,FDaysPlanTurnover,FCheapRate");
        sb.append(" from T_BD_MATERIALINVENTORY mc  where  mc.FStatus=1  ");
        sb.append(" and mc.FMaterialID in " + viewBD);
        sb.append(" and mc.FOrgUnit='" + srcOuId + "'  ");
        sb.append(" and not exists (select 1 from T_BD_MATERIALINVENTORY mc2 where mc2.FOrgUnit='");
        sb.append(destOuId).append("' and mc.FMaterialID=mc2.fmaterialid)");
        return sb.toString();
    }

    protected String getSQL4AssignCost(Context ctx, String userId, String viewBD, String destOuId, String srcOuId, String destCuId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer(200);
        sb.append("insert into T_BD_MATERIALCOST ");
        sb.append(" (FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FStatus,FOrgUnit,FFreezeOrgUnit,FMaterialID,FEffectedStatus,FStoreType,FIsCreateCostObject,FCostObejctGroupID,FIsParticipateReduct)  ");
        sb.append(" select newbosid('C45E21AA') FID , '" + userId + "' FCreatorID, now() FCreateTime, '" + userId + "' FLastUpdateUserID,  now() FLastUpdateTime, '" + destCuId + "'  FControlUnitID,1 FStatus,  '" + destOuId + "' FOrgUnit,null FFreezeOrgUnit,FMaterialID, FEffectedStatus,FStoreType,0 FIsCreateCostObject, null FCostObejctGroupID,FIsParticipateReduct");
        sb.append(" from T_BD_MATERIALCOST mc  where  mc.FStatus=1  ");
        sb.append(" and mc.FMaterialID in " + viewBD);
        sb.append(" and mc.FOrgUnit='" + srcOuId + "'  ");
        sb.append(" and not exists (select 1 from T_BD_MATERIALCOST mc2 where mc2.FOrgUnit='");
        sb.append(destOuId).append("' and mc.FMaterialID=mc2.fmaterialid)");
        return sb.toString();
    }

    protected String getSQL4AssignPlan(Context ctx, String userId, String viewBD, String destOuId, String srcOuId, String destCuId) throws EASBizException, BOSException {
        StorageOrgUnitInfo info = null;
        info = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(destOuId));
        boolean isBizUnit = info.isIsBizUnit();
        StringBuffer sb = new StringBuffer(200);
        sb.append("insert into T_BD_MaterialPlan ");
        sb.append(" (FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FStatus,FOrgUnit,FFreezeOrgUnit,FMaterialID,FMaterialAttr,FPlanStrategy,FManufactureStrategyID,FMaterialChar,FProductUnitID,FIsDemandAssign ,FIsMaxBatchMethod,FMaxBatchQty,FIsMinBatchMethod,FMinBatchQty,FIsRoundUpMultiple,FRoundUpMultipleQty,FIsBatchIncMethod,FBatchIncQty,FProduceLeadTime,FRecevingLeadTime,FSupplyOrgUnit ,FYield,FScrapRate,FScrapRateExpression,FOffsetMode,FForwardDaysOffset,FBackwardDaysOffset,FIsProductLinePlan,FIsQuotaControl,FInteval,FOutputType,FDutyDepartment,FIsBackFlush,FLLC,FForwardProcessTime,FBackwardProcessTime,FIssMode,FIssLeadTime,FLeadTimeType,FProvideType,FRCVDispersionBase,FRPTInHightLimit,FRPTInLowLimit,FRCVInHightLimit,FRCVInLowLimit,FISSInHightLimit,FISSInLowLimit,FBatchPolicy,FFixationBatchQty,FConsumeSpeed,FReBookQty,FPlanningMode,FEffectedStatus,FIsStockAllot,FFromInvOrgID,FFromWarehouseID,FIsCentralizedPar,FIsConfigable,FRemainTimeNoPlan,FTransferBatch,FBatchCycle,FPartitionType,FPartitionDays)  ");
        sb.append(" select newbosid('C463FD06') FID , '" + userId + "' FCreatorID, now() FCreateTime, '" + userId + "' FLastUpdateUserID,  now() FLastUpdateTime, '" + destCuId + "'  FControlUnitID,1 FStatus,  '" + destOuId + "' FOrgUnit,null FFreezeOrgUnit,FMaterialID,FMaterialAttr,FPlanStrategy,FManufactureStrategyID,FMaterialChar,FProductUnitID,FIsDemandAssign ,FIsMaxBatchMethod,FMaxBatchQty,FIsMinBatchMethod,FMinBatchQty,FIsRoundUpMultiple,FRoundUpMultipleQty,FIsBatchIncMethod,FBatchIncQty,FProduceLeadTime,FRecevingLeadTime,case FProvideType when " + String.valueOf(10910) + " then '" + destOuId + "' else FSupplyOrgUnit end,FYield,FScrapRate,FScrapRateExpression,FOffsetMode,FForwardDaysOffset,FBackwardDaysOffset,FIsProductLinePlan,FIsQuotaControl,FInteval,FOutputType,null,FIsBackFlush,FLLC,FForwardProcessTime,FBackwardProcessTime,FIssMode,FIssLeadTime,FLeadTimeType,FProvideType,FRCVDispersionBase,FRPTInHightLimit,FRPTInLowLimit,FRCVInHightLimit,FRCVInLowLimit,FISSInHightLimit,FISSInLowLimit,FBatchPolicy,FFixationBatchQty,FConsumeSpeed,FReBookQty,FPlanningMode,FEffectedStatus,FIsStockAllot,FFromInvOrgID,FFromWarehouseID,FIsCentralizedPar,FIsConfigable,FRemainTimeNoPlan,FTransferBatch,FBatchCycle,FPartitionType,FPartitionDays");
        sb.append(" from T_BD_MATERIALPLAN mc  where  mc.FStatus=1  ");
        sb.append(" and mc.FMaterialID in " + viewBD);
        sb.append(" and mc.FOrgUnit='" + srcOuId + "'  ");
        if (!isBizUnit) {
            sb.append(" and mc.FProvideType <> " + String.valueOf(10910));
        }
        sb.append(" and not exists (select 1 from T_BD_MaterialPlan mc2 where mc2.FOrgUnit='");
        sb.append(destOuId).append("' and mc.FMaterialID=mc2.fmaterialid)");
        return sb.toString();
    }

    protected String getSQL4AssignProfit(Context ctx, String userId, String viewBD, String destOuId, String srcOuId, String destCuId) throws EASBizException, BOSException {
        ProfitCenterOrgUnitInfo info = null;
        info = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(destOuId));
        boolean isBizUnit = info.isIsBizUnit();
        StringBuffer sb = new StringBuffer(200);
        sb.append("insert into T_BD_MaterialProfitCenterInfo ");
        sb.append(" (FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FStatus,FProfitCenterID, FFreezeOrgUnitID,FMaterialID,FAccountType,FKAClassID,FIsLot,FIsAssistProperty,FIsProject,FIsTrackNumber) ");
        sb.append(" select newbosid('B91D1664') FID , '" + userId + "' FCreatorID, now() FCreateTime, '" + userId + "' FLastUpdateUserID,  now() FLastUpdateTime, '" + destCuId + "'  FControlUnitID,1 FStatus,  '" + destOuId + "' FProfitCenterID, FFreezeOrgUnitID,FMaterialID,FAccountType,FKAClassID,FIsLot,FIsAssistProperty,FIsProject,FIsTrackNumber");
        sb.append(" from T_BD_MaterialProfitCenterInfo mpc  where  mpc.FStatus=1  ");
        sb.append(" and mpc.FMaterialID in " + viewBD);
        sb.append(" and mpc.FProfitCenterID='" + srcOuId + "'  ");
        sb.append(" and not exists (select 1 from T_BD_MaterialProfitCenterInfo mc2 where mc2.FProfitCenterID='");
        sb.append(destOuId).append("' and mc.FMaterialID=mc2.fmaterialid)");
        return sb.toString();
    }

    private String getKAClassSql(Context ctx, String destCompanyId) {
        String localeSuffix = ctx.getLocale().toString();
        StringBuffer kaSql = new StringBuffer();
        BOSUuid.read((String)destCompanyId);
        kaSql.append("\n ISNULL(").append("\n ISNULL(").append("\n (select TOP 1 KAClass.FID FID from T_BD_KAClassfication  as  KAClass").append("\n\t\tINNER JOIN T_BD_KAClassficationType AS KAClassType ON KAClassType.FID =  KAClass.FTypeLink ").append("\n\t\tINNER JOIN T_ORG_Company AS Company ON Company.FID =  KAClass.FCurrencyCompany ").append("\n\twhere  KAClass.FCurrencyCompany ='" + destCompanyId + "'").append("\n\t\tand KAClassType.FObjectTypeID='7ac99937-00fb-1000-e000-0002c0a81345B999CA39'").append("\n\t\tand KAClass.FAccountTableID=Company.FAccountTableID").append("\n\t\tand KAClass.FNumber=(select top 1 Fnumber from T_BD_KAClassfication where T_BD_KAClassfication.FID=mc.FKAClassID))").append("\n , ").append("\n (select TOP 1 KAClass.FID FID from T_BD_KAClassfication  as  KAClass").append("\n\t\tINNER JOIN T_BD_KAClassficationType AS KAClassType ON KAClassType.FID =  KAClass.FTypeLink ").append("\n\t\tINNER JOIN T_ORG_Company AS Company ON Company.FID =  KAClass.FCurrencyCompany ").append("\n\twhere  KAClass.FCurrencyCompany ='" + destCompanyId + "'").append("\n\t\tand KAClassType.FObjectTypeID='7ac99937-00fb-1000-e000-0002c0a81345B999CA39'").append("\n\t\tand KAClass.FAccountTableID=Company.FAccountTableID").append("\n\t\tand KAClass.FName_" + localeSuffix + "=(select top 1 FName_" + localeSuffix + " from T_BD_KAClassfication where T_BD_KAClassfication.FID=mc.FKAClassID))").append("\n  ), ").append("\n  (select TOP 1 KAClass.FID FID from T_BD_KAClassfication  as  KAClass").append("\n\t\tINNER JOIN T_BD_KAClassficationType AS KAClassType ON KAClassType.FID =  KAClass.FTypeLink ").append("\n\t\tINNER JOIN T_ORG_Company AS Company ON Company.FID =  KAClass.FCurrencyCompany ").append("\n\twhere  KAClass.FCurrencyCompany ='" + destCompanyId + "'").append("\n\t\tand KAClassType.FObjectTypeID='7ac99937-00fb-1000-e000-0002c0a81345B999CA39'").append("\n\t\tand KAClass.FAccountTableID=Company.FAccountTableID").append("\n \torder by KAClass.FLastUpdateTime desc )").append("\n )");
        return kaSql.toString();
    }

    boolean isParallel() {
        return true;
    }
}

