/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroup;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.app.AbstractMaterialBatchUpdateStrategy;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class MaterialBatchUpdateStrategy
extends AbstractMaterialBatchUpdateStrategy {
    private Logger logger = Logger.getLogger(MaterialBatchUpdateStrategy.class);

    @Override
    protected void validateBizLogic(Context ctx, IObjectPK pk, Map params) throws BOSException, EASBizException {
    }

    @Override
    protected void validate(Context ctx, Object[] pks, Map params) throws BOSException, EASBizException {
        if (this.properties == null || this.properties.length == 0 || pks.length == 0) {
            return;
        }
        String[] propertiesToCheck = new String[]{"shortName", "pictureNumber", "registeredmark", "warrantnumber"};
        this.checkLength(this.properties, propertiesToCheck, 80);
        HashSet<String> pkset = new HashSet<String>(0);
        for (int j = 0; j < pks.length; ++j) {
            String pk = (String)pks[j];
            pkset.add(pk.trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", pkset, CompareType.INCLUDE));
        view.setFilter(filter);
        IMaterial ie = MaterialFactory.getLocalInstance(ctx);
        MaterialCollection ls = ie.getMaterialCollection(view);
        if (ls != null && ls.size() != 0) {
            for (int i = 0; i < ls.size(); ++i) {
                MaterialInfo info = ls.get(i);
                MaterialInfo newInfo = (MaterialInfo)info.clone();
                this.setInfoNewValue((CoreBaseInfo)newInfo, this.values, this.properties, params);
                try {
                    ie.updateCheck((IObjectPK)new ObjectStringPK(info.getId().toString()), this.properties[0].toString(), info, newInfo);
                    this.uptIdList.add(info.getId().toString());
                    continue;
                }
                catch (Exception ex) {
                    MaterialBaseException mex = new MaterialBaseException(MaterialBaseException.MATERIAL_BATCH_FAILD, new String[]{info.getNumber()});
                    this.log.addException(mex.getMessage(), (Throwable)ex);
                }
            }
        }
        ls = null;
    }

    protected void checkLength(Object[] properties, String[] propertiesToCheck, int length) throws MaterialBaseException {
        if (this.isCheckLengthError(propertiesToCheck, length)) {
            throw new MaterialBaseException(MaterialBaseException.VALUETOOLARGE);
        }
    }

    @Override
    protected void executeUpdate(Context ctx) throws BOSException {
        if (!MaterialInfo.isAllowNonLeafGroup(ctx) && this.entity != null && this.properties != null && this.properties.length > 0 && "materialGroup".equalsIgnoreCase(this.properties[0].toString()) && "4409E7F0".equalsIgnoreCase(this.entity.getBosId()) && this.values != null && this.values instanceof Map && ((Map)this.values).get("materialGroup") != null) {
            String groupID = (String)((Map)this.values).get("materialGroup");
            MaterialGroupInfo group2 = null;
            try {
                group2 = new MaterialGroup().getMaterialGroupInfo((IObjectPK)new ObjectUuidPK(groupID));
            }
            catch (EASBizException e) {
                this.logger.error((Object)e);
            }
            if (group2 != null && !group2.isIsLeaf()) {
                try {
                    throw new MaterialBaseException(MaterialBaseException.NONLEAFADDNEW, new Object[]{" " + group2.getNumber() + " (" + group2.getName() + ") "});
                }
                catch (MaterialBaseException e) {
                    throw new BOSException((Throwable)((Object)e));
                }
            }
        }
        super.executeUpdate(ctx);
    }
}

