/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.app.AbstractMaterialBatchUpdateStrategy;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class MaterialCompanyBatchUpdateStrategy
extends AbstractMaterialBatchUpdateStrategy {
    @Override
    protected void validate(Context ctx, Object[] pks, Map params) throws BOSException, EASBizException {
        String unitId = this.getUnitId(params);
        if (StringUtils.isEmpty((String)unitId)) {
            throw new MaterialBaseException(MaterialBaseException.COMPANYORG_INVALID);
        }
        if (this.properties == null || this.properties.length == 0 || pks.length == 0) {
            return;
        }
        HashSet<String> pkset = new HashSet<String>(0);
        for (int j = 0; j < pks.length; ++j) {
            String pk = (String)pks[j];
            pkset.add(pk.trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mateial.id", pkset, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)unitId, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        IMaterialCompanyInfo ie = MaterialCompanyInfoFactory.getLocalInstance(ctx);
        view.getSelector().add("*");
        view.getSelector().add(new SelectorItemInfo("mateial.number"));
        view.getSelector().add(new SelectorItemInfo("mateial.name"));
        MaterialCompanyInfoCollection ls = ie.getMaterialCompanyInfoCollection(view);
        ArrayList<String> materialCom = new ArrayList<String>();
        for (int i = 0; i < ls.size(); ++i) {
            materialCom.add(ls.get(i).getMateial().getId().toString());
        }
        this._checkHasSubInfo(ctx, materialCom, pks, MaterialBaseException.MATERIAL_NO_SUCH_COMINFO);
        if (ls != null && ls.size() != 0) {
            Connection conn = null;
            Statement stmt = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                stmt = conn.createStatement();
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            for (int i = 0; i < ls.size(); ++i) {
                MaterialCompanyInfoInfo info = ls.get(i);
                this.setInfoNewValue((CoreBaseInfo)info, this.values, this.properties, params);
                try {
                    info.put("updateProperties", this.properties);
                    if ("accountType".equalsIgnoreCase(this.properties[0].toString()) && AccountType.SPECIAL_ACCT != info.getAccountType()) {
                        stmt.addBatch("update t_bd_materialcompanyinfo set FIslot=0,FIsAssistProperty=0,FIsProject=0,FIsTrackNumber=0 where fid ='" + info.getId().toString() + "'");
                    }
                    if ("calculateType".equalsIgnoreCase(this.properties[0].toString()) && CalculateTypeEnum.SELFMANUFACTURE != info.getCalculateType()) {
                        stmt.addBatch("update t_bd_materialcompanyinfo set FCreateCOByOrder=0 where fid ='" + info.getId().toString() + "'");
                    }
                    stmt.executeBatch();
                    ie.updateCheck((IObjectPK)new ObjectStringPK(info.getId().toString()), info);
                    this.uptIdList.add(info.getId().toString());
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    MaterialBaseException mex = new MaterialBaseException(MaterialBaseException.MATERIAL_BATCH_FAILD, new String[]{info.getMateial().getNumber()});
                    this.log.addException(mex.getMessage(), (Throwable)ex);
                }
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
        ls = null;
    }
}

