/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.master.material.app.AbstractMaterialBatchUpdateStrategy;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MaterialCompanySyncAssistStrategy
extends AbstractMaterialBatchUpdateStrategy {
    List orgIdList = null;

    @Override
    protected void validate(Context ctx, Object[] pks, Map params) throws BOSException, EASBizException {
        String unitId = this.getUnitId(params);
        if (StringUtils.isEmpty((String)unitId)) {
            throw new MaterialBaseException(MaterialBaseException.COMPANYORG_INVALID);
        }
        if (this.properties == null || this.properties.length == 0 || pks.length == 0) {
            return;
        }
        String materialPk = (String)pks[0];
        HashSet<String> unitPkSet = new HashSet<String>(0);
        this.orgIdList = (List)params.get("orgIdList");
        for (int i = 0; i < this.orgIdList.size(); ++i) {
            String pk = (String)this.orgIdList.get(i);
            unitPkSet.add(pk.trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)materialPk, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", unitPkSet, CompareType.INCLUDE));
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        IMaterialCompanyInfo ie = MaterialCompanyInfoFactory.getLocalInstance(ctx);
        view.getSelector().add("*");
        view.getSelector().add(new SelectorItemInfo("mateial.number"));
        view.getSelector().add(new SelectorItemInfo("mateial.name"));
        MaterialCompanyInfoCollection ls = ie.getMaterialCompanyInfoCollection(view);
        ArrayList<String> materialCom = new ArrayList<String>();
        for (int i = 0; i < ls.size(); ++i) {
            materialCom.add(ls.get(i).getMateial().getId().toString());
        }
        this._checkHasSubInfo(ctx, materialCom, pks, MaterialBaseException.MATERIAL_NO_SUCH_COMINFO);
        if (ls != null && ls.size() != 0) {
            Connection conn = null;
            Statement stmt = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                stmt = conn.createStatement();
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            for (int i = 0; i < ls.size(); ++i) {
                MaterialCompanyInfoInfo info = ls.get(i);
                this.setInfoNewValue((CoreBaseInfo)info, this.values, this.properties, params);
                try {
                    info.put("updateProperties", this.properties);
                    if ("accountType".equalsIgnoreCase(this.properties[0].toString()) && AccountType.SPECIAL_ACCT != info.getAccountType()) {
                        stmt.addBatch("update t_bd_materialcompanyinfo set FIslot=0,FIsAssistProperty=0,FIsProject=0,FIsTrackNumber=0 where fid ='" + info.getId().toString() + "'");
                    }
                    if ("calculateType".equalsIgnoreCase(this.properties[0].toString()) && CalculateTypeEnum.SELFMANUFACTURE != info.getCalculateType()) {
                        stmt.addBatch("update t_bd_materialcompanyinfo set FCreateCOByOrder=0 where fid ='" + info.getId().toString() + "'");
                    }
                    stmt.executeBatch();
                    this.uptIdList.add(info.getId().toString());
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    MaterialBaseException mex = new MaterialBaseException(MaterialBaseException.MATERIAL_BATCH_FAILD, new String[]{info.getMateial().getNumber()});
                    this.log.addException(mex.getMessage(), (Throwable)ex);
                }
            }
            this.log.setSuccessRecordCount(this.uptIdList.size());
            this.log.setFailRecordCount(this.orgIdList.size() - this.uptIdList.size());
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
        ls = null;
    }

    @Override
    protected void executeUpdate(Context ctx) throws BOSException {
        if (this.uptIdList == null) {
            return;
        }
        if (this.values == null || !(this.values instanceof Map)) {
            return;
        }
        if (this.entity == null) {
            return;
        }
        StringBuffer strSQL = new StringBuffer();
        if (this.properties != null && this.properties.length > 0 && "toolRate".equalsIgnoreCase(this.properties[0].toString()) && "557E499F".equalsIgnoreCase(this.entity.getBosId()) && "com.kingdee.eas.basedata.master.material.MaterialInventory".equalsIgnoreCase(this.entity.getClassId())) {
            strSQL.append("update t_bd_materialinventory ").append("set FToolRate = ").append("round(?,(select fpriceprecision from t_bd_material ").append("where fid = fmaterialid))");
        } else {
            strSQL.append(this.entity.createUpdateSQlCommand());
        }
        String tempSql = this.entity.createUpdateSQlCommand();
        Collection vs = ((Map)this.values).values();
        ArrayList<Object> ls = new ArrayList<Object>();
        ls.addAll(vs);
        int size = this.uptIdList.size();
        if (vs != null && size != 0) {
            strSQL.append(",flastupdateuserid='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',flastupdatetime=getdate() Where FID In(");
            StringBuffer preSQL = new StringBuffer();
            int avg = 1000;
            for (int i = 0; i < size; ++i) {
                preSQL.append("?,");
                ls.add(ls.size(), this.uptIdList.get(i).toString());
                if ((i + 1) % avg != 0) continue;
                preSQL.deleteCharAt(preSQL.length() - 1);
                preSQL.append(")");
                strSQL.append(preSQL.toString());
                super.execute(ctx, strSQL.toString(), ls.toArray());
                preSQL = new StringBuffer();
                strSQL = new StringBuffer();
                strSQL.append(this.entity.createUpdateSQlCommand());
                strSQL.append(",flastupdateuserid='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',flastupdatetime=getdate() Where FID In(");
                ls = new ArrayList();
                ls.addAll(vs);
            }
            if (ls.size() > 1) {
                preSQL.deleteCharAt(preSQL.length() - 1);
                preSQL.append(")");
                strSQL.append(preSQL.toString());
                super.execute(ctx, strSQL.toString(), ls.toArray());
            }
            if (tempSql.indexOf("FMaterialGroupID") != -1) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("standardType", (Object)MaterialGroupStandardTypeEnum.BasicStandard, CompareType.EQUALS));
                view.setFilter(filterInfo);
                IMaterialGroupStandard iGroupStand = MaterialGroupStandardFactory.getLocalInstance(ctx);
                MaterialGroupStandardCollection coll = iGroupStand.getMaterialGroupStandardCollection(view);
                String standardID = "";
                if (coll != null && coll.size() > 0) {
                    standardID = coll.get(0).getId().toString();
                    StringBuffer strBuffer = new StringBuffer();
                    strBuffer.append("update T_BD_MaterialGroupDetial set FMaterialGroupID = ? where FMaterialGroupStandardID = '");
                    strBuffer.append(standardID + "'");
                    strBuffer.append("and  FMaterialID in (");
                    for (int i = 0; i < size; ++i) {
                        if (i != 0) {
                            strBuffer.append(",");
                        }
                        strBuffer.append("?");
                    }
                    strBuffer.append(")");
                    super.execute(ctx, strBuffer.toString(), ls.toArray());
                }
            }
        }
        ORMValueCacheService.getInstance().discardType(ctx, this.entity.getBOSType());
    }
}

