/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.CostObjectAndMaterialSynchronousFacadeFactory;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialGroupCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupException;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.app.AbstractMaterialGroupControllerBean;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class MaterialGroupControllerBean
extends AbstractMaterialGroupControllerBean {
    private static final String MaterialResource = "com.kingdee.eas.basedata.master.material.MaterialResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.material.app.MaterialGroupControllerBean");

    protected void addAndUpdateCheck(Context ctx, MaterialGroupInfo info) throws BOSException, EASBizException {
        if (!MaterialInfo.isAllowNonLeafGroup(ctx)) {
            info.checkParentGroupMaterial(ctx);
        }
    }

    public IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaterialGroupInfo info = (MaterialGroupInfo)model;
        super._checkNumberBlank(ctx, (IObjectValue)info);
        this.checkNumberHasSpecialSym(info);
        super._checkNameBlank(ctx, (IObjectValue)info);
        this.addAndUpdateCheck(ctx, info);
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        info.setId(BOSUuid.read((String)pk.toString()));
        CostObjectAndMaterialSynchronousFacadeFactory.getLocalInstance((Context)ctx).addCostObjectGroupByMatTreeNode(info);
        return pk;
    }

    public void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        MaterialGroupInfo info = (MaterialGroupInfo)model;
        MaterialGroupInfo oldInfo = (MaterialGroupInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()));
        super._checkNameBlank(ctx, (IObjectValue)info);
        this.checkNumberHasSpecialSym(info);
        if (!info.getNumber().equals(oldInfo.getNumber()) || !info.getGroupStandard().getId().toString().equals(oldInfo.getGroupStandard().getId().toString())) {
            this._checkNumberDup(ctx, (IObjectValue)info);
        }
        super._checkNumberBlank(ctx, (IObjectValue)info);
        this.addAndUpdateCheck(ctx, info);
        this.checkGroupStandRef(ctx, info, oldInfo);
        ObjectUuidPK mpk = new ObjectUuidPK(info.getId().toString());
        super._update(ctx, (IObjectPK)mpk, (IObjectValue)info);
        this.updateGroupStandard(ctx, info, oldInfo);
        this.updateGroupParent(ctx, oldInfo);
        CostObjectAndMaterialSynchronousFacadeFactory.getLocalInstance((Context)ctx).moveCostObjectGroupByMatTreeNode(info);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaterialGroupInfo groupInfo = (MaterialGroupInfo)model;
        MaterialGroupInfo parent = groupInfo.getParent();
        String parentID = parent == null ? null : parent.getId().toString();
        String selfID = groupInfo.getId() == null ? null : groupInfo.getId().toString();
        String groupName = groupInfo.getName();
        String groupStandardId = groupInfo.getGroupStandard().getId().toString();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection ficEx = filter.getFilterItems();
        ficEx.add(new FilterItemInfo("name", (Object)groupName));
        ficEx.add(new FilterItemInfo("groupStandard.id", (Object)groupStandardId));
        ficEx.add(new FilterItemInfo("parent.id", (Object)parentID));
        ficEx.add(new FilterItemInfo("id", (Object)selfID, CompareType.NOTEQUALS));
        String currentCUID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String currentCULongNumber = ContextUtil.getCurrentCtrlUnit((Context)ctx).getLongNumber();
        FilterInfo s4Filter = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)currentCUID, (String)currentCULongNumber);
        FilterInfo childrenFilter = new FilterInfo();
        childrenFilter.getFilterItems().add(new FilterItemInfo("CU.longNumber", (Object)(currentCULongNumber + "!%"), CompareType.LIKE));
        s4Filter.mergeFilter(childrenFilter, "or");
        filter.mergeFilter(s4Filter, "and");
        if (super._exists(ctx, filter)) {
            String typeAndname = this._getPropertyAlias(ctx, (DataBaseInfo)groupInfo, "name") + groupInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{typeAndname});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
        MaterialGroupInfo matGrInfo = new MaterialGroupInfo();
        matGrInfo.setId(BOSUuid.read((String)pk.toString()));
        CostObjectAndMaterialSynchronousFacadeFactory.getLocalInstance((Context)ctx).deleteCostObjectGroupByMatTreeNode(matGrInfo);
    }

    protected void _deleteWithChildren(Context ctx, IObjectValue model) throws BOSException, EASBizException, TreeBaseException {
        super._deleteWithChildren(ctx, model);
    }

    private void checkNumberHasSpecialSym(MaterialGroupInfo info) throws MaterialGroupException {
        if (info.getNumber().indexOf(33) > -1) {
            throw new MaterialGroupException(MaterialGroupException.NUM_SPECIAL_SYM);
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaterialGroupInfo info = (MaterialGroupInfo)model;
        MaterialGroupStandardInfo mgsInfo = info.getGroupStandard();
        String groupNumber = info.getNumber();
        String groupStandardId = mgsInfo.getId().toString();
        IMaterialGroup iMaterialGroup = MaterialGroupFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer(50);
        oql.append("where number='").append(groupNumber.replaceAll("'", "''")).append("' and groupStandard.id='").append(groupStandardId).append("'");
        if (iMaterialGroup.exists(oql.toString())) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, (Object[])new String[]{groupNumber});
        }
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        MaterialGroupInfo info = (MaterialGroupInfo)model;
        if (info == null) {
            return null;
        }
        if (info.getCU() == null) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)super.getCU(ctx, (ObjectBaseInfo)info).getId().toString(), CompareType.EQUALS));
            return filter;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filerInfo = new FilterInfo();
        filerInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filerInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("CU.longNumber"));
        MaterialGroupCollection collection = null;
        try {
            collection = this.getMaterialGroupCollection(ctx, viewInfo);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (collection != null && collection.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("CU.longNumber", (Object)(collection.get(0).getCU().getLongNumber() + "%"), CompareType.LIKE));
        }
        if (info.getGroupStandard() != null) {
            filter.getFilterItems().add(new FilterItemInfo("groupStandard.id", (Object)info.getGroupStandard().getId()));
        }
        return filter;
    }

    @Override
    protected void _approve(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaterialGroupInfo materialGroupInfo = (MaterialGroupInfo)model;
        if (materialGroupInfo.getId() != null) {
            String longNumber = materialGroupInfo.getLongNumber();
            if (longNumber.indexOf("'") >= 0) {
                longNumber = longNumber.replaceAll("'", "''");
            }
            String[] nums = longNumber.split("!");
            StringBuffer param = new StringBuffer();
            for (int i = 0; i < nums.length; ++i) {
                if (i > 0) {
                    param.append(",");
                }
                param.append("'");
                param.append(nums[i]);
                param.append("'");
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("update T_BD_MaterialGroup ").append(" set FDeletedStatus = 1 ").append(" where FNumber in (").append(param.toString() + ")").append(" and FDeletedStatus = 2 ");
            buffer.append(" and FGroupStandard='").append(materialGroupInfo.getGroupStandard().getId().toString()).append("'");
            DbUtil.execute((Context)ctx, (String)buffer.toString());
            ORMValueCacheService.getInstance().discardType(ctx, this.getBOSType());
        }
    }

    @Override
    protected void _unapprove(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaterialGroupInfo materialGroupInfo = (MaterialGroupInfo)model;
        if (materialGroupInfo.getId() != null) {
            String longNumber = materialGroupInfo.getLongNumber();
            if (longNumber.indexOf("'") >= 0) {
                longNumber = longNumber.replaceAll("'", "''");
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("update T_BD_MaterialGroup ").append(" set FDeletedStatus = 2 ").append(" where ").append(" FLongNumber like ").append("'" + longNumber + "!%'");
            buffer.append(" or FLongNumber = '" + longNumber + "'");
            buffer.append(" and FGroupStandard='").append(materialGroupInfo.getGroupStandard().getId().toString()).append("'");
            DbUtil.execute((Context)ctx, (String)buffer.toString());
            ORMValueCacheService.getInstance().discardType(ctx, this.getBOSType());
        }
    }

    protected int getLongNumberLen(Context ctx, TreeBaseInfo info) throws EASBizException, BOSException {
        return 512;
    }

    protected void checkLNForTree(Context ctx, TreeBaseInfo treeBaseInfo) throws BOSException, EASBizException, TreeBaseException {
    }

    protected void checkGroupStandRef(Context ctx, MaterialGroupInfo info, MaterialGroupInfo oldInfo) throws BOSException, EASBizException {
        if (info == null || info.getId() == null) {
            return;
        }
        if (oldInfo == null) {
            oldInfo = (MaterialGroupInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
        }
        if (oldInfo == null || oldInfo.getGroupStandard() == null || oldInfo.getGroupStandard().getId() == null || info == null || info.getGroupStandard() == null || info.getGroupStandard().getId() == null) {
            return;
        }
        if (!oldInfo.getGroupStandard().getId().toString().equals(info.getGroupStandard().getId().toString())) {
            String longNumber = oldInfo.getLongNumber();
            if (longNumber.indexOf("'") >= 0) {
                longNumber = longNumber.replaceAll("'", "''");
            }
            StringBuffer sb = new StringBuffer();
            sb.append(" SELECT   a.fid ");
            sb.append("   FROM   T_BD_MaterialGroupDetial a, t_bd_materialgroup b ");
            sb.append("  WHERE       A.FMATERIALGROUPID = B.FID ");
            sb.append("          AND B.FGROUPSTANDARD = '" + oldInfo.getGroupStandard().getId().toString() + "' ");
            sb.append("          AND (B.FLONGNUMBER = '" + longNumber + "' OR B.FLONGNUMBER LIKE '" + longNumber + "!%') ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            try {
                if (rs != null && rs.next()) {
                    throw new MaterialBaseException(MaterialBaseException.CANNOTUPDATEGROUPSTAND);
                }
            }
            catch (SQLException e) {
                throw new MaterialBaseException(MaterialBaseException.CANNOTUPDATEGROUPSTAND);
            }
        }
    }

    protected void updateGroupStandard(Context ctx, MaterialGroupInfo info, MaterialGroupInfo oldInfo) throws BOSException, EASBizException {
        if (!oldInfo.getGroupStandard().getId().toString().equals(info.getGroupStandard().getId().toString())) {
            String longNumber = info.getLongNumber();
            if (longNumber.indexOf("'") >= 0) {
                longNumber = longNumber.replaceAll("'", "''");
            }
            StringBuffer sb = new StringBuffer();
            sb.append(" UPDATE   t_bd_materialgroup ");
            sb.append("    SET   fgroupstandard = '" + info.getGroupStandard().getId().toString() + "' ");
            sb.append("  WHERE   fgroupstandard = '" + oldInfo.getGroupStandard().getId().toString() + "' ");
            sb.append("      AND flongnumber LIKE '" + longNumber + "!%' ");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
    }

    protected void updateGroupParent(Context ctx, MaterialGroupInfo tempInfo) throws BOSException, EASBizException {
        TreeBaseCollection coll;
        MaterialGroupInfo groupInfo;
        if (tempInfo.getParent() != null && tempInfo.getParent().getId() != null && tempInfo.getParent().getId().toString().trim().length() > 0 && (groupInfo = (MaterialGroupInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(tempInfo.getParent().getId().toString()))) != null && groupInfo.getId() != null && (coll = this.getAllChildren(ctx, groupInfo)).size() <= 0) {
            groupInfo.setIsLeaf(true);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(groupInfo.getId()), (IObjectValue)groupInfo);
        }
    }

    @Override
    protected boolean _isGroupVisible(Context ctx, String CuTable, String datTab, String dataID) throws BOSException {
        return false;
    }

    @Override
    protected Map _getGroupCuInfo(Context ctx, String[] numbers) throws BOSException, EASBizException {
        HashMap<String, StringBuilder> groupCuInfoMap = new HashMap<String, StringBuilder>();
        if (numbers != null && numbers.length > 0) {
            String groupSql = null;
            Object groupCuSql = null;
            HashSet<String> fControlUnitIdSet = new HashSet<String>();
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            FullOrgUnitCollection fullOrgUnitCollection = null;
            StringBuilder cuTip = null;
            for (int i = 0; i < numbers.length; ++i) {
                groupSql = "SELECT FControlUnitId FROM T_BD_MaterialGroup where FLONGNUMBER like '" + numbers[i] + "!%';";
                IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)groupSql);
                try {
                    fControlUnitIdSet.clear();
                    while (rs1.next()) {
                        String fControlUnitId = rs1.getString("FControlUnitId");
                        fControlUnitIdSet.add(fControlUnitId);
                    }
                    if (fControlUnitIdSet.size() <= 0) continue;
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", fControlUnitIdSet, CompareType.INCLUDE));
                    ev.setFilter(filter);
                    ev.getSelector().add("*");
                    fullOrgUnitCollection = iFullOrgUnit.getFullOrgUnitCollection(ev);
                    cuTip = new StringBuilder();
                    if (fullOrgUnitCollection != null && fullOrgUnitCollection.size() > 0) {
                        for (int j = 0; j < fullOrgUnitCollection.size(); ++j) {
                            FullOrgUnitInfo fullOrgUnitInfo = fullOrgUnitCollection.get(j);
                            if (fullOrgUnitInfo == null) continue;
                            cuTip.append(fullOrgUnitInfo.getName()).append("(").append(fullOrgUnitInfo.getNumber()).append(")").append(",");
                        }
                        cuTip.deleteCharAt(cuTip.length() - 1);
                    }
                    groupCuInfoMap.put(numbers[i], cuTip);
                    continue;
                }
                catch (SQLException e) {
                    logger.error((Object)("MaterialGroup query error" + e));
                }
            }
        }
        return groupCuInfoMap;
    }

    @Override
    protected void _upgrade(Context ctx, IObjectPK dataPk, IObjectPK subCUPk, IObjectPK superCUPk) throws BOSException, EASBizException {
        DataBaseInfo dataInfo = (DataBaseInfo)this._getValue(ctx, dataPk);
        FullOrgUnitInfo subOu = new FullOrgUnitInfo();
        if (subCUPk != null) {
            subOu = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo(subCUPk);
        }
        FullOrgUnitInfo supOu = new FullOrgUnitInfo();
        if (superCUPk != null) {
            supOu = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo(superCUPk);
        }
        String logStr = ResourceBase.getString((String)MaterialResource, (String)"MaterialGroupMsg", (Locale)ctx.getOriginLocale()) + dataInfo.getNumber() + "    \n" + ResourceBase.getString((String)MaterialResource, (String)"SourceCu", (Locale)ctx.getOriginLocale()) + subOu.getNumber() + "    \n" + ResourceBase.getString((String)MaterialResource, (String)"AfterUpgradeCu", (Locale)ctx.getOriginLocale()) + supOu.getNumber();
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"_upgrade", (BOSObjectType)new MaterialInfo().getBOSType(), null, (String)logStr, (String)"bd_materialGroup_upgrade", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)ResourceBase.getString((String)MaterialResource, (String)"MaterialGroupUpgrade", (Locale)ctx.getOriginLocale()));
        CtrlUnitInfo CU = dataInfo.getCU();
        CtrlUnitInfo CUCopy = (CtrlUnitInfo)CU.clone();
        CUCopy.setId(BOSUuid.read((String)superCUPk.toString()));
        dataInfo.setCU(CUCopy);
        super._update(ctx, dataPk, (IObjectValue)dataInfo);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
    }

    protected void _moveTreeNode(Context ctx, IObjectValue sourceNode, IObjectValue targetNode) throws EASBizException, BOSException {
        MaterialGroupInfo sourceInfo = new MaterialGroupInfo();
        MaterialGroupInfo targetInfo = new MaterialGroupInfo();
        if (sourceNode != null && (TreeBaseInfo)sourceNode != null) {
            sourceInfo = this.getMaterialGroupInfo(ctx, (IObjectPK)new ObjectUuidPK(((TreeBaseInfo)sourceNode).getId()));
        }
        if (targetNode != null && (TreeBaseInfo)targetNode != null) {
            targetInfo = this.getMaterialGroupInfo(ctx, (IObjectPK)new ObjectUuidPK(((TreeBaseInfo)targetNode).getId()));
        }
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"_moveTreeNode", (BOSObjectType)new MaterialGroupInfo().getBOSType(), null, (String)(ResourceBase.getString((String)MaterialResource, (String)"SourceNode", (Locale)ctx.getOriginLocale()) + sourceInfo.getNumber() + "    \n" + ResourceBase.getString((String)MaterialResource, (String)"TatgetNode", (Locale)ctx.getOriginLocale()) + targetInfo.getNumber()), (String)"bd_materialGroup_moveTreeNode", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)ResourceBase.getString((String)MaterialResource, (String)"MaterialGroupMoveNode", (Locale)ctx.getOriginLocale()));
        super._moveTreeNode(ctx, sourceNode, targetNode);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
    }
}

