/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardException;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.master.material.app.AbstractMaterialGroupStandardControllerBean;
import com.kingdee.eas.common.EASBizException;
import org.apache.log4j.Logger;

public class MaterialGroupStandardControllerBean
extends AbstractMaterialGroupStandardControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.material.app.MaterialGroupStandardControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        if (((MaterialGroupStandardInfo)model).getName() == null || ((MaterialGroupStandardInfo)model).getName().trim().equals("")) {
            throw new MaterialGroupStandardException(MaterialGroupStandardException.STANDARDNAME_NOT_NULL);
        }
        this._checkNumberDup(ctx, model);
        this._checkNameDup(ctx, model);
        return super._submit(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        if (((MaterialGroupStandardInfo)model).getName() == null || ((MaterialGroupStandardInfo)model).getName().trim().equals("")) {
            throw new MaterialGroupStandardException(MaterialGroupStandardException.STANDARDNAME_NOT_NULL);
        }
        super._update(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        if (((MaterialGroupStandardInfo)model).getName() == null || ((MaterialGroupStandardInfo)model).getName().trim().equals("")) {
            throw new MaterialGroupStandardException(MaterialGroupStandardException.STANDARDNAME_NOT_NULL);
        }
        return super._addnew(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaterialGroupStandardInfo dataBaseInfo = (MaterialGroupStandardInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    @Override
    protected IObjectCollection _getBaseMaterialGroupStandardColl(Context ctx) throws BOSException {
        IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("standardType", (Object)MaterialGroupStandardTypeEnum.BasicStandard, CompareType.EQUALS));
        view.setFilter(filter);
        MaterialGroupStandardCollection coll = iMaterialGroupStandard.getMaterialGroupStandardCollection(view);
        return coll;
    }

    @Override
    protected IObjectCollection _getNetOrderTypeStandardColl(Context ctx, IObjectValue model) throws BOSException {
        IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("standardType", (Object)MaterialGroupStandardTypeEnum.NetOrderType, CompareType.EQUALS));
        if (model != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)((MaterialGroupStandardInfo)model).getId(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1");
        }
        view.setFilter(filter);
        MaterialGroupStandardCollection coll = iMaterialGroupStandard.getMaterialGroupStandardCollection(view);
        return coll;
    }
}

