/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.IMaterialProfitCenterInfo;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialProfitCenterInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialProfitCenterInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialProfitCenterInfoInfo;
import com.kingdee.eas.basedata.master.material.app.AbstractMaterialBatchUpdateStrategy;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MaterialProfitCenterSyncAssistStrategy
extends AbstractMaterialBatchUpdateStrategy {
    @Override
    protected void validate(Context ctx, Object[] pks, Map params) throws BOSException, EASBizException {
        int i;
        String unitId = this.getUnitId(params);
        if (StringUtils.isEmpty((CharSequence)unitId) || this.properties == null && this.properties.length == 0 && pks.length == 0) {
            return;
        }
        HashSet pkset = new HashSet();
        String materialPk = (String)pks[0];
        HashSet<String> unitPkSet = new HashSet<String>(0);
        List orgIdList = (List)params.get("orgIdList");
        for (int i2 = 0; i2 < orgIdList.size(); ++i2) {
            String orgPk = (String)orgIdList.get(i2);
            unitPkSet.add(orgPk.trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialPk, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("profitcenter.id", unitPkSet, CompareType.INCLUDE));
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        view.getSelector().add("*");
        view.getSelector().add(new SelectorItemInfo("material.number"));
        view.getSelector().add(new SelectorItemInfo("material.name"));
        IMaterialProfitCenterInfo ie = MaterialProfitCenterInfoFactory.getLocalInstance(ctx);
        MaterialProfitCenterInfoCollection ls = ie.getMaterialProfitCenterInfoCollection(view);
        if (ls == null) {
            return;
        }
        ArrayList<String> materialProfit = new ArrayList<String>();
        for (i = 0; i < ls.size(); ++i) {
            materialProfit.add(ls.get(i).getMaterial().getId().toString());
        }
        if (ls.size() != 0) {
            for (i = 0; i < ls.size(); ++i) {
                MaterialProfitCenterInfoInfo info = ls.get(i);
                this.setInfoNewValue((CoreBaseInfo)info, this.values, this.properties, params);
                try {
                    this.uptIdList.add(info.getId().toString());
                    continue;
                }
                catch (Exception ex) {
                    MaterialBaseException mex = new MaterialBaseException(MaterialBaseException.MATERIAL_BATCH_FAILD, new String[]{info.getMaterial().getNumber()});
                    this.log.addException(mex.getMessage(), (Throwable)ex);
                }
            }
        }
    }
}

