/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.BizHasDealException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.IBizHasDeal;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;

public class MaterialSelfBizHasDeal
implements IBizHasDeal {
    private static final String SQL_UNION_ALL = " UNION ALL ";
    private static BOSObjectType bosTypeMaterialMultiUnit = new MultiMeasureUnitInfo().getBOSType();
    private final String[] tableArray = new String[]{"T_BD_MaterialPurchasing", "T_BD_MaterialSales", "T_BD_MaterialInventory", "T_BD_MaterialPlan"};
    private final String[] uintFields = new String[]{"FUnitID", "FUnitID", "FUnitID", "FProductUnitID"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BizCheckResult checkHasDeal(Context ctx, BOSUuid id) throws BizHasDealException {
        if (id == null) {
            return new BizCheckResult(true, (EASBizException)((Object)new MaterialBaseException(MaterialBaseException.MATERIAL_IS_NULL)));
        }
        BizCheckResult bcr = new BizCheckResult(false);
        StringBuffer sql = null;
        if (!id.getType().equals((Object)bosTypeMaterialMultiUnit)) {
            return null;
        }
        sql = this.getMaterialSQLMultiUnit(ctx, id);
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            JdbcRowSet rs = (JdbcRowSet)SQLUtils.getJdbcRowSet((Connection)conn, (String)sql.toString());
            while (rs.next()) {
                HashMap<String, String> detailMap = new HashMap<String, String>();
                detailMap.put(rs.getString(1), rs.getString(2));
                bcr = new BizCheckResult(true, null, detailMap);
            }
        }
        catch (SQLException e) {
            bcr = new BizCheckResult(true, (EASBizException)((Object)new MaterialBaseException(MaterialBaseException.SQL_QUERY_ERROR)));
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return bcr;
    }

    protected StringBuffer getMaterialSQLMultiUnit(Context ctx, BOSUuid id) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT top 1 t1.FMaterialId").append(" ,T_BD_MeasureUnit.FName_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" FROM (").append("\t\n");
        for (int i = 0; i < this.tableArray.length; ++i) {
            if (i > 0) {
                sql.append("\t\n").append(SQL_UNION_ALL).append("\t\n");
            }
            sql.append(" SELECT Property.FMaterialId, MultiUnit.FMeasureUnitID ").append("FROM ").append(this.tableArray[i]).append(" Property ").append("INNER JOIN T_BD_MultiMeasureUnit MultiUnit ON ").append("Property.FMaterialId=MultiUnit.FMaterialId AND Property.").append(this.uintFields[i]).append("=MultiUnit.FMeasureUnitid ").append("WHERE MultiUnit.FID='").append(id.toString()).append("'");
        }
        sql.append(" ) t1 inner join T_BD_MeasureUnit");
        sql.append(" on t1.FMeasureUnitID = T_BD_MeasureUnit.fid");
        return sql;
    }
}

