/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.app.AbstractSyncAssignRelationFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SyncAssignRelationFacadeControllerBean
extends AbstractSyncAssignRelationFacadeControllerBean {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.material.app.SyncAssignRelationFacadeControllerBean");

    @Override
    protected void _syncAssign(Context ctx) throws BOSException {
        try {
            logger.error((Object)("start sync assign relation,time:" + System.currentTimeMillis()));
            String selectSql = "select top 1000 FDataBaseDID,FAssignCUID,FBOSObjectType,FStatus from T_BD_DataBaseAssign_In where FStatus=0 and FTryTimes<5 order by FBOSObjectType, FAssignCUID,FDataBaseDID,FCreateTime";
            Map<String, Map<String, Set<String>>> assignMap = SyncAssignRelationFacadeControllerBean.executeQueryAndFillDataToMap(ctx, selectSql);
            for (String bosType : assignMap.keySet()) {
                for (String cuId : assignMap.get(bosType).keySet()) {
                    SyncAssignRelationFacadeControllerBean.doAssign(ctx, bosType, cuId, assignMap.get(bosType).get(cuId));
                    this.updateSyncAssignSuccessStatus(ctx, bosType, cuId, assignMap.get(bosType).get(cuId));
                }
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
            throw new BOSException((Throwable)se);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _syncUnAssign(Context ctx) throws BOSException {
        try {
            logger.error((Object)("start sync un_assign relation,time:" + System.currentTimeMillis()));
            String selectSql = "select top 1000 FDataBaseDID,FAssignCUID,FBOSObjectType,FStatus from T_BD_DataBaseUnAssign_In where FStatus=0 and FTryTimes<5 order by FBOSObjectType, FAssignCUID,FDataBaseDID,FCreateTime";
            Map<String, Map<String, Set<String>>> unAssignMap = SyncAssignRelationFacadeControllerBean.executeQueryAndFillDataToMap(ctx, selectSql);
            HashMap<String, Map<String, Set<String>>> copyMap = new HashMap<String, Map<String, Set<String>>>();
            HashMap<String, Map<String, Set<String>>> allFailedMap = new HashMap<String, Map<String, Set<String>>>();
            SyncAssignRelationFacadeControllerBean.copyMap(unAssignMap, copyMap);
            for (String bosType : unAssignMap.keySet()) {
                for (String cuId : unAssignMap.get(bosType).keySet()) {
                    Map<String, Set<String>> failMap = SyncAssignRelationFacadeControllerBean.doUnAssignAndReturnFailed(ctx, bosType, cuId, unAssignMap.get(bosType).get(cuId));
                    if (failMap.size() <= 0) continue;
                    logger.error((Object)("current cu:" + cuId + ",unassign failed data length:" + failMap.get(cuId).size()));
                    ((Set)((Map)copyMap.get(bosType)).get(cuId)).removeAll((Collection)failMap.get(cuId));
                    allFailedMap.put(bosType, failMap);
                }
            }
            this.updateSyncUnAssignSuccessStatus(ctx, copyMap);
            this.updateSyncUnAssignFailedTimes(ctx, allFailedMap);
        }
        catch (SQLException se) {
            se.printStackTrace();
            throw new BOSException((Throwable)se);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private static Map<String, Map<String, Set<String>>> executeQueryAndFillDataToMap(Context ctx, String selectSql) throws SQLException, BOSException {
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSql);
        HashMap<String, Map<String, Set<String>>> allDataMap = new HashMap<String, Map<String, Set<String>>>();
        while (rowSet.next()) {
            HashSet<String> set;
            String bosType = rowSet.getString("FBOSObjectType");
            String cuId = rowSet.getString("FAssignCUID");
            String dataId = rowSet.getString("FDataBaseDID");
            if (allDataMap.get(bosType) != null) {
                if (((Map)allDataMap.get(bosType)).get(cuId) != null) {
                    ((Set)((Map)allDataMap.get(bosType)).get(cuId)).add(dataId);
                    continue;
                }
                set = new HashSet();
                set.add(dataId);
                ((Map)allDataMap.get(bosType)).put(cuId, set);
                continue;
            }
            set = new HashSet<String>();
            set.add(dataId);
            HashMap<String, HashSet<String>> dataMap = new HashMap<String, HashSet<String>>();
            dataMap.put(cuId, set);
            allDataMap.put(bosType, dataMap);
        }
        return allDataMap;
    }

    private void updateSyncUnAssignSuccessStatus(Context ctx, Map<String, Map<String, Set<String>>> successMap) throws BOSException {
        String updateSql = "update T_BD_DataBaseUnAssign_In set FStatus='1',FTryTimes=FTryTimes+1 where FBOSObjectType=? and FAssignCUID=? and FDataBaseDID=?";
        this.doUpdate(ctx, successMap, updateSql);
    }

    private void updateSyncUnAssignFailedTimes(Context ctx, Map<String, Map<String, Set<String>>> allFailedMap) throws BOSException {
        String updateSql = "update T_BD_DataBaseUnAssign_In set FTryTimes=FTryTimes+1 where FBOSObjectType=? and FAssignCUID=? and FDataBaseDID=?";
        this.doUpdate(ctx, allFailedMap, updateSql);
    }

    private void updateSyncAssignSuccessStatus(Context ctx, String bosType, String cuId, Set<String> set) throws BOSException {
        Connection cn = null;
        PreparedStatement stmt = null;
        String updateSql = "update T_BD_DataBaseAssign_In set FStatus='1',FTryTimes=FTryTimes+1 where FBOSObjectType=? and FAssignCUID=? and FDataBaseDID=?";
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.prepareStatement(updateSql);
            for (String dataId : set) {
                stmt.setString(1, bosType);
                stmt.setString(2, cuId);
                stmt.setString(3, dataId);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    private void doUpdate(Context ctx, Map<String, Map<String, Set<String>>> dataMap, String updateSql) throws BOSException {
        Connection cn = null;
        PreparedStatement stmt = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.prepareStatement(updateSql);
            for (String bosType : dataMap.keySet()) {
                for (String cuId : dataMap.get(bosType).keySet()) {
                    for (String dataId : dataMap.get(bosType).get(cuId)) {
                        stmt.setString(1, bosType);
                        stmt.setString(2, cuId);
                        stmt.setString(3, dataId);
                        stmt.addBatch();
                    }
                }
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    private static Map<String, Set<String>> doUnAssignAndReturnFailed(Context ctx, String bosType, String cuId, Set<String> set) throws BOSException, EASBizException {
        ctx.put((Object)"fromISC", (Object)true);
        if ("4409E7F0".equals(bosType)) {
            return MaterialFactory.getLocalInstance(ctx).batchUnAssignReturnFail(set.toArray(new String[0]), new String[]{cuId});
        }
        if ("BF0C040E".equals(bosType)) {
            return CustomerFactory.getLocalInstance((Context)ctx).batchUnAssignReturnFail(set.toArray(new String[0]), new String[]{cuId});
        }
        if ("37C67DFC".equals(bosType)) {
            return SupplierFactory.getLocalInstance((Context)ctx).batchUnAssignReturnFail(set.toArray(new String[0]), new String[]{cuId});
        }
        return new HashMap<String, Set<String>>();
    }

    private static void doAssign(Context ctx, String bosType, String cuId, Set<String> set) throws BOSException, EASBizException {
        ctx.put((Object)"fromISC", (Object)true);
        if ("4409E7F0".equals(bosType)) {
            MaterialFactory.getLocalInstance(ctx).batchAssign("", set.toArray(new String[0]), new String[]{cuId});
        } else if ("BF0C040E".equals(bosType)) {
            CustomerFactory.getLocalInstance((Context)ctx).batchAssign("", set.toArray(new String[0]), new String[]{cuId});
        } else if ("37C67DFC".equals(bosType)) {
            SupplierFactory.getLocalInstance((Context)ctx).batchAssign("", set.toArray(new String[0]), new String[]{cuId});
        }
    }

    private static void copyMap(Map paramsMap, Map resultMap) {
        for (Map.Entry entry : paramsMap.entrySet()) {
            Object key;
            resultMap.put(key, paramsMap.get(key = entry.getKey()) != null ? paramsMap.get(key) : "");
        }
    }
}

